$DECLARE
$NOTRUNCATE
$DEBUG
	PROGRAM MAKEMAPDATA
C
C	This program makes map data for the VELH program which is
C	consistent and should produce constant results to verify operation
C	of the routines.
C
C	08 Feb 91 -- Modified to produce random errors on the various
C	             values.
C
	INTEGER YY,DD,HH,MM,SS,NDOPP,IFREQ,NSRC,ISRC,IDOP,I,I1,I2
	INTEGER NCASE,ICASE,IFF,ISEED,KSRC,IZMAX
	REAL VX,VY,VZ,THETA,PHI,PI,DOPRES,X,Y,Z,VLOS,VMAG,DOPMAX,C
	REAL RAN2,STUFF,DOPF,FREQ,ZMAX,VERR,GAUSSDEV
	LOGICAL OK,DOPLINE(-128:128)
	CHARACTER*90 ALLHDR
	CHARACTER*38 MAPHEADER
	CHARACTER*20 GAMP
	CHARACTER*6 CFREQ,H(4)
C
	INTEGER  MAPAMP(256),MAPDOP(256),MAPRMS(256)
	REAL YMAP(256),XMAP(256)
	PARAMETER (C =3.0E8)
C
C
C   042 2821 88341 030129 285000000FA410C 0B905350000002 900 1  29025 3050 12 26 57  4   0  0

C
 	DATA MAPHEADER / ' 285000000FA410C 0B905350000002'/
	DATA GAMP /' 00 20 64'/
	DATA H /' 1100',' 1200',' 1300',' 1400'/
C

	PI = 4.0*ATAN(1.0)
	YY = 99
	DD = 123
	NDOPP = 32
C100Hz	DOPRES = 1.00/20.48
	DOPRES = 1.00/10.24
	DOPMAX = NDOPP*DOPRES
	CALL GETTIM(HH,MM,SS,I1)
C
	WRITE(*,*) ' Writing to file: TESTMAPM.SKY'
	OPEN(UNIT=1,FILE='TESTMAPM.SKY',FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS='UNKNOWN',MODE='WRITE')
	STUFF = RAN2(-(MM+SS+I1))
C
	WRITE(*,*) ' How many cases of data?'
	READ(*,*) NCASE
	WRITE(*,*) ' Enter Vx(North), Vy(East), Vz(Up) (m/s)'
	READ(*,*) VX,VY,VZ
	VMAG = SQRT(VX*VX + VY*VY + VZ*VZ)
	IF (VMAG.EQ.0.0) THEN
	   WRITE(*,*) 'Come on, give me a non-zero velocity!!'
	   STOP
	ENDIF
	WRITE(*,*) ' Enter the maximum LOS velocity error '
	READ(*,*) VERR
C
	WRITE(*,*)' 	Maximum Zenith Angle (deg)?'
	READ(*,*) ZMAX
	IZMAX = 10.0*ZMAX
	ZMAX = PI*ZMAX/180.
C	Scale the frequency to allow the velocity to be unaliased at the
C	maximum zenith angle.
	FREQ = DOPMAX*C/(2.0*VMAG)
	IFREQ = INT(FREQ/100.)
	WRITE(CFREQ,'(I6)') IFREQ
	WRITE(*,*) ' The Sounding Frequency (Mhz) is:',FREQ/1.0E6
C
	ICASE = 0
 1	DO 20 HH = 10, 23, 1
	DO 20 MM = 20, 59, 2
	DO 20 SS =  1, 59, 10
	DO 20 IFF = 1, 4
	   ICASE = ICASE + 1
	   IF (ICASE.GT.NCASE) GOTO 999
C
	   NSRC = MIN(2*NDOPP-5, 2*NDOPP*RAN2(ISEED))
	write(*,*) ' Enter # of sources for this subcase:'
	read(*,*) nsrc
	   KSRC = 0
	   DO 35 I = -NDOPP, NDOPP
	      DOPLINE(I) = .FALSE.
 35	   CONTINUE
C
	   DO 30 ISRC = 1, NSRC
C	      Keep sources within ZMAX radians of Zenith
C	      Theta is given a Normal distribution, centered at zero (overhead)
C	      and with a standard deviation set to 1/3 of Zmax.  Points
C	      beyond Zmax (>3 Sigma out) are deleted.
C	      Phi's distribution is Uniform.
	      THETA = MIN(ZMAX, 0.333*ZMAX*GAUSSDEV(ISEED)+ 0.0)
	      PHI = 2.0*PI*RAN2(ISEED)
	write(*,*) ' Enter source location THETA,PHI:'
	read(*,*) theta,phi
	theta = pi*theta/180.
	phi   = pi*phi/180.
	      X = SIN(THETA)*COS(PHI)
	      Y = SIN(THETA)*SIN(PHI)
	      Z = COS(THETA)
	      VLOS = VX*X + VY*Y + VZ*Z
	      VLOS = VLOS + VERR*RAN2(ISEED)
	      DOPF = - 2.0*VLOS*FREQ/C
C	      Determine the nearest DGS256 Doppler bin.
	      IDOP = NINT(ABS(DOPF)/DOPRES) + 1
	      OK = (IDOP.GE.1).AND.(IDOP.LE.NDOPP)
	      IF (DOPF.LT.0.0) IDOP = - IDOP
	      IF (.NOT.DOPLINE(IDOP).AND.OK) THEN
	         DOPLINE(IDOP) = .TRUE.
	         KSRC = KSRC + 1
	         MAPDOP(KSRC) = IDOP
	         MAPAMP(KSRC) = INT(20.0 + 42.0*RAN2(ISEED))
C	         Make +Y the Easterly direction.
C	         Round positions in the first decimal place
	         YMAP(KSRC) = NINT(-200.0*Y/SIN(ZMAX))/10.0
	         XMAP(KSRC) = NINT( 200.0*X/SIN(ZMAX))/10.0
	         MAPRMS(KSRC) = 20*RAN2(ISEED)
	      ENDIF
 30	   CONTINUE
C
C        Write results to the file.
	   WRITE(ALLHDR,101) ICASE,YY,DD,HH,MM,SS,MAPHEADER,IZMAX,
     +                     IFF,CFREQ,H(IFF),GAMP,KSRC,0,0
  101	   FORMAT (' 042',I5,I3.2,I3.3,1X,3I2.2,A31,
     +                     I4,I2,1X,A6,A5,A9,I3,I4,I3)
C
	   WRITE(1,'(A90)') ALLHDR
         DO 140 I1=1,KSRC,26
            I2=I1+25
            IF(I2.GT.KSRC) I2=KSRC
            WRITE(1,151) ' Y',(YMAP(I),I=I1,I2)
            WRITE(1,151) ' X',(XMAP(I),I=I1,I2)
            WRITE(1,150) 'PD',(MAPAMP(I),I=I1,I2)
            WRITE(1,150) 'DO',(MAPDOP(I),I=I1,I2)
            WRITE(1,150) 'ER',(MAPRMS(I),I=I1,I2)
  140    CONTINUE
  150    FORMAT(1X,A2,26I5)
  151    FORMAT(1X,A2,26F5.1)
C
 20	CONTINUE
	DD = DD + 1
	GOTO 1
C
 999	WRITE(*,*) ' Finished ...'
	CLOSE(UNIT=1)
	END
C
C   ===================================================================
C	
      REAL FUNCTION RAN2(IDUM)
C	Set IDUM to any negative number to re-initialize sequence.
	INTEGER M,IA,IC,IR(97),IFF,IDUM,IY,J
	REAL RM
      PARAMETER (M=714025,IA=1366,IC=150889,RM=1.4005112E-6)
      DATA IFF /0/
      IF(IDUM.LT.0.OR.IFF.EQ.0)THEN
        IFF=1
        IDUM=MOD(IC-IDUM,M)
        DO 11 J=1,97
          IDUM=MOD(IA*IDUM+IC,M)
          IR(J)=IDUM
11      CONTINUE
        IDUM=MOD(IA*IDUM+IC,M)
        IY=IDUM
      ENDIF
      J=1+(97*IY)/M
      IF(J.GT.97.OR.J.LT.1) PAUSE
      IY=IR(J)
      RAN2=IY*RM
      IDUM=MOD(IA*IDUM+IC,M)
      IR(J)=IDUM
      RETURN
      END
C
C  ===============================================================
C
	REAL FUNCTION GAUSSDEV(IDUM)
C	Produces a Normally distributed random number, with zero mean and
C	unit standard deviation.
	INTEGER ISET,IDUM
	REAL FAC,GSET,R,V1,V2,RAN2
      DATA ISET/0/
      IF (ISET.EQ.0) THEN
1       V1=2.*RAN2(IDUM)-1.
        V2=2.*RAN2(IDUM)-1.
        R=V1**2+V2**2
        IF(R.GE.1.)GO TO 1
        FAC=SQRT(-2.*LOG(R)/R)
        GSET=V1*FAC
        GAUSSDEV=V2*FAC
        ISET=1
      ELSE
        GAUSSDEV=GSET
        ISET=0
      ENDIF
      RETURN
      END

