$NOTRUNCATE
$DECLARE
$DEBUG

	PROGRAM PULLSKY
C
C	Create files of skymap data having arrival angles in
C	degrees Azimuth and Zenith, Source strength, and line of sight
C	velocity.  This is the data generated by the SAVESOURCE routine
C	in the velocity calculaton.

C.....Parameters.
$INCLUDE:'COMMON\PARAMS.CMN'
C
C.....Common Blocks
$INCLUDE:'COMMON\MAPDATA.CMN'
$INCLUDE:'COMMON\SOURCES.CMN'
cx $INCLUDE:'COMMON\BOUNDS.CMN'
C
	CHARACTER*40 INFILE,OUFILE
	INTEGER I,NT
	LOGICAL EOF
	real*8 parsetime,ntime,ltime

	WRITE(*,*) ' Enter file name with skymap data.'
	READ(*,'(A)') INFILE
	OPEN(UNIT=1,FILE=INFILE,FORM='FORMATTED',STATUS='OLD',
     +     MODE='READ')
C
	WRITE(*,*) ' Enter the output file name.'
	READ(*,'(A)') OUFILE
	OPEN(UNIT=2,FILE=OUFILE,FORM='FORMATTED',MODE='WRITE')
C
	EOF = .FALSE.
	ntime = 0
	ltime = 0
	DO WHILE (.NOT.EOF)
	   CALL READMAPDATA(1,EOF)
	   ltime = ntime
	   ntime = parsetime(ipref)
	   call filter(nt)
		CALL SAVESOURCE()
	   WRITE(*,101) (IPREF(I),I=1,11), Freq/1000000., Range/1000.
cx	   IF (NTIME.NE.LTIME) 
c	   use this line if time is needed every group.
cx	   if (ntime-ltime.gt.60.0) 
	   WRITE(2,101) (IPREF(I),I=1,11), Freq/1000000., Range/1000.
	   IF (NSRCRS.LT.1) CYCLE
	   WRITE(2,102) 'Th',(THETAS(I)/10.0,I=1,NSRCRS)
	   WRITE(2,102) 'Ph',  (PHIS(I)/10.0,I=1,NSRCRS)
	   WRITE(2,102) 'Vl', (VRS(I),I=1,NSRCRS)
	   WRITE(2,103) 'Er',  (ERMS(I),I=1,NSRCRS)
	   WRITE(2,103) 'Am', (AMPS(I),I=1,NSRCRS)
	   WRITE(2,103) 'No',(NOIS(I),I=1,NSRCRS)
	   WRITE(2,103) 'Do',(DOPS(I),I=1,NSRCRS)
	   NSRCRS = 0
	ENDDO

 101	FORMAT (1X,2I1,1X,3I1,1X,2I1,':',2I1,':',2I1, 3x,F10.4,F8.1)
 102	FORMAT (A2,99F7.1)
 103	FORMAT (A2,99I7)
	END

C
C  =======================================================================
C
	SUBROUTINE SAVESOURCE()
C
C	This routine transfers the necessary data from the /MAPDATA/ block
C	to the /SOURCES/ block with appropriate translation.
C	Only 1 BIN is used.
C
C
C.....Parameters.
$INCLUDE:'COMMON\PARAMS.CMN'
C
C.....Common Blocks
$INCLUDE:'COMMON\MAPDATA.CMN'
$INCLUDE:'COMMON\SOURCES.CMN'
cx $INCLUDE:'COMMON\BOUNDS.CMN'
C
C
	INTEGER ISRC,NBIN,IROUND,ID
	REAL DFR,DOPRES,DOPFRQ,TS,PS,AS,ES,NS,C,VS
	REAL ASIND,SIND,ATAND2
C
	DATA C /2.997924574E+8/
C
	IF (NUMSRC.LT.1) RETURN
C
	DFR = DOPRES()
	DO 30 ISRC = 1, NUMSRC
C........Negative MAPRMS means do not save this source.
	   IF (MAPRMS(ISRC).GE.0) THEN
C...........Translate from /MAPDATA/ format to /SOURCES/ format.
C	      /MAPDATA/: X is North, Y is West, PHI increases to the West.
C	                 Right Handed Coordinate System
C	      /SOURCES/: X is North, Y is East, PHI increases to the East.
C	                 Left Handed Coordinate System
C
	      TS = ASIND(SQRT(XMAP(ISRC)*XMAP(ISRC) + 
     +            YMAP(ISRC)*YMAP(ISRC))/20.0 * SIND(ZMAX))
	      PS = ATAND2(-YMAP(ISRC),XMAP(ISRC))
	      AS = MAPAMP(ISRC) + GAIN
	      NS = MPAMP + GAIN
	      ES = MAPRMS(ISRC)
	      id = mapdop(isrc)
	      IF (MAPDOP(ISRC).GT.0) THEN
	         DOPFRQ = DFR*(FLOAT(MAPDOP(ISRC)) - 0.5)
	      ELSE
	         DOPFRQ = DFR*(FLOAT(MAPDOP(ISRC)) + 0.5)
	      ENDIF
	      IF (FREQ.NE.0.0) THEN
	         VS = -C*DOPFRQ/(2.0*FREQ)
	      ELSE
	         VS = 0.0
	      ENDIF
C
ccc	      NBIN = PARTITION(FREQ,RANGE,TS,PS,BINLIST)
ccc	      IF (NBIN.GT.NOLAP) THEN
ccc	         WRITE(*,102) NBIN,NOLAP
ccc	         NBIN = NOLAP
ccc	      ENDIF
c
	      nbin = 1
C
	      IF (NBIN.GT.0) THEN
C..............Add this source to /SOURCES/, flag as belonging in NBIN bins.
	         NSRCRS = NSRCRS + 1
C..............Array boundary checking.
	         IF (NSRCRS.GT.NSS) THEN
	            NSRCRS = NSS
	            NSOVER = NSOVER + 1
	         ENDIF
C..............Save the source.
	         THETAS(NSRCRS) = IROUND(TS*10.0) 
	         PHIS(NSRCRS)   = IROUND(PS*10.0)
	         AMPS(NSRCRS)   = AS
	         NOIS(NSRCRS)   = NS
	         ERMS(NSRCRS)   = ES
	         VRS(NSRCRS)    = VS
	         ACTIVE(NSRCRS) = .FALSE.
	         dops(nsrcrs)   = id
	         devwgt(nsrcrs) = 1.0
	         bins(nsrcrs,1) = 1
cc	         DO 25 I = 1, NBIN
cc	            BINS(NSRCRS,I) = BINLIST(I)
cc 25	         CONTINUE
C              Zero the rest of the BINS.
cc	         DO 27 I = NBIN+1, NOLAP
cc	            BINS(NSRCRS,I) = 0
cc27	         CONTINUE
	      ENDIF
	   ENDIF
 30	CONTINUE
C
	IF (NSOVER.GT.0) WRITE(*,101) NSOVER,NSS
 101	FORMAT(' SAVESOURCE --',I4,' Excess sources.  Limit =',I5)
 102	FORMAT(' SAVESOURCE --',I2,' FRAB Overlaps.  Limit =',I2)
	RETURN
	END
C
C
C  ======================================================================
C 
	SUBROUTINE READMAPDATA(INFILE,EOF) 
C 
C===== READ THE MAP DATA FROM A FILE <infile> FOR LATER USE IN PRINTING 
C	SKYMAPS OR CALCULATING DRIFT VELOCITIES.  FREQUENCY READ IS
C	 <IFF>  THE FORMAT OF THE PREFACE IS AS FOLLOWS:
C
C	NOTE:  Range is converted to meters and Frequency to Hertz.
C 
C
C  POSITION ! FORMAT  !  INFORMATION
C_______________________________________________________________
C  1        ! A1      !  SPACE                                  !
C  2-4      ! 3Z1     !  STATION ID CODE                        !
C  5-9      ! I5      !  RECORD NO.                             !
C  10       ! A1      !  SPACE                                  !
C  11-15    ! 5Z1     !  DATE                                   !
C  16       ! A1      !  SPACE                                  !
C  17-22    ! 6Z1     !  TIME                                   !
C  23       ! 1X      !  SPACE                                  !
C  24       ! Z1      !  PROGRAM SET                            !
C  25       ! Z1      !  PROGRAM TYPE                           !
C  26-31    ! 6Z1     !  JOURNAL (6 HEX DIGITS)                 !
C  32-38    ! 7Z1     !  P1 TO P7 (7 HEX DIGITS)                !
C  39       ! 1X      !  SPACE                                  !
C  40-46    ! 7Z1     !  XLZTNRW (7 HEX DIGITS)                 !
C  47-53    ! 7Z1     !  K(I*)(G*)HEIG (7 HEX DIGITS)           !
C  54-57    ! I4      !  ZMAX (10THS OF A DEGREE)               !
C  58-59    ! I2      !  NFREQ=FREQUENCY NUMBER                 !
C  60-66    ! I7      !  FREQ(NFREQ), IN 100-HZ UNITS           !
C  67-71    ! I5      !  RANG(NFREQ), IN 100-METER UNITS        !
C  72-74    ! I3      !  IGAIN(NFREQ), IN DB                    !
C  75-77    ! I3      !  MPAMP(NFREQ)                           !
C  78-80    ! I3      !  MAXAMP(NFREQ)                          !
C  81-84    ! I4      !  NO. OF SOURCES FOR NFREQ               !
C  85-87    ! I3      !  KTH, CASE SELECTION THRESHOLD          !
C  88-90    ! I3      !  LTH, SPECTRAL LINE SELECTION THRESHOLD ! 
C================================================================
C
	INTEGER INFILE,I,I1,I2,IRNG,IFRQ,IZMAX,KC,LC,IERR
	CHARACTER*2 JUNK
	LOGICAL EOF
C
C	VARIABLES FOR THE COMMON BLOCKS
C
C.....For /MAPDATA/
$INCLUDE:'COMMON\PARAMS.CMN'
$INCLUDE:'COMMON\MAPDATA.CMN'
C
C
	DO 10 I =1, 89
 10   IPREF(I) = 0
	DO 20 I=1,NDLM
	   XMAP(I) = 0.0
	   YMAP(I) = 0.0
	   MAPAMP(I) = 0
	   MAPRMS(I) = 0
 20   CONTINUE
	EOF = .FALSE.
C
	READ(INFILE,110,END=99,ERR=901,IOSTAT=IERR)
     +  (IPREF(I),I=41,43),NMAP,(IPREF(I),I=1,19),
     +  (IPREF(I),I=26,32), (IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC,KC,LC
C
 110	FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +        I4,I2,I7,I5,4I3,I4,2I3) 
C
	RANGE = FLOAT(IRNG)*100.
	FREQ =  FLOAT(IFRQ)*100.
	ZMAX =  FLOAT(IZMAX)/10.
	 
	DO 140 I1=1,NUMSRC,26 
	   I2=I1+25
	   IF(I2.GT.NUMSRC) I2=NUMSRC 
	   READ(INFILE,151,ERR=902) JUNK,(YMAP(I),I=I1,I2) 
	   READ(INFILE,151,ERR=902) JUNK,(XMAP(I),I=I1,I2) 
	   READ(INFILE,150,ERR=902) JUNK,(MAPAMP(I),I=I1,I2)
	   READ(INFILE,150,ERR=902) JUNK,(MAPDOP(I),I=I1,I2) 
	   READ(INFILE,150,ERR=902) JUNK,(MAPRMS(I),I=I1,I2) 
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C 
	RETURN
C     End of File condition.
 99   EOF = .TRUE.
 	NUMSRC = 0
	RETURN

 901	WRITE(*,101)' Error #',IERR, ' reading the SKYMAP data header.'
	write(*,110)
     +  (IPREF(I),I=41,43),NMAP,(IPREF(I),I=1,19),
     +  (IPREF(I),I=26,32), (IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC,KC,LC

	NUMSRC = 0
	EOF = .FALSE.
	RETURN
 101	FORMAT (A,I5,A)

 902	WRITE(*,*) ' Error reading the SKYMAP source locations.'
	NUMSRC = 0
	EOF = .FALSE.
	RETURN
	END 
C
C  =======================================================================
C
	REAL FUNCTION DOPRES()
C
C	Determines from the preface IPREF and the sounding frequency FREQ
C	the Doppler Frequency Resolution, which can be used to translate the
C	Doppler numbers in /MAPDATA/ to frequencies.
C	Ex:  Given a Doppler # I and the correct value of DOPRES then:
C			Doppler Shift (Hz) = DOPRES*(I - 0.5)  I > 0
C			Doppler Shift (Hz) = DOPRES*(I + 0.5)  I < 0
C	                *** for a Digisonde 256.  
C
C.....For /MAPDATA/
$INCLUDE:'COMMON\PARAMS.CMN'
$INCLUDE:'COMMON\MAPDATA.CMN'
C
	INTEGER*1 NFREQS(16),NANTS(16),NHITES(16),IL,IT3,IN
	INTEGER IREP,NSMPLS,NPULSES
	REAL TINTEG
C
C.......Value =   0 1 2 3 4 5 6 7 8 9 A B C D E F
	DATA NFREQS/1,2,1,2,1,2,1,2,2,4,2,4,2,1,2,4/ 
	DATA  NANTS/1,4,4,8,4,8,1,4,1,4,4,8,4,8,1,4/
	DATA NHITES/2,1,2,1,2,2,8,1,2,1,2,1,2,2,8,1/
C 
	IL = IPREF(45)
	IT3 = IAND(IPREF(47),8)
	IN = IPREF(48)
	IREP = 50*2**((IPREF(49)+1)/2) 
	NSMPLS = 32*(2**IAND(IN,3))
	NPULSES = NANTS(IL+1)*NFREQS(IL+1)*NHITES(IL+1)
	TINTEG = FLOAT(NSMPLS*NPULSES)/FLOAT(IREP)
	DOPRES = (1+IT3)/TINTEG
	RETURN
	END
C
	INTEGER FUNCTION IROUND(VALUE)
C
	REAL VALUE
	IF (VALUE.GE.0) THEN
	   IROUND = INT(VALUE + 0.50001)
	ELSE
	   IROUND = INT(VALUE - 0.50001)
	ENDIF
	RETURN
	END
C
C
	REAL FUNCTION SIND(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	SIND = SIN(RAD*ANGLE)
	RETURN
	END
C
	REAL FUNCTION COSD(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	COSD = COS(RAD*ANGLE)
	RETURN
	END
C
	REAL FUNCTION TAND(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	TAND = TAN(RAD*ANGLE)
	RETURN
	END
C
C.....Inverse Trig functions return angles in degrees from 0-360 
	REAL FUNCTION ACOSD(VALUE)
	REAL VALUE,DEG
	DATA DEG /57.29577951/
	IF (ABS(VALUE).GT.1.0) VALUE = SIGN(1.0,VALUE)
	ACOSD = DEG*ACOS(VALUE)
	IF (ACOSD.LT.0.0) ACOSD = ACOSD + 360.0
	RETURN
	END
C
	REAL FUNCTION ASIND(VALUE)
	REAL VALUE,DEG
	DATA DEG /57.29577951/
	IF (ABS(VALUE).GT.1.0) VALUE = SIGN(1.0,VALUE)
	ASIND = DEG*ASIN(VALUE)
	IF (ASIND.LT.0.0) ASIND = ASIND + 360.0
	RETURN
	END
C
	REAL FUNCTION ATAND2(Y,X)
	REAL Y,X,DEG
	DATA DEG /57.29577951/
	ATAND2 = 0.0
	IF ((Y.EQ.0).AND.(X.EQ.0)) RETURN
	ATAND2 = DEG*ATAN2(Y,X)
	IF (ATAND2.LT.0.0) ATAND2 = ATAND2 + 360.0
	RETURN
	END
C
C  =======================================================================
C
	SUBROUTINE FILTER(NTOSS)
C
C	Apply the criteria in the /SELECT/ block to decide which /MAPDATA/
C	sources to keep and which ones to discard.
C	Deleted sources have a Negative MAPRMS.
C
$INCLUDE:'COMMON\PARAMS.CMN'
$INCLUDE:'COMMON\MAPDATA.CMN'
cx$INCLUDE:'COMMON\SELECT.CMN'
C
C
	INTEGER I,MD,NTOSS,MDMAX,MDOPLINE
	LOGICAL AOK
	integer mcasesnr,mindopp,maxdopp,msrcsnr,mposerr,minlobe
C
C	Check ratio of the subcase maximum amplitude to the subcase noise
C	to see if the case is to be kept.  If not, toss all sources.
C
cmh	mcasesnr = 0
cmh	mindopp = 3
cmh	maxdopp = -5
cmh	msrcsnr = 0
cmh	mposerr = 20
cmh	minlobe = 10
cmh	mdopline = 32
C	Ramey Drift and Heater Data: Liberal criterion.
	mcasesnr = -99
	mindopp = 0
	maxdopp = 99
	msrcsnr = 0
	mposerr = 99
	minlobe = 99
	mdopline = 99
 
	IF (((MAXAMP-MPAMP).LT.MCASESNR).OR.NUMSRC.EQ.0) THEN
	   NTOSS = NUMSRC
	   NUMSRC = 0
	   RETURN
	ENDIF
C.....Passed the subcase test, now check each source.
	MDMAX = MDOPLINE
	IF (MAXDOPP.LT.0) THEN
	   MDMAX = MDMAX - ABS(MAXDOPP)
	ELSE
	   MDMAX = ABS(MAXDOPP)
	ENDIF
C
	DO 20 I = 1, NUMSRC
	   MD = ABS(MAPDOP(I))
	   AOK = (MD.GE.MINDOPP).AND.(MD.LE.MDMAX).AND.
     +         ((MAPAMP(I)-MPAMP).GE.MSRCSNR).AND.
     +         (MAPRMS(I).LE.MPOSERR).AND.
     +         ((MAXAMP-MAPAMP(I)).LE.MINLOBE)
	   IF (.NOT.AOK) THEN
	      NTOSS = NTOSS + 1
	      MAPRMS(I) = -MAPRMS(I)
	   ENDIF
 20	CONTINUE
	RETURN
	END
C
C========================================================================
C
      REAL*8 FUNCTION PARSETIME(TIME)
C            This function takes an integer array of 11 values and
C         calculates the approximate number of seconds since January, 1900.
C         These values are for comparison purposes only.
C	    Performance across year boundires is not optimal, esp. leap years.
C         Will fail past the year 2000.
C
      INTEGER*2 TIME(11)
C         Seconds per year
      PARSETIME = 31662400.*(10*TIME(1)+ TIME(2))
C         Seconds per day
      PARSETIME = PARSETIME + 86400.*(100*TIME(3)+10*TIME(4)+TIME(5))
C         Seconds per hour
      PARSETIME = PARSETIME + 3600.*(10*TIME(6) + TIME(7))
C         Seconds per minute
      PARSETIME = PARSETIME + 60.*(10*TIME(8) + TIME(9))
C         And finally the seconds
      PARSETIME = PARSETIME + 10.*TIME(10) +1.*TIME(11)
      RETURN
      END

