$DECLARE
$DEBUG
$NOTRUNCATE
C
	PROGRAM COUPLE
C
C	Determine the effect of mutual antenna coupling on the calculated
C	arrival angles for the Digisonde Drift Technique.
C
	REAL F,C,W,K0,KH,P0,K(3),KM(3),PM(4),PI
	REAL THR,PHR,THD,PHD,THA,PHA,ESQ
C
	PARAMETER (C=3.0E8, PI=3.141579)
C
	F = 3.0E6
	W = C/F
	K0 = 2*PI/W
	P0 = 0.0
C
C	Loop through Zenith and Azimuth angles.
	DO THD = 5.0, 90.0, 5.0
	   THR = PI*THD/180.0
	   DO PHD = 0.0, 350.0, 10.0
	      PHR = PI*PHD/180.0
C	      Determine the K vector from this direction.
	      K(1) = K0*SIN(THR)*COS(PHR)  ! Kx
	      K(2) = K0*SIN(THR)*SIN(PHR)  ! Ky
	      K(3) = K0*COS(THR)           ! Kz
	      CALL MPHASE(P0,K, PM)
	      CALL SRCLOC(K0,PM,KM,ESQ)
C	      Determine the arrival angles from the located KM
	      KH = SQRT(KM(1)*KM(1) + KM(2)*KM(2))
	      THA = 0.0
	      PHA = 0.0
	      IF (KH.GT.0.0) THEN
	         THA = 180./PI*ACOS(KM(3)/K0)
	         PHA = 180./PI*ATAN2(KM(2),KM(1))
	         IF (PHA.LT.-0.1) PHA = PHA + 360.0
	      ENDIF
C	write(*,*) k
C	write(*,*) km
	      WRITE(*,101) THD,PHD,THA,PHA,ESQ
	   ENDDO
	ENDDO

 101	FORMAT (1X,6F8.1)
	      
	END
C
C  ============================================================
C
	SUBROUTINE MPHASE(P0,K,  PM)
C
C	Determine the measured phases [PM] given an initial phase P0,
C	the wave vector [K], the antenna positions [R] and
C	the mutual coupling matrix [CM].
C	X is North, Y is East, Z is up.
C
	REAL PM(4),P0,K(3),Rx(4),Ry(4),CM(4,4),PA(4)
	COMPLEX SIG
	INTEGER I,J
C
	DATA RX /0.0, 30.0, -30.0, 0.0/
	DATA RY /0.0, -17.32, -17.32, 34.64/
C
	DATA (CM(1,I),I=1,4) /1.0, 0.0, 0.0,  1.0/
	DATA (CM(2,I),I=1,4) /0.0, 1.0, 0.0,  1.0/
	DATA (CM(3,I),I=1,4) /0.0, 0.0, 1.0,  1.0/
	DATA (CM(4,I),I=1,4) /0.0, 0.0, 0.0,  1.0/
C
C	The actul phase is = [K]*[R].  Antennas are in the Z=0 plane.
	DO I = 1, 4
	   PA(I) = RX(I)*K(1) + RY(I)*K(2) + P0
	ENDDO
C
C	Perform mutual coupling by adding complex exponentials
C
	DO I = 1, 4
	   SIG = CMPLX(0.0,0.0)
	   DO J = 1, 4
	      SIG = SIG + CM(I,J)*CEXP(CMPLX(0.0, PA(J)))
	   ENDDO
	   PM(I) = ATAN2(IMAG(SIG),REAL(SIG))
	ENDDO
C
C	WRITE(*,*) ' Measured ',PM
C	WRITE(*,*) '  Actual  ',PA
	RETURN
	END
C
C  =======================================================================
C
	SUBROUTINE SRCLOC(K0,PM, KM,ESQ)
C
C	Use the Digisonde source location technique to find the wave vector
C	KM using the phases PM and the wavenumber magnitude K0.  This routine
C	assumes that the phases are already 2PI corrected.
C	The equation to find [KM] is [RSUM]*[KM] = [R*PM], but since [RSUM]
C	is so simple (diagnol 2x2 matrix), we can find Kx and Ky from
C	Kx = sum(X*PM)/sum(X*X) ;  Ky = sum(Y*PM)/sum(Y*Y)
C
	REAL Rx(4),Ry(4),K0,PM(4),KM(3),SXP,SYP,SXX,SYY,ESQ
	INTEGER I
C
	DATA RX /0.0, 30.0, -30.0, 0.0/
	DATA RY /0.0, -17.32, -17.32, 34.64/
C
	SXX = 1800.0
	SYY = 1800.0
C
	SXP = 0.0
	SYP = 0.0
	DO I = 1, 4
	   SXP = SXP + RX(I)*PM(I)
	   SYP = SYP + RY(I)*PM(I)
	ENDDO
C
	KM(1) = SXP/SXX
	KM(2) = SYP/SYY
	KM(3) = SQRT(MAX(K0*K0 - KM(1)*KM(1) - KM(2)*KM(2),0.0))
C	RMS error
	ESQ = 0.0
	DO I = 1, 4
	   ESQ = ESQ + (PM(I)- KM(1)*RX(I) - KM(2)*RY(I))**2
	ENDDO
	ESQ = SQRT(ESQ)
	RETURN
	END
	   
 
