$DECLARE
$NOTRUNCATE
C
	PROGRAM CVTVEL
C
C	05 September 1989    T. Bullett
C
C	This program reads an old style Velocity vector file
C	(one without Line-of Sight Velocities) and
C	produces a new style (latest) velocity vector file.  Version 3.0 is
C	the first with LOS velocity, so the old file version number
C	must be less than this.
C
C
	INTEGER INF,OUT,IFRB,IFRAB
	CHARACTER*30 INFILE,OUTFILE
	CHARACTER*17 CTIME
	LOGICAL EOF,ERROR
C
C.....Program Parameters.  NOTE: NPDF must be EVEN.
	INTEGER NIND,NFRAB,NSTAT,NSS,NPDF
	REAL VERSION
	PARAMETER (NIND=1000, NFRAB=32, NSTAT=7, NSS=2000, NPDF=180) 
	PARAMETER (VERSION = 3.0)
C
C.....Common Blocks
C.....For /GRPVEL/
	REAL GVZ(NFRAB,NSTAT),GVH(NFRAB,NSTAT),GAZ(NFRAB,NSTAT),
     +     GVX(NFRAB,NSTAT),GVY(NFRAB,NSTAT),GSQ(NFRAB,NSTAT),
     +     GVL(NFRAB,NSTAT),GSL(NFRAB,NSTAT)
	INTEGER NGVEL(NFRAB),NGVELOS(NFRAB)
	COMMON /GRPVEL/ GVZ,GVH,GAZ,GVX,GVY,GSQ,GVL,GSL,NGVEL,NGVELOS
C.....For /TIME/
	REAL*8 STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME
	CHARACTER*17 CSTIME,CETIME,CNTIME,CLTIME,CCSTIME
	INTEGER NR2DO
	COMMON /TIME/ STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME,
     +              CSTIME,CETIME,CNTIME,CLTIME,CCSTIME,NR2DO
C.....For /BOUNDS/
	INTEGER NFRABS,NBSRC(NFRAB)
	LOGICAL TRUEHEIGHT
	REAL BFRQ(NFRAB,2),BRNG(NFRAB,2),BANG(NFRAB,4)
	COMMON /BOUNDS/ NFRABS,TRUEHEIGHT,BFRQ,BRNG,BANG,NBSRC
C
C  /GRPVEL/        -  Statistical data for the Group Velocity in NFRAB
C	                possible Frequency-Range-Angle Bins.
C	                NFRAB and NSTAT are
C	                program parameters.
C	                The second index indicates which value is contained. 
C GVZ(NFRAB,NSTAT) -  Statistics for the Group Velocity Z-component.
C	     , 1)    -  Mean
C	     , 2)    -  Standard Deviation
C	     , 3)    -  Median
C	     , 4)    -  Upper quartile
C	     , 5)    -  Lower quartile
C	     , 6)    -  Most probable
C	     , 7)    -  Least Square fit to ALL data. 
C   8) -,NSTAT)    -  For future use  
C GVH(NFRAB,NSTAT) -  Statistics for the Group Velocity Horizontal magnitude.
C GAZ(NFRAB,NSTAT) -  Statistics for the Group Velocity horizontal AZimuth.
C GVX(NFRAB,NSTAT) -  Statistics for the Group Velocity X component.
C GVY(NFRAB,NSTAT) -  Statistics for the Group Velocity Y component.
C GSQ(NFRAB,NSTAT) -  Statistics for the velocity root mean square error.
C GVL(NFRAB,NSTAT) -  Statistics for the Group Velocity Line-of-Sight.
C GSL(NFRAB,NSTAT) -  Statistics for the LOS velocity root mean square error.
C NGVEL(NFRAB)     -  Number of measurements at each FRAB.
C NGVELOS(NFRAB)   -  Number of measurements at each FRAB.
C
C  /BOUNDS/      -  Data in this common block define the limits in
C                   Frequency, Range and Arrival Angle for each of the
C	              NFRAB's. 
C  NFRABS        -  Number of FRAB's defined.  Must be <= NFRAB.
C  TRUEHEIGHT    -  Logical flag selecting between true and virtual height
C	              selection of the data.  *** TRUE HEIGHT NOT YET AVAILABLE ***
C  BFRQ(NFRAB,2) -  Bounds upon the FReQuency, upper ,1) and lower ,2)
C  BRNG(NFRAB,2) -  Bounds upon the RaNGe, upper ,1) and lower ,2)
C  BANG(NFRAB,4) -  Bounds on the ANGles of arrival for this bin.
C                   ,1) = Zenith angle of the Line-of-Sight direction (deg).
C                   ,2) = Azimuth of the Line-of-Sight direction (deg).
C                   ,3) = Half 'Beamwidth' in Zenith (deg).
C                   ,4) = Half 'Beamwidth' in Azimuth (deg).
C  NBSRC(NFRAB)  - Number of sources in each FRAB
C
C  /TIME/
C	STARTTIME, ENDTIME, NOWTIME, LASTTIME
C	ATIME       - Data Accumulation time = time over which data is
C	              averaged/smoothed. (seconds)
C	ACCSTIME    - The accumulation (averaging) start time. 
C	CSTIME,CETIME,CNTIME,CCSTIME,CLTIME - Times in CHARACTER*17 format
C	                         YYYY DDD HH:MM:SS 
C	NR2DO       - The number of Subcases to process if ENDTIME unspecified.
C
C
	INF = 10
	OUT = 20
C

 901	WRITE(*,*) ' Enter the name of the old-format velocity file.'
	READ(*,'(A)') INFILE
	OPEN(UNIT=INF,FILE=INFILE,FORM='FORMATTED',
     +        ACCESS='SEQUENTIAL',STATUS='OLD',ERR=901)
C
 902	WRITE(*,*) ' Enter the name for the new format velocity file.'
	READ(*,'(A)') OUTFILE
	OPEN(UNIT=OUT,FILE=OUTFILE,FORM='FORMATTED',MODE='WRITE',
     +        ACCESS='SEQUENTIAL',STATUS='UNKNOWN',ERR=902)
C
C
 10	CALL READOLDGDATA(INF,IFRAB,EOF)
	   CALL WRITEGROUPDATA(OUT,IFRAB,ERROR)
	   IF (ERROR) WRITE(*,*) ' Error writing data.'
	   WRITE(*,*) CCSTIME
	IF (.NOT.EOF) GOTO 10
	CLOSE(UNIT=INF)
	CLOSE(UNIT=OUT)
	END
C
C ==========================================================================
C
	SUBROUTINE READOLDGDATA(UNIT,IFRB,EOF)
C
C	Reads data into the /GRPVEL/ common block for the bin IFRB
C	as well as some /TIME/ and /BOUNDS/ information from the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable EOF is set if the end of file
C	is encountered in a READ operation.
C
C	***** NOTE *****  This reads only Versions prior to 3.0
C
C	   IVAR   =  The number of variables  to read from the file
C	   NVAR   =  The number of variables the routine expects to find.
C	   ISTAT  =  The number of statistics to read from the file.
C	   NSTAT  =  The maximum number of statistics /GRPVEL/ can hold.
C
C.....Parameters
C.....PARAMS.CMN
C.....Program Parameters.  NOTE: NPDF must be EVEN.
	INTEGER NIND,NFRAB,NSTAT,NSS,NPDF
	REAL VERSION
	PARAMETER (NIND=1000, NFRAB=32, NSTAT=7, NSS=2000, NPDF=180) 
	PARAMETER (VERSION = 3.0)

C.....Common Blocks
C.....For /GRPVEL/
	REAL GVZ(NFRAB,NSTAT),GVH(NFRAB,NSTAT),GAZ(NFRAB,NSTAT),
     +     GVX(NFRAB,NSTAT),GVY(NFRAB,NSTAT),GSQ(NFRAB,NSTAT),
     +     GVL(NFRAB,NSTAT),GSL(NFRAB,NSTAT)
	INTEGER NGVEL(NFRAB),NGVELOS(NFRAB)
	COMMON /GRPVEL/ GVZ,GVH,GAZ,GVX,GVY,GSQ,GVL,GSL,NGVEL,NGVELOS
C.....For /TIME/
	REAL*8 STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME
	CHARACTER*17 CSTIME,CETIME,CNTIME,CLTIME,CCSTIME
	INTEGER NR2DO
	COMMON /TIME/ STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME,
     +              CSTIME,CETIME,CNTIME,CLTIME,CCSTIME,NR2DO
C.....For /BOUNDS/
	INTEGER NFRABS,NBSRC(NFRAB)
	LOGICAL TRUEHEIGHT
	REAL BFRQ(NFRAB,2),BRNG(NFRAB,2),BANG(NFRAB,4)
	COMMON /BOUNDS/ NFRABS,TRUEHEIGHT,BFRQ,BRNG,BANG,NBSRC
C
	INTEGER UNIT,IFRB,NVAR,I,ISTAT,IVAR
	REAL VSN
	LOGICAL EOF
	CHARACTER*3 JUNK
C
	EOF = .FALSE.
	NVAR = 6
C
 	READ(UNIT,101,END=900)  CCSTIME,IFRB,NGVEL(IFRB),BFRQ(IFRB,1),
     +                        BFRQ(IFRB,2),BRNG(IFRB,1),BRNG(IFRB,2),
     +                        ISTAT,IVAR
C
	IF((ISTAT.GT.NSTAT).OR.(IVAR.NE.NVAR).OR.(VSN.GE.3.0))THEN
	   WRITE(*,*) ' READOLDGDATA --> Incompatable file format.'
	   GOTO 900
	ENDIF

C
	READ(UNIT,102,END=900) JUNK,(GVZ(IFRB,I),I=1,ISTAT)
	READ(UNIT,102,END=900) JUNK,(GVH(IFRB,I),I=1,ISTAT)
	READ(UNIT,102,END=900) JUNK,(GAZ(IFRB,I),I=1,ISTAT)
	READ(UNIT,102,END=900) JUNK,(GVX(IFRB,I),I=1,ISTAT)
	READ(UNIT,102,END=900) JUNK,(GVY(IFRB,I),I=1,ISTAT)
	READ(UNIT,103,END=900) JUNK,(GSQ(IFRB,I),I=1,ISTAT)
	RETURN

 101	FORMAT (1X,A17,2I4,4F8.2,2I3)
 102	FORMAT (1X,A3,12F10.2)
 103	FORMAT (1X,A3,12F10.4)
C
 900	EOF = .TRUE.
	RETURN
	END
C
C ==========================================================================
C
	SUBROUTINE WRITEGROUPDATA(UNIT,IFRB,ERROR)
C
C	Writes the data from the /GRPVEL/ common block for the bin IFRB
C	as well as some /TIME/ and /BOUNDS/ information to the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable ERROR is set if an error occurs in
C	the write operation.
C
C.....Program Parameters.  NOTE: NPDF must be EVEN.
	INTEGER NIND,NFRAB,NSTAT,NSS,NPDF
	REAL VERSION
	PARAMETER (NIND=1000, NFRAB=32, NSTAT=7, NSS=2000, NPDF=180) 
	PARAMETER (VERSION = 3.0)

C.....Common Blocks
C.....For /GRPVEL/
	REAL GVZ(NFRAB,NSTAT),GVH(NFRAB,NSTAT),GAZ(NFRAB,NSTAT),
     +     GVX(NFRAB,NSTAT),GVY(NFRAB,NSTAT),GSQ(NFRAB,NSTAT),
     +     GVL(NFRAB,NSTAT),GSL(NFRAB,NSTAT)
	INTEGER NGVEL(NFRAB),NGVELOS(NFRAB)
	COMMON /GRPVEL/ GVZ,GVH,GAZ,GVX,GVY,GSQ,GVL,GSL,NGVEL,NGVELOS
	INTEGER NFRABS,NBSRC(NFRAB)
	LOGICAL TRUEHEIGHT
C.....For /BOUNDS/
	REAL BFRQ(NFRAB,2),BRNG(NFRAB,2),BANG(NFRAB,4)
	COMMON /BOUNDS/ NFRABS,TRUEHEIGHT,BFRQ,BRNG,BANG,NBSRC
C
	INTEGER UNIT,IFRB,NVAR,I
	LOGICAL ERROR
	CHARACTER*17 CTIME
C
	ERROR = .FALSE.
	NVAR = 8
C
	WRITE(UNIT,101,ERR=900) CTIME(2),IFRB,NSTAT,NVAR,VERSION
	WRITE(UNIT,104,ERR=900) 'BIN',BFRQ(IFRB,1),BFRQ(IFRB,2),
     +                         BRNG(IFRB,1),BRNG(IFRB,2),
     +                         (BANG(IFRB,I),I=1,4),
     +                         NGVEL(IFRB),NGVELOS(IFRB)
	WRITE(UNIT,102,ERR=900) 'VZ ',(GVZ(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'VH ',(GVH(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'AZ ',(GAZ(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'VX ',(GVX(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'VY ',(GVY(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,103,ERR=900) 'SQ ',(GSQ(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'VL ',(GVL(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'SL ',(GSL(IFRB,I),I=1,NSTAT)
	RETURN
 101	FORMAT (1X,A17,3I5,F5.2)
 102	FORMAT (1X,A3,12F10.2)
 103	FORMAT (1X,A3,12F10.4)
 104	FORMAT (1X,A3,8F10.2,2I6)
C
 900	ERROR = .TRUE.
	WRITE(*,*) ' WRITEGROUPDATA -- Error in writing to file.'
	RETURN
	END
C
C ==========================================================================
C
	SUBROUTINE READGROUPDATA(UNIT,IFRB,EOF)
C
C	Reads data into the /GRPVEL/ common block for the bin IFRB
C	as well as some /TIME/ and /BOUNDS/ information from the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable EOF is set if the end of file
C	is encountered in a READ operation.
C
C	   IVAR   =  The number of variables  to read from the file
C	   NVAR   =  The number of variables the routine expects to find.
C	   ISTAT  =  The number of statistics to read from the file.
C	   NSTAT  =  The maximum number of statistics /GRPVEL/ can hold.
C
C.....Program Parameters.  NOTE: NPDF must be EVEN.
	INTEGER NIND,NFRAB,NSTAT,NSS,NPDF
	REAL VERSION
	PARAMETER (NIND=1000, NFRAB=32, NSTAT=7, NSS=2000, NPDF=180) 
	PARAMETER (VERSION = 3.0)
C.....Common Blocks
C.....For /GRPVEL/
	REAL GVZ(NFRAB,NSTAT),GVH(NFRAB,NSTAT),GAZ(NFRAB,NSTAT),
     +     GVX(NFRAB,NSTAT),GVY(NFRAB,NSTAT),GSQ(NFRAB,NSTAT),
     +     GVL(NFRAB,NSTAT),GSL(NFRAB,NSTAT)
	INTEGER NGVEL(NFRAB),NGVELOS(NFRAB)
	COMMON /GRPVEL/ GVZ,GVH,GAZ,GVX,GVY,GSQ,GVL,GSL,NGVEL,NGVELOS
C.....For /TIME/
	REAL*8 STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME
	CHARACTER*17 CSTIME,CETIME,CNTIME,CLTIME,CCSTIME
	INTEGER NR2DO
	COMMON /TIME/ STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME,
     +              CSTIME,CETIME,CNTIME,CLTIME,CCSTIME,NR2DO
C.....For /BOUNDS/
	INTEGER NFRABS,NBSRC(NFRAB)
	LOGICAL TRUEHEIGHT
	REAL BFRQ(NFRAB,2),BRNG(NFRAB,2),BANG(NFRAB,4)
	COMMON /BOUNDS/ NFRABS,TRUEHEIGHT,BFRQ,BRNG,BANG,NBSRC
C
	INTEGER UNIT,IFRB,NVAR,I,ISTAT,IVAR
	REAL VSN
	LOGICAL EOF
	CHARACTER*3 JUNK
C
	EOF = .FALSE.
	NVAR = 8
C
	READ(UNIT,101,END=900) CCSTIME,IFRB,ISTAT,IVAR,VSN
	IF((ISTAT.GT.NSTAT).OR.(IVAR.GT.NVAR).OR.(VSN.NE.VERSION))THEN
	   WRITE(*,*) ' READGROUPDATA --> Incompatable file format.'
	   GOTO 900
	ENDIF
	READ(UNIT,104,END=900) JUNK,BFRQ(IFRB,1),BFRQ(IFRB,2),
     +                         BRNG(IFRB,1),BRNG(IFRB,2),
     +                         (BANG(IFRB,I),I=1,4),
     +                         NGVEL(IFRB),NGVELOS(IFRB)
	IF (IVAR.GT.0)
     +   READ(UNIT,102,END=900) JUNK,(GVZ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.1)
     +   READ(UNIT,102,END=900) JUNK,(GVH(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.2) 
     +   READ(UNIT,102,END=900) JUNK,(GAZ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.3)
     +   READ(UNIT,102,END=900) JUNK,(GVX(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.4) 
     +   READ(UNIT,102,END=900) JUNK,(GVY(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.5)
     +   READ(UNIT,103,END=900) JUNK,(GSQ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.6)
     +   READ(UNIT,102,END=900) JUNK,(GVL(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.7)
     +   READ(UNIT,103,END=900) JUNK,(GSL(IFRB,I),I=1,ISTAT)
	RETURN
 101	FORMAT (1X,A17,3I5,F5.2)
 102	FORMAT (1X,A3,12F10.2)
 103	FORMAT (1X,A3,12F10.4)
 104	FORMAT (1X,A3,8F10.2,2I6)
C
 900	EOF = .TRUE.
	RETURN
	END
C
C ==========================================================================
C
	CHARACTER*17 FUNCTION CTIME(ISEL)
C	
C	As a convenience feature, this function returns the CHARACTER*17 time
C	indicated by ISEL.
C
C	1) Current time (CNTIME)
C	2) Start time of current accumulation (CCSTIME)
C	3) Start time of entire run (CSTIME)
C	4) End time of entire run (CETIME)
C	5) CCSTIME, truncated to previous ATIME Min.
C	6) CCSTIME in Decimal Hours.
C
	REAL*8 STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME
	CHARACTER*17 CSTIME,CETIME,CNTIME,CLTIME,CCSTIME
	INTEGER NR2DO
	COMMON /TIME/ STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME,
     +              CSTIME,CETIME,CNTIME,CLTIME,CCSTIME,NR2DO

C
	INTEGER ISEL,IAT,IROUND,IH,IM,IS
	REAL RH,RM
	CHARACTER*17 CTT
C
	IF (ISEL.EQ.1) THEN
	   CTIME = CNTIME
	ELSE IF (ISEL.EQ.2) THEN
	   CTIME = CCSTIME
	ELSE IF (ISEL.EQ.3) THEN
	   CTIME = CSTIME
	ELSE IF (ISEL.EQ.4) THEN
	   CTIME = CETIME
	ELSE IF (ISEL.EQ.5) THEN
	   IF (ATIME.LE.0.0) RETURN
	   CTT = CCSTIME
C........# of Minutes to round off to.
	   RM = ATIME/60.
	   IAT = MAX(IROUND(RM),1)
	   READ (CTT,'(9X,I2,1X,I2,1X,I2)') IH,IM,IS
	   RM = IM + IS/60.
	   IM = IAT*INT(RM/IAT)
	   IF (IM.GE.60) THEN
	      IH = IH + 1
	      IM = IM - 60
	   ENDIF
	   IS = 0
	   WRITE(CTT,'(A9,I2.2,A1,I2.2,A1,I2.2)') CTT,IH,':',IM,':',IS
	   CTIME = CTT
	ELSE IF (ISEL.EQ.6) THEN
C........Time in YYYY DDD HH.HHHHH
	   CTT = CCSTIME
	   READ (CTT,'(9X,I2,1X,I2,1X,I2)') IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
	   WRITE(CTT,'(A9,F8.5)') CTT(1:9),RH
	   CTIME = CTT
	ELSE
	   CTIME = 'CTIME:Bad option '
	ENDIF
	RETURN
	END
C
	INTEGER FUNCTION IROUND(VALUE)
C
	REAL VALUE
	IF (VALUE.GE.0) THEN
	   IROUND = INT(VALUE + 0.50001)
	ELSE
	   IROUND = INT(VALUE - 0.50001)
	ENDIF
	RETURN
	END
