$DECLARE
$NOTRUNCATE
C
	PROGRAM DFTVEL
C
C	This program reads a Velocity vector file and produces
C	an array of velocities vs time.  A Discrete Fourier Transform is
C	performed of the velocity data, so that it can be filtered.
C	The DFT is modified to allow a random time step from sample to
C	sample.
C	  I don't know how well this really works.
C
C
C.....Parameters
$INCLUDE:'COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'COMMON\VELDATA.CMN'
$INCLUDE:'COMMON\FRQDATA.CMN'
$INCLUDE:'COMMON\GRPVEL.CMN'
$INCLUDE:'COMMON\TIME.CMN'
$INCLUDE:'COMMON\BOUNDS.CMN'
C
C
C  /VELDATA/   - Velocity data, read from the file.
C	MVEL     - Maximum number of velocities.
C	VTIME()  - Time of measurement 
C	DVTIME() - Time difference between measurements. 
C	VELX()   - X component of velocity
C	VELY()   - Y component of velocity
C	VELZ()   - Z component of velocity
C
C
C  /GRPVEL/        -  Statistical data for the Group Velocity in NFRAB
C	                possible Frequency-Range-Angle Bins.
C	                NFRAB and NSTAT are program parameters.
C	                The second index indicates which value is contained. 
C GVZ(NFRAB,NSTAT) -  Statistics for the Group Velocity Z-component.
C	     , 1)    -  Mean
C	     , 2)    -  Standard Deviation
C	     , 3)    -  Median
C	     , 4)    -  Upper quartile
C	     , 5)    -  Lower quartile
C	     , 6)    -  Most probable
C	     , 7)    -  Least Square fit to ALL data. 
C   8) -,NSTAT)    -  For future use  
C GVH(NFRAB,NSTAT) -  Statistics for the Group Velocity Horizontal magnitude.
C GAZ(NFRAB,NSTAT) -  Statistics for the Group Velocity horizontal AZimuth.
C GVX(NFRAB,NSTAT) -  Statistics for the Group Velocity X component.
C GVY(NFRAB,NSTAT) -  Statistics for the Group Velocity Y component.
C GSQ(NFRAB,NSTAT) -  Statistics for the velocity root mean square error.
C GVL(NFRAB,NSTAT) -  Statistics for the Group Velocity Line-of-Sight.
C GSL(NFRAB,NSTAT) -  Statistics for the LOS velocity root mean square error.
C NGVEL(NFRAB)     -  Number of measurements at each FRAB.
C NGVELOS(NFRAB)   -  Number of measurements at each FRAB.
C
C  /BOUNDS/      -  Data in this common block define the limits in
C                   Frequency, Range and Arrival Angle for each of the
C	              NFRAB's. 
C  NFRABS        -  Number of FRAB's defined.  Must be <= NFRAB.
C  TRUEHEIGHT    -  Logical flag selecting between true and virtual height
C	              selection of the data.  *** TRUE HEIGHT NOT YET AVAILABLE ***
C  BFRQ(NFRAB,2) -  Bounds upon the FReQuency, upper ,1) and lower ,2)
C  BRNG(NFRAB,2) -  Bounds upon the RaNGe, upper ,1) and lower ,2)
C  BANG(NFRAB,4) -  Bounds on the ANGles of arrival for this bin.
C                   ,1) = Zenith angle of the Line-of-Sight direction (deg).
C                   ,2) = Azimuth of the Line-of-Sight direction (deg).
C                   ,3) = Half 'Beamwidth' in Zenith (deg).
C                   ,4) = Half 'Beamwidth' in Azimuth (deg).
C  NBSRC(NFRAB)  - Number of sources in each FRAB
C
C
C
	INTEGER IU,OU,IFRB,NVEL,NFRQ,I,ITIME,TTYPE(3),GETINT
	INTEGER L1,L2,L3,L4,MIDF,IR
	REAL FMIN,FMAX,FSTEP,FCUTOFF,T,DT,RAN2,TM,TA,TS,TV,TK,TC,
     +     DTR,DTMAX
	LOGICAL EOF,FIRST
	COMPLEX ZERO
	REAL*8 PARCTIME
	CHARACTER*30 INFILE,OUTFILE
	CHARACTER*17 CTIME, CCST(MVEL)

C
	IU = 2
	OU = 3
	ZERO = CMPLX(0.0, 0.0)
	DATA TTYPE/2,6,7/
C	Get the time and initialize the random number generator.
	CALL GETTIM(L1,L2,L3,L4)
	DT = RAN2(-L4)

C
	WRITE(*,*) ' DFTVEL - Program for Fourier filtering of '
	WRITE(*,*) '          Digisonde Drift Data.'
c
 901	WRITE(*,*) ' Enter the name of the .VELocity file.'	
	READ(*,102) INFILE
cx	OPEN(UNIT=IU,FILE=INFILE,FORM='FORMATTED',ACCESS='SEQUENTIAL',
cx     +     STATUS='OLD',ERR=901)
C

 902	WRITE(*,*) ' Enter the name of the output file.'	
	READ(*,102) OUTFILE
	OPEN(UNIT=OU,FILE=OUTFILE,FORM='FORMATTED',ACCESS='SEQUENTIAL',
     +     STATUS='UNKNOWN',ERR=902)
C
C
	WRITE(*,*) ' Time format:'
	WRITE(*,*) '    1)  Standard format (YYYY DDD HH:MM:SS)'
	WRITE(*,*) '    2)  Decimal hours   (YYYY DDD HH.HHHHH)'
	WRITE(*,*) '    3)  Decimal days    (YYYY DDD.DDDDDDDD)'
	ITIME = GETINT(1,3)
	ITIME = TTYPE(ITIME)

C
C	Read entire .VEL file first
cx	EOF = .FALSE.
	EOF = .TRUE.   ! for testing, reads no data.
	FIRST = .FALSE.
	NVEL = 0
	DO WHILE (.NOT.EOF.AND.NVEL.LT.MVEL)
	   CALL READGROUPDATA(IU,IFRB,EOF)
	   IF (GVX(IFRB,1).EQ.0.0) CYCLE
	   NVEL = NVEL + 1
	   IF (FIRST) THEN
	      FIRST = .FALSE.
	      STARTTIME = PARCTIME(CCSTIME)
	   ENDIF
	   NOWTIME = PARCTIME(CCSTIME)
	   CCST(NVEL) = CCSTIME
	   VTIME(NVEL) = NOWTIME - STARTTIME
	   WRITE(*,*) CCSTIME
C	   NOTE - This will not work if there are multiple FRB's.
	   VELX(NVEL) = GVX(IFRB,1)
	   VELY(NVEL) = GVY(IFRB,1)
	   VELZ(NVEL) = GVZ(IFRB,1)
	   write(ou,105) ctime(itime),velx(nvel),vely(nvel),velz(nvel)
C	   Worry about error bars later
	ENDDO
	NVEL = NVEL - 1
	WRITE(*,*) NVEL,' Velocities read.'
c
C	Test data, uniform time step.
	nvel = 100
	dt = 0.05
	ir = -15
	dtr = ran2(ir)
	vtime(1) = 0.0
	velx(1) = 0.0
	vely(1) = 0.0
	velz(1) = 0.0
	ir = 3047
	dvtime(1) = dt
	do i = 2, nvel
c	   Occasionally omit a data point
	   dtr = ran2(ir)
	   if (dtr.lt.0.20) then
	      vtime(i) = vtime(i-1) + 2.0*dt
	   else
	      vtime(i) = vtime(i-1) + dt
	   endif
	   dvtime(i) = vtime(i) - vtime(i-1)
	   velx(i) = 10.*sin(10.*vtime(i)) + 5.0*cos(5.0*vtime(i))
	   vely(i) = 10.*sin(15.*vtime(i)) + 10.0*cos(8.0*vtime(i))
	   velz(i) = velx(i)*vely(i)
	enddo
	do i = 1, nvel
	   write(ou,103) vtime(i),real(velx(i)),real(vely(i)),
     +                          real(velz(i))
	enddo
	write(ou,*) ' '
C	Find the maximum time step.
	DTMAX = 0.0
	DO I = 2, NVEL
	   DTR = VTIME(I) - VTIME(I-1)
	   IF (DTR.GT.DTMAX) DTMAX = DTR
	   IF (DTR.LE.0.0) WRITE(*,*) ' Error in time sequence of data.'
	ENDDO
	WRITE(*,*) ' Maximum dT is ',DTMAX
C	   
C	Use SUBROUTINE MOMENT(DATA,N,AVE,ADEV,SDEV,VAR,SKEW,CURT) to
C	calculate statistics on the time differences in this data set.
	CALL MOMENT(DVTIME,NVEL,TM,TA,TS,TV,TK,TC)
	WRITE(*,107) 'dT Stats are:','Mean','Adev','Sdev','Var',
     +                            'Skew','Kurt'
	WRITE(*,108) ' ',TM,TA,TS,TV,TK,TC
C
C	Set up a frequency table.  VTIME is in seconds, F is in HZ.
C	An estimete of dT is made by dividing the total time interval T by
C	the number of samples.  dT is used to calculate the critical frequency,
C	and 1/T is used for the frequency resolution.
C	NOTE: This frequency table must be sorted.
	T = VTIME(NVEL) - VTIME(1)
	DT =  T / NVEL
	FMIN  = 1.0 / T
	FSTEP = FMIN
C	Nyqest:  The highest freq should correspond to the largest dT.
	FMAX  = 0.5/DTMAX
	NFRQ = INT(2.0*FMAX/FSTEP)
C
C	Force a zero frequency entry by having NFRQ be odd.
	IF (MOD(NFRQ,2).EQ.0) NFRQ = NFRQ + 1
	MIDF = NFRQ/2 + 1
	WRITE(*,104) 'Freq Limits:','Fmin','Fmax','Fstep','#Frq'
	WRITE(*,105) ' ',FMIN,FMAX,FSTEP,REAL(NFRQ)
C	Now input the filtering limits.
	WRITE(*,*) ' Velocity (low-pass) Filter Parameters.'
	WRITE(*,*) ' Enter cutoff period (sec) as a negative number'
	WRITE(*,*) ' or enter the cutoff freq (Hz) as a positive number.'
	READ(*,*) FCUTOFF
	IF (FCUTOFF.LT.0.0) FCUTOFF = ABS(1.0/FCUTOFF)
C
	WRITE(*,105) ' Filter cutoff = ',FCUTOFF
	DO I = 0, MIDF-1
	   FVAL(MIDF+I) =  FSTEP*REAL(I)
	   FVAL(MIDF-I) = -FVAL(MIDF+I)
 	ENDDO
C
C	Now that the table is set up, start the transforms.
C
C	X component
	WRITE(*,*) ' Transforming Vx ...'
	CALL DFT(VTIME,VELX,FVAL,FRQX,NVEL,NFRQ,+1)
C	Y component
	WRITE(*,*) ' Transforming Vy ...'
	CALL DFT(VTIME,VELY,FVAL,FRQY,NVEL,NFRQ,+1)
C	Z component
	WRITE(*,*) ' Transforming Vz ...'
	CALL DFT(VTIME,VELZ,FVAL,FRQZ,NVEL,NFRQ,+1)
C
	WRITE(OU,*) ' Power Spectral Densities'
	WRITE(OU,104) 'Freq','Fx','Fy','Fz'
	DO I = 1, NFRQ
	   WRITE(OU,106) FVAL(I),CABS(FRQX(I)),CABS(FRQY(I)),
     +                         CABS(FRQZ(I))
	ENDDO
c
	WRITE(*,*) ' Filtering velocities ...'
	DO I = 1, NFRQ
	   IF (ABS(FVAL(I)).GT.FCUTOFF) THEN
	      FRQX(I) = ZERO
	      FRQY(I) = ZERO
	      FRQZ(I) = ZERO
	   ENDIF
	ENDDO
C
	WRITE(OU,104) 'Freq','Fxr','Fxi','Fyr','Fyi','Fzr','Fzi'
	DO I = 1, NFRQ
	   WRITE(OU,106) FVAL(I),FRQX(I),FRQY(I),FRQZ(I)
	ENDDO
C	Reverse the transforms.
C	X component
	WRITE(*,*) ' Transforming Vx ...'
	CALL DFT(VTIME,VELX,FVAL,FRQX,NVEL,NFRQ,-1)
C	Y component
	WRITE(*,*) ' Transforming Vy ...'
	CALL DFT(VTIME,VELY,FVAL,FRQY,NVEL,NFRQ,-1)
C	Z component
	WRITE(*,*) ' Transforming Vz ...'
	CALL DFT(VTIME,VELZ,FVAL,FRQZ,NVEL,NFRQ,-1)
C
	WRITE(*,*) 'Transforms complete.  Saving results ...'
	WRITE(OU,104) 'Time (UT)','Vxr','Vxi','Vyr','Vyi','Vzr','Vzi'
	DO I = 1, NVEL
	   CCSTIME = CCST(I)
	   WRITE(OU,106) vtime(i),velx(i),vely(i),velz(i)
c	   WRITE(OU,105) CTIME(ITIME),VELX(I),VELY(I),VELZ(I)
	ENDDO
C
	CLOSE(IU)
	CLOSE(OU)
C
 101	FORMAT (6F10.3)
 102	FORMAT (A)
 103	FORMAT (8F10.3)
 104	FORMAT (A17,6A8)
 105	FORMAT (A17,6F8.2)
 106	FORMAT (F17.10,6F8.2)
 107	FORMAT (A17,6A8)
 108	FORMAT (A,6F10.5)

	END
C
C ==========================================================================
C
	SUBROUTINE DFT(T,FT,F,FF,NT,NF,IDIR)
C
C	Computes the Discrete Fourier Transform of the input array.
C	T  - Table of times, in seconds
C	FT - Function of time T to be transformed.
C	F  - Table of frequencies, in Hertz.
C	FF - Function of Frequency F to be transformed.
C	NT - Number of points in the time function
C	NF - number of points in the frequency function
C	IDIR - determines the direction of the transfer,
C	   +1 is a forward transform, time into frequency
C	   -1 is a reverse transform, frequency into time.
C
	INTEGER NT,NF,IDIR,IF,IT
	REAL T(NT),F(NF),PI,SCALE
	COMPLEX FT(NT),FF(NF),ZERO,CPART,C2PII,CFUNL
C
	PI = 4.0*ATAN(1.0)
	ZERO = CMPLX(0.0, 0.0)
	C2PII = CMPLX(0.0, 2.0*PI)
C
	IF (IDIR.GT.0) THEN
C	   Perform the forward transform
	   SCALE = 1.0
	   DO IF = 1, NF
	      FF(IF) = ZERO
C	      Perform the integration here.  Use the trapeziodal rule.
C	      There are N-1 intervals to add together.
	      CFUNL = FT(1)*CEXP(-C2PII*F(IF)*T(1))
	      DO IT = 2, NT
	         CPART = FT(IT)*CEXP(-C2PII*F(IF)*T(IT))
	         FF(IF) = FF(IF) + 0.5*(T(IT)-T(IT-1))*(CPART+CFUNL)
	         CFUNL = CPART
	      ENDDO
	      FF(IF) = FF(IF) * SCALE
	   ENDDO
	ELSE
C	   Perform the reverse transform.
	   SCALE = 1.0
	   DO IT = 1, NT
	      FT(IT) = ZERO
	      CFUNL = FF(1)*CEXP(C2PII*F(1)*T(IT))
C	      Perform the integration here.  Use the trapeziodal rule.
	      DO IF = 2, NF
	         CPART = FF(IF)*CEXP(C2PII*F(IF)*T(IT))
	         FT(IT) = FT(IT) + 0.5*(F(IF)-F(IF-1))*(CPART+CFUNL)
	         CFUNL = CPART
	      ENDDO
	      FT(IT) = FT(IT) * SCALE
	   ENDDO
	ENDIF
C
	RETURN
	END
C
C ==========================================================================
C
	SUBROUTINE READGROUPDATA(UNIT,IFRB,EOF)
C
C	Reads data into the /GRPVEL/ common block for the bin IFRB
C	as well as some /TIME/ and /BOUNDS/ information from the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable EOF is set if the end of file
C	is encountered in a READ operation.
C
C	   IVAR   =  The number of variables  to read from the file
C	   NVAR   =  The number of variables the routine expects to find.
C	   ISTAT  =  The number of statistics to read from the file.
C	   NSTAT  =  The maximum number of statistics /GRPVEL/ can hold.
C
C.....Parameters
$INCLUDE:'COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'COMMON\GRPVEL.CMN'
$INCLUDE:'COMMON\TIME.CMN'
$INCLUDE:'COMMON\BOUNDS.CMN'

C
	INTEGER UNIT,IFRB,NVAR,I,ISTAT,IVAR
	REAL VSN
	LOGICAL EOF
	CHARACTER*3 JUNK
C
	EOF = .FALSE.
	NVAR = 8
C
	READ(UNIT,101,END=900) CCSTIME,IFRB,ISTAT,IVAR,VSN
	IF((ISTAT.GT.NSTAT).OR.(IVAR.GT.NVAR).OR.(VSN.GT.VERSION))THEN
	   WRITE(*,*) ' READGROUPDATA --> Incompatable file format.'
	   GOTO 900
	ENDIF
	READ(UNIT,104,END=900) JUNK,BFRQ(IFRB,1),BFRQ(IFRB,2),
     +                         BRNG(IFRB,1),BRNG(IFRB,2),
     +                         (BANG(IFRB,I),I=1,4),
     +                         NGVEL(IFRB),NGVELOS(IFRB)
	IF (IVAR.GT.0)
     +   READ(UNIT,102,END=900) JUNK,(GVZ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.1)
     +   READ(UNIT,102,END=900) JUNK,(GVH(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.2) 
     +   READ(UNIT,102,END=900) JUNK,(GAZ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.3)
     +   READ(UNIT,102,END=900) JUNK,(GVX(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.4) 
     +   READ(UNIT,102,END=900) JUNK,(GVY(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.5)
     +   READ(UNIT,103,END=900) JUNK,(GSQ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.6)
     +   READ(UNIT,102,END=900) JUNK,(GVL(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.7)
     +   READ(UNIT,103,END=900) JUNK,(GSL(IFRB,I),I=1,ISTAT)
	RETURN
 101	FORMAT (1X,A17,3I5,F5.2)
 102	FORMAT (1X,A3,12F10.2)
 103	FORMAT (1X,A3,12F10.4)
 104	FORMAT (1X,A3,8F10.2,2I6)
C
 900	EOF = .TRUE.
	RETURN
	END
C
C ========================================================================
C
	INTEGER FUNCTION GETINT(A,B)
C	Returns an integer read from the console in the range (A,B)
C
	INTEGER A,B,I
 10	READ(*,*,ERR=10) I
	IF ((I.LT.A).OR.(I.GT.B)) THEN
	   WRITE(*,*) ' Invalid choice, try again ...'
	   GOTO 10
	ENDIF
	GETINT = I
	WRITE(*,*) ' '
	RETURN
	END
C
C========================================================================
C
      REAL*8 FUNCTION PARSETIME(TIME)
C            This function takes an integer array of 11 values and
C         calculates the approximate number of seconds since January, 1900.
C         These values are for comparison purposes only.
C	    Performance across year boundires is not optimal, esp. leap years.
C         Will fail past the year 2000.
C
      INTEGER*2 TIME(11)
C         Seconds per year
      PARSETIME = 31662400.*(10*TIME(1)+ TIME(2))
C         Seconds per day
      PARSETIME = PARSETIME + 86400.*(100*TIME(3)+10*TIME(4)+TIME(5))
C         Seconds per hour
      PARSETIME = PARSETIME + 3600.*(10*TIME(6) + TIME(7))
C         Seconds per minute
      PARSETIME = PARSETIME + 60.*(10*TIME(8) + TIME(9))
C         And finally the seconds
      PARSETIME = PARSETIME + 10.*TIME(10) +1.*TIME(11)
      RETURN
      END
C
C========================================================================
C
	CHARACTER*17 FUNCTION CTIMELTT(LTT)
C.....Converts the 11 INTEGER*2 argument LTT into the 17 character
C.....CTT time format.
	INTEGER*2 I,LTT(11)
	CTIMELTT = ' '
	WRITE(CTIMELTT,102) (LTT(I),I=1,11)
 102	FORMAT ('19',2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
	RETURN
	END
C
C========================================================================
C
	REAL*8 FUNCTION PARCTIME(CTT)
C
C	Parse a CHARACTER*17 time into a REAL*8 time.
C
	REAL*8 PARSETIME
	CHARACTER*17 CTT
	INTEGER*2 LTT(11),ZERO,I
C
	ZERO = ICHAR('0')
C.....Year.
	LTT(1)  = ICHAR(CTT(3:3))   - ZERO
	LTT(2)  = ICHAR(CTT(4:4))   - ZERO
C.....Day.
	LTT(3)  = ICHAR(CTT(6:6))   - ZERO
	LTT(4)  = ICHAR(CTT(7:7))   - ZERO
	LTT(5)  = ICHAR(CTT(8:8))   - ZERO
C.....Hour.
	LTT(6)  = ICHAR(CTT(10:10)) - ZERO
	LTT(7)  = ICHAR(CTT(11:11)) - ZERO
C.....Minute.
	LTT(8)  = ICHAR(CTT(13:13)) - ZERO
	LTT(9)  = ICHAR(CTT(14:14)) - ZERO
C.....Second
	LTT(10) = ICHAR(CTT(16:16)) - ZERO
	LTT(11) = ICHAR(CTT(17:17)) - ZERO
C
	DO 5 I = 1, 11
	   IF (LTT(I).LT.0) LTT(I) = 0
 5	CONTINUE
C
	PARCTIME = PARSETIME(LTT)
	RETURN
	END

C
C ==========================================================================
C
	CHARACTER*17 FUNCTION CTIME(ISEL)
C	
C	As a convenience feature, this function returns the CHARACTER*17 time
C	indicated by ISEL.
C
C	1) Current time (CNTIME)
C	2) Start time of current accumulation (CCSTIME)
C	3) Start time of entire run (CSTIME)
C	4) End time of entire run (CETIME)
C	5) CCSTIME, truncated to previous ATIME Min.
C	6) CCSTIME in Decimal Hours.
C	7) CCSTIME in Decimal Days.
C
$INCLUDE:'COMMON\TIME.CMN'

C
	INTEGER ISEL,IAT,ID,IH,IM,IS
	REAL RH,RM
	CHARACTER*17 CTT
C
	IF (ISEL.EQ.1) THEN
	   CTIME = CNTIME
	ELSE IF (ISEL.EQ.2) THEN
	   CTIME = CCSTIME
	ELSE IF (ISEL.EQ.3) THEN
	   CTIME = CSTIME
	ELSE IF (ISEL.EQ.4) THEN
	   CTIME = CETIME
	ELSE IF (ISEL.EQ.5) THEN
	   IF (ATIME.LE.0.0) RETURN
	   CTT = CCSTIME
C........# of Minutes to round off to.
	   RM = ATIME/60.
	   IAT = MAX(NINT(RM),1)
	   READ (CTT,105) IH,IM,IS
	   RM = IM + IS/60.
	   IM = IAT*INT(RM/IAT)
	   IF (IM.GE.60) THEN
	      IH = IH + 1
	      IM = IM - 60
	   ENDIF
	   IS = 0
	   WRITE(CTT,115) CTT,IH,':',IM,':',IS
	   CTIME = CTT
	ELSE IF (ISEL.EQ.6) THEN
C........Time in YYYY DDD HH.HHHHH
	   CTT = CCSTIME
	   READ (CTT,105) IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
	   WRITE(CTT,116) CTT(1:9),RH
	   CTIME = CTT
	ELSE IF (ISEL.EQ.7) THEN
C........Time in YYYY DDD.DDDDDDDD
	   CTT = CCSTIME
	   READ (CTT,107) ID,IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
		RH = ID + RH/24.0
	   WRITE(CTT,117) CTT(1:5),RH
	   CTIME = CTT
	ELSE
	   CTIME = 'CTIME:Bad option '
	ENDIF
 105	FORMAT (9X,I2,1X,I2,1X,I2)
 107	FORMAT (5X,I3,1X,I2,1X,I2,1X,I2)
 115	FORMAT (A9,I2.2,A1,I2.2,A1,I2.2)
 116	FORMAT (A9,F8.5)
 117	FORMAT (A5,F12.8)
	RETURN
	END
C
C  =============================================================
C
	REAL FUNCTION RAN2(IDUM)
C
C	Returns a uniform random deviate between 0.0 and 1.0.  Set argument
C	IDUM to any negative value to initialize or reinitialize the sequence.
C
	INTEGER M,IA,IC,IY,IDUM,IR(97),IFF,J
	REAL RM
	PARAMETER (M=714025,IA=1366,IC=150889,RM=1.0/M)
	DATA IFF / 0/
C
	IF ((IDUM.LT.0).OR.(IFF.EQ.0)) THEN
	   IFF = 1
	   IDUM = MOD(IC-IDUM,M)
C	   Initialize the shuffle table.
	   DO 11 J = 1, 97
	      IDUM = MOD(IA*IDUM+IC,M)
	      IR(J) = IDUM
 11	   CONTINUE
	   IDUM = MOD(IA*IDUM+IC,M)
	   IY = IDUM
	ENDIF
	J = 1+(97*IY)/M
	IF ((J.GT.97).OR.(J.LT.1)) J = 1
	IY = IR(J)
	RAN2 = IY*RM
	IDUM =MOD(IA*IDUM+IC,M)
	IR(J) = IDUM
	RETURN
	END
C
C   ============================================================
C
	SUBROUTINE MOMENT(DATA,N,AVE,ADEV,SDEV,VAR,SKEW,CURT)
C
C	Given an array of DATA lenght N, this routine returns its mean in
C	AVE, (first moment) the average deviation ADEV, the standard deviation
C     SDEV (second moment), the variance VAR, the skewness SKEW (third
C	moment) and the kutrosis CURT (fourth moment).
C
	INTEGER N,J
	REAL DATA(N),AVE,ADEV,SDEV,VAR,SKEW,CURT,S,P,TINY,huge
	PARAMETER (TINY=1.0E-8, HUGE=1.0E8)
C
	IF(N.LT.1) THEN
	   AVE  = 0.0
	   ADEV = 0.0
	   SDEV = 0.0
	   VAR  = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	   RETURN
	ENDIF
	IF (N.EQ.1) THEN
	   AVE  = DATA(1)
	   ADEV = 0.0
	   SDEV = 0.0
	   VAR  = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	   RETURN
	ENDIF
C
	S = 0.0
	DO 11 J = 1, N
	   S = S + DATA(J)
 11	CONTINUE
	AVE = S/N
	ADEV = 0.0
	VAR = 0.0
	SKEW = 0.0 
	CURT = 0.0
	DO 12 J = 1, N
	   S = DATA(J) - AVE
	   ADEV = ADEV + ABS(S)
C	   Attempt to eliminate overflow
	   P = MIN( S*S, HUGE)
	   VAR = VAR + P
	   P = P * S
	   SKEW = SKEW + P
	   P = MIN( P * S, HUGE)
	   CURT = CURT + P
 12	CONTINUE
	ADEV = ADEV/N
	VAR = VAR /(N-1)
	IF (VAR.GT.TINY) THEN
	   SDEV = SQRT(VAR)
	   SKEW = SKEW/(N*SDEV**3)
	   CURT = CURT/(N*VAR**2) - 3
	ELSE
C	   SKEW and CURT are undefined.
	   SDEV = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	ENDIF
	RETURN
	END

