$DECLARE
$NOTRUNCATE
C
	PROGRAM DRIFTFQ
C
C	Extract Time and Frequency information from SKYMAP files
C	into a text file.
C
$INCLUDE:'COMMON\MAPDATA.CMN'
C
	INTEGER IU,OU,IY,ID,IH,IM,IS,I,K,ITF
	LOGICAL EOF
	CHARACTER*40 INFILE,LFILE,ETIME,STIME,TIME
	REAL HOUR,DAY,FFF(4)
C
	IU = 12
	OU = 13
C
	WRITE(*,*) ' Extract Drift Frequency Data from SKYMAP files'
	WRITE(*,*) ' '
C
 2	WRITE(*,*) ' Enter the name of the file with the Skymap data:'
	READ(*,'(A)') INFILE
	OPEN(UNIT=IU,FILE=INFILE,FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS='OLD',ERR=2)

 3	WRITE(*,*) ' Name of the file for the data listings.'
	READ(*,'(A)') LFILE
	OPEN(UNIT=OU,FILE=LFILE,FORM='FORMATTED',MODE='WRITE',
     +    ACCESS='SEQUENTIAL',ERR=3)
C
	WRITE(*,*) ' Output time in decimal:'
	WRITE(*,*) '    1) Hours'
	WRITE(*,*) '    2) Days'
	WRITE(*,*) '    3) YY DDD HH:MM:SSS'
	READ(*,*) ITF
C
	K = 0
	CALL READMAPDATA(IU,EOF)
	DO WHILE (.NOT.EOF)
	   K = K + 1
 	   WRITE(ETIME,101) (IDPREF(I),I=1,11)
	   READ(ETIME,104) IY,ID,IH,IM,IS
	   IF (K.EQ.1) STIME = ETIME
	   HOUR = IH + (IM + IS/60.)/60.0
	   DAY  = ID + HOUR/24.0
	   IF (ITF.EQ.1) THEN
	      WRITE(TIME,102) HOUR
	   ELSE IF (ITF.EQ.2) THEN
	      WRITE(TIME,102) DAY
	   ELSE
	      TIME = ETIME
	   ENDIF
	   WRITE(*,103) ETIME
C
	   FFF(1) = FREQ / 1.0E6
	   DO 20 I = 2, 4
	      CALL READMAPDATA(IU,EOF)
	      FFF(I) = FREQ/1.0E6
 20	   CONTINUE
C
	   WRITE(OU,103) TIME,(FFF(I),I=1,4)
C
	   CALL READMAPDATA(IU,EOF)
C	   
	ENDDO
C
	CLOSE(OU)
	CLOSE(IU)
C	
 101	FORMAT (2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
 102	FORMAT (F15.4)
 103	FORMAT (1X,A17,4F10.2)
 104	FORMAT (I2,1X,I3,1X,I2,1X,I2,1X,I2)
C
	END
C
C  ======================================================================
C 
	SUBROUTINE READMAPDATA(INFILE,EOF) 
C 
C	READ THE MAP DATA FROM A FILE <infile> FOR LATER USE IN PRINTING 
C	SKYMAPS OR CALCULATING DRIFT VELOCITIES.  FREQUENCY READ IS
C	 <IFF>  THE FORMAT OF THE PREFACE IS AS FOLLOWS:
C
C	NOTE:  Range is converted to meters and Frequency to Hertz.
C 
C
C  POSITION ! FORMAT  !  INFORMATION
C_______________________________________________________________
C  1        ! A1      !  SPACE                                  !
C  2-4      ! 3Z1     !  STATION ID CODE                        !
C  5-9      ! I5      !  RECORD NO.                             !
C  10       ! A1      !  SPACE                                  !
C  11-15    ! 5Z1     !  DATE                                   !
C  16       ! A1      !  SPACE                                  !
C  17-22    ! 6Z1     !  TIME                                   !
C  23       ! 1X      !  SPACE                                  !
C  24       ! Z1      !  PROGRAM SET                            !
C  25       ! Z1      !  PROGRAM TYPE                           !
C  26-31    ! 6Z1     !  JOURNAL (6 HEX DIGITS)                 !
C  32-38    ! 7Z1     !  P1 TO P7 (7 HEX DIGITS)                !
C  39       ! 1X      !  SPACE                                  !
C  40-46    ! 7Z1     !  XLZTNRW (7 HEX DIGITS)                 !
C  47-53    ! 7Z1     !  K(I*)(G*)HEIG (7 HEX DIGITS)           !
C  54-57    ! I4      !  ZMAX (10THS OF A DEGREE)               !
C  58-59    ! I2      !  NFREQ=FREQUENCY NUMBER                 !
C  60-66    ! I7      !  FREQ(NFREQ), IN 100-HZ UNITS           !
C  67-71    ! I5      !  RANG(NFREQ), IN 100-METER UNITS        !
C  72-74    ! I3      !  IGAIN(NFREQ), IN DB                    !
C  75-77    ! I3      !  MPAMP(NFREQ)                           !
C  78-80    ! I3      !  MAXAMP(NFREQ)                          !
C  81-84    ! I4      !  NO. OF SOURCES FOR NFREQ               !
C  85-87    ! I3      !  KTH, CASE SELECTION THRESHOLD          !
C  88-90    ! I3      !  LTH, SPECTRAL LINE SELECTION THRESHOLD ! 
C================================================================
C
	INTEGER INFILE,I,I1,I2,IRNG,IFRQ,IZMAX
	CHARACTER*2 JUNK
	LOGICAL EOF
C
C	VARIABLES FOR THE COMMON BLOCKS
C
C.....For /MAPDATA/
$INCLUDE:'COMMON\MAPDATA.CMN'
C
C
	DO 10 I =1, 89
 10   IDPREF(I) = 0
	DO 20 I=1,256
	   XMAP(I) = 0.0
	   YMAP(I) = 0.0
	   MAPAMP(I) = 0
	   MAPRMS(I) = 0
 20   CONTINUE
	EOF = .FALSE.
C
	READ(INFILE,110,END=99) (IDPREF(I),I=41,43),NMAP,
     +  (IDPREF(I),I=1,19), (IDPREF(I),I=26,32),(IDPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC
C
 110	FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +	  I4,I2,I7,I5,4I3,I4) 
C
	RANGE = FLOAT(IRNG)*100.
	FREQ =  FLOAT(IFRQ)*100.
	ZMAX =  FLOAT(IZMAX)/10.
	 
	DO 140 I1=1,NUMSRC,26 
	   I2=I1+25
	   IF(I2.GT.NUMSRC) I2=NUMSRC 
	   READ(INFILE,151) JUNK,(YMAP(I),I=I1,I2) 
	   READ(INFILE,151) JUNK,(XMAP(I),I=I1,I2) 
	   READ(INFILE,150) JUNK,(MAPAMP(I),I=I1,I2)
	   READ(INFILE,150) JUNK,(MAPDOP(I),I=I1,I2) 
	   READ(INFILE,150) JUNK,(MAPRMS(I),I=I1,I2) 
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C 
	RETURN
C     End of File condition.
 99   EOF = .TRUE.
 	NUMSRC = 0
	RETURN
	END 
C
