$DECLARE
$NOTRUNCATE
C
	PROGRAM DRIFTHT
C
C	Extract Time and Frequency information from SKYMAP files
C	and use contour info from an ADEP file to produce a file
C	of freq and true height vs time.
C
$INCLUDE:'COMMON\MAPDATA.CMN'
$INCLUDE:'COMMON\ADEP.CMN'
$INCLUDE:'COMMON\COEFS.CMN'
C
	INTEGER IU,OU,AU,IY,ID,IH,IM,IS,I,K,ITF,KDCOUNT
	LOGICAL EOF
	CHARACTER*40 INFILE,LFILE,ETIME,STIME,TIME,NXATIME
	REAL HOUR,DAY,FFF(4),AST,DST,DLT,ATIME,DTIME,HHH(4),
     +       TRUEHGT,ONEMIN
C
	IU = 12
	OU = 13
	AU = 14
	ONEMIN = 1.0/(60.0*24.0)
C
	WRITE(*,*) ' Extract Drift Frequency Data from SKYMAP files'
	WRITE(*,*) ' '
C
 1	WRITE(*,*) ' Enter name of the ADEP file.'
	READ(*,'(A)') INFILE
	OPEN(UNIT=AU,FILE=INFILE,FORM='FORMATTED',MODE='READ',
     +     STATUS='OLD',ERR=1,BLOCKSIZE=4096)

 2	WRITE(*,*) ' Enter the name of the Skymap file.'
	READ(*,'(A)') INFILE
	OPEN(UNIT=IU,FILE=INFILE,FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS='OLD',ERR=2)

 3	WRITE(*,*) ' Name of the file for the data listings.'
	READ(*,'(A)') LFILE
	OPEN(UNIT=OU,FILE=LFILE,FORM='FORMATTED',MODE='WRITE',
     +    ACCESS='SEQUENTIAL',ERR=3)
C
	WRITE(*,*) ' Output time in decimal:'
	WRITE(*,*) '    1) Hours'
	WRITE(*,*) '    2) Days'
	WRITE(*,*) '    3) YY DDD HH:MM:SSS'
	READ(*,*) ITF
C
C	Search for the starting record.
C	DST = Drift Start Time, AST = Adep Start Time
	K = 0
	CALL READMAPDATA(IU,EOF)
	DST = DTIME(IDPREF)
	CALL RDADEP(EOF,AU)
	AST = ATIME(IPREF)
C
C	If the ionogram file starts first, read it until it passes
C	than the drift file.
	DO WHILE (AST.LT.DST)
	   CALL RDADEP(EOF,AU)
	   AST = ATIME(IPREF)
	ENDDO
C
C	Now, the drift starts before the ionogram.  Read drift until it
C	just passes the ionogram.
	DO WHILE (DST.LT.AST)
	   CALL READMAPDATA(IU,EOF)
	   DST  = DTIME(IDPREF)
	ENDDO
C
C	The Drift Start Time is now just after the ionogram's.
C
	KDCOUNT = 0
C
	DO WHILE (.NOT.EOF)
	   DLT = DST
	   K = K + 1
 	   WRITE(ETIME,101) (IDPREF(I),I=1,11)
	   READ(ETIME,104) IY,ID,IH,IM,IS
	   IF (K.EQ.1) STIME = ETIME
	   HOUR = IH + (IM + IS/60.)/60.0
	   DAY  = ID + HOUR/24.0
	   DST = DAY
	   IF (ITF.EQ.1) THEN
	      WRITE(TIME,102) HOUR
	   ELSE IF (ITF.EQ.2) THEN
	      WRITE(TIME,102) DAY
	   ELSE
	      TIME = ETIME
	   ENDIF
C
	   FFF(1) = FREQ / 1.0E6
	   DO 20 I = 2, 4
	      CALL READMAPDATA(IU,EOF)
	      FFF(I) = FREQ/1.0E6
 20	   CONTINUE
C
C	KDCOUNT is the number of drift cases since the last ionogram
	KDCOUNT = KDCOUNT + 1
C
C	   If an ADEP record is missing, blindly reading the next ADEP
C	   record will yeild an incorrect record.  Similar bad things
C	   happen if Drift records are missing. 
C	   Check to see if a new ionogram is needed.  If so, read it.
	   IF (((DST-DLT).GE.ONEMIN).AND.(AST.LT.DST)) THEN
	      CALL RDADEP(EOF,AU)
	      WRITE(NXATIME,101) (IPREF(I),I=1,11)
	      AST = ATIME(IPREF)
	      WRITE(*,*) '  New ADEP record: ',NXATIME
	      KDCOUNT = 1
	   ENDIF
C
C	   Display the time here, after any possible ADEP changes.
	   WRITE(*,103) ETIME
C	      
C	   For the THIRD drift case after the ionogram, convert the
C	   Drift frequencies into heights, then write them to a file.
	   IF (KDCOUNT.EQ.3) THEN
	      HHH(1) = TRUEHGT(FFF(1))
	      HHH(2) = HHH(1)
	      HHH(3) = TRUEHGT(FFF(3))
	      HHH(4) = HHH(3)
	      WRITE(OU,103) TIME,FFF(1),HHH(1),FFF(3),HHH(3)
	   ENDIF
C
	   CALL READMAPDATA(IU,EOF)
C	   
	ENDDO
C
	CLOSE(OU)
	CLOSE(IU)
	CLOSE(AU)
C	
 101	FORMAT (2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
 102	FORMAT (F15.4)
 103	FORMAT (1X,A17,8F10.2)
 104	FORMAT (I2,1X,I3,1X,I2,1X,I2,1X,I2)
C
	END
C
C  ======================================================================
C
	REAL FUNCTION ATIME(ITIME)
C
C	Convert from INTEGER(60) time to Decimal Day.
C
	INTEGER ITIME(60),IY,ID,IH,IM,IS,I
	CHARACTER*20 ETIME 
C
 	WRITE(ETIME,101) (ITIME(I),I=1,11)
	READ(ETIME,104) IY,ID,IH,IM,IS
	ATIME = IH + (IM + IS/60.)/60.0
	ATIME  = ID + ATIME/24.0
	RETURN
 101	FORMAT (2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
 104	FORMAT (I2,1X,I3,1X,I2,1X,I2,1X,I2)
	END
C
C  ======================================================================
C
	REAL FUNCTION DTIME(ITIME)
C
C	Convert from INTEGER(89) time to Decimal Day.
C
	INTEGER*2 ITIME(89)
	INTEGER IY,ID,IH,IM,IS,I
	CHARACTER*20 ETIME 
C
 	WRITE(ETIME,101) (ITIME(I),I=1,11)
	READ(ETIME,104) IY,ID,IH,IM,IS
	DTIME = IH + (IM + IS/60.)/60.0
	DTIME  = ID + DTIME/24.0
	RETURN
 101	FORMAT (2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
 104	FORMAT (I2,1X,I3,1X,I2,1X,I2,1X,I2)
 	END
C
C  ======================================================================
C 
	SUBROUTINE READMAPDATA(INFILE,EOF) 
C 
C	READ THE MAP DATA FROM A FILE <infile> FOR LATER USE IN PRINTING 
C	SKYMAPS OR CALCULATING DRIFT VELOCITIES.  FREQUENCY READ IS
C	 <IFF>  THE FORMAT OF THE PREFACE IS AS FOLLOWS:
C
C	NOTE:  Range is converted to meters and Frequency to Hertz.
C 
C
C  POSITION ! FORMAT  !  INFORMATION
C_______________________________________________________________
C  1        ! A1      !  SPACE                                  !
C  2-4      ! 3Z1     !  STATION ID CODE                        !
C  5-9      ! I5      !  RECORD NO.                             !
C  10       ! A1      !  SPACE                                  !
C  11-15    ! 5Z1     !  DATE                                   !
C  16       ! A1      !  SPACE                                  !
C  17-22    ! 6Z1     !  TIME                                   !
C  23       ! 1X      !  SPACE                                  !
C  24       ! Z1      !  PROGRAM SET                            !
C  25       ! Z1      !  PROGRAM TYPE                           !
C  26-31    ! 6Z1     !  JOURNAL (6 HEX DIGITS)                 !
C  32-38    ! 7Z1     !  P1 TO P7 (7 HEX DIGITS)                !
C  39       ! 1X      !  SPACE                                  !
C  40-46    ! 7Z1     !  XLZTNRW (7 HEX DIGITS)                 !
C  47-53    ! 7Z1     !  K(I*)(G*)HEIG (7 HEX DIGITS)           !
C  54-57    ! I4      !  ZMAX (10THS OF A DEGREE)               !
C  58-59    ! I2      !  NFREQ=FREQUENCY NUMBER                 !
C  60-66    ! I7      !  FREQ(NFREQ), IN 100-HZ UNITS           !
C  67-71    ! I5      !  RANG(NFREQ), IN 100-METER UNITS        !
C  72-74    ! I3      !  IGAIN(NFREQ), IN DB                    !
C  75-77    ! I3      !  MPAMP(NFREQ)                           !
C  78-80    ! I3      !  MAXAMP(NFREQ)                          !
C  81-84    ! I4      !  NO. OF SOURCES FOR NFREQ               !
C  85-87    ! I3      !  KTH, CASE SELECTION THRESHOLD          !
C  88-90    ! I3      !  LTH, SPECTRAL LINE SELECTION THRESHOLD ! 
C================================================================
C
	INTEGER INFILE,I,I1,I2,IRNG,IFRQ,IZMAX
	CHARACTER*2 JUNK
	LOGICAL EOF
C
C	VARIABLES FOR THE COMMON BLOCKS
C
C.....For /MAPDATA/
$INCLUDE:'COMMON\MAPDATA.CMN'
C
C
	if (eof) return
	DO 10 I =1, 89
 10   IDPREF(I) = 0
	DO 20 I=1,256
	   XMAP(I) = 0.0
	   YMAP(I) = 0.0
	   MAPAMP(I) = 0
	   MAPRMS(I) = 0
 20   CONTINUE
	EOF = .FALSE.
C
	READ(INFILE,110,END=99) (IDPREF(I),I=41,43),NMAP,
     +  (IDPREF(I),I=1,19),(IDPREF(I),I=26,32),(IDPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC
C
 110	FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +	  I4,I2,I7,I5,4I3,I4) 
C
	RANGE = FLOAT(IRNG)*100.
	FREQ =  FLOAT(IFRQ)*100.
	ZMAX =  FLOAT(IZMAX)/10.
	 
	DO 140 I1=1,NUMSRC,26 
	   I2=I1+25
	   IF(I2.GT.NUMSRC) I2=NUMSRC 
	   READ(INFILE,151) JUNK,(YMAP(I),I=I1,I2) 
	   READ(INFILE,151) JUNK,(XMAP(I),I=I1,I2) 
	   READ(INFILE,150) JUNK,(MAPAMP(I),I=I1,I2)
	   READ(INFILE,150) JUNK,(MAPDOP(I),I=I1,I2) 
	   READ(INFILE,150) JUNK,(MAPRMS(I),I=I1,I2) 
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C 
	RETURN
C     End of File condition.
 99   EOF = .TRUE.
 	NUMSRC = 0
	RETURN
	END 
C
C
C  =================================================================
C
      SUBROUTINE RDADEP(EOF,IU)
C
C     This subroutine reads scaled Ionospheric data from a textfile
C     in the format specified by the University of Lowell Center for
C     Atmospheric Research for ionospheric data produced by Digisonde
C     256 digital ionospheric sounders and processed by the ADEP
C     ARTIST Data Editing Program.
C	The file to be read must be OPEN on FORTRAN unit IU
C     The EOF variable is set to .TRUE. if an End Of File is encountered
C	during the file read operation.
C
C     For further information, see the ULowell doccument:
C           ARTIST Data Editing Program Output Format or contact:
C
C	           University of Lowell Center for Atmospheric Research
C	           University of Lowell Research Foundation
C	           450 Aiken St.
C	           Lowell, Massachusetts  01854   USA
C	               Telephone: (508) 458-2504
C	               Telex: (710) 343-6461
C	               Fax: (508) 453-6035
C
C     NOTE:   Values which are all conatined on one line are not
C             read in implied DO loops so as to minimize the effect
C             of errors on the subsiquent records.
C
C     Arrays for Digisonde 256 data in the /ADEP/ Common Block.
C
C	29 Nov 89 -- Revised format for True Height coefficients.
C
$INCLUDE:'COMMON\ADEP.CMN'
C
C	Local program variables.
C
      LOGICAL EOF
      INTEGER I,IU
C
	if (eof) return
C
C...data file index
C     The data file index integers should all be on one line.
      READ(IU,101,END=9) IDFI
 101  FORMAT (40I3)
C
C...ionogram sounding parameters
      READ(IU,102,END=9) (IPREF(I),I=1,IDFI(1))
 102  FORMAT (60Z1)
C
C...scaled ionogram parameters
      IF(IDFI(2).GT.0) READ(IU,103,END=9) (SCALED(I),I=1,IDFI(2))
 103  FORMAT (15F8.3)
C
C...ARTIST analysis flags
      IF(IDFI(3) .GT.0) READ(IU,104,END=9) IAF
 104  FORMAT (20I2)
C
C...Geophysical constants
      IF(IDFI(4).GT.0) READ(IU,105,END=9) GCONST
 105  FORMAT (10F7.3)
C
C...Doppler translation table
      IF(IDFI(5).GT.0) READ(IU,106,END=9) DTT
 106  FORMAT (16F7.3)
C
C...O-trace F2 points
      IF(IDFI(6).GT.0) READ(IU,101,END=9) (IOTF(I),I=1,IDFI(6))
      IF(IDFI(7).GT.0) READ(IU,107,END=9) (IOAF(I),I=1,IDFI(7))
      IF(IDFI(8).GT.0) READ(IU,108,END=9) (IODF(I),I=1,IDFI(8))
      IF(IDFI(9).GT.0) READ(IU,109,END=9) (FOF(I), I=1,IDFI(9))
 107  FORMAT (60I2)
 108  FORMAT (120I1)
 109  FORMAT (20F6.3)
C
C...O-trace F1 points
      IF(IDFI(10).GT.0) READ(IU,101,END=9) (IOTF1(I),I=1,IDFI(10))
      IF(IDFI(11).GT.0) READ(IU,107,END=9) (IOAF1(I),I=1,IDFI(11))
      IF(IDFI(12).GT.0) READ(IU,108,END=9) (IODF1(I),I=1,IDFI(12))
      IF(IDFI(13).GT.0) READ(IU,109,END=9) (FOF1(I), I=1,IDFI(13))
C
C...O-trace E points
      IF(IDFI(14).GT.0) READ(IU,101,END=9) (IOTE(I),I=1,IDFI(14))
      IF(IDFI(15).GT.0) READ(IU,107,END=9) (IOAE(I),I=1,IDFI(15))
      IF(IDFI(16).GT.0) READ(IU,108,END=9) (IODE(I),I=1,IDFI(16))
      IF(IDFI(17).GT.0) READ(IU,109,END=9) (FOE(I), I=1,IDFI(17))
C
C...X-trace F2 points
      IF(IDFI(18).GT.0) READ(IU,101,END=9) (IXTF(I),I=1,IDFI(18))
      IF(IDFI(19).GT.0) READ(IU,107,END=9) (IXAF(I),I=1,IDFI(19))
      IF(IDFI(20).GT.0) READ(IU,108,END=9) (IXDF(I),I=1,IDFI(20))
      IF(IDFI(21).GT.0) READ(IU,109,END=9) (FXF(I),I=1,IDFI(21))
C
C...X-trace F1 points
      IF(IDFI(22).GT.0) READ(IU,101,END=9) (IXTF1(I),I=1,IDFI(22))
      IF(IDFI(23).GT.0) READ(IU,107,END=9) (IXAF1(I),I=1,IDFI(23))
      IF(IDFI(24).GT.0) READ(IU,108,END=9) (IXDF1(I),I=1,IDFI(24))
      IF(IDFI(25).GT.0) READ(IU,109,END=9) (FXF1(I),I=1,IDFI(25))

C
C...X-trace E points
      IF(IDFI(26).GT.0) READ(IU,101,END=9) (IXTE(I),I=1,IDFI(26))
      IF(IDFI(27).GT.0) READ(IU,107,END=9) (IXAE(I),I=1,IDFI(27))
      IF(IDFI(28).GT.0) READ(IU,108,END=9) (IXDE(I),I=1,IDFI(28))
      IF(IDFI(29).GT.0) READ(IU,109,END=9) (FXE(I),I=1,IDFI(29))
C
C...Median amplitude of F echo
      IF(IDFI(30).GT.0) READ(IU,110,END=9) (MEDF(I),I=1,IDFI(30))
 110  FORMAT (20I2)
C...Median amplitude of E echo
      IF(IDFI(31).GT.0) READ(IU,110,END=9) (MEDE(I),I=1,IDFI(31))
C...Median amplitude of Es echo
      IF(IDFI(32).GT.0) READ(IU,110,END=9) (MEDES(I),I=1,IDFI(32))
C
C...F2 layer true height parameters
      IF(IDFI(33).GT.0) READ(IU,111,END=9) (THF2(I),I=1,IDFI(33))
 111  FORMAT (20E9.4E1)
C...F1 layer true height parameters
      IF(IDFI(34).GT.0) READ(IU,111,END=9) (THF1(I),I=1,IDFI(34))
C...E layer true height parameters
      IF(IDFI(35).GT.0) READ(IU,111,END=9) (THE(I),I=1,IDFI(35))
C...monotonic layer true height parameters
      IF(IDFI(36).GT.0) READ(IU,111,END=9) (THMON(I),I=1,IDFI(36))
C...Valley parameters
      IF(IDFI(37).GT.0) READ(IU,111,END=9) (THVAL(I),I=1,IDFI(37))
C
      EOF = .FALSE.
      RETURN
C
 9    EOF = .TRUE.
      RETURN
      END
C
C  ===================================================================
C
	REAL FUNCTION TRUEHGT(F)
C
C	Using the /ADEP/ coefficients for the true height, calculate
C	the TRUEHGT [Km] of the profile at the given frequency F [MHz].
C	The method of calculating the height Z is:
C                       M
C    Z=DUM(M+1)+SQRT(XM)+SUM DUM(I)*TSTAR(XM,I)
C                      I=0
C   WHERE A=COEFFICIENTS OF POLYNOMIAL FUNCTION
C         XM=(ALOG(FN/FOF2))/(ALOG(FOE/FOF2))
C         TSTAR=SHIFTED CHEBYSHEV FUNCTION
C   INPUT: DUM=COEFFICIENTS
C          FN=PLASMA FREQ
C
$INCLUDE:'COMMON\ADEP.CMN'
$INCLUDE:'COMMON\COEFS.CMN'
C
	INTEGER I
C
	IF (IDFI(36).GT.0) THEN
C	   This is a monotonic profile.
	   FSTART = THMON(1)
	   FEND   = THMON(2)
	   A(8)   = THMON(3)
	   IF ((F.GE.FSTART).AND.(F.LE.FEND)) THEN
	      NCOEF = 7
	      DO 36 I = 1, 7
	         A(I) = THMON(I+4)
 36	      CONTINUE
	      CALL PROF(F,TRUEHGT)
	   ELSE
	      TRUEHGT = 0.0
	   ENDIF
		RETURN
	ENDIF
C
C	Use the frequency F to select the layer to use
	IF ((F.LT.THE(1)).OR.(F.GT.THF2(2))) THEN
C	   F is above or below the trace
	   TRUEHGT = -1.0
	   RETURN
C	E-Layer
	ELSE IF ((IDFI(35).GT.0).AND.
     +        (F.GE.THE(1)).AND.(F.LE.THE(2))) THEN
C	      Use the coefficients for the E layer
	   NCOEF = 3
	   FSTART = THE(1)
	   FEND   = THE(2)
	   A(8)   = THE(3)
	   DO 35 I = 1, NCOEF
	      A(I) = THE(I+4)
	      AE(I) = A(I)
 35	   CONTINUE
	ELSE IF ((IDFI(35).EQ.0).AND.(F.LE.SCALED(9))) THEN
C	   Parabolic E model using Hmax and Ym
	   TRUEHGT = SCALED(15) - 
     +      SCALED(16)*SQRT(1.0 - (F/SCALED(9))**2)
	   RETURN
C	F1 Layer
	ELSE IF ((IDFI(34).GT.0).AND.
     +   (F.GE.THF1(1)).AND.(F.LE.THF1(2))) THEN
	   NCOEF = 5
	   FSTART = THF1(1)
	   FEND   = THF1(2)
	   A(8)   = THF1(3)
	   DO 34 I = 1, NCOEF
	      A(I) = THF1(I+4)
	      AF1(I) = A(I)
 34	   CONTINUE
C	F2 Layer
	ELSE IF ((IDFI(33).GT.0).AND.
     +   (F.GE.THF2(1)).AND.(F.LE.THF2(2))) THEN
	   NCOEF = 5
	   FSTART = THF2(1)
	   FEND   = THF2(2)
	   A(8)   = THF2(3)
	   DO 33 I = 1, NCOEF
	      A(I) = THF2(I+4)
	      AF(I) = A(I)
 33	   CONTINUE
	ELSE
C	   There are no true height coefficients
	   TRUEHGT = -0.1
	   RETURN
	ENDIF
	CALL PROF(F,TRUEHGT)
C
	RETURN
	END
C
C**********************************************************************
C
      SUBROUTINE PROF(FN,H)
C...FROM THE ASSUMED INITIAL PROFILE, CALCULATE
C    H ACCORDING TO THE EQUATION
C                       M
C    Z=DUM(M+1)+SQRT(XM)+SUM DUM(I)*TSTAR(XM,I)
C                      I=0
C   WHERE A=COEFFICIENTS OF POLYNOMIAL FUNCTION
C         XM=(ALOG(FN/FOF2))/(ALOG(FOE/FOF2))
C         TSTAR=SHIFTED CHEBYSHEV FUNCTION
C   INPUT: DUM=COEFFICIENTS
C          FN=PLASMA FREQ
C   OUTPUT: H
C.................................................
C
$INCLUDE:'COMMON\COEFS.CMN'
C
	REAL Y1,YS,XM,TSTAR,FN,H
	INTEGER I
C
C...BELOW IS FOR E- AND F- REGION POLYNOMIAL FITS
      H=0.
C...CHECK THE START FREQUENCY
      IF(FN.GT.FSTART) THEN
C... AND THE END FREQUENCY
         IF(FN.LT.FEND)THEN
            Y1=ALOG(FN/FEND)
            YS=ALOG(FSTART/FEND)
            XM=Y1/YS
            IF(XM.LT.0.) THEN
               WRITE(*,'(A,3F7.1)')' *****XM < 0. IN PROF,FN,FSTART, 
     +         FEND=',FN,FSTART,FEND
            XM=0.
            ENDIF
C222
         ELSE
            XM=0.
C222
         ENDIF
C...CALCULATE THE TRUE HEIGHT
         DO 10 I=1,NCOEF
   10    H=H+A(I)*TSTAR(XM,I)
         H=H*SQRT(XM)
         H=H+A(8)
C111
      ENDIF
C
  300 CONTINUE
      RETURN
      END
C
C**********************************************************************
C
      REAL FUNCTION TSTAR(CD,N)
C...TSTAR CALCULATE SHIFTED CHEVBYSHEV FUNCTION
C   INPUT: CD=LN(FN/FOF2)/LN(FOE/FOF2)
C          N=INDEX OF POLYNOMIAL
C    C=COEFFICIENTS OF THE TAYLOR DEVELOPMENT OF TSTAR
C       FUNCTION
C,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
C
      REAL C(8,8),CD
	INTEGER J,N
C
      DATA C(1,1),C(1,2),C(1,3),C(1,4),C(1,5),C(1,6),C(1,7),C(1,8)
     +/1.,7*0./
C
      DATA C(2,1),C(2,2),C(2,3),C(2,4),C(2,5),C(2,6),C(2,7),C(2,8)
     +/2.,-1.,6*0./
C
      DATA C(3,1),C(3,2),C(3,3),C(3,4),C(3,5),C(3,6),C(3,7),C(3,8)
     +/8.,-8.,1.,5*0./
C
      DATA C(4,1),C(4,2),C(4,3),C(4,4),C(4,5),C(4,6),C(4,7),C(4,8)
     +/32.,-48.,18.,-1.,4*0./
C
      DATA C(5,1),C(5,2),C(5,3),C(5,4),C(5,5),C(5,6),C(5,7),C(5,8)
     +/128.,-256.,160.,-32.,1.,3*0./
C
      DATA C(6,1),C(6,2),C(6,3),C(6,4),C(6,5),C(6,6),C(6,7),C(6,8)
     +/512.,-1280.,1120.,-400.,50.,-1.,2*0./
C
      DATA C(7,1),C(7,2),C(7,3),C(7,4),C(7,5),C(7,6),C(7,7),C(7,8)
     +/2048.,-6144.,6912.,-3584.,840.,-72.,1.,0./
C
      DATA C(8,1),C(8,2),C(8,3),C(8,4),C(8,5),C(8,6),C(8,7),C(8,8)
     +/8192.,-28672.,39424.,-26880.,9408.,-1568.,98.,-1./
C...FOR THE N=1 CONDITION - TSTAR EQUALS THE TAYLOR COEFFICIENT
      TSTAR=C(N,1)
      IF (N .EQ. 1) GO TO 20
C...FOR N>1 CALCULATE TSTAR
      DO 10 J=2,N
   10 TSTAR=TSTAR*CD+C(N,J)
      RETURN
   20 CONTINUE
      RETURN
      END
C
