$DECLARE
$NOTRUNCATE
$DEBUG
C
	PROGRAM DVDFXYZ
C
C	This program reads a Velocity vector file containing Drift vectors
C	at two frequencies simultaneously and produces a file of velocity
C	and frequency differences vs time.
C	Output vector is in Cartesian coordinates
C
C.....Parameters
$INCLUDE:'COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'COMMON\GRPVEL.STR'
$INCLUDE:'COMMON\TIME.CMN'
$INCLUDE:'COMMON\BOUNDS.CMN'
C
C
C	This is now a STRUCTURE
C  /GRPVEL/        -  Statistical data for the Group Velocity in NFRAB
C	                possible Frequency-Range-Angle Bins.
C	                NFRAB and NSTAT are program parameters.
C	                The second index indicates which value is contained. 
C GVZ(NSTAT) -  Statistics for the Group Velocity Z-component.
C	     , 1)    -  Mean
C	     , 2)    -  Standard Deviation
C	     , 3)    -  Median
C	     , 4)    -  Upper quartile
C	     , 5)    -  Lower quartile
C	     , 6)    -  Most probable
C	     , 7)    -  Least Square fit to ALL data. 
C   8) -,NSTAT)    -  For future use  
C GVH(NSTAT) -  Statistics for the Group Velocity Horizontal magnitude.
C GAZ(NSTAT) -  Statistics for the Group Velocity horizontal AZimuth.
C GVX(NSTAT) -  Statistics for the Group Velocity X component.
C GVY(NSTAT) -  Statistics for the Group Velocity Y component.
C GSQ(NSTAT) -  Statistics for the velocity root mean square error.
C GVL(NSTAT) -  Statistics for the Group Velocity Line-of-Sight.
C GSL(NSTAT) -  Statistics for the LOS velocity root mean square error.
C NGVEL      -  Number of measurements at each FRAB.
C NGVELOS    -  Number of measurements at each FRAB.
C IGVFRAB    -  The FRAB# which comes out of the data file.
C GVTIME     -  Time of this measurement.
C GVFRQ      -  Average frequency
C GVHGT      -  Average Height.
C
C  /BOUNDS/      -  Data in this common block define the limits in
C                   Frequency, Range and Arrival Angle for each of the
C	              NFRAB's. 
C  NFRABS        -  Number of FRAB's defined.  Must be <= NFRAB.
C  TRUEHEIGHT    -  Logical flag selecting between true and virtual height
C	              selection of the data.  *** TRUE HEIGHT NOT YET AVAILABLE ***
C  BFRQ(NFRAB,2) -  Bounds upon the FReQuency, upper ,1) and lower ,2)
C  BRNG(NFRAB,2) -  Bounds upon the RaNGe, upper ,1) and lower ,2)
C  BANG(NFRAB,4) -  Bounds on the ANGles of arrival for this bin.
C                   ,1) = Zenith angle of the Line-of-Sight direction (deg).
C                   ,2) = Azimuth of the Line-of-Sight direction (deg).
C                   ,3) = Half 'Beamwidth' in Zenith (deg).
C                   ,4) = Half 'Beamwidth' in Azimuth (deg).
C  NBSRC(NFRAB)  - Number of sources in each FRAB
C
C
C
	INTEGER IU,OU,NVEL
	REAL DF,DVX,DVY,DVZ
	LOGICAL EOF,GOOD
	CHARACTER*30 INFILE,OUTFILE
	CHARACTER*17 CTIME
C
	RECORD /GRPVEL/ VEL1,VEL2

C
	IU = 2
	OU = 3

C
	WRITE(*,*) ' DVDFXYZ - Calculate and Extract Frequency '
	WRITE(*,*) ' Dependance in Drift Velocity Data.'
c
 901	WRITE(*,*) ' Enter the name of the .VELocity file.'	
	READ(*,102) INFILE
	OPEN(UNIT=IU,FILE=INFILE,FORM='FORMATTED',ACCESS='SEQUENTIAL',
     +     STATUS='OLD',MODE='READ',ERR=901)
C

 902	WRITE(*,*) ' Enter the name of the output file.'	
	READ(*,102) OUTFILE
	OPEN(UNIT=OU,FILE=OUTFILE,FORM='FORMATTED',ACCESS='SEQUENTIAL',
     +     STATUS='UNKNOWN',ERR=902)
C
	WRITE(*,*) ' Time format is:'
	WRITE(*,*) '    Decimal hours   (YYYY DDD HH.HHHHH)'
C
	EOF = .FALSE.
	NVEL = 0
	CALL RDGRPDATA(IU,VEL1,EOF)
	WRITE(OU,*) ' Extracted dV/df Drift Velocities, [m/s per MHz]'
	WRITE(OU,104) 'Time (UT)','N2','N1','dVx/df','dVy/df',
     +               'dVz/df','F2','F1'
	DO WHILE (.NOT.EOF)
	   CALL RDGRPDATA(IU,VEL2,EOF)
	   GOOD = (VEL1.GVTIME.EQ.VEL2.GVTIME).AND.
     +          (VEL1.NGVEL.GT.0).AND.(VEL2.NGVEL.GT.0) 
	   IF (.NOT.GOOD) THEN
C	      This program needs 2 velocities at different frequencies
C	      to calculate dV/df.  Skip if this is not so.
	      VEL1 = VEL2
	      WRITE(*,*) CCSTIME,'     ... Skipped '
	   ELSE
	      WRITE(*,*) CCSTIME
	      DF = VEL2.GVFRQ - VEL1.GVFRQ
	      IF (DF.EQ.0) DF = 10000.0
	      DVX = VEL2.GVX(1) - VEL1.GVX(1)
	      DVY = VEL2.GVY(1) - VEL1.GVY(1)
	      DVZ = VEL2.GVZ(1) - VEL1.GVZ(1)
	      WRITE(OU,105) CTIME(6),VEL2.NGVEL,VEL1.NGVEL,
     +                    DVX/DF,DVY/DF,DVZ/DF,
     +                    VEL2.GVFRQ,VEL1.GVFRQ
	   ENDIF
	ENDDO
C
	CLOSE(IU)
	CLOSE(OU)
C
 102	FORMAT (A)
 104	FORMAT (A17,10A10)
 105	FORMAT (A17,2I10,10F10.2)
 106	FORMAT (F17.10,I5,10F10.2)

	END
C
C ==========================================================================
C
	SUBROUTINE RDGRPDATA(UNIT,VG,EOF)
C
C	Reads data into the /GRPVEL/ STRUCTURE all data with the same 
C	TIME as the 
C	as well as some /TIME/ and /BOUNDS/ information from the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable EOF is set if the end of file
C	is encountered in a READ operation.
C
C	   IVAR   =  The number of variables  to read from the file
C	   NVAR   =  The number of variables the routine expects to find.
C	   ISTAT  =  The number of statistics to read from the file.
C	   NSTAT  =  The maximum number of statistics /GRPVEL/ can hold.
C
C.....Parameters
$INCLUDE:'COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'COMMON\GRPVEL.STR'
$INCLUDE:'COMMON\TIME.CMN'
$INCLUDE:'COMMON\BOUNDS.CMN'

C
	INTEGER UNIT,IFRB,NVAR,I,ISTAT,IVAR,i1,i2
	REAL VSN,r1,r2
	LOGICAL EOF
	CHARACTER*3 JUNK
	RECORD /GRPVEL/ VG
C
	EOF = .FALSE.
	NVAR = 8
C
	READ(UNIT,101,END=900) CCSTIME,IFRB,ISTAT,IVAR,VSN
	IF((ISTAT.GT.NSTAT).OR.(IVAR.GT.NVAR).OR.(VSN.GT.VERSION))THEN
	   WRITE(*,*) ' RDGRPDATA --> Incompatable file format.'
	   GOTO 900
	ENDIF
	VG.GVTIME = CCSTIME
	VG.IGVFRAB = IFRB
	IFRB = MAX(1,IFRB)
C
	READ(UNIT,104,END=900) JUNK,BFRQ(IFRB,1),BFRQ(IFRB,2),
     +                         BRNG(IFRB,1),BRNG(IFRB,2),
     +                         (BANG(IFRB,I),I=1,4),
     +                          i1,i2,r1,r2
	VG.NGVEL = i1
	VG.NGVELOS = i2
	VG.GVFRQ = r1
	VG.GVHGT = r2
C	The temporary variables I1,I2,R1,R2 above are a work-around 
C	solution to a compiler bug.
C
	IF (IVAR.GT.0)
     +   READ(UNIT,102,END=900) JUNK,(VG.GVZ(I),I=1,ISTAT)
	IF (IVAR.GT.1)
     +   READ(UNIT,102,END=900) JUNK,(VG.GVH(I),I=1,ISTAT)
	IF (IVAR.GT.2) 
     +   READ(UNIT,102,END=900) JUNK,(VG.GAZ(I),I=1,ISTAT)
	IF (IVAR.GT.3)
     +   READ(UNIT,102,END=900) JUNK,(VG.GVX(I),I=1,ISTAT)
	IF (IVAR.GT.4) 
     +   READ(UNIT,102,END=900) JUNK,(VG.GVY(I),I=1,ISTAT)
	IF (IVAR.GT.5)
     +   READ(UNIT,103,END=900) JUNK,(VG.GSQ(I),I=1,ISTAT)
	IF (IVAR.GT.6)
     +   READ(UNIT,102,END=900) JUNK,(VG.GVL(I),I=1,ISTAT)
	IF (IVAR.GT.7)
     +   READ(UNIT,103,END=900) JUNK,(VG.GSL(I),I=1,ISTAT)
C
	RETURN
 101	FORMAT (1X,A17,3I5,F5.2)
 102	FORMAT (1X,A3,12F10.2)
 103	FORMAT (1X,A3,12F10.4)
 104	FORMAT (1X,A3,8F10.2,2I6,F6.2,F6.1)
C
 900	EOF = .TRUE.
	RETURN
	END
C
C ==========================================================================
C
	CHARACTER*17 FUNCTION CTIME(ISEL)
C	
C	As a convenience feature, this function returns the CHARACTER*17 time
C	indicated by ISEL.
C
C	1) Current time (CNTIME)
C	2) Start time of current accumulation (CCSTIME)
C	3) Start time of entire run (CSTIME)
C	4) End time of entire run (CETIME)
C	5) CCSTIME, truncated to previous ATIME Min.
C	6) CCSTIME in Decimal Hours.
C	7) CCSTIME in Decimal Days.
C
$INCLUDE:'COMMON\TIME.CMN'

C
	INTEGER ISEL,IAT,ID,IH,IM,IS
	REAL RH,RM
	CHARACTER*17 CTT
C
	IF (ISEL.EQ.1) THEN
	   CTIME = CNTIME
	ELSE IF (ISEL.EQ.2) THEN
	   CTIME = CCSTIME
	ELSE IF (ISEL.EQ.3) THEN
	   CTIME = CSTIME
	ELSE IF (ISEL.EQ.4) THEN
	   CTIME = CETIME
	ELSE IF (ISEL.EQ.5) THEN
	   IF (ATIME.LE.0.0) RETURN
	   CTT = CCSTIME
C........# of Minutes to round off to.
	   RM = ATIME/60.
	   IAT = MAX(NINT(RM),1)
	   READ (CTT,105) IH,IM,IS
	   RM = IM + IS/60.
	   IM = IAT*INT(RM/IAT)
	   IF (IM.GE.60) THEN
	      IH = IH + 1
	      IM = IM - 60
	   ENDIF
	   IS = 0
	   WRITE(CTT,115) CTT,IH,':',IM,':',IS
	   CTIME = CTT
	ELSE IF (ISEL.EQ.6) THEN
C........Time in YYYY DDD HH.HHHHH
	   CTT = CCSTIME
	   READ (CTT,105) IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
	   WRITE(CTT,116) CTT(1:9),RH
	   CTIME = CTT
	ELSE IF (ISEL.EQ.7) THEN
C........Time in YYYY DDD.DDDDDDDD
	   CTT = CCSTIME
	   READ (CTT,107) ID,IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
		RH = ID + RH/24.0
	   WRITE(CTT,117) CTT(1:5),RH
	   CTIME = CTT
	ELSE
	   CTIME = 'CTIME:Bad option '
	ENDIF
 105	FORMAT (9X,I2,1X,I2,1X,I2)
 107	FORMAT (5X,I3,1X,I2,1X,I2,1X,I2)
 115	FORMAT (A9,I2.2,A1,I2.2,A1,I2.2)
 116	FORMAT (A9,F8.5)
 117	FORMAT (A5,F12.8)
	RETURN
	END
