$DECLARE
$NOTRUNCATE
$DEBUG
C
	PROGRAM ISRVZ
C
C	Extract Incoherent Scatter Radar vertical velocities and average
C	them over heights from [250-375Km].  The standard deviation
C	will indicate the variability of the velocity over height.
C
	INTEGER I,K,NV
	REAL VM,VS,VV,BCHIRP,C1,C2,C3,C4,AL,AH,SUMWT
	REAL UT(100),AZ(100),EL(100),ALT(100),VO(100),DVO(100),NE(100)
	CHARACTER*1 MODE(100)
	CHARACTER*30 INFILE,OUFILE
	LOGICAL EOF1,VMODE,ALTRNG,SAMETIME

C	B-mode chirp factor.
	BCHIRP = -9.98
C	Altitude limits.
	AL = 200
	AH = 400

	WRITE(*,*) ' Enter the input file name'
	READ(*,'(A)') INFILE

	WRITE(*,*) ' Enter the output file name'
	READ(*,'(A)') OUFILE
C
	OPEN (UNIT=1,FILE=INFILE,FORM='FORMATTED',STATUS='OLD',
     +      MODE='READ')
	OPEN (UNIT=2,FILE=OUFILE,FORM='FORMATTED',MODE='WRITE')
C
	EOF1 = .FALSE.
	K = 1
	NV = 0
	SUMWT = 0.0
	DO WHILE (.NOT.EOF1)
	   READ(1,101,IOSTAT=I) UT(K),AZ(K),EL(K),MODE(K),ALT(K),
     +                        VO(K),DVO(K),NE(K)
	   WRITE(*,101) UT(K),AZ(K),EL(K),MODE(K),ALT(K),
     +               VO(K),DVO(K),NE(K)
	   EOF1 = EOF(1)
	   IF (EOF1) CYCLE
C
	   VMODE = ((AZ(K).EQ.180.0).AND.(EL(K).EQ.88.0).AND.
     +            (MODE(K).EQ.'B'))
	   ALTRNG = (ALT(K).GE.AL).AND.(ALT(K).LE.AH)

	   IF (VMODE) THEN
C	      These are the modes we want.
	      IF (ALTRNG) THEN
C	         Start collecting them.
	         NV = NV + 1
	         VO(K) = VO(K) + BCHIRP
	         DVO(K) = MAX(DVO(K), 0.9)
C	         Weight velocities by their error.
	         VO(K) = VO(K)/(DVO(K)*DVO(K))
	         SUMWT = SUMWT + 1.0/(DVO(K)*DVO(K))
	         K = K + 1
	      ENDIF
	   ELSE IF (NV.GT.0) THEN 
C	      It time to calculate a velocity.
	      CALL MOMENT(VO,NV,VM,C1,VS,VV,C3,C4)
	      VM = NV*VM/SUMWT
	      VS = SQRT((NV-1)*VV/SUMWT)
C	      Ensure times are the same.
	      SAMETIME = .TRUE.
	      DO I = 2, NV
	         SAMETIME = SAMETIME.AND.(UT(I).EQ.UT(1))
	      ENDDO
	      IF (SAMETIME) THEN
	         WRITE(2,102) UT(1),VM,VS,NV,SUMWT
	         WRITE(*,102) UT(1),VM,VS,NV,SUMWT
	      ELSE
	         WRITE(*,103) ' Time error',(UT(I),I=1,NV)
	      ENDIF
	      NV = 0
	      SUMWT = 0.0
	      K = 1
	   ELSE
C	      Over-write the previous data line, we don't want it.
	      CONTINUE
	   ENDIF
	ENDDO
	CLOSE (UNIT=1)
	CLOSE (UNIT=2)
C

 101	FORMAT (F7.3,2F8.1,3X,A1,F8.2,2F8.1,E13.5)
 102	FORMAT (F7.3,2F8.1,I5,F10.3)
 103	FORMAT (A,10F7.3)
	END

C
C   ============================================================
C
	SUBROUTINE MOMENT(DATA,N,AVE,ADEV,SDEV,VAR,SKEW,CURT)
C
C	Given an array of DATA lenght N, this routine returns its mean in
C	AVE, (first moment) the average deviation ADEV, the standard deviation
C     SDEV (second moment), the variance VAR, the skewness SKEW (third
C	moment) and the kutrosis CURT (fourth moment).
C
	INTEGER N,J
	REAL DATA(N),AVE,ADEV,SDEV,VAR,SKEW,CURT,S,P,TINY,huge
	PARAMETER (TINY=1.0E-8, HUGE=1.0E8)
C
	IF(N.LT.1) THEN
	   AVE  = 0.0
	   ADEV = 0.0
	   SDEV = 0.0
	   VAR  = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	   RETURN
	ENDIF
	IF (N.EQ.1) THEN
	   AVE  = DATA(1)
	   ADEV = 0.0
	   SDEV = 0.0
	   VAR  = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	   RETURN
	ENDIF
C
	S = 0.0
	DO 11 J = 1, N
	   S = S + DATA(J)
 11	CONTINUE
	AVE = S/N
	ADEV = 0.0
	VAR = 0.0
	SKEW = 0.0 
	CURT = 0.0
	DO 12 J = 1, N
	   S = DATA(J) - AVE
	   ADEV = ADEV + ABS(S)
C	   Attempt to eliminate overflow
	   P = MIN( S*S, HUGE)
	   VAR = VAR + P
	   P = P * S
	   SKEW = SKEW + P
	   P = MIN( P * S, HUGE)
	   CURT = CURT + P
 12	CONTINUE
	ADEV = ADEV/N
	VAR = VAR /(N-1)
	IF (VAR.GT.TINY) THEN
	   SDEV = SQRT(VAR)
	   SKEW = SKEW/(N*SDEV**3)
	   CURT = CURT/(N*VAR**2) - 3
	ELSE
C	   SKEW and CURT are undefined.
	   SDEV = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	ENDIF
	RETURN
	END
	   
