C
C ==========================================================================
C
	SUBROUTINE WRITEGROUPDATA(UNIT,IFRB,ERROR)
C
C	Writes the data from the /GRPVEL/ common blockfor the bin IFRB
C	as well as some /TIME/ and /BOUNDRIES/ information to the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable ERROR is set if an error occurs in
C	the write operation.
C
C.....Parameters
	INTEGER NIND,NFRB,NSTAT,NSS
	PARAMETER (NIND=400, NFRB=64, NSTAT=6, NSS=5000) 
C
C.....Common Blocks
C.....For /GRPVEL/
	REAL GVZ(NFRB,NSTAT),GVH(NFRB,NSTAT),GAZ(NFRB,NSTAT),
     +     GVX(NFRB,NSTAT),GVY(NFRB,NSTAT),GSQ(NFRB,NSTAT)
	INTEGER NGVEL(NFRB)
	COMMON /GRPVEL/ GVZ,GVH,GAZ,GVX,GVY,GSQ,NGVEL
C.....For /TIME/
	REAL*8 STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME
	CHARACTER*17 CSTIME,CETIME,CNTIME,CLTIME,CCSTIME
	INTEGER NR2DO
	COMMON /TIME/ STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME,
     +              CSTIME,CETIME,CNTIME,CLTIME,CCSTIME,NR2DO
C.....For /BOUNDRIES/
	INTEGER NFRBS,NBSRC(NFRB)
	LOGICAL TRUEHEIGHT
	REAL BFRQ(NFRB,2),BRNG(NFRB,2)
	COMMON /BOUNDRIES/ NFRBS,TRUEHEIGHT,BFRQ,BRNG,NBSRC
C
	INTEGER UNIT,IFRB,NVAR,I
	LOGICAL ERROR
C
	ERROR = .FALSE.
	NVAR = 6
C
	WRITE(UNIT,101,ERR=900) ACCSTIME,IFRB,NGVEL(IFRB),BFRQ(IFRB,1),
     +                        BFRQ(IFRB,2),BRNG(IFRB,1),BRNG(IFRB,2),
     +                        NSTAT,NVAR
	WRITE(UNIT,102,ERR=900) (GVZ(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) (GVH(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) (GAZ(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) (GVX(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) (GVY(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,103,ERR=900) (GSQ(IFRB,I),I=1,NSTAT)
	RETURN
 101	FORMAT (1X,A17,2I4,4F8.2,2I3)
 102	FORMAT (12F10.2)
 103	FORMAT (12F10.4)
C
 900	ERROR = .TRUE.
	RETURN
	END
C
C ==========================================================================
C
	SUBROUTINE READGROUPDATA(UNIT,IFRB,EOF)
C
C	Writes the data from the /GRPVEL/ common blockfor the bin IFRB
C	as well as some /TIME/ and /BOUNDRIES/ information to the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable EOF is set if the end of file
C	is encountered in a READ operation.
C
C	   IVAR   =  The number of variables  to read from the file
C	   NVAR   =  The number of variables the routine expects to find.
C	   ISTAT  =  The number of statistics to read from the file.
C	   NSTAT  =  The maximum number of statistics /GRPVEL/ can hold.
C
C.....Parameters
	INTEGER NIND,NFRB,NSTAT,NSS
	PARAMETER (NIND=400, NFRB=64, NSTAT=6, NSS=5000) 
C
C.....Common Blocks
C.....For /GRPVEL/
	REAL GVZ(NFRB,NSTAT),GVH(NFRB,NSTAT),GAZ(NFRB,NSTAT),
     +     GVX(NFRB,NSTAT),GVY(NFRB,NSTAT),GSQ(NFRB,NSTAT)
	INTEGER NGVEL(NFRB)
	COMMON /GRPVEL/ GVZ,GVH,GAZ,GVX,GVY,GSQ,NGVEL
C.....For /TIME/
	REAL*8 STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME
	CHARACTER*17 CSTIME,CETIME,CNTIME,CLTIME,CCSTIME
	INTEGER NR2DO
	COMMON /TIME/ STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME,
     +              CSTIME,CETIME,CNTIME,CLTIME,CCSTIME,NR2DO
C.....For /BOUNDRIES/
	INTEGER NFRBS,NBSRC(NFRB)
	LOGICAL TRUEHEIGHT
	REAL BFRQ(NFRB,2),BRNG(NFRB,2)
	COMMON /BOUNDRIES/ NFRBS,TRUEHEIGHT,BFRQ,BRNG,NBSRC
C
	INTEGER UNIT,IFRB,NVAR,I,ISTAT,IVAR
	LOGICAL EOF
C
	EOF = .FALSE.
	NVAR = 6
C
	READ(UNIT,101,END=900) ACCSTIME,IFRB,NGVEL(IFRB),BFRQ(IFRB,1),
     +                        BFRQ(IFRB,2),BRNG(IFRB,1),BRNG(IFRB,2),
     +                        ISTAT,IVAR
	IF ((ISTAT.GT.NSTAT).OR.(IVAR.NE.NVAR)) THEN
	   WRITE(*,*) ' READGROUPDATA --> Incompatable file format.'
	   GOTO 900
	ENDIF
	READ(UNIT,102,END=900) (GVZ(IFRB,I),I=1,ISTAT)
	READ(UNIT,102,END=900) (GVH(IFRB,I),I=1,ISTAT)
	READ(UNIT,102,END=900) (GAZ(IFRB,I),I=1,ISTAT)
	READ(UNIT,102,END=900) (GVX(IFRB,I),I=1,ISTAT)
	READ(UNIT,102,END=900) (GVY(IFRB,I),I=1,ISTAT)
	READ(UNIT,103,END=900) (GSQ(IFRB,I),I=1,ISTAT)
	RETURN
 101	FORMAT (1X,A17,2I4,4F8.2,2I3)
 102	FORMAT (12F10.2)
 103	FORMAT (12F10.4)
C
 900	EOF = .TRUE.
	RETURN
	END
C
