		DO NOT USE THIS FILE.  IT HAS BUGS.
$DECLARE
$NOTRUNCATE
C
	PROGRAM PULLV
C
C	This program reads a Velocity vector file and produces
C	a file of velocities and errors vs time.
C
C
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\PLAY\COMMON\PULLDATA.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\GRPVEL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
C
C  /GRPVEL/        -  Statistical data for the Group Velocity in NFRAB
C	                possible Frequency-Range-Angle Bins.
C	                NFRAB and NSTAT are
C	                program parameters.
C	                The second index indicates which value is contained. 
C GVZ(NFRAB,NSTAT) -  Statistics for the Group Velocity Z-component.
C	     , 1)    -  Mean
C	     , 2)    -  Standard Deviation
C	     , 3)    -  Median
C	     , 4)    -  Upper quartile
C	     , 5)    -  Lower quartile
C	     , 6)    -  Most probable
C	     , 7)    -  Least Square fit to ALL data. 
C   8) -,NSTAT)    -  For future use  
C GVH(NFRAB,NSTAT) -  Statistics for the Group Velocity Horizontal magnitude.
C GAZ(NFRAB,NSTAT) -  Statistics for the Group Velocity horizontal AZimuth.
C GVX(NFRAB,NSTAT) -  Statistics for the Group Velocity X component.
C GVY(NFRAB,NSTAT) -  Statistics for the Group Velocity Y component.
C GSQ(NFRAB,NSTAT) -  Statistics for the velocity root mean square error.
C GVL(NFRAB,NSTAT) -  Statistics for the Group Velocity Line-of-Sight.
C GSL(NFRAB,NSTAT) -  Statistics for the LOS velocity root mean square error.
C NGVEL(NFRAB)     -  Number of measurements at each FRAB.
C NGVELOS(NFRAB)   -  Number of measurements at each FRAB.
C
C  /BOUNDS/      -  Data in this common block define the limits in
C                   Frequency, Range and Arrival Angle for each of the
C	              NFRAB's. 
C  NFRABS        -  Number of FRAB's defined.  Must be <= NFRAB.
C  TRUEHEIGHT    -  Logical flag selecting between true and virtual height
C	              selection of the data.  *** TRUE HEIGHT NOT YET AVAILABLE ***
C  BFRQ(NFRAB,2) -  Bounds upon the FReQuency, upper ,1) and lower ,2)
C  BRNG(NFRAB,2) -  Bounds upon the RaNGe, upper ,1) and lower ,2)
C  BANG(NFRAB,4) -  Bounds on the ANGles of arrival for this bin.
C                   ,1) = Zenith angle of the Line-of-Sight direction (deg).
C                   ,2) = Azimuth of the Line-of-Sight direction (deg).
C                   ,3) = Half 'Beamwidth' in Zenith (deg).
C                   ,4) = Half 'Beamwidth' in Azimuth (deg).
C  NBSRC(NFRAB)  - Number of sources in each FRAB
C
C  /TIME/
C	STARTTIME, ENDTIME, NOWTIME, LASTTIME
C	ATIME       - Data Accumulation time = time over which data is
C	              averaged/smoothed. (seconds)
C	ACCSTIME    - The accumulation (averaging) start time. 
C	CSTIME,CETIME,CNTIME,CCSTIME,CLTIME - Times in CHARACTER*17 format
C	                         YYYY DDD HH:MM:SS 
C	NR2DO       - The number of Subcases to process if ENDTIME unspecified.
C
C	This one 3D array (PDATA) holds all of the /GRPDATA/.  Access to
C	different variables is by index, not variable name.  This increases
C	output flexability, at the cost of comprehension.
C	PFMT is a character variable with the FORMAT for each PDATA type.
C	PLAB is a character variable with the LABEL  for each PDATA	type.
C
C	PVAR  | Type, Format, Label | PSTT | Statistic
C	-----------------------------------------------
C	   1  | GVZ,     F8.2  Vz   |  1   | Mean  
C	   2  | GVH,     F8.2  Vh   |  2   | Sdev   
C	   3  | GAZ,     F8.2  Az   |  3   | Med	  
C	   4  | GVX,     F8.2  Vx   |  4   | Qu     
C	   5  | GVY,     F8.2  Vy   |  5   | Ql     
C	   6  | GSQ,     F8.4  Esq  |  6   | Mp     
C	   7  | GVL,     F8.2  Vlos |  7   | MinE	  
C	   8  | GSL,     F8.4  Elos |  
C	   9  | NGVEL,   F8.0  #vel |
C	  10  | NGVELOS, F8.0  #los |
C
	INTEGER NPMAX
	PARAMETER (NPMAX=20)
	INTEGER I,J,INF,OUT,IFRAB,KFRAB,ITIME,NPVAR,LEN1,NVMAX
	INTEGER TTYPE(3),PSEQ(NPMAX),PSTT(NPMAX)
	INTEGER GETINT
	CHARACTER*4 PFMT(NGVAR),PLAB1(NGVAR),PLAB2(NSTAT)
	CHARACTER*17 CTIME
	CHARACTER*30 INFILE,OUTFILE
	CHARACTER*150 LAB,FMT,LFMT
	LOGICAL EOF
C

C.....Initialize Variables
	DATA TTYPE/2,6,7/
	DATA PFMT/'F8.2','F8.2','F8.2','F8.2','F8.2','F8.4',
     +          'F8.2','F8.4','F8.0','F8.0'/
	DATA PLAB1/'  Vz','  Vh','  Az','  Vx','  Vy',' Esq',
     +          ' Vls',' Els','  #V',' #ls'/
	DATA PLAB2/'Mean','Sdev','Med ','Qu  ','Ql  ','Mp  ',
     +           'MinE'/

	INF = 10
	OUT = 20
C
	WRITE(*,*)' Drift Velocity Data File Information Extractor'
	WRITE(*,*) '   Re-formats .VEL files for plotting routines,'
	WRITE(*,*) '   transfer to other machines, etc.'
	WRITE(*,*) ' '

 901	WRITE(*,*) ' Enter the name of the input VELOCITY file.'
	READ(*,'(A)') INFILE
	OPEN(UNIT=INF,FILE=INFILE,FORM='FORMATTED',
     +        ACCESS='SEQUENTIAL',STATUS='OLD',ERR=901)
C
 902	WRITE(*,*) ' Enter the name of the output text file.'
	READ(*,'(A)') OUTFILE
	OPEN(UNIT=OUT,FILE=OUTFILE,FORM='FORMATTED',MODE='WRITE',
     +        ACCESS='SEQUENTIAL',STATUS='UNKNOWN',ERR=902)
C
	WRITE(*,*) ' Time format:'
	WRITE(*,*) '    1)  Standard format (YYYY DDD HH:MM:SS)'
	WRITE(*,*) '    2)  Decimal hours   (YYYY DDD HH.HHHHH)'
	WRITE(*,*) '    3)  Decimal days    (YYYY DDD.DDDDDDDD)'
	ITIME = GETINT(1,3)
	ITIME = TTYPE(ITIME)
C
	WRITE(*,*) ' '
	WRITE(*,*) ' Variable Printing Sequence.'
	WRITE(*,*) ' Enter: variable #, statistic #'
	WRITE(*,*) '    or 0,0 to continue.'
	WRITE(*,*) ' Variables availible:'
	WRITE(*,103) (PLAB1(I),I=1,NGVAR)
	WRITE(*,104) (I,I=1,NGVAR)
	WRITE(*,*) ' Statistics availible:'
	WRITE(*,103) (PLAB2(I),I=1,NSTAT)
	WRITE(*,104) (I,I=1,NSTAT)
C
	NPVAR = 0
 10	CONTINUE
	   READ(*,*) I,J
	   IF (I.GT.NGVAR) THEN
	      WRITE(*,*) ' Incorrect combination ',I,J
	      GOTO 10
	   ENDIF
	   IF (I.GT.0.AND.J.GT.0) THEN
	      NPVAR = NPVAR + 1
	      PSEQ(NPVAR) = I
	      PSTT(NPVAR) = J
	      GOTO 10
	   ENDIF
	CONTINUE
C.....Build the FORMAT variable and the header line.
	WRITE(FMT,105) ' (1X,A17,10(',
     +                 (PFMT(PSEQ(I)),',',I=1,NPVAR),'1X))' 
	WRITE(*,*) FMT
C
	LEN1 = 4*NPVAR - 2
	NVMAX = (15/NPVAR) - 1
	WRITE(LFMT,106) NPVAR
C	WRITE(LFMT,106) NPVAR,NVMAX,LEN1,LEN1
	WRITE(*,*) LFMT
C
C     (5X,A4,9X, 2(2A4), 4('|', 7('-'),I2, 7('-'),'|'))
	WRITE(LAB,LFMT)'Time',(PLAB1(PSEQ(I)),PLAB2(PSTT(I)),I=1,NPVAR),
     +               (I+1,I=1,NVMAX)
 106	FORMAT ('(5X,A4,9X,',I2,'(2A4))')
C ,3X,',I2,'(''|'',',I2,
C     +  '(''-''),I2,',I2,'(''-''),''|''))')

C
	WRITE(*,*) LAB
	WRITE(*,*) FMT
	WRITE(OUT,'(A)') LAB
C
	CALL READGROUPDATA(INF,IFRAB,EOF)
	KFRAB = 0
 20	CONTINUE
	   CLTIME = CCSTIME
	   WRITE(*,*) CCSTIME
C........Transfer data from /GRPVEL/ variables to PDATA array.
	   KFRAB = KFRAB + 1
	   DO 30 I = 1, NSTAT
	      PDATA(KFRAB, 1,I) = GVZ(IFRAB,I)
	      PDATA(KFRAB, 2,I) = GVH(IFRAB,I)
	      PDATA(KFRAB, 3,I) = GAZ(IFRAB,I)
	      PDATA(KFRAB, 4,I) = GVX(IFRAB,I)
	      PDATA(KFRAB, 5,I) = GVY(IFRAB,I)
	      PDATA(KFRAB, 6,I) = GSQ(IFRAB,I)
	      PDATA(KFRAB, 7,I) = GVL(IFRAB,I)
	      PDATA(KFRAB, 8,I) = GSL(IFRAB,I)
	      PDATA(KFRAB, 9,I) = NGVEL(IFRAB)
	      PDATA(KFRAB,10,I) = NGVELOS(IFRAB)
 30	   CONTINUE
C........Keep reading until the time changes.
	   CALL READGROUPDATA(INF,IFRAB,EOF)
	   IF (CCSTIME.EQ.CLTIME.AND..NOT.EOF) GOTO 20
C
	   WRITE(OUT,FMT) CTIME(ITIME),
     +           ((PDATA(J,PSEQ(I),PSTT(I)),I=1,NPVAR),J=1,KFRAB)
	   KFRAB = 0
	IF (.NOT.EOF) GOTO 20

	CLOSE(UNIT=INF)
	CLOSE(UNIT=OUT)
 101	FORMAT (1X,A17,12A10)
 102	FORMAT (1X,A17,10F10.3,I10)
 103	FORMAT (2X,15(A4,1X))
 104	FORMAT (15I5)
 105	FORMAT (30A)
	END

C ==========================================================================
C
C1	SUBROUTINE READOLDGDATA(UNIT,IFRB,EOF)
C
C	Reads data into the /GRPVEL/ common block for the bin IFRB
C	as well as some /TIME/ and /BOUNDS/ information from the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable EOF is set if the end of file
C	is encountered in a READ operation.
C
C	***** NOTE *****  This reads only Versions prior to 3.0
C
C	   IVAR   =  The number of variables  to read from the file
C	   NVAR   =  The number of variables the routine expects to find.
C	   ISTAT  =  The number of statistics to read from the file.
C	   NSTAT  =  The maximum number of statistics /GRPVEL/ can hold.
C
C.....Parameters
C1$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
C1$INCLUDE:'\DRIFT\VELOCITY\COMMON\GRPVEL.CMN'
C1$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
C1$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
C
C1	INTEGER UNIT,IFRB,NVAR,I,ISTAT,IVAR
C1	REAL VSN
C1	LOGICAL EOF
C1	CHARACTER*3 JUNK
C
C1	EOF = .FALSE.
C1	NVAR = 6
C
C1 	READ(UNIT,101,END=900)  CCSTIME,IFRB,NGVEL(IFRB),BFRQ(IFRB,1),
C1     +                        BFRQ(IFRB,2),BRNG(IFRB,1),BRNG(IFRB,2),
C1     +                        ISTAT,IVAR
C
C1	IF((ISTAT.GT.NSTAT).OR.(IVAR.NE.NVAR).OR.(VSN.GE.3.0))THEN
C1	   WRITE(*,*) ' READOLDGDATA --> Incompatable file format.'
C1	   GOTO 900
C1	ENDIF
C
C
C1	READ(UNIT,102,END=900) JUNK,(GVZ(IFRB,I),I=1,ISTAT)
C1	READ(UNIT,102,END=900) JUNK,(GVH(IFRB,I),I=1,ISTAT)
C1	READ(UNIT,102,END=900) JUNK,(GAZ(IFRB,I),I=1,ISTAT)
C1	READ(UNIT,102,END=900) JUNK,(GVX(IFRB,I),I=1,ISTAT)
C1	READ(UNIT,102,END=900) JUNK,(GVY(IFRB,I),I=1,ISTAT)
C1	READ(UNIT,103,END=900) JUNK,(GSQ(IFRB,I),I=1,ISTAT)
C1	RETURN
C
C1 101	FORMAT (1X,A17,2I4,4F8.2,2I3)
C1 102	FORMAT (1X,A3,12F10.2)
C1 103	FORMAT (1X,A3,12F10.4)
C
C1 900	EOF = .TRUE.
C1	RETURN
C1	END
C
C
C ==========================================================================
C
	SUBROUTINE READGROUPDATA(UNIT,IFRB,EOF)
C
C	Reads data into the /GRPVEL/ common block for the bin IFRB
C	as well as some /TIME/ and /BOUNDS/ information from the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable EOF is set if the end of file
C	is encountered in a READ operation.
C
C	   IVAR   =  The number of variables  to read from the file
C	   NVAR   =  The number of variables the routine expects to find.
C	   ISTAT  =  The number of statistics to read from the file.
C	   NSTAT  =  The maximum number of statistics /GRPVEL/ can hold.
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\GRPVEL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'

C
	INTEGER UNIT,IFRB,NVAR,I,ISTAT,IVAR
	REAL VSN
	LOGICAL EOF
	CHARACTER*3 JUNK
C
	EOF = .FALSE.
	NVAR = 8
C
	READ(UNIT,101,END=900) CCSTIME,IFRB,ISTAT,IVAR,VSN
	IF((ISTAT.GT.NSTAT).OR.(IVAR.GT.NVAR).OR.(VSN.GT.VERSION))THEN
	   WRITE(*,*) ' READGROUPDATA --> Incompatable file format.'
	   GOTO 900
	ENDIF
	READ(UNIT,104,END=900) JUNK,BFRQ(IFRB,1),BFRQ(IFRB,2),
     +                         BRNG(IFRB,1),BRNG(IFRB,2),
     +                         (BANG(IFRB,I),I=1,4),
     +                         NGVEL(IFRB),NGVELOS(IFRB)
	IF (IVAR.GT.0)
     +   READ(UNIT,102,END=900) JUNK,(GVZ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.1)
     +   READ(UNIT,102,END=900) JUNK,(GVH(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.2) 
     +   READ(UNIT,102,END=900) JUNK,(GAZ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.3)
     +   READ(UNIT,102,END=900) JUNK,(GVX(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.4) 
     +   READ(UNIT,102,END=900) JUNK,(GVY(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.5)
     +   READ(UNIT,103,END=900) JUNK,(GSQ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.6)
     +   READ(UNIT,102,END=900) JUNK,(GVL(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.7)
     +   READ(UNIT,103,END=900) JUNK,(GSL(IFRB,I),I=1,ISTAT)
	RETURN
 101	FORMAT (1X,A17,3I5,F5.2)
 102	FORMAT (1X,A3,12F10.2)
 103	FORMAT (1X,A3,12F10.4)
 104	FORMAT (1X,A3,8F10.2,2I6)
C
 900	EOF = .TRUE.
	RETURN
	END
C
C ==========================================================================
C
	CHARACTER*17 FUNCTION CTIME(ISEL)
C	
C	As a convenience feature, this function returns the CHARACTER*17 time
C	indicated by ISEL.
C
C	1) Current time (CNTIME)
C	2) Start time of current accumulation (CCSTIME)
C	3) Start time of entire run (CSTIME)
C	4) End time of entire run (CETIME)
C	5) CCSTIME, truncated to previous ATIME Min.
C	6) CCSTIME in Decimal Hours.
C	7) CCSTIME in Decimal Days.
C
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'

C
	INTEGER ISEL,IAT,IROUND,ID,IH,IM,IS
	REAL RH,RM
	CHARACTER*17 CTT
C
	IF (ISEL.EQ.1) THEN
	   CTIME = CNTIME
	ELSE IF (ISEL.EQ.2) THEN
	   CTIME = CCSTIME
	ELSE IF (ISEL.EQ.3) THEN
	   CTIME = CSTIME
	ELSE IF (ISEL.EQ.4) THEN
	   CTIME = CETIME
	ELSE IF (ISEL.EQ.5) THEN
	   IF (ATIME.LE.0.0) RETURN
	   CTT = CCSTIME
C........# of Minutes to round off to.
	   RM = ATIME/60.
	   IAT = MAX(IROUND(RM),1)
	   READ (CTT,105) IH,IM,IS
	   RM = IM + IS/60.
	   IM = IAT*INT(RM/IAT)
	   IF (IM.GE.60) THEN
	      IH = IH + 1
	      IM = IM - 60
	   ENDIF
	   IS = 0
	   WRITE(CTT,115) CTT,IH,':',IM,':',IS
	   CTIME = CTT
	ELSE IF (ISEL.EQ.6) THEN
C........Time in YYYY DDD HH.HHHHH
	   CTT = CCSTIME
	   READ (CTT,105) IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
	   WRITE(CTT,116) CTT(1:9),RH
	   CTIME = CTT
	ELSE IF (ISEL.EQ.7) THEN
C........Time in YYYY DDD.DDDDDDDD
	   CTT = CCSTIME
	   READ (CTT,107) ID,IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
		RH = ID + RH/24.0
	   WRITE(CTT,117) CTT(1:5),RH
	   CTIME = CTT
	ELSE
	   CTIME = 'CTIME:Bad option '
	ENDIF
 105	FORMAT (9X,I2,1X,I2,1X,I2)
 107	FORMAT (5X,I3,1X,I2,1X,I2,1X,I2)
 115	FORMAT (A9,I2.2,A1,I2.2,A1,I2.2)
 116	FORMAT (A9,F8.5)
 117	FORMAT (A5,F12.8)
	RETURN
	END
C
	INTEGER FUNCTION IROUND(VALUE)
C
	REAL VALUE
	IF (VALUE.GE.0) THEN
	   IROUND = INT(VALUE + 0.50001)
	ELSE
	   IROUND = INT(VALUE - 0.50001)
	ENDIF
	RETURN
	END
C
C ========================================================================
C
	INTEGER FUNCTION GETINT(A,B)
C	Returns an integer read from the console in the range (A,B)
C
	INTEGER A,B,I
 10	READ(*,*,ERR=10) I
	IF ((I.LT.A).OR.(I.GT.B)) THEN
	   WRITE(*,*) ' Invalid choice, try again ...'
	   GOTO 10
	ENDIF
	GETINT = I
	WRITE(*,*) ' '
	RETURN
	END

