$DECALRE
$NOTRUNCATE
C
C	This program allows one to read in MAPDATA files and write text files
C	with various contents dependiing upon the desired application.  Much
C	code is borrowed from the VELH program.
C
C
C	Common Block Contents.
C  /RULES/  Determine how to PLAY with the data.
C	NCOLUMN     -  # of columns of data to print.
C	COLCONT(20) -  Content type of each column.
C	IGROUP      -  Type of grouping for each row.
C
C  /MAPDATA/   Data read in from input file (SKY output)
C	NMAP      	-  Record number from original tape (useless here)
C	IFF         -  Frequency/height number (1-4)
C	IPREF(89)   -  Digisonde Preface characters
C	FREQ        -  Frequency of measurement MHz
C	RANGE       -  Virtual height of the data, Km
C	GAIN        -  Receiver attenuation, dB
C	MPAMP       -  Most Probable AMPlitude, dB
C	MAXAMP      -  Maximum Amplitude, dB
C	ZMAX        -  Maximum Zenith angle, degrees
C	NUMSRC      -  # of sources that follow
C	YMAP(256)   -  Y coordinates of sources
C	XMAP(256)   -  X coordinates of sources
C	MAPAMP(256) -  Amplitudes of sources, dB
C	MAPDOP(256) -  Doppler channel # of sources
C
C  /SOURCES/ Information on each source required for determining the
C	       velocity vector.  NSS is the parameter for the maximum
C            number of saved sources.
C	NSRCRS     - Current number of sources  (INTEGER*4)
C	THETAS(NSS) - INTEGER*2 arrival elevation angle*10, from Zenith.
C	PHIS(NSS)   - INTEGER*2 arrival azimuth*10, from magnetic North, 
C	              increasing to the EAST, like Navigational coordiantes.
C	              *** NOTE ***  This is opposite SKYMAP data conventions. 
C	ERMS(NSS)   - INTEGER*1 source RMS positional error.
C	AMPS(NSS)   - INTEGER*1 amplitude of the source,dB.
C	NOIS(NSS)   - INTEGER*1 noise (MPA) of the source,dB.
C	VRS(NSS)    - Radial velocity of the source. (REAL*4)
C	BINS(NSS)   - INTEGER*2 The /BOUNDARY/ bin for this source.
C	ACTIVE(NSS) - LOGICAL*1 flag indicating selection of this source.
C
C  /TIME/
C	STARTTIME, ENDTIME, NOWTIME, LASTTIME
C	ATIME       - Data Accumulation time = time over which data is
C	              averaged/smoothed. (seconds)
C	ACCSTIME    - The accumulation (averaging) start time. 
C	CSTIME,CETIME,CNTIME,CCSTIME,CLTIME - Times in CHARACTER*17 format
C	                         YYYY DDD HH:MM:SS 
C	NR2DO       - The number of Subcases to process if ENDTIME unspecified.
C
C
$INCLUDE:'\DRIFT\PLAY\RULES.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\MAPDATA.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\SOURCES.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
C
C.....Read input parameters.
	CALL INPUT()
C
C
C.....Start searching for the first record desired.
	NSKIP = 0
	IF (STARTTIME.EQ.0) THEN
	   WRITE(*,*) ' Starting at begining of file ...'
	   CALL READMAPDATA(IU,EOF50)
	   LASTTIME = 0.0
	   NOWTIME = PARSETIME(IPREF)
	   LASTTIME = NOWTIME
	   CNTIME = CTIMELTT(IPREF)
	   CLTIME = CNTIME
	ELSE
 11	   CALL READMAPDATA(IU,EOF50)
	   IF(EOF50) GO TO 1450
	   LASTTIME = NOWTIME
	   CLTIME = CNTIME
	   NOWTIME = PARSETIME(IPREF)
	   CNTIME = CTIMELTT(IPREF)
	   IF (NOWTIME.LT.STARTTIME) THEN
	      WRITE(*,'(1X,2A)') CNTIME,' Skipping ...'
	      NSKIP = NSKIP + 1
	      GOTO 11
	   ENDIF
	   WRITE(*,133) CNTIME,NSKIP
	ENDIF
C
 133	FORMAT(' Found desired start time ',A20,'.  Skipped ',I4,
     +         ' Subcases.')
C
C.....Desired record has been found, start processing.
C
C
	END
C
C  =======================================================================
C
	SUBROUTINE INPUT()
C
C	Use menus to read in pertinent input parameters for the skymap
C	data manipulations.
C
C.....Paramteters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE"'\DRIFT\PLAY\RULES.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\CONTROL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\SELECT.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
C
C
	PU = 11
	IU = 50
C
	WRITE(*,*) ' SPLAY -- Skymap data manipulation program.'
	WRITE(*,*) '  Output Skymap data in many formats.'
C
C 
 902	WRITE(*,*) 'Enter the name of the file with the Skymap data:'
	READ(*,'(A)') INFILE
	OPEN(UNIT=IU,FILE=INFILE,FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS='OLD',ERR=902)
C
C....Output data formats.  The data is output in rows and columns.  Define
C....here what the rows and columns mean.
C
	WRITE(*,*)' Enter the number of COLUMNS (1-20) desired.'
	NCOLUMN = GETINT(1,20)
	WRITE(*,*)' Data COLUMN contents:
	WRITE(*,*)'   1) Zenith Angle (degrees).'
	WRITE(*,*)'   2) Zenith Angle (radians).'
	WRITE(*,*)'   3) Azimuth Angle (degrees).' 
	WRITE(*,*)'   4) Azimuth Angle (radians).'
	WRITE(*,*)'   5) Amplitude (dB).'
	WRITE(*,*)'   6) Doppler Number (bins).'
	WRITE(*,*)'   7) Doppler Frequency (Hz).'
	WRITE(*,*)'   '
	DO 22 I = 1, NCOMUMN
	   WRITE(*,103) I
	   COLCONT(I) = GETINT(1,7)
 22	CONTINUE
C
	WRITE(*,*) ' Data ROW grouping options.  Output one line per:'
	WRITE(*,*) '     1) Source.'
	WRITE(*,*) '     2) Subcase.'
	WRITE(*,*) '     3) Case.'
	WRITE(*,*) '     4) Group.'
	WRITE(*,*) '     5) Specify grouping interval.'
	IGROUP = GETINT(1,5)
	IF (IGROUP.EQ.5) THEN
	   WRITE(*,*) ' Enter number of minutes between velocity',
     +              ' calculations.'
	   READ(*,*) ATIME
	   ATIME = ATIME*60.0
	ENDIF

C
 103	FORMAT (' Contents for column #',I3,'? = '\)
	WRITE(*,*) ' Data Listing Destination:'
	WRITE(*,*) '      1) List to the printer.'
	WRITE(*,*) '      2) List to a file.'
	FILE = (GETINT(1,2).EQ.2)
	ENDIF
	IF (FILE) THEN
 903	   WRITE(*,*) ' Name of the file for the data listings.'
	   READ(*,'(A)') LFILE
	   OPEN(UNIT=PU,FILE=LFILE,FORM='FORMATTED',MODE='WRITE',
     +       ACCESS='SEQUENTIAL',ERR=903)
	 ELSE
	   OPEN(UNIT=PU,FILE='PRN',FORM='FORMATTED',MODE='WRITE',
     +        ACCESS='SEQUENTIAL')
	   CALL INITOPTI(PU,GRAPH)
	ENDIF
C
C.....Starting and ending times.
C
	NR2DO = 0
 21 	WRITE(*,*) ' Enter starting date and time in the format:'
	WRITE(*,*) ' 1987 022 01:05:02   or enter 0 for first record'
	WRITE(*,*) ' of the file.'
	READ (*,29) CTT
 29	FORMAT (A17)
	STARTTIME = PARCTIME(CTT)
	CSTIME = CTT
	WRITE(*,*) ' Enter ending date and time (same format) or'
	WRITE(*,*) ' enter 0 to select a number of cases.'
	READ(*,29) CTT
	ENDTIME = PARCTIME(CTT)
	CETIME = CTT
	IF (STARTTIME.GT.ENDTIME) THEN
	   WRITE(*,*)' Entered start time exceeds entered ending time.'
	   GOTO 21
	ENDIF
	IF (ENDTIME.EQ.0.0) THEN
	   ENDTIME = 1.0E27
	   WRITE(*,*) ' Enter number of DRIFT sub-cases to process or'
	   WRITE(*,*) ' enter 0 for all records up to EOF.'
	   READ(*,*) NR2DO
	ENDIF
	IF (NR2DO.EQ.0) NR2DO = 9999999
	END
C
C ==========================================================================
C
	SUBROUTINE COLOUT(IO,NCOL,SFMT,DATA)
C
C	Writes to the unit IO NCOLumns of DATA with each element having
C	a format defined in SFMT.  IO must be opened for formatted output.
C
	INTEGER I,IO,NCOL
	CHARACTER*10 SFMT(NCOL)
	CHARACTER*200 TFMT
	REAL DATA(NCOL)
C
C.....Build the FORMAT statment TFMT.
	WRITE(TFMT,'(40A)') '(',(SFMT(I),',',I=1,NCOL-1),SFMT(NCOL),')'
C.....Write the data to unit IO
	WRITE(IO,TMFT) (DATA(I),I=1,NCOL)
	RETURN
	END
C
C===========================================================================
