$DECLARE
$NOTRUNCATE
C
C	I/O routines for the PLAY data manipulation programs.
C
C ========================================================================
C
	CHARACTER*17 FUNCTION CTIME(ISEL)
C	
C	As a convenience feature, this function returns the CHARACTER*17 time
C	indicated by ISEL.
C
C	1) Current time (CNTIME)
C	2) Start time of current accumulation (CCSTIME)
C	3) Start time of entire run (CSTIME)
C	4) End time of entire run (CETIME)
C	5) Start time of current accumulation, rounded to previous ATIME Min.
C
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
C
	INTEGER ISEL,MIN,ZERO,IAT,IROUND
	REAL RMIN
	CHARACTER*17 CTT
	CHARACTER*2 CMIN
	ZERO = ICHAR('0')
C
	IF (ISEL.EQ.1) THEN
	   CTIME = CNTIME
	ELSE IF (ISEL.EQ.2) THEN
	   CTIME = CCSTIME
	ELSE IF (ISEL.EQ.3) THEN
	   CTIME = CSTIME
	ELSE IF (ISEL.EQ.4) THEN
	   CTIME = CETIME
	ELSE IF ((ISEL.EQ.5).AND.(ATIME.GT.0)) THEN
	   CTT = CCSTIME
	   RMIN = ATIME/60.
	   IAT = MAX(IROUND(RMIN),1)
C........Minute.
	   RMIN = 10.*(ICHAR(CTT(13:13)) - ZERO) +
     +           1.*(ICHAR(CTT(14:14)) - ZERO) +
     +     0.166667*(ICHAR(CTT(16:16)) - ZERO) +
     +     0.016667*(ICHAR(CTT(17:17)) - ZERO)
	   MIN = IAT*IROUND(RMIN/IAT)
	   WRITE(CMIN,'(2I1)') MIN/10, MOD(MIN,10)
	   CTT(13:13) = CMIN(1:1)
	   CTT(14:14) = CMIN(2:2)
	   CTT(16:16) = '0'
	   CTT(17:17) = '0'
	   CTIME = CTT
	ELSE
	   CTIME = 'CTIME:Bad option '
	ENDIF
	RETURN
	END
C	Functions and things for the VELH program.
C
	REAL FUNCTION SIND(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	SIND = SIN(RAD*ANGLE)
	RETURN
	END
C
	REAL FUNCTION COSD(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	COSD = COS(RAD*ANGLE)
	RETURN
	END
C
	REAL FUNCTION TAND(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	TAND = TAN(RAD*ANGLE)
	RETURN
	END
C
C.....Inverse Trig functions return angles in degrees from 0-360 
	REAL FUNCTION ACOSD(VALUE)
	REAL VALUE,DEG
	DATA DEG /57.29577951/
	IF (ABS(VALUE).GT.1.0) VALUE = SIGN(1.0,VALUE)
	ACOSD = DEG*ACOS(VALUE)
	IF (ACOSD.LT.0.0) ACOSD = ACOSD + 360.0
	RETURN
	END
C
	REAL FUNCTION ASIND(VALUE)
	REAL VALUE,DEG
	DATA DEG /57.29577951/
	IF (ABS(VALUE).GT.1.0) VALUE = SIGN(1.0,VALUE)
	ASIND = DEG*ASIN(VALUE)
	IF (ASIND.LT.0.0) ASIND = ASIND + 360.0
	RETURN
	END
C
	REAL FUNCTION ATAND2(VALUE1,VALUE2)
	REAL VALUE1,VALUE2,DEG
	DATA DEG /57.29577951/
	ATAND2 = 0.0
	IF ((VALUE1.EQ.0).AND.(VALUE2.EQ.0)) RETURN
	ATAND2 = DEG*ATAN2(VALUE1,VALUE2)
C
C ========================================================================
C
	INTEGER FUNCTION GETINT(A,B)
C	Returns an integer read from the console in the range (A,B)
C
	INTEGER A,B,I
 10	READ(*,*,ERR=10) I
	IF ((I.LT.A).OR.(I.GT.B)) THEN
	   WRITE(*,*) ' Invalid choice, try again ...'
	   GOTO 10
	ENDIF
	GETINT = I
	WRITE(*,*) ' '
	RETURN
	END
C
C
	INTEGER FUNCTION IROUND(VALUE)
C
	REAL VALUE
	IF (VALUE.GE.0) THEN
	   IROUND = INT(VALUE + 0.50001)
	ELSE
	   IROUND = INT(VALUE - 0.50001)
	ENDIF
	RETURN
	END
C
C  ======================================================================
C 
	SUBROUTINE READMAPDATA(INFILE,EOF) 
C 
C===== READ THE MAP DATA FROM A FILE <infile> FOR LATER USE IN PRINTING 
C	SKYMAPS OR CALCULATING DRIFT VELOCITIES.  FREQUENCY READ IS
C	 <IFF>  THE FORMAT OF THE PREFACE IS AS FOLLOWS:
C
C	NOTE:  Range is converted to meters and Frequency to Hertz.
C 
C
C  POSITION ! FORMAT  !  INFORMATION
C_______________________________________________________________
C  1        ! A1      !  SPACE                                  !
C  2-4      ! 3Z1     !  STATION ID CODE                        !
C  5-9      ! I5      !  RECORD NO.                             !
C  10       ! A1      !  SPACE                                  !
C  11-15    ! 5Z1     !  DATE                                   !
C  16       ! A1      !  SPACE                                  !
C  17-22    ! 6Z1     !  TIME                                   !
C  23       ! 1X      !  SPACE                                  !
C  24       ! Z1      !  PROGRAM SET                            !
C  25       ! Z1      !  PROGRAM TYPE                           !
C  26-31    ! 6Z1     !  JOURNAL (6 HEX DIGITS)                 !
C  32-38    ! 7Z1     !  P1 TO P7 (7 HEX DIGITS)                !
C  39       ! 1X      !  SPACE                                  !
C  40-46    ! 7Z1     !  XLZTNRW (7 HEX DIGITS)                 !
C  47-53    ! 7Z1     !  K(I*)(G*)HEIG (7 HEX DIGITS)           !
C  54-57    ! I4      !  ZMAX (10THS OF A DEGREE)               !
C  58-59    ! I2      !  NFREQ=FREQUENCY NUMBER                 !
C  60-66    ! I7      !  FREQ(NFREQ), IN 100-HZ UNITS           !
C  67-71    ! I5      !  RANG(NFREQ), IN 100-METER UNITS        !
C  72-74    ! I3      !  IGAIN(NFREQ), IN DB                    !
C  75-77    ! I3      !  MPAMP(NFREQ)                           !
C  78-80    ! I3      !  MAXAMP(NFREQ)                          !
C  81-84    ! I4      !  NO. OF SOURCES FOR NFREQ               !
C  85-87    ! I3      !  KTH, CASE SELECTION THRESHOLD          !
C  88-90    ! I3      !  LTH, SPECTRAL LINE SELECTION THRESHOLD ! 
C================================================================
C
	INTEGER INFILE,I,I1,I2,IRNG,IFRQ,IZMAX
	CHARACTER*2 JUNK
	LOGICAL EOF
C
C	VARIABLES FOR THE COMMON BLOCKS
C
C.....For /MAPDATA/
$INCLUDE:'\DRIFT\VELOCITY\COMMON\MAPDATA.CMN'
C
C
	DO 10 I =1, 89
 10   IPREF(I) = 0
	DO 20 I=1,256
	   XMAP(I) = 0.0
	   YMAP(I) = 0.0
	   MAPAMP(I) = 0
	   MAPRMS(I) = 0
 20   CONTINUE
	EOF = .FALSE.
C
	READ(INFILE,110,END=99) (IPREF(I),I=41,43),NMAP,
     +  (IPREF(I),I=1,19), (IPREF(I),I=26,32), (IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC
C
 110	FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +	  I4,I2,I7,I5,4I3,I4) 
C
	RANGE = FLOAT(IRNG)*100.
	FREQ =  FLOAT(IFRQ)*100.
	ZMAX =  FLOAT(IZMAX)/10.
	 
	DO 140 I1=1,NUMSRC,26 
	   I2=I1+25
	   IF(I2.GT.NUMSRC) I2=NUMSRC 
	   READ(INFILE,151) JUNK,(YMAP(I),I=I1,I2) 
	   READ(INFILE,151) JUNK,(XMAP(I),I=I1,I2) 
	   READ(INFILE,150) JUNK,(MAPAMP(I),I=I1,I2)
	   READ(INFILE,150) JUNK,(MAPDOP(I),I=I1,I2) 
	   READ(INFILE,150) JUNK,(MAPRMS(I),I=I1,I2) 
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C 
	RETURN
C     End of File condition.
 99   EOF = .TRUE.
 	NUMSRC = 0
	RETURN
	END 
C
C  ======================================================================
C
	SUBROUTINE INITOPTI(IO,SMALL)
C	Initializes the Okidata 192 printer with OptiFont characters
C	in place of the numbers 0-9 and the letters A-F, as well as the
C	period (.) character.
C	The array CHARSET contains the 12 decimal ASCII numbers needed to
C	define the Optifont characters.
C	If (SMALL) is .TRUE., Line spacing is 13/144", unidirectional.
C	If (SMALL) is .FALSE., Line spacing is 17/144", bidirectional.
C
	CHARACTER*2 STARTDEF,UNIDIR,BIDIR
	CHARACTER*3 DEFINEA
	CHARACTER*4 L13144,L17144
	INTEGER*2 CHARSET(17,12),I,IC
	INTEGER IO
	LOGICAL SMALL
C
	DATA (CHARSET(1,I),I=1,12)/176,0,0,20,0,0,0,0,0,0,0,0/
	DATA (CHARSET(2,I),I=1,12)/177,0,0,62,0,0,0,0,0,0,0,0/
	DATA (CHARSET(3,I),I=1,12)/178,58,0,0,36,0,0,0,0,0,0,0/
	DATA (CHARSET(4,I),I=1,12)/179,42,0,0,54,0,0,0,0,0,0,0/
	DATA (CHARSET(5,I),I=1,12)/180,14,0,8,0,0,60,0,0,0,0,0/
	DATA (CHARSET(6,I),I=1,12)/181,46,0,0,42,0,48,0,0,0,0,0/
	DATA (CHARSET(7,I),I=1,12)/182,62,0,0,40,0,56,0,0,0,0,0/
	DATA (CHARSET(8,I),I=1,12)/183,58,0,0,62,0,6,0,0,0,0,0/
	DATA (CHARSET(9,I),I=1,12)/184,62,0,0,42,0,30,0,0,0,0,0/
	DATA (CHARSET(10,I),I=1,12)/185,46,0,0,58,0,0,62,0,0,0,0/
	DATA (CHARSET(11,I),I=1,12)/193,62,0,0,54,0,0,62,0,0,0,0/
	DATA (CHARSET(12,I),I=1,12)/194,62,0,0,62,0,0,60,0,0,32,0/
	DATA (CHARSET(13,I),I=1,12)/195,62,0,0,62,0,0,58,0,0,36,0/
	DATA (CHARSET(14,I),I=1,12)/196,62,0,0,62,0,0,42,0,0,54,0/
	DATA (CHARSET(15,I),I=1,12)/197,62,0,0,62,0,0,62,0,0,28,0/
	DATA (CHARSET(16,I),I=1,12)/198,62,0,0,62,0,0,62,0,0,58,0/
	DATA (CHARSET(17,I),I=1,12)/174,0,0,0,0,0,8,0,0,0,0,0/
C
	STARTDEF = CHAR(27)//CHAR(36)
	DEFINEA = CHAR(27)//CHAR(37)//CHAR(65)
C	L13144 sets line spacing to 13/144" for Optifont
C	L17144 sets line spacing to 17/144" for Text.
C
	L13144 = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(13)
	L17144 = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(17)
	UNIDIR = CHAR(27)//CHAR(45)
	BIDIR = CHAR(27)//CHAR(61)
C
C	This copies the printer character set to printer's RAM,
C	Then transfers the OptiFont characters to the printer.
C	Unit IO is for the printer
C
	WRITE(IO,99) STARTDEF,
     +            (DEFINEA,(CHAR(CHARSET(IC,I)),I=1,12),IC=1,17)
 99	FORMAT(1X,A2,17(A3,12A1))
C.....Switches the printer to use the downloaded character set
	IF (SMALL) THEN
	   WRITE(IO,'(1X,2A1,A4,A2)') CHAR(27),CHAR(50),L13144,UNIDIR
	ELSE
	   WRITE(IO,'(1X,2A1,A4,A2)') CHAR(27),CHAR(50),L17144,BIDIR
	ENDIF	
	RETURN
	END





