$DECLARE
$NOTRUNCATE
$DEBUG
C
	PROGRAM VELXYX
C
C	This program reads a Velocity vector file and produces
C	a file of velocities and errors vs time.
C	Output vector is in Cartesian coordinates
C
C.....Parameters
$INCLUDE:'COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'COMMON\GRPVEL.CMN'
$INCLUDE:'COMMON\TIME.CMN'
$INCLUDE:'COMMON\BOUNDS.CMN'
C
C
C  /GRPVEL/        -  Statistical data for the Group Velocity in NFRAB
C	                possible Frequency-Range-Angle Bins.
C	                NFRAB and NSTAT are program parameters.
C	                The second index indicates which value is contained. 
C GVZ(NFRAB,NSTAT) -  Statistics for the Group Velocity Z-component.
C	     , 1)    -  Mean
C	     , 2)    -  Standard Deviation
C	     , 3)    -  Median
C	     , 4)    -  Upper quartile
C	     , 5)    -  Lower quartile
C	     , 6)    -  Most probable
C	     , 7)    -  Least Square fit to ALL data. 
C   8) -,NSTAT)    -  For future use  
C GVH(NFRAB,NSTAT) -  Statistics for the Group Velocity Horizontal magnitude.
C GAZ(NFRAB,NSTAT) -  Statistics for the Group Velocity horizontal AZimuth.
C GVX(NFRAB,NSTAT) -  Statistics for the Group Velocity X component.
C GVY(NFRAB,NSTAT) -  Statistics for the Group Velocity Y component.
C GSQ(NFRAB,NSTAT) -  Statistics for the velocity root mean square error.
C GVL(NFRAB,NSTAT) -  Statistics for the Group Velocity Line-of-Sight.
C GSL(NFRAB,NSTAT) -  Statistics for the LOS velocity root mean square error.
C NGVEL(NFRAB)     -  Number of measurements at each FRAB.
C NGVELOS(NFRAB)   -  Number of measurements at each FRAB.
C
C  /BOUNDS/      -  Data in this common block define the limits in
C                   Frequency, Range and Arrival Angle for each of the
C	              NFRAB's. 
C  NFRABS        -  Number of FRAB's defined.  Must be <= NFRAB.
C  TRUEHEIGHT    -  Logical flag selecting between true and virtual height
C	              selection of the data.  *** TRUE HEIGHT NOT YET AVAILABLE ***
C  BFRQ(NFRAB,2) -  Bounds upon the FReQuency, upper ,1) and lower ,2)
C  BRNG(NFRAB,2) -  Bounds upon the RaNGe, upper ,1) and lower ,2)
C  BANG(NFRAB,4) -  Bounds on the ANGles of arrival for this bin.
C                   ,1) = Zenith angle of the Line-of-Sight direction (deg).
C                   ,2) = Azimuth of the Line-of-Sight direction (deg).
C                   ,3) = Half 'Beamwidth' in Zenith (deg).
C                   ,4) = Half 'Beamwidth' in Azimuth (deg).
C  NBSRC(NFRAB)  - Number of sources in each FRAB
C
C
C
	INTEGER IU,OU,IFRB,NVEL,ITIME,TTYPE(3),GETINT
	LOGICAL EOF,FIRST
	REAL*8 PARCTIME
	CHARACTER*30 INFILE,OUTFILE
	CHARACTER*17 CTIME

C
	IU = 2
	OU = 3
	DATA TTYPE/2,6,7/

C
	WRITE(*,*) ' VELXYZ - Program for Extracting Digisonde '
	WRITE(*,*) ' Drift Velocity Data in Cartesian Coordinates.'
c
 901	WRITE(*,*) ' Enter the name of the .VELocity file.'	
	READ(*,102) INFILE
	OPEN(UNIT=IU,FILE=INFILE,FORM='FORMATTED',ACCESS='SEQUENTIAL',
     +     STATUS='OLD',MODE='READ',ERR=901)
C

 902	WRITE(*,*) ' Enter the name of the output file.'	
	READ(*,102) OUTFILE
	OPEN(UNIT=OU,FILE=OUTFILE,FORM='FORMATTED',ACCESS='SEQUENTIAL',
     +     STATUS='UNKNOWN',ERR=902)
C
	WRITE(*,*) ' Time format:'
	WRITE(*,*) '    1)  Standard format (YYYY DDD HH:MM:SS)'
	WRITE(*,*) '    2)  Decimal hours   (YYYY DDD HH.HHHHH)'
	WRITE(*,*) '    3)  Decimal days    (YYYY DDD.DDDDDDDD)'
	ITIME = GETINT(1,3)
	ITIME = TTYPE(ITIME)
C
	EOF = .FALSE.
	FIRST = .FALSE.
	NVEL = 0
	WRITE(OU,*) ' Extracted Drift Velocities, unmodified'
	WRITE(OU,104) 'Time (UT)','Mean-Vx','Sdev-Vx',
     +                          'Mean-Vy','Sdev-Vy',
     +                          'Mean-Vz','Sdev-Vz','FRB#','NIVEL'
	DO WHILE (.NOT.EOF)
	   CALL READGROUPDATA(IU,IFRB,EOF)
	   IF (IFRB.EQ.0) CYCLE
	   IF (NGVEL(IFRB).EQ.0) CYCLE
	   NVEL = NVEL + 1
	   IF (FIRST) THEN
	      FIRST = .FALSE.
	      STARTTIME = PARCTIME(CCSTIME)
	   ENDIF
	   NOWTIME = PARCTIME(CCSTIME)
	   WRITE(*,*) CCSTIME
C	   NOTE - This will not work if there are multiple FRB's.
	   WRITE(OU,105) CTIME(ITIME),GVX(IFRB,1), GVX(IFRB,2),
     +                              GVY(IFRB,1), GVY(IFRB,2),
     +                              GVZ(IFRB,1), GVZ(IFRB,2),
     +                              IFRB,NGVEL(IFRB)
	ENDDO
	NVEL = NVEL - 1
	WRITE(*,*) NVEL,' Velocities read.'
C
	CLOSE(IU)
	CLOSE(OU)
C
 102	FORMAT (A)
 104	FORMAT (A17,10A10)
 105	FORMAT (A17,6F10.2,2I10)
 106	FORMAT (F17.10,6F10.2,2I10)

	END
C
C ==========================================================================
C
	SUBROUTINE READGROUPDATA(UNIT,IFRB,EOF)
C
C	Reads data into the /GRPVEL/ common block for the bin IFRB
C	as well as some /TIME/ and /BOUNDS/ information from the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable EOF is set if the end of file
C	is encountered in a READ operation.
C
C	   IVAR   =  The number of variables  to read from the file
C	   NVAR   =  The number of variables the routine expects to find.
C	   ISTAT  =  The number of statistics to read from the file.
C	   NSTAT  =  The maximum number of statistics /GRPVEL/ can hold.
C
C.....Parameters
$INCLUDE:'COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'COMMON\GRPVEL.CMN'
$INCLUDE:'COMMON\TIME.CMN'
$INCLUDE:'COMMON\BOUNDS.CMN'

C
	INTEGER UNIT,IFRB,NVAR,I,ISTAT,IVAR
	REAL VSN
	LOGICAL EOF,KILL
	CHARACTER*3 JUNK
C
	EOF = .FALSE.
	NVAR = 8
C
	READ(UNIT,101,END=900) CCSTIME,IFRB,ISTAT,IVAR,VSN
	IF((ISTAT.GT.NSTAT).OR.(IVAR.GT.NVAR).OR.(VSN.GT.VERSION))THEN
	   WRITE(*,*) ' READGROUPDATA --> Incompatable file format.'
	   GOTO 900
	ENDIF
	KILL = (IFRB.LE.0)
	IFRB = MAX(1,IFRB)
	READ(UNIT,104,END=900) JUNK,BFRQ(IFRB,1),BFRQ(IFRB,2),
     +                         BRNG(IFRB,1),BRNG(IFRB,2),
     +                         (BANG(IFRB,I),I=1,4),
     +                         NGVEL(IFRB),NGVELOS(IFRB)
	IF (IVAR.GT.0)
     +   READ(UNIT,102,END=900) JUNK,(GVZ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.1)
     +   READ(UNIT,102,END=900) JUNK,(GVH(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.2) 
     +   READ(UNIT,102,END=900) JUNK,(GAZ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.3)
     +   READ(UNIT,102,END=900) JUNK,(GVX(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.4) 
     +   READ(UNIT,102,END=900) JUNK,(GVY(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.5)
     +   READ(UNIT,103,END=900) JUNK,(GSQ(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.6)
     +   READ(UNIT,102,END=900) JUNK,(GVL(IFRB,I),I=1,ISTAT)
	IF (IVAR.GT.7)
     +   READ(UNIT,103,END=900) JUNK,(GSL(IFRB,I),I=1,ISTAT)
C
	IF (KILL) IFRB = 0
	RETURN
 101	FORMAT (1X,A17,3I5,F5.2)
 102	FORMAT (1X,A3,12F10.2)
 103	FORMAT (1X,A3,12F10.4)
 104	FORMAT (1X,A3,8F10.2,2I6)
C
 900	EOF = .TRUE.
	RETURN
	END
C
C ========================================================================
C
	INTEGER FUNCTION GETINT(A,B)
C	Returns an integer read from the console in the range (A,B)
C
	INTEGER A,B,I
 10	READ(*,*,ERR=10) I
	IF ((I.LT.A).OR.(I.GT.B)) THEN
	   WRITE(*,*) ' Invalid choice, try again ...'
	   GOTO 10
	ENDIF
	GETINT = I
	WRITE(*,*) ' '
	RETURN
	END
C
C========================================================================
C
      REAL*8 FUNCTION PARSETIME(TIME)
C            This function takes an integer array of 11 values and
C         calculates the approximate number of seconds since January, 1900.
C         These values are for comparison purposes only.
C	    Performance across year boundires is not optimal, esp. leap years.
C         Will fail past the year 2000.
C
      INTEGER*2 TIME(11)
C         Seconds per year
      PARSETIME = 31662400.*(10*TIME(1)+ TIME(2))
C         Seconds per day
      PARSETIME = PARSETIME + 86400.*(100*TIME(3)+10*TIME(4)+TIME(5))
C         Seconds per hour
      PARSETIME = PARSETIME + 3600.*(10*TIME(6) + TIME(7))
C         Seconds per minute
      PARSETIME = PARSETIME + 60.*(10*TIME(8) + TIME(9))
C         And finally the seconds
      PARSETIME = PARSETIME + 10.*TIME(10) +1.*TIME(11)
      RETURN
      END
C
C========================================================================
C
	CHARACTER*17 FUNCTION CTIMELTT(LTT)
C.....Converts the 11 INTEGER*2 argument LTT into the 17 character
C.....CTT time format.
	INTEGER*2 I,LTT(11)
	CTIMELTT = ' '
	WRITE(CTIMELTT,102) (LTT(I),I=1,11)
 102	FORMAT ('19',2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
	RETURN
	END
C
C========================================================================
C
	REAL*8 FUNCTION PARCTIME(CTT)
C
C	Parse a CHARACTER*17 time into a REAL*8 time.
C
	REAL*8 PARSETIME
	CHARACTER*17 CTT
	INTEGER*2 LTT(11),ZERO,I
C
	ZERO = ICHAR('0')
C.....Year.
	LTT(1)  = ICHAR(CTT(3:3))   - ZERO
	LTT(2)  = ICHAR(CTT(4:4))   - ZERO
C.....Day.
	LTT(3)  = ICHAR(CTT(6:6))   - ZERO
	LTT(4)  = ICHAR(CTT(7:7))   - ZERO
	LTT(5)  = ICHAR(CTT(8:8))   - ZERO
C.....Hour.
	LTT(6)  = ICHAR(CTT(10:10)) - ZERO
	LTT(7)  = ICHAR(CTT(11:11)) - ZERO
C.....Minute.
	LTT(8)  = ICHAR(CTT(13:13)) - ZERO
	LTT(9)  = ICHAR(CTT(14:14)) - ZERO
C.....Second
	LTT(10) = ICHAR(CTT(16:16)) - ZERO
	LTT(11) = ICHAR(CTT(17:17)) - ZERO
C
	DO 5 I = 1, 11
	   IF (LTT(I).LT.0) LTT(I) = 0
 5	CONTINUE
C
	PARCTIME = PARSETIME(LTT)
	RETURN
	END

C
C ==========================================================================
C
	CHARACTER*17 FUNCTION CTIME(ISEL)
C	
C	As a convenience feature, this function returns the CHARACTER*17 time
C	indicated by ISEL.
C
C	1) Current time (CNTIME)
C	2) Start time of current accumulation (CCSTIME)
C	3) Start time of entire run (CSTIME)
C	4) End time of entire run (CETIME)
C	5) CCSTIME, truncated to previous ATIME Min.
C	6) CCSTIME in Decimal Hours.
C	7) CCSTIME in Decimal Days.
C
$INCLUDE:'COMMON\TIME.CMN'

C
	INTEGER ISEL,IAT,ID,IH,IM,IS
	REAL RH,RM
	CHARACTER*17 CTT
C
	IF (ISEL.EQ.1) THEN
	   CTIME = CNTIME
	ELSE IF (ISEL.EQ.2) THEN
	   CTIME = CCSTIME
	ELSE IF (ISEL.EQ.3) THEN
	   CTIME = CSTIME
	ELSE IF (ISEL.EQ.4) THEN
	   CTIME = CETIME
	ELSE IF (ISEL.EQ.5) THEN
	   IF (ATIME.LE.0.0) RETURN
	   CTT = CCSTIME
C........# of Minutes to round off to.
	   RM = ATIME/60.
	   IAT = MAX(NINT(RM),1)
	   READ (CTT,105) IH,IM,IS
	   RM = IM + IS/60.
	   IM = IAT*INT(RM/IAT)
	   IF (IM.GE.60) THEN
	      IH = IH + 1
	      IM = IM - 60
	   ENDIF
	   IS = 0
	   WRITE(CTT,115) CTT,IH,':',IM,':',IS
	   CTIME = CTT
	ELSE IF (ISEL.EQ.6) THEN
C........Time in YYYY DDD HH.HHHHH
	   CTT = CCSTIME
	   READ (CTT,105) IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
	   WRITE(CTT,116) CTT(1:9),RH
	   CTIME = CTT
	ELSE IF (ISEL.EQ.7) THEN
C........Time in YYYY DDD.DDDDDDDD
	   CTT = CCSTIME
	   READ (CTT,107) ID,IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
		RH = ID + RH/24.0
	   WRITE(CTT,117) CTT(1:5),RH
	   CTIME = CTT
	ELSE
	   CTIME = 'CTIME:Bad option '
	ENDIF
 105	FORMAT (9X,I2,1X,I2,1X,I2)
 107	FORMAT (5X,I3,1X,I2,1X,I2,1X,I2)
 115	FORMAT (A9,I2.2,A1,I2.2,A1,I2.2)
 116	FORMAT (A9,F8.5)
 117	FORMAT (A5,F12.8)
	RETURN
	END
