$DECLARE
$NOTRUNCATE

      PROGRAM SKYMAP
C
C     This program prints two types of SKYMAPs from the  INDATA
C     located in text files.  Large maps (1 per page) or small maps 
C     (42 per page) are possible.
C
C     ***** N O T E ******
C        These Skymaps are linear in the SPACIAL dimension with tick marks
C        representing ZENITH ANGLES at the AXIS CROSSINGS.  The Skymaps
C        are projections ON THE GROUND and viewed as if from ABOVE.
C
C              SUBROUTINES CALLED
C
C GATHERMAPS -- Controlls entire Skymap sequencing and plotting 
C               given one Skymap per call.
C PARSETIME  -- Converts a time from Year,Day,Hour,Minute,Second to
C               seconds for time comparison.
C
C      IMPLICIT NONE
      INTEGER IFILE,MODE,VALUE,NNN,PFILE,I,ITH,N,MAPTYPE,JUNK
      INTEGER*2 LTT(11)
      REAL ZEEMAX,ZMRK
      REAL*8 PARSETIME,STARTTIME
      CHARACTER*20 DATAFILE
      LOGICAL EOF,PRT,BIG,PSRC

C
C         VARIABLES FOR THE COMMON BLOCKS
C
C     For /INDATA/
      INTEGER*2 NMAP,IFF,GAIN,MPAMP,MAXAMP,NUMSRC,IPREF(89),
     +        MAPAMP(256), MAPDOP(256),MAPRMS(256),KTH,LTH
      REAL FREQ,RANGE,YMAP(256),XMAP(256),ZMAX
      COMMON/INDATA/ NMAP,IFF,IPREF,FREQ,RANGE,GAIN,MPAMP,MAXAMP,
     +              ZMAX,NUMSRC,YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS,KTH,LTH
C     For /BMAP/
      CHARACTER*1 BIGMAP(-41:44,-41:44)
      CHARACTER*120 TITLE1
      COMMON/BMAP/ BIGMAP,TITLE1
C     For /SMAP/
      INTEGER*2 BITMAP(499,11)
      CHARACTER*20 TITLE(6)
      COMMON/SMAP/ BITMAP,TITLE
C     For /SOURCES/
      CHARACTER*135 SLINE(300)
      INTEGER NLINES
      COMMON/SOURCES/ NLINES,SLINE
C
      DATA LTT /0,0,0,0,0,0,0,0,0,0,0/
      NLINES = 1
      ZEEMAX = 45
      ZMRK = 5
C
      WRITE(*,*) ' Enter the name of the file with the input data.'
      READ(*,'(A)') DATAFILE
      IFILE = 20
      PFILE = 10
      OPEN(UNIT=IFILE,FILE=DATAFILE,FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS='OLD')
      OPEN(UNIT=PFILE,FILE='PRN',FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL')
C
      WRITE(*,*) ' Do you wish to print :'
      WRITE(*,*) '     1)  Large maps (1 per page)'
      WRITE(*,*) '     2)  Small maps (6x7 per page)'
      READ(*,*) MAPTYPE
      BIG = .FALSE.
	PSRC = .FALSE.
      IF (MAPTYPE.EQ.1) THEN 
	   BIG = .TRUE.
	   WRITE(*,*) ' List sources for LARGE maps?'
	   WRITE(*,*) '     1) List sources.' 
	   WRITE(*,*) '     2) Do NOT list sources.' 
	   READ(*,*) JUNK
	   PSRC = (JUNK.EQ.1) 
	ENDIF
C
      WRITE(*,*)' MODEs:'
      WRITE(*,*)'   1) 1 Map per Subcase'
      WRITE(*,*)'          (Cases w/o sources skipped if VALUE = 0.)'
      WRITE(*,*)'   2) 1 Map per Case'
      WRITE(*,*)'          (Cases w/o sources skipped if VALUE = 0.)'
      WRITE(*,*)'   3) 1 Map per group of cases.'
      WRITE(*,*)'   4) 1 Map every VALUE seconds.'
      WRITE(*,*)'   5) 1 Map every VALUE subcases.'
      WRITE(*,*)'   6) 1 Map every VALUE sources.'
      WRITE(*,*) ' Enter MODE,VALUE '
      READ(*,*) MODE,VALUE
C
      WRITE(*,*) ' Enter maximum Zenith angle(deg) on the maps.'
      READ(*,*) ZEEMAX
      IF (ZEEMAX.EQ.0) ZEEMAX = 90.
C
C      IF (BIG) THEN
         WRITE(*,*) ' Enter tick mark spacing (deg) on the maps.'
         READ(*,*) ZMRK
C      ENDIF
C 
      WRITE(*,*) ' Enter the threshold (dB below subcase maximum)'
      WRITE(*,*) '    for source inclusion.'
      READ(*,*) ITH
C
      WRITE(*,*) ' Enter starting time (ie: 881121900) '
      WRITE(*,*) ' or 0 for begining of file.'
      READ(*,'(11I1)') LTT
      STARTTIME = PARSETIME(LTT)
C
      WRITE(*,*) ' Number of MAPS to process?'
      READ(*,*) NNN
      IF (NNN.EQ.0) NNN = 99999
C
      N = 0
 10   CONTINUE
  3      CALL READMAPDATA(IFILE,EOF)
         IF (EOF) THEN
            IF (.NOT.PRT)
     +       CALL GATHERMAPS(PFILE,99,0,ZEEMAX,ZMRK,ITH,PRT,BIG,PSRC)
            STOP
         ENDIF
         IF (PARSETIME(IPREF).LT.STARTTIME) GOTO 3
         WRITE(*,18) (IPREF(I),I=1,11),NUMSRC
 18      FORMAT(1X,2I1,' ',3I1,'-',2I1,':'2I1,':',2I1,I5,' Sources')
         CALL GATHERMAPS(PFILE,MODE,VALUE,ZEEMAX,ZMRK,ITH,PRT,BIG,PSRC)
 22      FORMAT (1X,11I1,I5)
         IF (PRT) N = N + 1
      IF (N.LT.NNN) GOTO 10
      IF (.NOT.BIG) CALL GATHERMAPS
     +                   (PFILE,99,0,ZEEMAX,ZMRK,ITH,PRT,BIG,PSRC)
      END
C
C
C  ======================================================================
C
      SUBROUTINE GATHERMAPS(PU,MODE,VALUE,ZMX,ZMRK,ITH,PRT,LARGE,PSRC)
C
C     This routine takes the sources located in the /INPUTDATA/ Common
C     block and adds them to the SKYMAP to be printed.  Both large and small
C     can be printed, by selecting the value of the LARGE command.  The map
C     size may be changed, but it causes a form  feed.  Only those sources
C     with amplitudes within ITH of the maximum amplitude for the
C     subcase are included.  All sources included if ITH = 0.
C     This also prints the headers, titles, etc, and prints to PU when
C     necessary.  The map is scaled based on the value of SINZMAX, which
C     is the SIN of the maximum zenith angle on the map.  The PRT flag is
C     set .TRUE. if a map is completed and ready to be printed.
C
C     MODEs:   1) 1 Map per Subcase, those w/o sources skipped if VALUE=0.
C              2) 1 Map per Case, Cases w/o sources skipped if VALUE = 0.
C              3) 1 Map per group of cases.
C              4) 1 Map every VALUE seconds.
C              5) 1 Map every VALUE subcases.
C              6) 1 Map every VALUE sources.
C             99) Print the current maps.
C
C
C                 SUBROUTINES CALLED
C INITBMAP      --  Initiallizes the arrays for the large maps.
C INITSMAP      --  Initiallizes the arrays for the small maps.
C PRTBMAP       --  Print the large-size map.
C PRTSMAP       --  Print the small-size map.
C PRTHEAD       --  Print the header/title for each page.
C WRITEMAPDATA  --  Prints the Skymap data to memory for later printing. 
C ADDSSRC       --  Adds a small source to a small map
C ADDBSRC       --  Adds a big source to a big map.
C
C                 VARIABLES
C CTITLE   -- Title for the map currently being accumulated.
C HEADER   -- Text string title for the entire page.
C TITLE1   -- Complete title (including CTITLE) for BIG maps.
C TITLE(6) -- Titles for all 6 SMALL maps on the current line.
C
C
C      IMPLICIT NONE
      INTEGER MODE,VALUE,I,PU,ITH,MD,LASTMODE,NSUBCASES,
     +        NSOURCES,NOFF,MAP,ROW
      REAL ZMX,SCALE,SXM,SYM,ZMRK,SIND
      REAL*8 NOWTIME,PARSETIME,SUMTIME,LASTTIME
      LOGICAL NEXTMAP,ONMAP,FIRSTCASE,AOK,PRT,LARGE,LLARGE,PSRC
      CHARACTER*80 HEADER
      CHARACTER*20 CTITLE
      SAVE LASTMODE,NSUBCASES,NSOURCES,SUMTIME,MAP,ROW,LLARGE,
     +     LASTTIME,CTITLE,FIRSTCASE,NOFF
C
C         VARIABLES FOR THE COMMON BLOCKS
C
C     For /INDATA/
      INTEGER*2 NMAP,IFF,GAIN,MPAMP,MAXAMP,NUMSRC,IPREF(89),
     +        MAPAMP(256),MAPDOP(256),MAPRMS(256),KTH,LTH
      REAL FREQ,RANGE,YMAP(256),XMAP(256),ZMAX
      COMMON/INDATA/ NMAP,IFF,IPREF,FREQ,RANGE,GAIN,MPAMP,MAXAMP,
     +              ZMAX,NUMSRC,YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS,KTH,LTH
C     For /BMAP/
      CHARACTER*1 BIGMAP(-41:44,-41:44)
      CHARACTER*120 TITLE1
      COMMON/BMAP/ BIGMAP,TITLE1
C     For /SMAP/
      INTEGER*2 BITMAP(499,11)
      CHARACTER*20 TITLE(6)
      COMMON/SMAP/ BITMAP,TITLE
C
      DATA LASTMODE /0/
      DATA FIRSTCASE /.TRUE./
      DATA MAP /1/
      DATA ROW /1/
C
      PRT = .FALSE.
      IF (MODE.EQ.0) RETURN
      LASTTIME = NOWTIME
      NOWTIME = PARSETIME(IPREF)
C
      IF (FIRSTCASE) THEN
C........This is the first call to this routine, or the first map for the 
C........current page, so initialize some stuff.
         FIRSTCASE = .FALSE.
C........Determine a new HEADER for the entire page.
         HEADER = ' '
         WRITE(HEADER,33) (IPREF(I),I=41,43),(IPREF(I),I=1,11),
     +      (IPREF(I),I=26,32),(IPREF(I),I=44,54)
     +      ,ZMX,MODE,VALUE,ITH
 33      FORMAT (1X,3Z1,5X,2I1,1X,3I1,1X,2I1,':',2I1,':',2I1,2X,7Z1,1X,
     +        4Z1,1X,3Z1,1X,4Z1,F7.1,' M=',I2,' V=',I4,' T=',I3,'dB')
C........Update the CTITLE for this new map.
         WRITE(CTITLE,35) (IPREF(I),I=6,11),INT(FREQ/10.),INT(RANGE)
 35      FORMAT (2I1,':',2I1,':',2I1,2I4)
C           
         IF (.NOT. LARGE) CALL PRTHEAD(PU,HEADER)
         CALL INITBMAP(ZMX,ZMRK)
         CALL INITSMAP(ZMX,ZMRK)
C........Initialize some variables for the new map.
         NSUBCASES = 0
         NSOURCES = 0
         NOFF = 0
         SUMTIME = NOWTIME
         LASTMODE = MODE
         LLARGE = LARGE
      ENDIF
C
C     Changing modes requires starting a new page.
      IF ((MODE.NE.LASTMODE).OR.(LARGE.NEQV.LLARGE).OR.
     +                                         (MODE.EQ.99)) THEN
         FIRSTCASE = .TRUE.
         LASTMODE = 0
         IF (LARGE) THEN
            WRITE(TITLE1,111) CTITLE,NSOURCES-NOFF,NSOURCES,NSUBCASES
            CALL PRTBMAP(PU,HEADER,PSRC)
            CALL INITBMAP(ZMX,ZMRK)
	      PRT = .TRUE.
 111        FORMAT (1X,A20,I4,' Sources shown out of ',I4,' from ',I3,
     +         ' Subcases.')
         ELSE
            IF (MODE.EQ.1) THEN
               WRITE(TITLE(MAP),'(A16,I3)') CTITLE(1:16),NSOURCES
            ELSE
               WRITE(TITLE(MAP),'(A8,I4,I5)') 
     +                 CTITLE(1:8),NSUBCASES,NSOURCES
            ENDIF
            CALL PRTSMAP(PU,.TRUE.)
			PRT = .TRUE.
            CALL INITSMAP(ZMX,ZMRK)
         ENDIF
C........Initialize some variables for the new map.
         NSUBCASES = 0
         NSOURCES = 0
         NOFF = 0
         SUMTIME = NOWTIME
         RETURN
      ENDIF
C
C     Use current data and MODE to determine if it is time to change maps.
C
      NEXTMAP = .FALSE.
C
      IF ((MODE.EQ.1).AND.((NUMSRC.GT.0).OR.(VALUE.NE.0))) THEN
         NEXTMAP = .TRUE.
      ELSE IF ((MODE.EQ.2).AND.(NOWTIME.NE.LASTTIME).AND.
     +   ((NSOURCES.GT.0).OR.(VALUE.NE.0))) THEN
         NEXTMAP = .TRUE.
      ELSE IF ((MODE.EQ.3).AND.((NOWTIME-LASTTIME).GT.50.).AND.
     +   (NSUBCASES.GT.VALUE*4.)) THEN
         NEXTMAP = .TRUE.
      ELSE IF ((MODE.EQ.4).AND.((NOWTIME-SUMTIME).GT.VALUE)) THEN
         NEXTMAP = .TRUE.
      ELSE IF ((MODE.EQ.5).AND.(NSUBCASES.GT.VALUE)) THEN
         NEXTMAP = .TRUE.
      ELSE IF ((MODE.EQ.6).AND.((NSOURCES).GT.VALUE)) THEN
         NEXTMAP = .TRUE.
      ENDIF
C
      IF (NEXTMAP.AND.MODE.NE.1) THEN
C........Print the current map BEFORE adding sources.
         IF (LARGE) THEN
            WRITE(TITLE1,111) CTITLE,NSOURCES-NOFF,NSOURCES,NSUBCASES
            CALL PRTBMAP(PU,HEADER,PSRC)
            PRT = .TRUE.
	      CALL INITBMAP(ZMX,ZMRK)
          ELSE
            WRITE(TITLE(MAP),'(A8,I4,I5)') 
     +             CTITLE(1:8),NSUBCASES,NSOURCES
            MAP = MAP + 1
            PRT = .TRUE.
            IF (MAP.GE.7) THEN
               MAP = 1
               ROW = ROW + 1
               IF (ROW.GE.8) THEN
C.................A new page is required, with new header
                  FIRSTCASE = .TRUE.
                  ROW = 1
                  CALL PRTSMAP(PU,.TRUE.)
                  CALL INITSMAP(ZMX,ZMRK)
               ELSE
C.................Just print the current line
                  CALL PRTSMAP(PU,.FALSE.)
	            CALL INITSMAP(ZMX,ZMRK)
               ENDIF
            ENDIF
         ENDIF
C........Initialize some variables for the new map.
         NSUBCASES = 0
         NSOURCES = 0
         NOFF = 0
         SUMTIME = NOWTIME
C        Update the CTITLE,HEADER for this new map.
         WRITE(CTITLE,35) (IPREF(I),I=6,11),INT(FREQ/10.),INT(RANGE)
         WRITE(HEADER,33) (IPREF(I),I=41,43),(IPREF(I),I=1,11),
     +                 (IPREF(I),I=26,32),(IPREF(I),I=44,54)
     +                 ,ZMX,MODE,VALUE,ITH
      ENDIF
C
C     Now, add the current sources to the current map & list of sources.
C
      IF((MODE.EQ.1).OR.((MODE.EQ.2).AND.(NOWTIME.NE.LASTTIME))) THEN
        NSUBCASES = 1
      ELSE
         NSUBCASES = NSUBCASES + 1
      ENDIF
      IF (LARGE) CALL WRITEMAPDATA(NSUBCASES)
C
      SCALE = SIND(ZMAX)/SIND(ZMX)
      DO 40 I = 1, NUMSRC
         AOK = (MAPAMP(I).GE.(MAXAMP-ITH)).OR.(ITH.EQ.0)
         IF (AOK)  THEN
            SXM = SCALE*XMAP(I)
            SYM = SCALE*YMAP(I)
            MD = MAPDOP(I)
	      IF (LARGE) THEN
               CALL ADDBSRC(SXM,SYM,NSUBCASES,MD,ONMAP)
	      ELSE
               CALL ADDSSRC(MAP,SXM,SYM,ONMAP)
	      ENDIF
         ENDIF
         IF (ONMAP.AND.AOK) THEN
            NSOURCES = NSOURCES + 1
         ELSE
            NOFF = NOFF + 1
         ENDIF
 40   CONTINUE
C
      IF ((MODE.EQ.1).AND.NEXTMAP) THEN
C........Sources have been added, print the map now.
         IF (LARGE) THEN
            WRITE(TITLE1,111) CTITLE,NSOURCES-NOFF,NSOURCES,NSUBCASES
            CALL PRTBMAP(PU,HEADER,PSRC)
            PRT = .TRUE.
            CALL INITBMAP(ZMX,ZMRK)
	      FIRSTCASE = .TRUE.
         ELSE
            WRITE(TITLE(MAP),'(A16,I3)') CTITLE(1:16),NSOURCES
            MAP = MAP + 1
            PRT = .TRUE.
            IF (MAP.GE.7) THEN
               MAP = 1
               ROW = ROW + 1
               IF (ROW.GE.8) THEN
C.................A new page is required, with new header
	            FIRSTCASE = .TRUE.
                  ROW = 1
                  CALL PRTSMAP(PU,.TRUE.)
                  CALL INITSMAP(ZMX,ZMRK)
               ELSE
C.................Just print the current line
                  CALL PRTSMAP(PU,.FALSE.)
                  CALL INITSMAP(ZMX,ZMRK)
               ENDIF
            ENDIF
         ENDIF
C........Initialize some variables for the new map.
         NSUBCASES = 0
         NSOURCES = 0
         NOFF = 0
         SUMTIME = NOWTIME
C        Update the CTITLE,HEADER for this new map.
         WRITE(CTITLE,35) (IPREF(I),I=6,11),INT(FREQ/10.),INT(RANGE)
         WRITE(HEADER,33) (IPREF(I),I=41,43),(IPREF(I),I=1,11),
     +                 (IPREF(I),I=26,32),(IPREF(I),I=44,54)
     +                 ,ZMX,MODE,VALUE,ITH
      ENDIF
      RETURN
      END
C
C   ======================================================================
C
      SUBROUTINE ADDBSRC(X,Y,I1,I2,ON)
C
C     Add a source to the BIGMAP array to the current MAP at
C     the map coordiantes (X,Y).  I1 and I2 are the two INTEGER
C         numbers to print on the map.  I1 should be in the range of
C     1 to 26.  The sign of I2 is printed in front of I1.
C
C     Example:      +A   is printed if I1=1 and I2=15.  This means that
C                   15   this point is from subcase #1 and is from Doppler
C                        line +15.
C
C      IMPLICIT NONE
      INTEGER I1,I2,IX,IY,IROUND
      REAL X,Y
      LOGICAL ON
      CHARACTER*2 CJ
      CHARACTER*1 SIGN
C
C     Variables for the COMMON blocks.
C
C     For /BMAP/
      CHARACTER*1 BIGMAP(-41:44,-41:44)
      CHARACTER*120 TITLE1
      COMMON/BMAP/ BIGMAP,TITLE1
C
      ON = .TRUE.
      IF ((ABS(X).GT.20).OR.(ABS(Y).GT.20)) THEN
         ON = .FALSE.
         RETURN
      ENDIF
      IX = IROUND(2*X)
      IY = IROUND(2*Y)
      SIGN = '+'
      IF (I2.LT.0) SIGN = '-'
      BIGMAP(IX,IY) = SIGN
	IF (I1.GT.60) THEN
         BIGMAP(IX,IY-1) = '*'
	ELSE
         BIGMAP(IX,IY-1) = CHAR(64+I1)
	ENDIF
      WRITE(CJ,99) ABS(I2)
      BIGMAP(IX-1,IY) = CJ(1:1)
      BIGMAP(IX-1,IY-1) = CJ(2:2)
 98   FORMAT (A1,I1)
 99   FORMAT (I2)
C
      RETURN
      END
C
C  ===================================================================
C
      SUBROUTINE PRTBMAP(PUNIT,HEADER,PRTSOURCE)
C
C     Print out the BIGMAP image, with blank space on the left.
C     Output is to the previously opened unit PUNIT
C
C      IMPLICIT NONE
      CHARACTER*80 HEADER
      LOGICAL PRTSOURCE
      INTEGER I,IX,IY,PUNIT,NLMAX
C
C     Variables for the COMMON blocks.
C
C     For /BMAP/
      CHARACTER*1 BIGMAP(-41:44,-41:44)
      CHARACTER*120 TITLE1
      COMMON/BMAP/ BIGMAP,TITLE1

C     For /SOURCES/
      CHARACTER*135 SLINE(300)
      INTEGER NLINES
      COMMON/SOURCES/ NLINES,SLINE
C
C......NLMAX is the maximum number of source lines that can be printed
C......on the same page as the SKYMAP.
	NLMAX = 16
C
C     Print the HEADER out to PUNIT
C
COKI  8 LPI, 10 CPI.
      WRITE(PUNIT,101) CHAR(30),CHAR(27),CHAR(56),CHAR(27),CHAR(45),
     +                 'S K Y M A P'
CEPS  8/72" Line Spacing, 10 CPI
CEPS      WRITE(PUNIT,101) CHAR(18),CHAR(27),CHAR(80),CHAR(27),
CEPS     + CHAR(65),CHAR(8),'S K Y M A P'
 101  FORMAT (1X,5A1,35X,A)
	WRITE(PUNIT,*) ' '
      WRITE(PUNIT,'(5X,2A)')'Station   Date  Time (UT) OUTPUT',
     +              '  XLZT NRW HEIG   Zmax'
      WRITE(PUNIT,'(5X,A75)') HEADER
C
COKI  12 CPI, 13/144" Line spacing
      WRITE(PUNIT,87) CHAR(28),CHAR(27),CHAR(37),CHAR(57),CHAR(13)
C
CEPS  12 CPI, 6/72" Line Spacing
CEPS      WRITE(PUNIT,87) CHAR(27),CHAR(77),CHAR(27),CHAR(65),CHAR(6)
 87   FORMAT (1X,6A1)
C
      DO 10 IX = 43,-40,-1
         WRITE(PUNIT,77) (BIGMAP(IX,IY),IY=43,-40,-1)
 10   CONTINUE
C
 77   FORMAT (5X,86A1)
C
COKI  17 CPI, 15/144" Line spacing.
CEPS  17 CPI, 7/72" Line Spacing
	WRITE(PUNIT,*) ' '
CEPS     WRITE(PUNIT,87) CHAR(27),CHAR(15),CHAR(27),CHAR(65),CHAR(7),TITLE1
      WRITE(PUNIT,88) TITLE1,CHAR(29),CHAR(27),CHAR(37),
     +                CHAR(57),CHAR(15)
      IF(PRTSOURCE) THEN
C........Formfeed if too many source lines for the current page.
	   IF (NLINES.GT.NLMAX) THEN
	      WRITE(PUNIT,87) CHAR(12)
CEPS........WRITE(PUNIT,87) CHAR(27),CHAR(15),CHAR(27),CHAR(65),CHAR(7),TITLE1
            WRITE(PUNIT,88) TITLE1,CHAR(29),CHAR(27),CHAR(37),
     +                      CHAR(57),CHAR(15)
	   ENDIF
         DO 83 I = 1, NLINES-1
            WRITE(PUNIT,89) SLINE(I)
 83      CONTINUE
         NLINES = 1
      ENDIF
C.....Formfeed
      WRITE(PUNIT,87) CHAR(12)
 88   FORMAT(5X,A90,5A1)
 89   FORMAT(1X,A120)
      RETURN
      END
C
C  ===================================================================
C
      SUBROUTINE INITBMAP(ZMAX,ZMARK)
C
C     Initializes the BIGMAP print array with borders and scale tick marks
C         every ZMARK degrees.
C
C      IMPLICIT NONE
      INTEGER IX,IY,IROUND
      REAL ZMAX,ZMARK,STEP,X,SIND
      CHARACTER*2 CJ
C
C     Variables for the COMMON blocks.
C
C     For /BMAP/
      CHARACTER*1 BIGMAP(-41:44,-41:44)
      CHARACTER*120 TITLE1
      COMMON/BMAP/ BIGMAP,TITLE1
C
      STEP = 40.0/ZMAX
C
      DO 10 IX = -41,44
         DO 10 IY = -41, 44
            BIGMAP(IX,IY) = ' '
 10   CONTINUE
C
      TITLE1 = ' '
C
C.....Insert the left and rightmost borders and the center line.
      DO 20 IX = -40,40
            BIGMAP(IX,40) = '|'
            BIGMAP(IX,-40) = '|'
            BIGMAP(IX,0) = '|'
 20   CONTINUE
C.....Top and bottom borders and center line.
      DO 30 IY = -40, 40
         BIGMAP(40,IY) = '-'
         BIGMAP(-40,IY) = '-'
         BIGMAP(0,IY) = '-'
 30   CONTINUE
C.....Corners and center dot.
      BIGMAP(40,40) = '+'
      BIGMAP(40,-40) = '+'
      BIGMAP(-40,40) = '+'
      BIGMAP(-40,-40) = '+'
      BIGMAP(0,0) = '+'
      BIGMAP(0,40) = '+'
      BIGMAP(0,-40) = '+'
      BIGMAP(40,0) = '+'
      BIGMAP(-40,0) = '+'
C.....Place the tick marks and the scale.
      BIGMAP( 0,43) = '0'
      BIGMAP( 3,41) = 'W'
      BIGMAP( 1,41) = 'E'
      BIGMAP(-1,41) = 'S'
      BIGMAP(-3,41) = 'T'
      BIGMAP(41, 2) = 'N'
      BIGMAP(41, 1) = 'O'
      BIGMAP(41, 0) = 'R'
      BIGMAP(41,-1) = 'T'
      BIGMAP(41,-2) = 'H'
      BIGMAP(43,0) = '0'
C
      DO 40 X = ZMARK, ZMAX, ZMARK
         IX = IROUND(40.0*SIND(X)/SIND(ZMAX))
         WRITE(CJ,'(I2)') IROUND(X)
         BIGMAP(IX,0) = '+'
         BIGMAP(IX,40) = '+'
         BIGMAP(IX,-40) = '+'
         BIGMAP(IX,41) = CJ(2:2)
         BIGMAP(IX,42) = CJ(1:1)
         BIGMAP(IX,43) = '+'
         BIGMAP(-IX,0) = '+'
         BIGMAP(-IX,40) = '+'
         BIGMAP(-IX,-40) = '+'
         BIGMAP(-IX,41) = CJ(2:2)
         BIGMAP(-IX,42) = CJ(1:1)
         BIGMAP(-IX,43) = '-'
	   IY = IX
         BIGMAP(0,IY) = '+'
         BIGMAP(40,IY) = '+'
         BIGMAP(-40,IY) = '+'
         BIGMAP(41,IY) = CJ(2:2)
         BIGMAP(42,IY) = CJ(1:1)
         BIGMAP(43,IY) = '+'
         BIGMAP(0,-IY) = '+'
         BIGMAP(40,-IY) = '+'
         BIGMAP(-40,-IY) = '+'
         BIGMAP(41,-IY) = CJ(2:2)
         BIGMAP(42,-IY) = CJ(1:1)
         BIGMAP(43,-IY) = '-'
 40   CONTINUE
      RETURN
      END
C
C   ======================================================================
C
      SUBROUTINE ADDSSRC(MAP,X,Y,ON)
C
C     Add a source to the BITMAP array in the specified MAP (1-7) at
C     the map coordiantes (X,Y).
C
C      IMPLICIT NONE
      INTEGER MAP,YBYTE,XBYTE,XBIT,PBYTE,IEXP,IX,IY,IOR
      REAL X,Y
      LOGICAL ON
C
C     Variables for the COMMON blocks.
C
C     For /SMAP/
      INTEGER*2 BITMAP(499,11)
      CHARACTER*20 TITLE(6)
      COMMON/SMAP/ BITMAP,TITLE
C
      ON = .TRUE.
      IF ((MAP.LT.1).OR.(MAP.GT.6)) THEN
         WRITE(*,*) 'ADDSOURCE -- Invalid map number ',MAP
         ON = .FALSE.
         RETURN
      ENDIF
      IF ((ABS(X).GT.20).OR.(ABS(Y).GT.20)) THEN
         ON = .FALSE.
         RETURN
      ENDIF
      YBYTE = 81*(MAP-1) + INT(41 - 2.0*Y)
      XBIT  = INT(41 - 2.0*X)
C
      DO 10 IY = 0, 1
         DO 10 IX = 0, 1
            XBYTE = (XBIT + IX)/8 + 1
            IEXP = 7 - MOD(XBIT+IX,8)
            PBYTE = BITMAP(YBYTE+IY, XBYTE)
            BITMAP(YBYTE+IY,XBYTE) = IOR(PBYTE,2**IEXP)
 10   CONTINUE
      RETURN
      END
C
C  ===================================================================
C
      SUBROUTINE PRTSMAP(PU,FF)
C
C     Initialize the (Okidata 192) Epson FX-85 printer and print
C     the BITMAP image, with 51 pixels of blank space on the left for
C     a total of 550 pixels/line.  Line spacing set to (15/144") 8/72" 
C     Resulting print density is 72x72 DPI.
C     Output is to the previously opened unit PU
C
C     NOTE:  Okidata printer must have the byte to be printed INVERTed as the
C     print head firing sequence is upside down from that of the Epson.
C
C      IMPLICIT NONE
      CHARACTER*12 STARTGRAPH,STOPGRAPH
      LOGICAL FF
      INTEGER I,J,PU
	INTEGER INVERT
C
C     Variables for the COMMON blocks.
C
C     For /SMAP/
      INTEGER*2 BITMAP(499,11)
      CHARACTER*20 TITLE(6)
      COMMON/SMAP/ BITMAP,TITLE
C
CEPS      STARTGRAPH = CHAR(27)//CHAR(65)//CHAR(8)//
CEPS     +    CHAR(27)//CHAR(42)//CHAR(5)//CHAR(38)//CHAR(2)
CEPS      STOPGRAPH = CHAR(0)
      STARTGRAPH = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(15)//
     +   CHAR(27)//CHAR(42)//CHAR(102)//CHAR(80)//CHAR(58)//CHAR(3)
      STOPGRAPH = CHAR(3)//CHAR(2)
      WRITE(PU,99) (STARTGRAPH,(CHAR(0),I=1,51),
     +       (CHAR(INVERT(BITMAP(I,J))),I=1,499),STOPGRAPH,J=1,11)
 99   FORMAT (1X,A10,550A1,A2)
C
CEPS      WRITE(PU,99) (STARTGRAPH,(CHAR(0),I=1,51),
CEPS     +             (CHAR(BITMAP(I,J)),I=1,499),
CEPS     +              STOPGRAPH,J=1,11)
CEPS 99   FORMAT (1X,A8,550A1,A1)
C
C     Print the 6 TITLEs in 17 CPI mode.
      WRITE(PU,88) CHAR(29),(TITLE(I),I=1,6)
  88  FORMAT(1X,A1,11X,6A20/)
CEPS      WRITE(PU,88) CHAR(27),CHAR(15),CHAR(27),CHAR(50),
CEPS     +             (TITLE(I),I=1,6)
CEPS 88   FORMAT(1X,4A1,12X,6A20)
      IF (FF) WRITE(PU,'(1X,A1)') CHAR(12)
      RETURN
      END
C
C  ===================================================================
C
      SUBROUTINE PRTHEAD(PU,HEADER)
C
C      IMPLICIT NONE
      INTEGER PU
      CHARACTER*80 HEADER
C
C     Prints the HEADER out to PU (in 12 CPI)
C     Set the Okidata printer to unidirectional printing, 17/144"
C     Set the Epson printer to unidirectional printing, 8/72"
C
	WRITE(PU,5) CHAR(28),CHAR(27),CHAR(37),CHAR(57),CHAR(17),
     +      CHAR(27),CHAR(45)
CEPS      WRITE(PU,5) CHAR(27),CHAR(77),CHAR(27),CHAR(48)
 5    FORMAT (1X,8A1)
      WRITE(PU,'(1X,35X,A/)') 'SKYMAP SURVEY'
      WRITE(PU,'(1X,10X,2A)')'Station   Date  Time (UT) OUTPUT',
     +              '  XLZT NRW HEIG   Zmax'
      WRITE(PU,'(1X,10X,A80/)') HEADER
      RETURN
      END

C  ===================================================================
C
      SUBROUTINE INITSMAP(ZMAX,ZMARK)
C
C     Initializes the BITMAP print array with borders and scale tick
C     marks for the 7 maps across the page.
C     One map is initialized, then copied 6 times.
C
C      IMPLICIT NONE
      INTEGER I,J,K,IX,IROUND
	REAL ZMAX,ZMARK,X,SIND
C
C     Variables for the COMMON blocks.
C
C     For /SMAP/
      INTEGER*2 BITMAP(499,11)
      CHARACTER*20 TITLE(6)
C
C     COMMON Blockings
      COMMON/SMAP/ BITMAP,TITLE
C
      DO 10 I = 1, 499
         DO 10 J = 1, 11
            BITMAP(I,J) = 0
 10   CONTINUE
C
      DO 15 I = 1, 6
         TITLE(I) = ' '
 15   CONTINUE
C.....Insert the left and rightmost borders.
      DO 20 J = 1, 10
         BITMAP(1,J) = 255
         BITMAP(82,J) = 255
 20   CONTINUE
      BITMAP(1,11) = 240
      BITMAP(82,11) = 240
C.....Top and bottom borders
      DO 30 I = 2, 81
         BITMAP(I,1) = 128
         BITMAP(I,11) = 16
 30   CONTINUE
C
C
C.....Place the small scale marks.
	DO 35 X = -ZMAX+ZMARK,ZMAX-ZMARK,ZMARK
	   IX = IROUND(40.0*SIND(X)/SIND(ZMAX))
C........Top scale
         BITMAP(42+IX, 1) = 224
C........Bottom scale
         BITMAP(42+IX,11) = 112
         J = (42+IX)/8 + 1
         I = 2**(7 - MOD((42+IX),8))
C........Left scale.
	   BITMAP(2,J) = IOR(BITMAP(2,J),I)
	   BITMAP(3,J) = IOR(BITMAP(3,J),I)
C........Right scale.
	   BITMAP(80,J) = IOR(BITMAP(80,J),I)
	   BITMAP(81,J) = IOR(BITMAP(81,J),I)
 35	CONTINUE
C
C.....Place the Zero scale marks.
C.....Top
	BITMAP(42, 1) = 255
C.....Bottom
	BITMAP(42,10) = 15
	BITMAP(42,11) = 240
	DO 25 I = 1, 6
C........Left
	   BITMAP(I+3,6) = 32
C........Right
	   BITMAP(I+73,6) = 32
 25	CONTINUE
C
C     One map is now complete; copy it to the other 5 locations
C
      DO 40 I = 2, 82
         DO 40 J = 1, 11
            DO 40 K = 1, 5
               BITMAP(81*K+I,J) = BITMAP(I,J)
 40   CONTINUE
      RETURN
      END
C
C  ====================================================================== 

      REAL FUNCTION SIND(X)
      REAL X
      SIND = SIN(0.01745329*X)
      RETURN
      END

C   ===================================================================
C
      REAL*8 FUNCTION PARSETIME(TIME)
C            This function takes an integer array of 11 values and
C         calculates the approximate number of seconds since January, 1900.
C         These values are for comparison purposes only, as they do not take
C         leap years, etc into consideration.  Will also fail past the year
C         2000 as far as I can tell.
C
C      IMPLICIT NONE
      INTEGER*2 TIME(11)
C.........Seconds per year
      PARSETIME = 3153600.*(10*TIME(1)+ TIME(2))
C.........Seconds per day
      PARSETIME = PARSETIME + 86400.*(100*TIME(3)+10*TIME(4)+TIME(5))
C.........Seconds per hour
      PARSETIME = PARSETIME + 3600.*(10*TIME(6) + TIME(7))
C.........Seconds per minute
      PARSETIME = PARSETIME + 60.*(10*TIME(8) + TIME(9))
C.........And finally the seconds
      PARSETIME = PARSETIME + 10.*TIME(10) +1.*TIME(11)
      RETURN
         END
C
C ========================================================================
C
      INTEGER FUNCTION IROUND(VALUE)
C
      REAL VALUE
      IF (VALUE.GE.0) THEN
         IROUND = INT(VALUE + 0.501)
      ELSE
         IROUND = INT(VALUE - 0.501)
      ENDIF
      RETURN
      END
C
C  ======================================================================
C
      SUBROUTINE READMAPDATA(INFILE,EOF)
C
C===== READ THE MAP DATA FROM A FILE <infile> FOR LATER USE IN PRINTING
C      SKYMAPS OR CALCULATING DRIFT VELOCITIES.  FREQUENCY READ IS
C          <IFF>  THE FORMAT OF THE PREFACE IS AS FOLLOWS:
C
C=======================================================================
C CODE RELEVANT PREFACE CHARACTERS (DECIMAL UNLESS SPECIFIED OTHERWISE)
C    INTO ARRAY MAPREF:
C  POSITION ! FORMAT  !  INFORMATION
C_______________________________________________________________
C  1        ! A1      !  SPACE                                  !
C  2-4      ! 3Z1     !  STATION ID CODE                        !
C  5-9      ! I5      !  RECORD NO.                             !
C  10       ! A1      !  SPACE                                  !
C  11-15    ! 5Z1     !  DATE                                   !
C  16       ! A1      !  SPACE                                  !
C  17-22    ! 6Z1     !  TIME                                   !
C  23       ! 1X      !  SPACE                                  !
C  24       ! Z1      !  PROGRAM SET                            !
C  25       ! Z1      !  PROGRAM TYPE                           !
C  26-31    ! 6Z1     !  JOURNAL (6 HEX DIGITS)                 !
C  32-38    ! 7Z1     !  P1 TO P7 (7 HEX DIGITS)                !
C  39       ! 1X      !  SPACE                                  !
C  40-46    ! 7Z1     !  XLZTNRW (7 HEX DIGITS)                 !
C  47-53    ! 7Z1     !  K(I*)(G*)HEIG (7 HEX DIGITS)           !
C  54-57    ! I4      !  ZMAX (10THS OF A DEGREE)               !
C  58-59    ! I2      !  NFREQ=FREQUENCY NUMBER                 !
C  60-66    ! I7      !  FREQ(NFREQ), IN 100-HZ UNITS           !
C  67-71    ! I5      !  RANG(NFREQ), IN 100-METER UNITS        !
C  72-74    ! I3      !  IGAIN(NFREQ), IN DB                    !
C  75-77    ! I3      !  MPAMP(NFREQ)                           !
C  78-80    ! I3      !  MAXAMP(NFREQ)                          !
C  81-84    ! I4      !  NO. OF SOURCES FOR NFREQ               !
C  85-87    ! I3      !  KTH, CASE SELECTION THRESHOLD          !
C  88-90    ! I3      !  LTH, SPECTRAL LINE SELECTION THRESHOLD ! 
C================================================================
C
      INTEGER INFILE,I,I1,I2,IRNG,IFRQ,IZMAX,IERR
      CHARACTER*2 JUNK
      LOGICAL EOF
C
C         VARIABLES FOR THE COMMON BLOCKS
C
C     For /INDATA/
      INTEGER*2 NMAP,IFF,GAIN,MPAMP,MAXAMP,NUMSRC,IPREF(89),
     +        MAPAMP(256), MAPDOP(256),MAPRMS(256),KTH,LTH
      REAL FREQ,RANGE,YMAP(256),XMAP(256),ZMAX
C
C     Common Blockings
      COMMON/INDATA/ NMAP,IFF,IPREF,FREQ,RANGE,GAIN,MPAMP,MAXAMP,
     +     ZMAX,NUMSRC,YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS,KTH,LTH
C
C
      DO 10 I =1, 89
 10   IPREF(I) = 0
      DO 20 I=1,256
         XMAP(I) = 0.0
         YMAP(I) = 0.0
         MAPAMP(I) = 0
         MAPRMS(I) = 0
 20   CONTINUE
      EOF = .FALSE.
C
	READ(INFILE,110,END=99,ERR=901,IOSTAT=IERR)
     +  (IPREF(I),I=41,43),NMAP,(IPREF(I),I=1,19),
     +  (IPREF(I),I=26,32), (IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC,KTH,LTH
C
 110	FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +        I4,I2,I7,I5,4I3,I4,2I3) 

      RANGE = FLOAT(IRNG)/10.
      FREQ =  FLOAT(IFRQ)/10.
      ZMAX =  FLOAT(IZMAX)/10.
C
      DO 140 I1=1,NUMSRC,26
         I2=I1+25
         IF(I2.GT.NUMSRC) I2=NUMSRC
	   READ(INFILE,151,ERR=902) JUNK,(YMAP(I),I=I1,I2) 
	   READ(INFILE,151,ERR=902) JUNK,(XMAP(I),I=I1,I2) 
	   READ(INFILE,150,ERR=902) JUNK,(MAPAMP(I),I=I1,I2)
	   READ(INFILE,150,ERR=902) JUNK,(MAPDOP(I),I=I1,I2) 
	   READ(INFILE,150,ERR=902) JUNK,(MAPRMS(I),I=I1,I2) 
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C
      RETURN
C     End of File condition.
 99   EOF = .TRUE.
      NUMSRC = 0
      RETURN

 901	WRITE(*,101)' Error #',IERR, ' reading the SKYMAP data header.'
	NUMSRC = 0
	EOF = .FALSE.
	RETURN
 101	FORMAT (A,I5,A)

 902	WRITE(*,*) ' Error reading the SKYMAP source locations.'
	NUMSRC = 0
	EOF = .FALSE.
C
      END
C
C  ======================================================================
C
      SUBROUTINE WRITEMAPDATA(ICASE)
C
C===== WRITE THE MAP DATA TO AN ARRAY SLINE
C         SEE READMAPDATA FOR MORE INFO. ON THE FORMAT.
C
      INTEGER I,I1,I2,IRNG,IFRQ,IZMAX,ICASE
C
C         VARIABLES FOR THE COMMON BLOCKS
C
C     For /INDATA/
      INTEGER*2 NMAP,IFF,GAIN,MPAMP,MAXAMP,NUMSRC,IPREF(89),
     +        MAPAMP(256), MAPDOP(256),MAPRMS(256),KTH,LTH
      REAL FREQ,RANGE,YMAP(256),XMAP(256),ZMAX
      COMMON/INDATA/ NMAP,IFF,IPREF,FREQ,RANGE,GAIN,MPAMP,MAXAMP,
     +     ZMAX,NUMSRC,YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS,KTH,LTH
C     For /SOURCES/
      CHARACTER*135 SLINE(300)
      INTEGER NLINES
      COMMON/SOURCES/ NLINES,SLINE

C
	IF (NLINES.GT.300-6) RETURN
C
      IRNG = INT(10.*RANGE)
      IFRQ = INT(10.*FREQ)
      IZMAX = INT(10.*ZMAX)
      WRITE(SLINE(NLINES),110) CHAR(ICASE+64),(IPREF(I),I=41,43),
     +  NMAP,(IPREF(I),I=1,19),(IPREF(I),I=26,32),(IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC,KTH,LTH
	NLINES = NLINES + 1
C
 110  FORMAT (1X,A1,' - '3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +        I4,I2,I7,I5,4I3,I4,2I3)
      DO 140 I1=1,NUMSRC,26
         I2=I1+25
         IF(I2.GT.NUMSRC) I2 = NUMSRC
         WRITE(SLINE(NLINES+0),151) '  Y ',(YMAP(I),I=I1,I2)
         WRITE(SLINE(NLINES+1),151) '  X ',(XMAP(I),I=I1,I2)
         WRITE(SLINE(NLINES+2),150) '  PD',(MAPAMP(I),I=I1,I2)
         WRITE(SLINE(NLINES+3),150) '  DO',(MAPDOP(I),I=I1,I2)
         WRITE(SLINE(NLINES+4),150) '  ER',(MAPRMS(I),I=I1,I2)
         NLINES = NLINES + 5
  140 CONTINUE
  150 FORMAT(1X,A4,26I5)
  151 FORMAT(1X,A4,26F5.1)
      RETURN
      END
C
C  ========================================================================
C
	INTEGER FUNCTION INVERT(BYTE)
C
C     Exchanges the bits in the value BYTE.  Necessary for the printing
C     on both Epson and Okidata printers from the same BITMAP because of
C     differing print head logic.  Also looks for a resulting value of
C     3, which is an Okidata printer graphics command preface character,
C     the passing of which to the printer would screw up the output.
C     The value of 3 is changed to a 6, which moves the source down 1 dot.
C
	INTEGER*2 BYTE,I
C
	INVERT = 0
	DO 10 I = 0, 7
	   INVERT = IOR(INVERT,ISHFT(IAND(BYTE,2**I), 7-2*I))
 10	CONTINUE
	IF (INVERT.EQ.3) INVERT = 6
	RETURN
	END
C
C  ====================================================================
C      INTEGER FUNCTION IOR(A,B)
C      INTEGER A,B
C      IOR = A.OR.B
C      RETURN
C      END
C
C      INTEGER FUNCTION IAND(A,B)
C      INTEGER A,B
C      IAND = A.AND.B
C      RETURN
C      END
C  ====================================================================== 
