$NOTRUNCATE
$DECLARE
$DEBUG
C 
C  =======================================================================
C
	SUBROUTINE PRINTSTATS(STATION,PU,ISTAT,TTIME,GOOD )
C
C	This routine controls the initialization, accumulation and printing
C	of the statistical data tests performed on the drift data.
C	  This routine is directly responsible for the following values:
C	     NBAD
C	  The routine PREPDAT takes care of:
C	     KAMP(), KPHAS()
C	  The routine SCRLOC takes care of the following:
C	     NREJ(),NQUAL(),NACPT(),NTOSS(),NOUT(),NSRCS(),KPDIF(,),KERR(,)
C	     KRMS()
C
C	PU is the Printer Unit number, which must be open.
C
C	Variable ISTAT determines what data is to be output.
C	   1)   Raw Probability Distribution Function dump
C	   2)   Cleaned PDF dump (1 distribution/132 character line)
C	   3)   Data moment sumary (Mean, std. dev., median, etc.)
c	   4)   Signal and noise Means and Std. devs. for all antennas.
C
C   The variable SSTS(25,10) contain the moment sumaries.  The first index
C	indicates the variable summarized, the second the statistic measure.
C	   (1,  )   -  All Amplitudes
C	   (2,  )   -  All Phases 
C        (4,  )   -  Antenna #1 Peak Amplitude
C        (5,  )   -  Antenna #2 Peak Amplitude
C        (6,  )   -  Antenna #3 Peak Amplitude
C        (7,  )   -  Antenna #4 Peak Amplitude
C        (8,  )   -  Antenna #5 Peak Amplitude
C        (9,  )   -  Antenna #6 Peak Amplitude
C       (10,  )   -  Antenna #7 Peak Amplitude
C       (11,  )   -  Antenna #1 Most Probable Amplitude
C       (12,  )   -  Antenna #2 Most Probable Amplitude
C       (13,  )   -  Antenna #3 Most Probable Amplitude
C       (14,  )   -  Antenna #4 Most Probable Amplitude
C       (15,  )   -  Antenna #5 Most Probable Amplitude
C       (16,  )   -  Antenna #6 Most Probable Amplitude
C       (17,  )   -  Antenna #7 Most Probable Amplitude
C       (18,  )   -  RMS Errors
C       (19,  )   -  p2+p3+p4-3p1
C       (20,  )   -  p5+p6+p7-3p1
C       (21,  )   -  (p1-p2)+(p4-p7)
C       (22,  )   -  (p1-p3)+(p2-p5)
C       (23,  )   -  (p1-p4)+(p3-p6)
C       (24,  )   -  (p2+p3+p4)-(p5+p6+p7)
C   --------------------------------------------------
C	     , 1)   -  Mean
C	     , 2)   -  Average Deviation
C	     , 3)   -  Standard Deviation
C	     , 4)   -  Variance
C	     , 5)   -  Skewness
C	     , 6)   -  Kurtosis
C	     , 7)   -  Median
C          , 8)   -  Most Probable
C   , 9) - ,10)   -  For future use  

C
	INTEGER ISTAT,I,I1,I2,I3,J,JJ,K,PU,PDF(361),INDX(7),JC,MPA,
     +        NP,NA,NM,IROUND,MEDIAN
	REAL TTIME,AVE,VAR,SDEV,ADEV,SKEW,CURT,A(7,7),
     +     PERR(35,7),X(7),PEQS(7,7),D,VALS(35),TINY,XMEDIAN,PF,
     +     SSTS(25,10)
	REAL*8 LSTATTIME
	LOGICAL GOOD
	CHARACTER*30 PHILABEL(6),LABEL
	CHARACTER*20 STATION
	CHARACTER*15 LCTIME
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /TIME/
	REAL*8 ENDTIME,LASTTIME,STARTTIME,NOWTIME
	CHARACTER*15 CTIME
C     For /STATS/
	INTEGER NREJ(4),NQUAL(4),NACPT(4),NTOSS(4),NOUT(4),NSRCS(4),
     +        NBAD,KAMP(0:63),KMAX(7,0:63),KMPA(7,0:63),KPHAS(0:359),
     +        KRMS(0:359),KPDIF(-180:180,6),KERR(21,-100:100)
C
C	   	COMMON BLOCKINGS
	COMMON/TIME/ STARTTIME,ENDTIME,NOWTIME,CTIME,LASTTIME
      COMMON/STATS/ NREJ,NQUAL,NACPT,NTOSS,NOUT,NSRCS,NBAD,KAMP,
     +	   	      KMAX,KMPA,KRMS,KPHAS,KPDIF,KERR
C
C
	DATA LSTATTIME / 0.0/
	DATA TINY /1.0E-20/
	DATA PHILABEL /'p2+p3+p4-3p1','p5+p6+p7-3p1','(p1-p2)+(p4-p7)',
     +   '(p1-p3)+(p2-p5)','(p1-p4)+(p3-p6)','(p2+p3+p4)-(p5+p6+p7)'/
	DATA (PEQS(1,I),I=1,7) /-3, 1, 1, 1, 0, 0, 0/
	DATA (PEQS(2,I),I=1,7) /-3, 0, 0, 0, 1, 1, 1/
	DATA (PEQS(3,I),I=1,7) / 1,-1, 0, 1, 0, 0,-1/
	DATA (PEQS(4,I),I=1,7) / 1, 0, 1,-1, 0,-1, 0/
	DATA (PEQS(5,I),I=1,7) / 0, 0, 0, 0, 0, 0, 0/
	DATA (PEQS(6,I),I=1,7) / 0, 0, 0, 0, 0, 0, 0/
	DATA (PEQS(7,I),I=1,7) / 0, 0, 0, 0, 0, 0, 0/
	

C
	IF (LSTATTIME.EQ.0) THEN
C	   First time the routine is called, initialize.
	   LSTATTIME = NOWTIME
	   LCTIME = CTIME
	ENDIF
C
	IF(.NOT.GOOD) NBAD = NBAD + 1
C
C   Is it time to print or initialize?
	IF ((NOWTIME-LSTATTIME).LT.TTIME) RETURN
	PF = FLOAT(NSRCS(1)+NSRCS(2)+NSRCS(3)+NSRCS(4))
	PF = 100.0/MAX(PF,1.0)
	NA = 0
	NM = 0
	DO 3 I = 0,63
	   NM = NM + KMAX(1,I)
 3	NA = NA + KAMP(I)
	NP = 0
	DO 4 I = 0,359
 4	NP = NP + KPHAS(I)
	NA = MAX(NA,1)
	NM = MAX(NM,1)
	NP = MAX(NP,1)

 18	FORMAT(1X,A,17I4,18I3,I4) 
 19	FORMAT (1X,7A7)
 20	FORMAT (1X,7I7)
 21	FORMAT(1X,A,36I3) 
 22	FORMAT(1X,I4,'-',I4,2X,36I3) 
 23	FORMAT(1X,A,9I4,27I3) 
 24	FORMAT (1X,'Ant#',I1,A,36I3)
 99	FORMAT (' Statistics for ',A, ' from ', A,' to ',A,' --> ',A)

C
C	Calculate moments for possible future use.
C
C     Amplitude distribution
      CALL PDFMOMENT(KAMP,0.0,63.0,64,AVE,ADEV,SDEV,VAR,SKEW,CURT)
      CALL PDFMEDIAN(KAMP,64,MEDIAN,MPA)
      MEDIAN = MEDIAN - 1
      MPA = MPA - 1
      SSTS(1,1) = AVE
      SSTS(1,2) = ADEV
      SSTS(1,3) = SDEV
      SSTS(1,4) = VAR
      SSTS(1,5) = SKEW
      SSTS(1,6) = CURT
      SSTS(1,7) = MEDIAN
      SSTS(1,8) = MPA
C       Phase distribution.
      CALL PDFMOMENT(KPHAS,0.0,359.0, 360,AVE,ADEV,SDEV,VAR,
     +                SKEW,CURT)
	CALL PDFMEDIAN(KPHAS,360,MEDIAN,MPA)
	MEDIAN = MEDIAN - 1
	MPA = MPA - 1
	SSTS(2,1) = AVE
	SSTS(2,2) = ADEV
	SSTS(2,3) = SDEV
	SSTS(2,4) = VAR
	SSTS(2,5) = SKEW
	SSTS(2,6) = CURT
	SSTS(2,7) = MEDIAN
	SSTS(2,8) = MPA
C	
C	 Maximum Amplitudes
	DO 86 I = 1, 7
	   DO 49 K = 0,63
	      PDF(K+1) = KMAX(I,K)
 49	   CONTINUE
	   CALL PDFMOMENT(PDF,0.0,63.0,64,AVE,ADEV,SDEV,VAR,
     +               SKEW,CURT)
	   CALL PDFMEDIAN(PDF,64,MEDIAN,MPA)
	   MEDIAN = MEDIAN - 1
	   MPA = MPA - 1
	   SSTS(I+2,1) = AVE
	   SSTS(I+2,2) = ADEV
	   SSTS(I+2,3) = SDEV
	   SSTS(I+2,4) = VAR
	   SSTS(I+2,5) = SKEW
	   SSTS(I+2,6) = CURT
	   SSTS(I+2,7) = MEDIAN
	   SSTS(I+2,8) = MPA
 86	CONTINUE
C
C	Most Probable Amplitudes
	DO 87 I = 1, 7
	   DO 50 K = 0,63
	      PDF(K+1) = KMPA(I,K)
 50	   CONTINUE
	   CALL PDFMOMENT(PDF,0.0,63.0,64,AVE,ADEV,SDEV,VAR,
     +               SKEW,CURT)
	   CALL PDFMEDIAN(PDF,64,MEDIAN,MPA)
	   MEDIAN = MEDIAN - 1
	   MPA = MPA - 1
	   SSTS(I+10,1) = AVE
	   SSTS(I+10,2) = ADEV
	   SSTS(I+10,3) = SDEV
	   SSTS(I+10,4) = VAR
	   SSTS(I+10,5) = SKEW
	   SSTS(I+10,6) = CURT
	   SSTS(I+10,7) = MEDIAN
	   SSTS(I+10,8) = MPA
 87	CONTINUE
C	
c	RMS distribution.
	CALL PDFMOMENT(KRMS,0.0,359.0, 360,AVE,ADEV,SDEV,VAR,
     +               SKEW,CURT)
	CALL PDFMEDIAN(KRMS,360,MEDIAN,MPA)
	MEDIAN = MEDIAN - 1
	MPA = MPA - 1
	SSTS(18,1) = AVE
	SSTS(18,2) = ADEV
	SSTS(18,3) = SDEV
	SSTS(18,4) = VAR
	SSTS(18,5) = SKEW
	SSTS(18,6) = CURT
	SSTS(18,7) = MEDIAN
	SSTS(18,8) = MPA
C
C	Phase difference distributions
	DO 66 I = 1, 6
	   DO 45 K = -180,180
	      PDF(K+181) = KPDIF(K,I)
 45	   CONTINUE
	   CALL PDFMOMENT(PDF,-180.,180.,361,AVE,ADEV,SDEV,VAR,
     +               SKEW,CURT)
	   CALL PDFMEDIAN(PDF,361,MEDIAN,MPA)
	   MEDIAN = MEDIAN - 181
	   MPA = MPA - 181
	   SSTS(I+18,1) = AVE
	   SSTS(I+18,2) = ADEV
	   SSTS(I+18,3) = SDEV
	   SSTS(I+18,4) = VAR
	   SSTS(I+18,5) = SKEW
	   SSTS(I+18,6) = CURT
	   SSTS(I+18,7) = MEDIAN
	   SSTS(I+18,8) = MPA
 66	CONTINUE
C
C		Select the desired output based on the value if ISTAT.
C
C	Select the raw statistic data printout.
	IF (ISTAT.EQ.1) THEN
	   WRITE(PU,99) STATION,LCTIME,CTIME,'Raw Statistics'
	   WRITE(PU,19) 'FREQ','NREJ','NQUAL','NACPT','NTOSS','NOUT',
     +	             'NSRCS'
	   WRITE(PU,20) (I,NREJ(I),NQUAL(I),NACPT(I),NTOSS(I),NOUT(I),
     +                 NSRCS(I), I=1,4)
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % Amplitude Distribution'
	   WRITE(PU,21) '  0-31 ',(IROUND(100./NA*KAMP(I)),I=0,31)
	   WRITE(PU,21) ' 31-63 ',(IROUND(100./NA*KAMP(I)),I=32,63)
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' %*10 Phase Distribution'
	   DO 25 K = 0,324,36
 25	   WRITE(PU,22) K,K+35,(IROUND(1000./NP*KPHAS(I)),I=K,K+35)
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % Maximum Amplitude Distribution'
	   DO 110 K = 1,7
	      WRITE(PU,24) K,'  0-31 ',(IROUND(100./NM*KMAX(K,I)),I=0,31)
	      WRITE(PU,24) K,' 31-63 ',(IROUND(100./NM*KMAX(K,I)),I=32,63)
 110	   CONTINUE
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % Most Probable Amplitude Distribution'
	   DO 111 K = 1,7
	      WRITE(PU,24) K,'  0-31 ',(IROUND(100./NM*KMPA(K,I)),I=0,31)
	      WRITE(PU,24) K,' 31-63 ',(IROUND(100./NM*KMPA(K,I)),I=32,63)
 111	   CONTINUE
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % RMS Distribution'
	   DO 26 K = 0,324,36
 26	   WRITE(PU,22) K,K+35,(IROUND(PF*KRMS(I)),I=K,K+35)
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % Phase Diffference Distributions'
	   DO 40 J = 1,6
	      WRITE(PU,'(1X,2A)') ' Phase Sum ',PHILABEL(J)
	      DO 27 K=-180,144,36
 27	      WRITE(PU,22) K,K+35,(IROUND(PF*KPDIF(I,J)),I=K,K+35)
 40	   CONTINUE
	   WRITE(PU,*) ' '
C	   End of raw STAT printout.
C
C
C	Select the cleaner statistic data printout.
	ELSE IF (ISTAT.EQ.2) THEN
	   WRITE(PU,99) STATION,LCTIME,CTIME,'Cleaned Statistics'
	   WRITE(PU,19) 'FREQ','NREJ','NQUAL','NACPT','NTOSS','NOUT',
     +	             'NSRCS'
	   WRITE(PU,20) (I,NREJ(I),NQUAL(I),NACPT(I),NTOSS(I),NOUT(I),
     +                 NSRCS(I), I=1,4)
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % Amplitude Distribution'
	   WRITE(PU,21) 'Amp', (I,I = 0,62,2)
	   WRITE(PU,21) ' % ',(IROUND(100./NA*(KAMP(I)+KAMP(I+1))),
     +	              I=0,62,2)
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % Phase Distribution'
	   WRITE(PU,21) 'Phase/10',(I/10,I=0,350,10)
	   WRITE(PU,21) '      % ',(IROUND(100./NP*(KPHAS(I)+KPHAS(I+1)+
     +    KPHAS(I+2)+KPHAS(I+3)+KPHAS(I+4)+KPHAS(I+5)+KPHAS(I+6)+
     +    KPHAS(I+7)+KPHAS(I+8)+KPHAS(I+9))),I=0,350,10)
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % Maximum Amplitude Distribution'
	   WRITE(PU,21) 'Amplitude', (I,I = 0,62,2)
	   DO 112 K = 1,7
	      WRITE(PU,24) K,'  % ',(IROUND(100./NM*(KMAX(K,I)+
     +                   KMAX(K,I+1))),I=0,62,2)
 112	      CONTINUE
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % Most Probable Amplitude Distribution'
	   WRITE(PU,21) 'Amplitude', (I,I = 0,62,2)
	   DO 113 K = 1,7
	      WRITE(PU,24) K,'  % ',(IROUND(100./NM*(KMPA(K,I)+
     +                   KMPA(K,I+1))),I=0,62,2)
 113	      CONTINUE
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' % RMS Distribution'
	   WRITE(PU,21) 'RMS Error',(I,I=0,30),360
	   K = 0
	   DO 118 I = 31,359
 118	   K = K + KRMS(I)
	   K = IROUND(PF*K)
	   WRITE(PU,21) '       % ',(IROUND(PF*(KRMS(I))),I=0,30),K
	   WRITE(PU,*) ' '
C
	   WRITE(PU,*) ' Phase Diffference Distributions'
	   DO 41 J = 1,6
	      WRITE(PU,'(1X,2A)') ' Phase Sum ',PHILABEL(J)
	      I1 = 0
	      I2 = 0
	      DO 119 I = 86,180
	         I1 = I1 + KPDIF(I,J)
	         I2 = I2 + KPDIF(-I,J)
 119	      CONTINUE
	      I1 = IROUND(PF*I1)
	      I2 = IROUND(PF*I2)
	      WRITE(PU,18) 'Phase ',-180,(I,I=-85,80,5),180
	      WRITE(PU,18) '    % ',I2,(IROUND(PF*(KPDIF(I,J)+
     +      KPDIF(I+1,J)+KPDIF(I+2,J)+KPDIF(I+3,J)+KPDIF(I+4,J))),
     +      I=-85,80,5),I1
 41	   CONTINUE
	   WRITE(PU,*) ' '
C	   End of cleaned STAT printout.
C
C
	ELSE IF (ISTAT.EQ.3) THEN 
C	   Means, medians and standard deviations of the availible data.
	   WRITE(PU,99) STATION,LCTIME,CTIME,'Statistical Summary'
	   WRITE(PU,19) 'FREQ','NREJ','NQUAL','NACPT','NTOSS','NOUT',
     +	             'NSRCS'
	   WRITE(PU,20) (I,NREJ(I),NQUAL(I),NACPT(I),NTOSS(I),NOUT(I),
     +                 NSRCS(I), I=1,4)
	   WRITE(PU,*) ' '
C
	   WRITE(PU,33) 'Variable','Mean','AveDev','StdDev','Var',
     +    'Skew','Kurt','Median','MostProb'
 33	   FORMAT(1X,A22,8A12)
C	   Amplitude distribution
	   LABEL = 'Amplitudes'
	   WRITE(PU,34) LABEL,(SSTS(1,J),J=1,8)
 34	   FORMAT(1X,A22,8F12.3)
C	   Phase distribution.
	   LABEL = 'Phases'
	   WRITE(PU,34) LABEL,(SSTS(2,J),J=1,8)
	   WRITE(PU,*) ' '
C	   Maximum Amplitudes
		DO 186 I = 1, 7
	      WRITE(LABEL,'(A,I1,A)') 'Ant#',I,' Peak Amplitude'
	      WRITE(PU,34) LABEL,(SSTS(2+I,J),J=1,8)
 186	   CONTINUE
	   WRITE(PU,*) ' '
C
C	   Most Probable Amplitudes
		DO 187 I = 1, 7
	      WRITE(LABEL,'(A,I1,A)') 'Ant#',I,' Noise'
	      WRITE(PU,34) LABEL,(SSTS(10+I,J),J=1,8)
 187	   CONTINUE
	   WRITE(PU,*) ' '
C
C	   RMS distribution.
	   LABEL = 'RMS Errors'
	   WRITE(PU,34) LABEL,(SSTS(1,J),J=1,8)
	   WRITE(PU,*) ' '
C
C	   Phase difference distributions
	   DO 166 I = 1, 6
	      WRITE(PU,34) PHILABEL(I),(SSTS(18+I,J),J=1,8)
 166	   CONTINUE
	   WRITE(PU,*) ' '
C
C	   Try to determine which antennas are in error by setting groups
C	   of three phase errors to zero and calculating the others.   
C	   There are 35 possible combinations.
	   JC = 0
	   DO 68 I1 = 1, 5
	      DO 68 I2 = I1+1, 6
	         DO 68 I3 = I2+1, 7
	            JC = JC + 1
C	            Let the phases on antennas I1,I2 and I3 = 0.0 and the
C	            rest of the phases be determined by the phase equations
C	            1,2,3 and 5 above. 
	            DO 70 I = 1, 7
	               DO 70 J = 1, 7
	                  A(I,J) = PEQS(I,J)
 70	            CONTINUE
	            A(5,I1) = 1.0
	            A(6,I2) = 1.0
	            A(7,I3) = 1.0
C 	            Now set the vector.
	            X(1) = SSTS(19,1)
	            X(2) = SSTS(20,1)
	            X(3) = SSTS(21,1)
	            X(4) = SSTS(22,1)
	            X(5) = 0.0
	            X(6) = 0.0
	            X(7) = 0.0
C	            WRITE(PU,101) ((A(I,J),J=1,7),X(I),I=1,7)
C 101	            FORMAT (1X,7F5.1,5X,F5.1)
C	            Solve the equations.
	            CALL LUDCMP(A,7,7,INDX,D)
	            CALL LUBKSB(A,7,7,INDX,X)
	            DO 69 I = 1, 7
	               IF (ABS(X(I)).GT.180.0) X(I) = 0.0
	               PERR(JC,I) = X(I)
 69	            CONTINUE
C	            WRITE(PU,102) JC,I1,I2,I3,(PERR(JC,I),I=1,7)
 102	            FORMAT (1X,I4,3X,3I1,3X,7F8.2)
 68	   CONTINUE
	   DO 72 I = 1, 7
	      K = 0
	      DO 71 JC = 1, 35
	         IF (ABS(PERR(JC,I)).GT.0) THEN
	            K = K + 1
	            VALS(K) = PERR(JC,I)
	         ENDIF
 71	      CONTINUE
	      WRITE(LABEL,'(A,I1)') 'Antenna #',I
	      CALL MOMENT(VALS,K,AVE,ADEV,SDEV,VAR,SKEW,CURT)
	      CALL MEDIAN1(VALS,K,XMEDIAN)
	      WRITE(PU,34) LABEL,AVE,SDEV,XMEDIAN
 72	   CONTINUE
	   WRITE(PU,*) ' '
C
C	   Antenna error distributions.
	   JJ = 0
	   DO 77 I = 1, 6
	      DO 77 J = I+1, 7
	        JJ = JJ + 1
	        DO 76 K = -100,100
	           PDF(K+101) = KERR(JJ,K)
 76	        CONTINUE
	        CALL PDFMOMENT(PDF,-100.,100.,201,AVE,ADEV,SDEV,VAR,
     +                  SKEW,CURT)
	        CALL PDFMEDIAN(PDF,201,MEDIAN,MPA)
	        MEDIAN = MEDIAN - 101
	        MPA = MPA - 101
	        WRITE(LABEL,'(A,I1,A,I1)') 'Antenna ',I,'-',J
	        WRITE(PU,34) LABEL,AVE,SDEV,REAL(MEDIAN),REAL(MPA)
 77	   CONTINUE
	   WRITE(PU,*) ' '
C
	ELSE IF (ISTAT.EQ.4) THEN
C	   Selective statisitc printout.
C				*** NOT YET IMPLEMENTED ***
	ENDIF
C
	CALL INITSTAT()
	LSTATTIME = NOWTIME
	LCTIME = CTIME
C
	RETURN
	END
C
C
	INTEGER FUNCTION GETINT(A,B)
C	Returns an integer read from the console in the range (A,B)
C
	INTEGER A,B,I
 10	READ(*,*) I
	IF ((I.LT.A).OR.(I.GT.B)) THEN
	   WRITE(*,*) ' Invalid choice, try again ...'
	   GOTO 10
	ENDIF
	GETINT = I
	WRITE(*,*) ' '
	RETURN
	END
C
C
	REAL*8 FUNCTION PARSETIME(TIME)
C	   This function takes an integer array of 11 values and
C	calculates the approximate number of seconds since January, 1900.
C	These values are for comparison purposes only, as they do not take
C	leap years, etc into consideration.  Will also fail past the year
C	2000 as far as I can tell.
C
	INTEGER*2 TIME(11)
C	Seconds per year
	PARSETIME = 3153600.*(10*TIME(1)+ TIME(2))
C	Seconds per day
	PARSETIME = PARSETIME + 86400.*(100*TIME(3)+10*TIME(4)+TIME(5))
C	Seconds per hour
	PARSETIME = PARSETIME + 3600.*(10*TIME(6) + TIME(7))
C	Seconds per minute
	PARSETIME = PARSETIME + 60.*(10*TIME(8) + TIME(9))
C	And finally the seconds
	PARSETIME = PARSETIME + 10.*TIME(10) +1.*TIME(11)
	RETURN
	END
C 
C
C===== READ INPUT PARAMETERS ===========================================
C
	SUBROUTINE READINPUT()
C
C	COMMON BLOCKINGS
C	For /CONTROL/
	INTEGER LOCALE,IPRT,ISTAT,CASECLEAN,LINECLEAN,P2,P3,P4,P5,NR2DO
	LOGICAL FINDSRC,PRT,STAT,TEST,FILE,TOSS1
	REAL ZEEMAX,TTIME
	CHARACTER*30 SKYDATAFILE,TESTFILE,STATFILE,STATION
C	   FOR /TIME/
	REAL*8 ENDTIME,LASTTIME,STARTTIME,NOWTIME
	CHARACTER*15 CTIME
C
	COMMON/CONTROL/ FINDSRC,PRT,STAT,TEST,FILE,LOCALE,ZEEMAX,TTIME,
     +                SKYDATAFILE,IPRT,ISTAT,CASECLEAN,LINECLEAN,
     +                P2,P3,P4,P5,NR2DO,TESTFILE,STATFILE,STATION,
     +	             TOSS1
	COMMON/TIME/ STARTTIME,ENDTIME,NOWTIME,CTIME,LASTTIME
C
	INTEGER GETINT,I
	INTEGER*2 LTT(11)
	REAL*8 PARSETIME
	CHARACTER*20 STANAME(10)
C
	DATA STANAME /'Goose Bay','Ramey, PR','Thule (>3/85)',
     +              'Millstone Hill','Tennessee','Erie','Qaanaaq',
     +              'Argentia','Wallops Island','Standard Array'/
C
	WRITE(*,*) ' Digisonde 256 Drift Processing'
	WRITE(*,*) '     SKYMAP - Source Location Program'
	WRITE(*,*) ' '
	WRITE(*,*) ' Data Source options:'
	WRITE(*,*) '     1) Data from 9-track tape.'
	WRITE(*,*) '     2) Data from a disk file.'
	FILE = (GETINT(1,2).EQ.2)
	IF(FILE) THEN
	   WRITE(*,*) ' Enter the name of the file with the data:'
	   READ(*,'(A)') TESTFILE
	ENDIF
C
	WRITE(*,*) ' Data Test/Process options.'
	WRITE(*,*) '     1)  Process data normally.'
	WRITE(*,*) '     2)  Process data under test conditions.'
	TEST = (GETINT(1,2).EQ.2) 
C
	WRITE(*,*) ' Enter the number of the desired location'
	WRITE(*,*) '   1) Goose Bay, Labrador.'
	WRITE(*,*) '   2) Ramey, Puerto Rico.'                 
	WRITE(*,*) '   3) Thule, Greenland since March 1985'
	WRITE(*,*) '   4) Millstone Hill, Massachusetts'
	WRITE(*,*) '   5) Tennesse'	
	WRITE(*,*) '   6) Erie, Colorado'
	WRITE(*,*) '   7) Qaanaaq, Greenland'
	WRITE(*,*) '   8) Argentia, Newfoundland'
	WRITE(*,*) '   9) Wallops Island, Virginia'
	WRITE(*,*) '  10) Standard Antenna Array'
	LOCALE = GETINT(1,10)
	STATION = STANAME(LOCALE)
C
	WRITE(*,*) ' Data Processing Options:'
	WRITE(*,*) '     1) Locate Sources and Produce SKYMAP Data.'
	WRITE(*,*) '     2) Print Data.'
	WRITE(*,*) '     3) Perform Statistical Data Testing.'
	I = GETINT(1,3)
	FINDSRC = I.EQ.1
	PRT = I.EQ.2
	STAT = I.EQ.3
	STATFILE = '*'
	IF(STAT.OR.PRT) THEN
	   WRITE(*,*) ' Printed/Statistic data output options:'
	   WRITE(*,*) '     1) Output to printer.'
	   WRITE(*,*) '     2) Output to file.'
	   I = GETINT(1,2)
	   IF (I.EQ.2) THEN
	      WRITE(*,*) 'Enter the name of the file for the printed/',
     +                 'statistical data:'
	      READ(*,'(A)') STATFILE
	   ENDIF
	ENDIF
C
	IF (FINDSRC.OR.STAT) THEN
	   WRITE(*,*) ' Enter maximum zenith angle for the Skymaps.'
	   WRITE(*,*) '  (in degrees, 0 for default) '
	   READ(*,*) ZEEMAX
	   WRITE(*,*) ' '
	   WRITE(*,*) ' Enter SNR threshold value for Case selection.'
	   CASECLEAN = GETINT(0,96)
	   WRITE(*,*) ' Enter SNR threshold value for Spectral line ',
     +     'selection.'
	   LINECLEAN = GETINT(0,96)
	   WRITE(*,*) ' Enter: '
	   WRITE(*,*) '       1) Toss first DRIFT case of each group.'
	   WRITE(*,*) '       2) Process all cases in each group,'
	   TOSS1 = (GETINT(1,2).EQ.1)
	ENDIF
	IF (FINDSRC) THEN
	   WRITE(*,*) ' Enter name of the output file for the MAPDATA.'
	   WRITE(*,*) '    (extensions .SKY, .HDR will be added)'
CSEG	   WRITE(*,*) '    (extensions SK1,SK2, ... will be added)'
	   READ(*,'(A)') SKYDATAFILE
	   WRITE(*,*) ' '
	ELSE IF (PRT) THEN
	   WRITE(*,*) ' Select the desired printing option:'
	   WRITE(*,*) '     1) Hexdump of raw data.'
	   WRITE(*,*) '     2) Drift data Prefaces only.'
	   WRITE(*,*) '     3) Data Amplitudes (dB).'
	   WRITE(*,*) '     4) Data Phases (degrees).'
	   WRITE(*,*) '     5) DGS 256 Raw Data Printout.'
	   WRITE(*,*) '     6) Hex Amp/Phase /w Ant#1 phase=0.'
	   IPRT = GETINT(1,6)
	   IF (IPRT.EQ.5) THEN
	      WRITE(*,*) ' Enter value for P2.'
	      P2 = GETINT(0,15)
	      WRITE(*,*) ' Enter value for P3.'
	      P3 = GETINT(0,15)
	      WRITE(*,*) ' Enter value for P4.'
	      P4 = GETINT(0,15)
	      WRITE(*,*) ' Enter value for P5.'
	      P5 = GETINT(0,15)
	   ENDIF 
	ELSE IF (STAT) THEN
	   WRITE(*,*) ' Select the desired Data Testing options:'
	   WRITE(*,*) '     1) Raw PDF dump.'
	   WRITE(*,*) '     2) Cleaned PDF display.'
	   WRITE(*,*) '     3) Data Moment Sumary.'
	   ISTAT = GETINT(1,3)
	   WRITE(*,*) ' Enter the time period (in minutes) ',
     +              'to test data. (0 = whole tape)' 
	   READ(*,*) TTIME
	   TTIME = TTIME * 60.0
	   IF (TTIME.EQ.0) TTIME = 1.0E30
	ENDIF
C 
	NR2DO = 0
 21 	WRITE(*,*) ' Enter starting date and time (ie 870220105) or'
	WRITE(*,*) '   enter 0 for current record.'
	READ (*,29) LTT
 29	FORMAT (11I1)
	STARTTIME = PARSETIME(LTT)
	WRITE(*,*) ' Enter ending date and time (same format) or'
	WRITE(*,*) '   enter 0 to select a number of cases.'
	READ(*,29) LTT
	ENDTIME = PARSETIME(LTT)
	IF (ENDTIME.NE.0.AND.STARTTIME.GT.ENDTIME) THEN
	   WRITE(*,*)' Entered start time exceeds entered ending time.'
	   GOTO 21
	ENDIF
	IF (ENDTIME.EQ.0.0) THEN
	   ENDTIME = 1.0E27
	   WRITE(*,*) 'Enter number of DRIFT cases to process or'
	   WRITE(*,*) '  enter 0 for all records up to EOF.'
	   READ(*,*) NR2DO
	ENDIF
	IF (NR2DO.EQ.0) NR2DO = 9999999
	RETURN
	END
C
C  =====================================================================
C
	SUBROUTINE PRINTAMP(IFF,IO)
C
C	Prints the amplitudes in dB (6 MSB) for frequency IFF.
C	All dopplers and 1 to NANT antennas are printed.
C	Negative dopplers first, then positive
C
	INTEGER IFF,I,IANT,IDOP,ISIGN,IO
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C	   FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/UNPACKED/ FM,PHI
C
	WRITE(IO,125) 'Amplitudes ... ',(IPREF(I),I=1,11),
     +         RANG(IFF),IGAIN(IFF),FREQ(IFF)/1000.
	DO 100 IANT = 1, NANT
	   WRITE(IO,135) IANT,
     +        (FM(IDOP,IANT,1),IDOP = NDOPP,1,-1),
     +        (FM(IDOP,IANT,2),IDOP = 1,NDOPP)
C
 100	CONTINUE
 125  FORMAT(1X,A15,2I1,1X,3I1,1X,2I1,':',2I1,':',2I1,
     +       '  H =',F5.0,'Km  G =',I3,'dB  F = ',F9.5,' MHz')
 135	FORMAT(1X,'A#',I1,32I4/,4X,32I4)
	RETURN
	END
C
C  ========================================================================
C
	SUBROUTINE PRINTPHASE(IFF,IO)
C
C	Prints the phases (in degrees) for frequency IFF.
C	All dopplers and 1 to NANT antennas are printed.
C	Negative dopplers first, then positive
C
	INTEGER IFF,I,IANT,IDOP,ISIGN,IPHAS,IO
	REAL DEG
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C	   FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/UNPACKED/ FM,PHI
C
	DATA DEG /57.29577951/
C
	WRITE(IO,125) 'Phases ... ',(IPREF(I),I=1,11),
     +   RANG(IFF),IGAIN(IFF),FREQ(IFF)/1000.
	DO 100 IANT = 1, NANT
	   WRITE(IO,135) IANT,
     +   (INT(DEG*PHI(IDOP,IANT,1)),IDOP = NDOPP,1,-1),
     +   (INT(DEG*PHI(IDOP,IANT,2)),IDOP = 1,NDOPP)
 100	CONTINUE
 125  FORMAT(1X,A15,2I1,1X,3I1,1X,2I1,':',2I1,':',2I1,
     +       '  H=',F5.0,'Km  G =',I2,'dB  F = ',F9.5,'MHz')
 135	FORMAT(1X,'A#',I1,32I4/,4X,32I4)
	RETURN
	END
C
C  ========================================================================
C
	SUBROUTINE apprint(IFF,IO)
C
C	Prints the amplitudes (0-64) for frequency IFF, followed by the
C	phase (degees).  Note that the phases arrive here in radians!
C	All dopplers and 1 to NANT antennas are printed.
C	Negative dopplers first, then positive
C
	INTEGER IFF,I,K,IANT,IDOP,ISIGN,IPHAS,IO,iph(128)
	REAL a,b
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C	   FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/UNPACKED/ FM,PHI
C	 360/2*pi
	DATA b /37.29577951/
c 	Number of dB per amplitude count.
	data a / 1.500/
C
	WRITE(IO,125) (IPREF(I),I=1,11),
     +   RANG(IFF),IGAIN(IFF),FREQ(IFF)/1000.
c
	write(io,134) (-i,i=ndopp,1,-1),(i,i=1,ndopp,1) 
c
	DO IANT = 1, NANT
	   WRITE(IO,135) IANT,
     +        (nint(a*FM(IDOP,IANT,1)),IDOP = NDOPP,1,-1),
     +        (nint(a*FM(IDOP,IANT,2)),IDOP = 1,NDOPP)
	ENDDO

	DO 100 IANT = 1, NANT
c	   Relative phase, in degrees.  Constrain phase to -180 ... +180
	   K = 0
	   DO I = NDOPP, 1, -1
	      K = K + 1
cant	      IPH(K) = NINT(B*(PHI(I,IANT,1) - PHI(I,1,1)))
	      IPH(K) = NINT(B*(PHI(I,IANT,1)))
	      IF (IPH(K).LT.-180) IPH(K) = IPH(K) + 360
	      IF (IPH(K).GT. 180) IPH(K) = IPH(K) - 360
	   ENDDO
	   DO I = 1, NDOPP
	      K = K + 1
cant	      IPH(K) = NINT(B*(PHI(I,IANT,2) - PHI(I,1,2)))
	      IPH(K) = NINT(B*(PHI(I,IANT,2)))
	      IF (IPH(K).LT.-180) IPH(K) = IPH(K) + 360
	      IF (IPH(K).GT. 180) IPH(K) = IPH(K) - 360
	   ENDDO
	   WRITE(IO,136) IANT, (IPH(I),I=1,K)
 100	CONTINUE
	write(io,*) ' '

 125  FORMAT(2I1,1X,3I1,1X,2I1,':',2I1,':',2I1,
     +       '  H=',F5.0,'Km  G=',I2,'dB  F= ',F9.5,'MHz')
 134	FORMAT('D#',1x,64(1x,i4))
 135	FORMAT('A#',I1,64(1x,i4))
 136	FORMAT('P#',I1,64(1x,i4))
 137	format (100x,'-+')
	RETURN
	END
C
C  ========================================================================
C
	SUBROUTINE DGS256PRINT(IFF,P2,P3,P4,P5,IO)
C
C	Produces drift output similar to that of the DGS256 processor
C	printer output.
C	  IFF  - Frequency number in the present record. (1-4)
C	  P2,P3,P4,P5 - The OUTPUT parameters desired for this printout.
C	This routine requires the calling of PREPDAT. The function PAMP 
C     will convert 6-bit values to thresholded to Digisonde 256 5-bit values.
C
	INTEGER P2,P3,P4,P5,IANT,JANT,KANT,ISTEP,IDOPP,OV,TH,I,K,
     +        MPA,IO,MAX5BIT,PFRQ
	INTEGER PAMP,PPHASE
	INTEGER*1 ITABLE(17)
	CHARACTER*1 CTABLE(17)
	LOGICAL PREF
	EQUIVALENCE(ITABLE,CTABLE)
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C	   FOR /TIME/
	REAL*8 ENDTIME,LASTTIME,STARTTIME,NOWTIME
	CHARACTER*15 CTIME
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C	   FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C	For /INDATA/
	INTEGER*1 MAXAMP(7),MPAMP(7),
     +           MAPAMP(256),MAPDOP(256),MAPRMS(256)
	REAL YMAP(256),XMAP(256)
 	LOGICAL*2 TOSSLINE(128,2)
	INTEGER NUMSRC
C
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
	COMMON/TIME/ STARTTIME,ENDTIME,NOWTIME,CTIME,LASTTIME
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/UNPACKED/ FM,PHI
	COMMON/MAPDATA/ NUMSRC,MAXAMP,MPAMP,TOSSLINE,
     +                 YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS
C
C	Put the Optifont values (high bits set) into CTABLE
	DATA ITABLE/-80,-79,-78,-77,-76,-75,-74,-73,-72,-71,
     +            -63,-62,-61,-60,-59,-58, 32/
C
C	Print preface for every new group of cases.
	PREF = ((((NOWTIME-LASTTIME).GT.50).OR.(NOWTIME.EQ.LASTTIME))
     +  .AND. (IFF.EQ.1))
	IF (PREF) THEN
	   WRITE(IO,*) ' ' 
	   CALL PRTPREF(1,0,IO)
	ENDIF
C	No printing if P2 or P3 = 0
	IF ((P2.EQ.0).OR.(P3.EQ.0)) RETURN
C
	PFRQ = P2
	IF (PFRQ.GT.5) PFRQ = PFRQ - 5
	IF (PFRQ.GT.5) PFRQ = PFRQ - 5
	IF ((P2.EQ.5).OR.(P2.EQ.10).OR.(P2.EQ.15)) THEN
	   KANT = 1
	   PFRQ = IFF
	ELSE
	   KANT = NANT
	ENDIF
C
C	Loop through all antennas to be printed.
	DO 120 JANT = 1, KANT
	   IF (KANT.EQ.1) THEN
	      IANT = IAND(P3,7) 
	   ELSE
	      IANT = JANT
	   ENDIF
C	   Cannot print the SUM data
	   IF (IANT.EQ.0) IANT = 1
C	   Now print the data as requested for antenna # IANT.
C	   For P5 > 0, the value to be printed obeys the following formula:
C	      VAL + OV + 7 = 5BIT
C	   Where:
C	         VAL  = Value to be printed (0-15 Optifont)
C	         OV   = Overflow value
C	         5BIT = 5 MSB of the amplitude as stored on tape.
C	   OV is determined by taking the maximum value of 5BIT, setting
C	   VAL to 15 and solving for OV.  The minimum allowable value for
C	   OV is P5
C
	   IF (P5.EQ.0) THEN
C	      This is not yet implemented
	      RETURN
	   ELSE
	      MAX5BIT = MAXAMP(IANT)/2
	      OV = MAX5BIT - 7 - 15
	      IF (OV.LT.P5) OV = P5
	      MPA = MPAMP(IANT)/2 - OV - 7
	      IF (MPA.LT.0) MPA = 0
	      TH = MPA + P4 - 2
	      IF (PFRQ.EQ.IFF) WRITE(IO,100) INT(FREQ(IFF))/10,
     +      INT(RANG(IFF)),IGAIN(IFF)/6, MPA, OV,
     +      (CTABLE(PAMP(FM(IDOPP,IANT,1),OV,TH)+1),
     +         IDOPP = 32-1,1,-1),
     +      (CTABLE(PAMP(FM(IDOPP,IANT,2),OV,TH)+1),
     +         IDOPP = 1,32-1,1),
     +      (CTABLE(PPHASE(PHI(IDOPP,IANT,1),FM(IDOPP,IANT,1),OV
     +        ,TH)+1), IDOPP = 32-1,1,-1),
     +      (CTABLE(PPHASE(PHI(IDOPP,IANT,2),FM(IDOPP,IANT,2),OV
     +        ,TH)+1), IDOPP = 1,32-1, 1)
	      IF (IFF.EQ.4) WRITE(IO,110) (IPREF(I),I=8,11)
	   ENDIF
 120	CONTINUE
 110	   FORMAT (1X,2I1,'MIN ',2I1,'SEC  -',14X,'-',14X,'-+',14X,'+',
     +   14X,'+-',14X,'-',14X,'-+',14X,'+',14X,'+')
 100	FORMAT (1X,2I4,I2,1X,Z1,I1,62A1,62A1)
	RETURN
	END
C
C  ========================================================================
C
	INTEGER FUNCTION PAMP(AMPLITUDE,OVERFLOW,THRESHOLD)
C
C	Returns a value PAMP in the range 0-16 representing the value
C	of AMPLITUDE scaled by the value of OVERFLOW and THRESHOLDed.
C	Return value is 16 if AMPLITUDE < THRESHOLD
C
	INTEGER AMP5BIT,OVERFLOW,THRESHOLD
	INTEGER*1 AMPLITUDE
C
	AMP5BIT = AMPLITUDE/2
	PAMP = MIN0(AMP5BIT - 7 - OVERFLOW, 16)
	IF (PAMP.LT.THRESHOLD) PAMP = 16
	IF (PAMP.LT.0) PAMP = 0
	RETURN
	END
C
C  ========================================================================
C
	INTEGER FUNCTION PPHASE(PHASE,AMPLITUDE,OVERFLOW,THRESHOLD)
C
C	Returns a value PPHASE in the range 0-16 representing the value
C	of PHASE scaled by PI/8  and THRESHOLDed wrt AMPLITUDE.
C	Return value is 16 if AMPLITUDE < THRESHOLD
C
	INTEGER AMP5BIT,THRESHOLD,OVERFLOW,PA
	INTEGER*1 AMPLITUDE
	REAL PHASE
C
	AMP5BIT = AMPLITUDE/2
	PA = MIN0(AMP5BIT - 7 - OVERFLOW, 16)
	PPHASE = MIN0(INT(2.5465*PHASE), 16)
	IF (PPHASE.LT.0) PPHASE = 0
	IF (PA.LT.THRESHOLD) PPHASE = 16
	RETURN
	END
C
C  *************************************************************************
C
	SUBROUTINE READFILE(FILE,BUFFER,RECORDTYPE,EOF)
C
C	Reads binary input from the pre-opened file FILE as 4096 INTEGER*1's
C	and then transfers them to the BUFFER of 4096 INTEGER*2's. EOF is
C	set if the end of file is hit.
C
	INTEGER*1 IBUF(4096)
	INTEGER*2 BUFFER(4096)
	INTEGER FILE,I,RECORDTYPE
	LOGICAL EOF
C
	READ(FILE,END=99) IBUF
	DO 10 I = 1, 4096
	   IF (IBUF(I).LT.0) THEN
            BUFFER(I) = 256 + IBUF(I)
	   ELSE
	      BUFFER(I) = IBUF(I)
	   ENDIF
 10	CONTINUE
	RECORDTYPE = IAND(BUFFER(1),15)
	EOF = .FALSE.
	RETURN
 99	EOF = .TRUE.
	RETURN
	END
C 
C  *************************************************************************
C
C
	SUBROUTINE READTAPE(BUFFER,RECORDTYPE,EOF)
C
C	This routine reads a single record from the tape drive.
C	Several status bits are checked and the operator is
C	allowed to change tapes, stop the program, rewind, etc.
C
C	Recordsize is assumed to have been initialized to 4096
C
	INTEGER READST,STATUS,REWIND,TAPESTAT,TS2,GETINT
	INTEGER*2 BUFFER(4096)
	INTEGER RECORDTYPE
	CHARACTER*1 JUNK
	LOGICAL RED,EOF
C
 1	TAPESTAT = STATUS()
	RED = .FALSE.
	EOF = .FALSE.
C
C...Check the following bits of the status
C.....Bit 4 -- Tape ONLINE
 2	IF(IAND(TAPESTAT,16).EQ.0) THEN
	   WRITE(*,*) ' Tape not ONLINE.  Place tape ONLINE and'
	   WRITE(*,100)
	   READ(*,'(A)') JUNK
	ENDIF
 100	FORMAT (' Hit RETURN to continue or ^C to abort')
C.....Bit 7 -- EOT - End Of Tape.
	IF(IAND(TAPESTAT,128).NE.0) THEN
	   WRITE(*,*) ' End of tape encountered.'
         WRITE(*,*) ' Finalizing processing of current tape.'
	   EOF = .TRUE.
	   RED = .TRUE.
	ENDIF
C	Bit 8 -- Hard Error
	IF(IAND(TAPESTAT,256).NE.0) THEN
	   WRITE(*,*) ' Hard error detected on tape -- Block unreadable.'
c	   WRITE(*,*) ' Enter:'
c	   WRITE(*,*) '      1) Continue processing past Hard Error.'
c	   WRITE(*,*) '      2) Finalize data processing.'
c	   WRITE(*,100)
c	   EOF = (GETINT(1,2).EQ.2)
	   EOF = .FALSE.
	   RED = EOF
	   IF (.NOT.EOF) WRITE(*,*) ' Reading next block ...'
	ENDIF
C	Bit 10 -- EOF End Of File mark.
	IF (IAND(TAPESTAT,1024).NE.0) THEN
	   WRITE(*,*) ' End of file mark encountered.'
	   WRITE(*,*) ' Select an option from below and '
	   WRITE(*,100)
	   WRITE(*,*) ' Options:'
	   WRITE(*,*) '      1) Continue processing past EOF.'
	   WRITE(*,*) '      2) Finalize data processing.'
	   EOF = (GETINT(1,2).EQ.2)
	   RED = EOF
	ENDIF
C
C	Now read the data, and then re-check the status
C	 
	IF (.NOT.RED) THEN
	   TAPESTAT = READST(BUFFER)
	   RECORDTYPE = IAND(BUFFER(1),15)
	   RED = .TRUE.
	   GOTO 2
	ELSE
	   RETURN
	ENDIF
	RETURN
	END
C
C
C  =================================================================
C
C
	SUBROUTINE PRTPREF(IFHEADER,NMAP,IO)
C
C	Prints the preface values for the current record, assumed to
C	have been decoded into the array IPREF.
C	   IFHEADER is an integer.  A non-zero value here causes the routine
C	      to print the header to the preface.
C	   NMAP is an integer block counter counting the number of blocks
C	      read off of the tape. 
C
	INTEGER IFHEADER,NMAP,IO,IP
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
C
C 	   	   	   	   	   	   	   	   	   	   
C
      	IF((IFHEADER.NE.0)) WRITE(IO,103)
      	WRITE(IO,105) NMAP,(IPREF(IP),IP=1,89)
 103 	   FORMAT(/3X,'REC  DATE  TIME  SP JOURNAL FREQ  P1---P7', 
     +	   	'  S Q  U CAB  V  XLZTNRWKIGHEIG',
     +	   	'  H1  G1  F1  H2  G2  F2  H3  G3  F3  H4  G4  F4') 
 105 	   FORMAT(1X,I5,1X,5Z1,1X,6Z1,1X,2Z1,2(1X,6Z1),1X,7Z1, 
     +	   	1X,2Z1,1X,Z1,1X,2Z1,2(1X,3Z1),1X,14Z1,
     +	   	4(2X,3Z1,1X,Z1,1X,4Z1)) 
	RETURN
	END
C
C
C 
C  ======================================================================
      SUBROUTINE PRINTMAPDATA(NMAP,IFF,OUTFILE,NBYTES,GOOD) 
C 
C===== WRITE THE MAP DATA TO A FILE <outfile> FOR LATER USE IN PRINTING 
C      SKYMAPS OR CALCULATING DRIFT VELOCITIES.  FREQUENCY TO OUTPUT IS
C	 <IFF>  THE FORMAT OF THE PREFACE IS AS FOLLOWS:
C 
C=======================================================================
C CODE RELEVANT PREFACE CHARACTERS (DECIMAL UNLESS SPECIFIED OTHERWISE) 
C    INTO ARRAY MAPREF:
C  POSITION ! FORMAT  !  INFORMATION
C_______________________________________________________________
C  1        ! A1      !  SPACE                                  !
C  2-4      ! 3Z1     !  STATION ID CODE                        !
C  5-9      ! I5      !  RECORD NO.                             !
C  10       ! A1      !  SPACE                                  !
C  11-15    ! 5Z1     !  DATE                                   ! 
C  16       ! A1      !  SPACE                                  !
C  17-22    ! 6Z1     !  TIME                                   ! 
C  23       ! 1X      !  SPACE                                  !
C  24       ! Z1      !  PROGRAM SET                            ! 
C  25       ! Z1      !  PROGRAM TYPE                           ! 
C  26-31    ! 6Z1     !  JOURNAL (6 HEX DIGITS)                 ! 
C  32-38    ! 7Z1     !  P1 TO P7 (7 HEX DIGITS)                !
C  39       ! 1X      !  SPACE                                  !
C  40-46    ! 7Z1     !  XLZTNRW (7 HEX DIGITS)                 ! 
C  47-53    ! 7Z1     !  K(I*)(G*)HEIG (7 HEX DIGITS)           ! 
C  54-57    ! I4      !  ZMAX (10THS OF A DEGREE)               ! 
C  58-59    ! I2      !  NFREQ=FREQUENCY NUMBER                 ! 
C  60-66    ! I7      !  FREQ(NFREQ), IN 100-HZ UNITS           ! 
C  67-71    ! I5      !  RANG(NFREQ), IN 100-METER UNITS        ! 
C  72-74    ! I3      !  IGAIN(NFREQ), IN DB                    ! 
C  75-77    ! I3      !  MPA                                    ! 
C  78-80    ! I3      !  MAXAMP                                 ! 
C  81-84    ! I4      !  NO. OF SOURCES FOR NFREQ               !
C  85-87    ! I3      !  CASE SELECTION THRESHOLD               !
C  88-90    ! I3      !  SPECTRAL LINE SELECTION THRESHOLD      ! 
C================================================================
C
	INTEGER IP,IFF,NMAP,IERR,OUTFILE,IZMAX,IROUND,IFRQ,IRNG,I,I1,I2,
     +        MAXX,MPA
	LOGICAL GOOD
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C	For /CONTROL/
	INTEGER LOCALE,IPRT,ISTAT,CASECLEAN,LINECLEAN,P2,P3,P4,P5,NR2DO
	LOGICAL FINDSRC,PRT,STAT,TEST,FILE,TOSS1
	REAL ZEEMAX,TTIME
	CHARACTER*30 SKYDATAFILE,TESTFILE,STATFILE,STATION
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C	For /MAPDATA/
	INTEGER*1 MAXAMP(7),MPAMP(7),
     +           MAPAMP(256),MAPDOP(256),MAPRMS(256)
	REAL YMAP(256),XMAP(256)
	LOGICAL*2 TOSSLINE(128,2)
	INTEGER NUMSRC
C	For /ANTENNA/
	INTEGER*1 JSEQ(7),NANTNO(7)
	REAL YCOORD(7),XCOORD(7),DELX(6,7),SDXSQ,DELY(6,7),SDYSQ,
     +       SDXDY,ANTSEP,ZMAX
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
	COMMON/CONTROL/ FINDSRC,PRT,STAT,TEST,FILE,LOCALE,ZEEMAX,TTIME,
     +                SKYDATAFILE,IPRT,ISTAT,CASECLEAN,LINECLEAN,
     +                P2,P3,P4,P5,NR2DO,TESTFILE,STATFILE,STATION,
     +	             TOSS1 
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/MAPDATA/ NUMSRC,MAXAMP,MPAMP,TOSSLINE,
     +                 YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS
      COMMON/ANTENNA/ JSEQ,NANTNO,YCOORD,XCOORD,DELX,SDXSQ,DELY,SDYSQ,
     +                SDXDY,ANTSEP,ZMAX
C
C	Determine the Maximum and Most Probable Amplitudes as the
C	average (dB) of the  NANT antennas.
	MAXX = 0
	MPA = 0
	DO 20 I = 1, NANT
	   MAXX = MAXX + MAXAMP(I)
	   MPA = MPA + MPAMP(I)
 20	CONTINUE
	MAXX = MAXX/NANT
	MPA = MPA/NANT 
C	Write out the preface data.
	IZMAX = IROUND(10.0*ZMAX)
	IFRQ = INT(10.0*FREQ(IFF))
	IRNG = INT(10*RANG(IFF))
	WRITE(OUTFILE,110) (IPREF(I),I=41,43), NMAP, (IPREF(I),I=1,19),
     +  (IPREF(I),I=26,32),(IPREF(I),I=44,57),IZMAX,IFF,IFRQ,IRNG,
     +  IGAIN(IFF),MPA,MAXX,NUMSRC,CASECLEAN,LINECLEAN
	NBYTES = NBYTES + 92	
 110	FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +        I4,I2,I7,I5,4I3,I4,2I3) 
C 
	IF (.NOT.GOOD) RETURN
C
      DO 140 I1=1,NUMSRC,26 
         I2=I1+25
         IF(I2.GT.NUMSRC) I2=NUMSRC
         NBYTES = NBYTES + 5*(5 + 5*(I2-I1+1)) 
         WRITE(OUTFILE,151) ' Y',(YMAP(I),I=I1,I2) 
         WRITE(OUTFILE,151) ' X',(XMAP(I),I=I1,I2) 
         WRITE(OUTFILE,150) 'PD',(MAPAMP(I),I=I1,I2)
         WRITE(OUTFILE,150) 'DO',(MAPDOP(I),I=I1,I2) 
         WRITE(OUTFILE,150) 'ER',(MAPRMS(I),I=I1,I2) 
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C 
      RETURN
      END 
C
C
C  ========================================================================= 
C
	SUBROUTINE HEXDUMP(IO)
C
C	Prints a hexadecimal dump of the drift data in the 4096 long
C	buffer IBUF.
C	Formatted in hex as 128 lines of 32 bytes/line
	INTEGER IO,I,J
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
C
	WRITE(IO,*) ' '
	WRITE(IO,105) (J,J=1,32)
	DO 100 I = 0, 127
	   WRITE(IO,110) I, (IBUF(32*I+J),J=1,32)
 100	CONTINUE
 105	FORMAT (4X,8('-',4Z2))
 110	FORMAT (2X,Z2,8('-',4Z2))
	WRITE(IO,*) ' '
	RETURN
	END
C
C  ======================================================================
C
	SUBROUTINE INITOPTI(IO)
C	Initializes the Okidata 192 printer with OptiFont characters
C	in place of the numbers 1-9 and the letters A-F.
C	The array CHARSET contains the 12 decimal ASCII numbers needed to
C	define the 16 Optifont characters.
C	Line spacing is also set to 13/144".
C
	CHARACTER*2 STARTDEF
	CHARACTER*3 DEFINEA
	CHARACTER*4 L13144
	INTEGER*2 CHARSET(16,12),I,IC
	INTEGER IO
C
	DATA (CHARSET(1,I),I=1,12)/176,0,0,0,0,0,0,0,0,0,0,0/
	DATA (CHARSET(2,I),I=1,12)/177,0,0,62,0,0,0,0,0,0,0,0/
	DATA (CHARSET(3,I),I=1,12)/178,58,0,0,36,0,0,0,0,0,0,0/
	DATA (CHARSET(4,I),I=1,12)/179,42,0,0,54,0,0,0,0,0,0,0/
	DATA (CHARSET(5,I),I=1,12)/180,14,0,8,0,0,60,0,0,0,0,0/
	DATA (CHARSET(6,I),I=1,12)/181,46,0,0,42,0,48,0,0,0,0,0/
	DATA (CHARSET(7,I),I=1,12)/182,62,0,0,40,0,56,0,0,0,0,0/
	DATA (CHARSET(8,I),I=1,12)/183,58,0,0,62,0,6,0,0,0,0,0/
	DATA (CHARSET(9,I),I=1,12)/184,62,0,0,42,0,30,0,0,0,0,0/
	DATA (CHARSET(10,I),I=1,12)/185,46,0,0,58,0,0,62,0,0,0,0/
	DATA (CHARSET(11,I),I=1,12)/193,62,0,0,54,0,0,62,0,0,0,0/
	DATA (CHARSET(12,I),I=1,12)/194,62,0,0,62,0,0,60,0,0,32,0/
	DATA (CHARSET(13,I),I=1,12)/195,62,0,0,62,0,0,58,0,0,36,0/
	DATA (CHARSET(14,I),I=1,12)/196,62,0,0,62,0,0,42,0,0,54,0/
	DATA (CHARSET(15,I),I=1,12)/197,62,0,0,62,0,0,62,0,0,28,0/
	DATA (CHARSET(16,I),I=1,12)/198,62,0,0,62,0,0,62,0,0,58,0/
C
	STARTDEF = CHAR(27)//CHAR(36)
	DEFINEA = CHAR(27)//CHAR(37)//CHAR(65)
C	L13144 sets line spacing to 13/144" for Optifont
C
	L13144 = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(13)
C
C	This copies the printer character set to printer's RAM,
C	Then transfers the OptiFont characters to the printer.
C
C	Unit IO is for the printer
C
	WRITE(IO,99) STARTDEF,
     +            (DEFINEA,(CHAR(CHARSET(IC,I)),I=1,12),IC=1,16)
 99	FORMAT(1X,A2,16(A3,12A1))
C
C	Switches the printer to use the downloaded character set
C
	WRITE(IO,'(1X,2A1)')  CHAR(27),CHAR(50)
	WRITE(IO,'(1X,A4)') L13144
	RETURN
	END
C
C ========================================================================
C
	INTEGER FUNCTION IROUND(VALUE)
C
	REAL VALUE
	IF (VALUE.GE.0) THEN
	   IROUND = INT(VALUE + 0.501)
	ELSE
	   IROUND = INT(VALUE - 0.501)
	ENDIF
	RETURN
	END
C
C========================================================================
C
	CHARACTER*17 FUNCTION CTIMELTT(LTT)
C.....Converts the 11 INTEGER*2 argument LTT into the 17 character
C.....CTT time format.
	INTEGER*2 I,LTT(11)
	CTIMELTT = ' '
	WRITE(CTIMELTT,102) (LTT(I),I=1,11)
 102	FORMAT ('19',2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
	RETURN
	END
C
