$NOTRUNCATE
$DECLARE
$DEBUG
      PROGRAM SKYMAP
C
C  Originally written by Claude Dozois in FORTRAN 4 on CDC Cyber.
C  Converted from FORTRAN 4 to FORTRAN 77 Microsoft V4.10 on IBM AT
C  By Terence Bullett  Starting 09 Oct 1987.
C
C	HARDWARE:    IBM AT compatable w/ 60Meg Hard Disk
C	             Pertec 9 track tape drive
C	             Okidata 192 printer
C
C
C	This program reads DRIFT data from magnetic tapes produced by a
C   Digisonde 256.  Digisonde 128 data is not supported.
C
C   The calculations performed by this program include:
C	1) The printing of raw data in various formats.
C	2) The statistical testing of data for quality and consistency
C	   in both amplitude and phase of the signals measured.
C	3) The determination of the azimuth and elevation angles
C	    of arrival for each Doppler component of a radio wave.
C 
C=======================================================================
C	This program DOES NOT work with Digisonde 128 data as 
C  this data is on 7-track tapes and cannot be read by the 9 track
C  tape drives.
C=======================================================================
C
C   22 Nov 1989 -- Add Sondre Stromfjord station and 'Standard Array'
C	             to the list of possible stations.  Also indicate to
C	             the operator the use of coordinate systems.
C
C   04 April 1989 -- Reconcile differences in source selection between
C                    this program and Claude's.
C                 -- Make program operational for 2 DRIFT cases per tape
C                    record.
C	            -- Limit acceptable drift tasks to L=B,Z=2,N=5
C	                and L=F,Z=0,1, N=5,6
C	            -- Changed calculation of the Most Probable Amplitude
C	               to a 2-bin smoothing method, not the single bin
C	               method previously implemented.
C
C   13 Feb 1989 -- Write /MAPDATA/ routine was modified to
C                  contain CASECLEAN and LINECLEAN variables.
C
C				   VARIABLE LIST AND EXPLANATION
C
C   LOCALE       - Integer defining which station/antenna configuration
C	   	   	 is being used.  The following are currently valid.
C	   	   	   1) Goose Bay, Labrador.
C	   	   	   2) Ramey, Puerto Rico.
C	   	   	   3) Thule, Greenland since March 1985
C	   	   	   4) Millstone Hill, Massachusetts
C	   	   	   5) Sondre Stromfjord, Greenland (AWS#11)
C	   	   	   6) Erie, Colorado
C	   	   	   7) Qaanaaq, Greenland
C	   	   	   8) Argentia, Newfoundland
C	               9) Wallops Island, Virginia. (AWS#1)
C	              10) Standard Antenna Array/
C   LTT          - Integer array for holding time components.
C   MAXFILESIZE  - Maximum size (in bytes) of output file.
C   SKYFILE      - Name of file actually open for output.
C   FILENO       - Current # in the sequence of output files.
C   LASTFILENO   - Previous file # in the sequence.
C   NLOCS        - Number of stations this program is prepared for (8)
C   ZEEMAX       - Maximum zenith angle input value.
C
C                           COMMON BLOCK VARIABLES
C      /BUFFS/
C   IBUF(4096)   - Buffer holding the raw data from the tape.
C   IPREF(89)    - The current preface, unpacked.
C   LPREF(89)    - The previous preface, unpacked.
C	/UNPACKED/
C   FM(128,7,2)  - Array of magnitudes, NDOPPxNANTxISIGN (Upper 6 INTEGER)
C   PHI(128,7,2) - Array of phases, NDOPPxNANTxISIGN  (radians)
C	           - NOTE: ISIGN = 1 for Negative Dopplers
C	                   ISIGN = 2 for Positive Dopplers
C	           - Increasing values of the Doppler line # correspond
C	             to increasingly larger absolute value Doppler shifts,
C	             thus (128,x,1) is the most negative Doppler for antenna
C	             x and (128,x,2) is the most positive.
C	/CONTROL/
C   LOCALE       - Integer specifying location.  See READINPUT for specifics.
C   IPRT         - Specifies print options
C   ISTAT        - Specifies data testing (statistics) options.
C   CASECLEAN    - Case selection SNR criterion (see PREPDAT)
C   LINECLEAN    - Spectral line selection SNR criterion (see PREPDAT)
C   P2,P3,P4,P5  - Digisonde OUTPUT parameters, for DGS256PRINT.
C   NR2DO        - Number of cases to process.
C   FINDSRC      - Controls source location process.
C   PRT          - Controls printing.
C   STAT         - Controls data testing.
C   ZEEMAX       - Desired maximum zenith angle input parameter.
C   TTIME        - Number of seconds for statsitic/testing accumulation.
C   TEST         - Controls reading of real test data from a disk file.
C   TOSS1        - Determines the tossing out of the first drift case.
C 
C	/TIME/
C   ENDTIME      - Double precision real roughly representing the
C	   	   	 # of seconds since 1900.  Indicates desired ending
C	   	   	 time for the present calculation.
C   LASTTIME     - Time of the last record, ENDTIME format.
C   STARTTIME    - Desired starting time for data processing.  ENDTIME format.
C   NOWTIME      - Indicates time of present record.  Same format as ENDTIME.   
C	/PRAMS/
C   IL           - The L Preface parameter.  Determines the number of 
C	             antennas,freqs,heights,dopplers,samples and channels.
C   IZ           - The Z Preface parameter.  Determines Amplitude resolution.
C   IT3          - The third bit of the T Preface parameter.
C   IN           - The N Preface paramter.
C   IREP         - Pulse Repetition Frequency, Hertz.
C   NFREQ        - Number of drift frequencies.
C   NANT         - Number of antennas used.
C   NANTDAT      - Number of ANTenna DATa blocks on the tape.
C   NHITES       - Number of heights.
C   NCHAN        - Number of channels??
C   NSMPLS       - Number of samples ??
C   NPULSES      - Number of pulses (per integration/FFT?)
C   NDOPP        - Number of Doppler spectral lines.
C   NCASES       - Number of drift cases per record.
C   FREQ(4)      - Four(max) drift frequencies (KHz).
C   RANG(4)      - Four(max) heights (Km).
C   IGAIN(4)     - The gain parameter for the 4 freq/heights.
C   LASTGAIN(4)  - The previous gain parameters.
C	/CONSTANTS/
C   PI           - 3.14159....
C	/STATS/
C   NREJ(4)      - The number of spectral lines rejected for SNR reasons.
C   NQUAL(4)     - The number of spectral lines rejected for phase reasons.
C   NACPT(4)     - The number of spectral lines accepted.
C   NTOSS(4)     - The number of subcases tossed for SNR reasons.
C   NOUT(4)      - The number of sources beyond Zmax.
C   NSRCS(4)     - The total number of sources. 
C   NBAD         - The total number of bad tape errors.
C   KAMP(0:63)   - Total 6-bit amplitude PDF.
C   KMAX(7,0:63) - PDF of maximum amplitudes, by antenna.
C   KMPA(7,0:63) - PDF of most probable amplitudes, by antenna.
C   KPHAS(0:359) - Total phase PDF (degrees).
C   KRMS(0:359)  -
C   KPDIF(-180:180,I) - Phase difference PDF (degrees)
C                  I determines which phase difference is contained.
C          I = 1 : P2 + P3 + P4 - 3*P1
C          I = 2 : P5 + P6 + P7 - 3*P1
C          I = 3 : (P1 - P2) + (P4 - P7)
C          I = 4 : (P1 - P3) + (P2 - P5)
C          I = 5 : (P1 - P4) - (P3 - P6)
C          I = 6 : (P2 + P3 + P4) - (P5 + P6 + P7)
C   KERR(21,-100:100) - Percentage error of each antenna separation
C                   with respect to the total RMS error for each source.
C
C	/MAPDATA/
C   NUMSRC       - The number of sources on the current skymap
C   MAXAMP(7)    - Maximum of spectral peak, for 7 antennas.
C   MPAMP(7)     - Most Probable Doppler Amplitude, ie Noise.
C   TOSSLINE(128,2) - Logical determining use of spectral line.
C   YMAP(256)    - Y map coordinates for all sources.
C   XMAP(256)    - X map coordiantes for all sources.
C   MAPAMP(256)  - Amplitude for all sources.
C   MAPDOP(256)  - Doppler shift for all sources.
C   MAPRMS(256)  - Errors for the source point locations
C   
C	/ANTENNA/
C   JSEQ(7)      - Order in which antenna data appears on tape.
C   NANTNO(7)    - Antenna numbers for the data.
C   YCOORD(7)    - Y coordinates of the 7 antennas.
C   XCOORD(7)    - X coordinates of the 7 antennas.
C   DELX(6,7)    - Difference in X between all paris of two antennas.
C   DELY(6,7)    - Difference in Y between all pairs of two antennas.
C   SDXSQ        - Double sum of DELX**2 over both indices
C   SDYSQ        - Double sum of DELY**2 over both indices
C   ANTSEP       - Distance between antennas factor, for sidelobe calcs.
C   ZEEMAX       - Default (fixed) Max. Zenith angle.
C   ZMAX         - Calculated (variable) Max. Zenith angle
C=======================================================================
C
C					SUBROUTINES REFERENCED
C
C	ANT .......... Defines antenna array geometry.
C	PREF256 ...... Decodes the DGS 256 preface for necessary info.
C	PREPDAT ...... Checks data for SNR & prepares it for SRCLOC.
C	SRCLOC  ...... Determines arrival angle for each reflection point.
C	UNP256  ...... Unpacks amplitude and phase info from DGS 256 raw data.
C...Located in file SKYIO.FOR
C	DGS256PRINT .. Prints data in format like DGS 256 online printout.
C	HEXDUMP  ..... Prints a hex dump for the raw DGS 256 data.
C	INITOPTI ..... Initialize the Okidata 192 printer for Optifont.
C	PRTPREF  ..... Print the drift preface.
C	PRINTAMP ..... Prints spectral amplitudes.
C	PRINTPHASE ... Prints spectral phases.
C	PRINTSTATS ... Prints statistical info.
C	READFILE ..... Read raw DGS 256 data from a file.
C	READINPUT .... Gets the input and control info from user.
C	READTAPE ..... Read raw DGS 256 data from 9-track tape.
C
C
C=======================================================================
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C.....For /CONTROL/
	INTEGER LOCALE,IPRT,ISTAT,CASECLEAN,LINECLEAN,P2,P3,P4,P5,NR2DO
	LOGICAL FINDSRC,PRT,STAT,TEST,FILE,TOSS1
	REAL ZEEMAX,TTIME
	CHARACTER*30 SKYDATAFILE,TESTFILE,STATFILE,STATION
C.....FOR /TIME/
	REAL*8 ENDTIME,LASTTIME,STARTTIME,NOWTIME
	CHARACTER*15 CTIME
C.....FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C.....FOR /CONSTANTS/
	REAL PI
C.....FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C.....For /STATS/
	INTEGER NREJ(4),NQUAL(4),NACPT(4),NTOSS(4),NOUT(4),NSRCS(4),
     +        NBAD,KAMP(0:63),KMAX(7,0:63),KMPA(7,0:63),KPHAS(0:359),
     +        KRMS(0:359),KPDIF(-180:180,6),KERR(21,-100:100)
C.....For /MAPDATA/
	INTEGER*1 MAXAMP(7),MPAMP(7),
     +      MAPAMP(256),MAPDOP(256),MAPRMS(256)
	REAL YMAP(256),XMAP(256)
	LOGICAL*2 TOSSLINE(128,2)
	INTEGER NUMSRC
C.....For /ANTENNA/
	INTEGER*1 JSEQ(7),NANTNO(7)
	REAL YCOORD(7),XCOORD(7),DELX(6,7),SDXSQ,DELY(6,7),SDYSQ,
     +       SDXDY,ANTSEP,ZMAX
C
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
	COMMON/CONTROL/ FINDSRC,PRT,STAT,TEST,FILE,LOCALE,ZEEMAX,TTIME,
     +                SKYDATAFILE,IPRT,ISTAT,CASECLEAN,LINECLEAN,
     +                P2,P3,P4,P5,NR2DO,TESTFILE,STATFILE,STATION,
     +	             TOSS1 
	COMMON/TIME/ STARTTIME,ENDTIME,NOWTIME,CTIME,LASTTIME
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/CONSTANTS/ PI
	COMMON/UNPACKED/ FM,PHI
      COMMON/STATS/ NREJ,NQUAL,NACPT,NTOSS,NOUT,NSRCS,NBAD,KAMP,
     +	   	      KMAX,KMPA,KRMS,KPHAS,KPDIF,KERR
	COMMON/MAPDATA/ NUMSRC,MAXAMP,MPAMP,TOSSLINE,
     +                 YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS
      COMMON/ANTENNA/ JSEQ,NANTNO,YCOORD,XCOORD,DELX,SDXSQ,DELY,SDYSQ,
     +                SDXDY,ANTSEP,ZMAX
 
C
C  	   	 VARIABLE DECLARATION
	INTEGER*2 LTT(11)
	INTEGER NLOCS,TAPESTAT
	INTEGER READST,INIT,SPACER,SPACEF,REWIND,STATUS
	INTEGER IRECTYPE,NMAP,NSKIP,NRPROC,L,Z,T,FILENO,LASTFILENO,
     +     SKYFILENUMBER,HDRFILENUMBER,FILESIZE,PRUNIT,MAXFILESIZE,
     +     I,JI,J,IERR,NRECHK,IHEAD,KASE,NUMCAS,IFF,OUTUNIT,
     +     TESTUNIT,STATUNIT
	REAL*8 PARSETIME
	LOGICAL FOUND,INRANGE,EOF1,GOODDATA,NCASE1
	CHARACTER*35 SKYFILE,HDRFILE
	CHARACTER*17 CTIMELTT,CNTIME
	CHARACTER*4 L17144
C
C
C
C=======================================================================
C	   	   	   INITIALIZE VARIABLES
C
C	Get the program control variables.
	CALL READINPUT()
C	
	PI = 4.0 * ATAN(1.0)
	MAXFILESIZE = 3000000
	SKYFILENUMBER = 50
	HDRFILENUMBER = 49
C
C	INITIALIZE THE TAPE DRIVE (/w 4K buffer)
	TAPESTAT = INIT(4096)
C
C
	IF(STATFILE(1:1).NE.'*') THEN
	   PRUNIT = 11
	   OPEN(UNIT=11,FILE=STATFILE,ACCESS='SEQUENTIAL',MODE='WRITE',
     +        FORM='FORMATTED',STATUS='UNKNOWN')
	ELSE IF (.NOT.FINDSRC) THEN
C	   Open unit # 10 as the printer.
	   PRUNIT = 10
	   OPEN(UNIT=10,FILE='PRN',ACCESS='SEQUENTIAL',
     +        MODE='WRITE',FORM='FORMATTED')
C	   l17144 sets linew spacing to 17/144" for characters.
	   L17144 = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(17)
	   WRITE(PRUNIT,'(1X,A4)') L17144
C
C	   Initialize the printer for Optifont in ASCII character values 
C	     176-185 and 193-198  (1-9,A-F with the high bit set)
	   IF (IPRT.EQ.5) THEN
	      CALL INITOPTI(PRUNIT)
	    ENDIF
	ENDIF
C
	IF (FILE) THEN
	   TESTUNIT = 12
	   OPEN(UNIT=12,FILE=TESTFILE,ACCESS='DIRECT',MODE='READ',
     +        FORM='BINARY',RECL=4096,STATUS='OLD')
	ENDIF
C
C=====SKIP TO FIRST TAPE RECORD WANTED
C	Start searching the tape for the desired date and time.
C	No search if TEST or STARTTIME=0.0
	NSKIP = -1
	IHEAD = 1
	FOUND = .FALSE.
	NOWTIME = 0.0
	LASTTIME = 0.0
	IF ((STARTTIME.GT.0.0).OR..NOT.TEST) THEN
	   WRITE(*,*) ' Searching for desired start time ...'
 100	   CONTINUE
	      IF(FILE) THEN
	         CALL READFILE(TESTUNIT,IBUF,IRECTYPE,EOF1)
	      ELSE
	         CALL READTAPE(IBUF,IRECTYPE,EOF1)
	      ENDIF
	      NSKIP = NSKIP + 1
	      IF (IRECTYPE.EQ.10) THEN
	         CALL PREF256(2,GOODDATA)
	         CNTIME = CTIMELTT(IPREF)
	         WRITE(*,*) ' Time = ',CNTIME
	         FOUND = (NOWTIME.GE.STARTTIME)
	      ENDIF
	   IF (.NOT.FOUND) GOTO 100
	ELSE
	   FOUND = .TRUE.
	   NSKIP = 0
	ENDIF
C	Back the tape up one record  
	TAPESTAT = SPACER()
	NOWTIME = LASTTIME
	LASTTIME = 0.0
	WRITE(*,*) 'Found desired record:'
	WRITE(*,*) 'Skipped ',NSKIP,' records.'
	INRANGE = .TRUE.
C 
C 	   	   	   	   	   	   	   	   	     
C===== MAIN LOOP: PROCESS EACH RECORD OF INPUT DATA ========
C	DO WHILE (INRANGE = TRUE) FOR THE MAIN LOOP
C
	NRPROC = 0
	NMAP = NSKIP
	IHEAD = 0
	LASTTIME = 0.0
CSEG	LASTFILENO = 0
C
C     Open the desired output file (non-segmented file)
C
	IF (FINDSRC) THEN
	   WRITE(SKYFILE,'(2A)') SKYDATAFILE,'.SKY'
	   WRITE(HDRFILE,'(2A)') SKYDATAFILE,'.HDR'
	   OPEN(UNIT=SKYFILENUMBER,FILE=SKYFILE,ACCESS='SEQUENTIAL',
     +        FORM='FORMATTED',STATUS='UNKNOWN',IOSTAT=IERR)
	   OPEN(UNIT=HDRFILENUMBER,FILE=HDRFILE,ACCESS='SEQUENTIAL',
     +        FORM='FORMATTED',STATUS='UNKNOWN',IOSTAT=IERR)
	ENDIF
C
 1000 CONTINUE 
C
C     Open the desired output file (segmented file)
CSEG	FILENO = FILESIZE/MAXFILESIZE + 1
CSEG	IF (FINDSRC.AND.(FILENO.NE.LASTFILENO)) THEN
CSEG	   LASTFILENO = FILENO
CSEG	   CLOSE(UNIT=SKYFILENUMBER)
CSEG	   WRITE(SKYFILE,'(2A,I1)') SKYDATAFILE,'.SK',FILENO
CSEG	   OPEN(UNIT=SKYFILENUMBER,FILE=SKYFILE,ACCESS='SEQUENTIAL',
CSEG   +        FORM='FORMATTED',STATUS='UNKNOWN',IOSTAT=IERR)
CSEG	ENDIF
C
C	Read in the data to be processed.
C
	IF(FILE) THEN
	   CALL READFILE(TESTUNIT,IBUF,IRECTYPE,EOF1)
	ELSE
	   CALL READTAPE(IBUF,IRECTYPE,EOF1)
	ENDIF
	IF (EOF1) GOTO 1290
C
	NMAP = NMAP + 1
C	Skip all non-drift data.
	IF (IRECTYPE.NE.10) GOTO 1000
	GOODDATA = .TRUE.
      CALL PREF256(1,GOODDATA)
	CNTIME = CTIMELTT(IPREF)
	IF (.NOT.GOODDATA) THEN
	   WRITE(*,101) NMAP
 101	   FORMAT (' Data at tape record ',I6,' is bad, Skipping ...')
	ENDIF
C
C	Toss the first case in each group if TOSS1, finding sources,
C     and not TESTing data.
C
	NCASE1 = (NOWTIME-LASTTIME.GT.59)
	IF (FINDSRC.AND.NCASE1.AND.TOSS1) GOODDATA = .FALSE.
	GOODDATA = (GOODDATA.OR.TEST)
	NRPROC = NRPROC + 1
C	 
	IHEAD = 1
	IF ((IPRT.EQ.2).AND.(NRPROC.GT.1)) IHEAD = 0
      IF(PRT.AND.IPRT.LT.5) CALL PRTPREF(IHEAD,NMAP,PRUNIT)
	IF (FINDSRC.AND.(NRPROC.GT.1)) IHEAD = 0
      IF(FINDSRC) CALL PRTPREF(IHEAD,NMAP,HDRFILENUMBER)
C
C	Print the raw hexdump of the data here, if requested.
      IF(IPRT.EQ.1) CALL HEXDUMP(PRUNIT)
C
C=======================================================================
C  CHECK TIME OR NUMBER OF RECORDS PROCESSED TO DETERMINE WHETHER TO STOP. 
C=======================================================================
C
	IF (NRPROC.GE.NR2DO) INRANGE = .FALSE.
	IF (NOWTIME.GE.ENDTIME) INRANGE = .FALSE. 
C 
C===== CALL ANT IF IT HASN'T BEEN CALLED YET FOR THIS ANTENNA OPTION
C 
	L = IPREF(45)
	Z = IPREF(46)
	T = IPREF(47)
C
C
C
C...........MORE CHECKS NEEDED HERE SINCE DRIFT UPGRADE
C
C
	IF (L.NE.LPREF(45)) CALL ANT(LOCALE,L,Z,  NANT,GOODDATA)
	IF (.NOT.GOODDATA) THEN
	   NBAD = NBAD + 1
	   GOTO 1000
	ENDIF
C 
C
      DO 1230 KASE=1,NCASES 
	   NUMCAS = NUMCAS + 1 
	   DO 1230 IFF = 1,NFREQ 
	      CALL PREPDAT(IFF,KASE,CASECLEAN,LINECLEAN,STAT,GOODDATA)
	      IF (IPRT.EQ.3) THEN
	         CALL PRINTAMP(IFF,PRUNIT)
	      ELSE IF (IPRT.EQ.4) THEN
	         CALL PRINTPHASE(IFF,PRUNIT)
	      ELSE IF (IPRT.EQ.5) THEN
	         CALL DGS256PRINT(IFF,P2,P3,P4,P5,PRUNIT)
	      else if (iprt.eq.6) then
	         call apprint(iff,prunit)
	      ENDIF
      	   IF (FINDSRC) THEN
	         CALL SRCLOC(IFF,ZEEMAX,GOODDATA,.FALSE.)
               CALL PRINTMAPDATA(NMAP,IFF,SKYFILENUMBER,FILESIZE,
     +                           GOODDATA)
	         WRITE(*,33) CNTIME,SKYFILE,FILESIZE,NUMSRC
CSEG	         WRITE(*,33) SKYFILE,MOD(FILESIZE,MAXFILESIZE),NUMSRC
	      ELSE IF (STAT) THEN
	         CALL SRCLOC(IFF,ZEEMAX,GOODDATA,.TRUE.)
	         CALL PRINTSTATS(STATION,PRUNIT,ISTAT,TTIME,GOODDATA)
C	         Perform other stat tests here, zero and print when
C				necessary, etc
	      ENDIF
C
 33	FORMAT (' Time: ',A17,' Output file: ',A10,' = ',I8,' bytes. (',
     +         I3,' Sources)')
C
	      IF (IERR.NE.0) THEN
C	         An I/O error has occured.  Simple error-reporting
	         WRITE(*,*) ' I/O error on file ',OUTUNIT
	         WRITE(*,*) ' System error number = ',IERR
	         STOP
	      ENDIF	
 1230 CONTINUE
 1290 CONTINUE
C
C
	IF (EOF1) THEN
	   IF (STAT) CALL PRINTSTATS(STATION,PRUNIT,ISTAT,-1.0,.TRUE.)
	   WRITE(*,1310) NMAP+NSKIP
 1310 	FORMAT(' Tape hit EOF at record # ',I6) 
	ELSE IF (INRANGE)  THEN 
	   GOTO 1000
	ELSE
	   IF (STAT) CALL PRINTSTATS(STATION,PRUNIT,ISTAT,-1.0,.TRUE.)
      	WRITE(*,1320) NMAP+NSKIP 
 1320	   FORMAT(' Data processing ended at tape record #. ',I6)
      	WRITE(*,*) ' There may be more data on the input tape.' 
	ENDIF
	CLOSE(UNIT=SKYFILENUMBER)
	CLOSE(UNIT=HDRFILENUMBER)
	CLOSE(UNIT=PRUNIT)
      END 
C
C  ***********************************************************************

      SUBROUTINE PREF256(NCHC,GOOD)
C 
C	   Unpacks the preface characters from a drift record.
C	NCHC is a switch where:
C	   	= 1 -- Decode all of the preface
C	   	= 2 -- Decode just the first 11 characters (date & time)
C	NMAP  is a tape block number counter.
C

      INTEGER IE,IP,IPEND,SHIFT,NCHC,I,K,K1,K2,ITEMP,IZ3
      INTEGER LFREQ(16),LANT(16),LHITES(16) 
	REAL DB
	REAL*8 PARSETIME
	LOGICAL GOOD
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C	   FOR /TIME/
	REAL*8 ENDTIME,LASTTIME,STARTTIME,NOWTIME
	CHARACTER*15 CTIME
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)

C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
	COMMON/TIME/ STARTTIME,ENDTIME,NOWTIME,CTIME,LASTTIME
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
C
C	Valid                             X       X
C	   L =      0 1 2 3 4 5 6 7 8 9 A B C D E F
      DATA LFREQ /1,2,1,2,1,2,1,2,2,4,2,4,2,1,2,4/ 
      DATA LANT  /1,4,4,8,4,8,1,4,1,4,4,8,4,8,1,4/
      DATA LHITES/2,1,2,1,2,2,8,1,2,1,2,1,2,2,8,1/
C 
      DO 60 IP = 1,89
	   LPREF(IP) = IPREF(IP) 
	   IPREF(IP) = 0
 60	CONTINUE 
C 
C===== DECODE PREFACE BITS (LOWEST BIT OF 8-BIT AMPLITUDES, STARTING
C     AT BYTE 5), AND ENCODE 4 BITS INTO ONE PREFACE CHARACTER. 
C 	104 BYTES IN TOTAL. LSB's COME OUT FIRST.
C	Note that the preface characters are incoded into the LSB's of
C	the amplitudes ONLY.  The arrangement of the data is 128 Amps,
C	128 Phases, 128 Amps, 128 Phases, etc.  This means that the first
C	31 Preface characters come from the bytes 1-128, the next 32
C	from bytes 257-384 and the last 26 preface characters come from
C	bytes 513-616 in the IBUF buffer.
C
      IPEND=89
      IF(NCHC.EQ.2) IPEND=11
C 
      DO 100 IP = 1,IPEND 
	   IE = 4*IP+1
C	   Preface characters 32-64 found in bytes 257-384
	   IF (IP.GT.31) IE = IE + 128
C	   Preface characters 64-89 found in bytes 513-616 
	   IF (IP.GT.63) IE = IE + 128
	   DO 80 I = 0,3 
	   	IPREF(IP) = IPREF(IP) + IAND(IBUF(IE+I),1)*2**I
 80	   CONTINUE
 100	CONTINUE
C 
C
	LASTTIME = NOWTIME
	NOWTIME = PARSETIME(IPREF)
	WRITE(CTIME,33) (IPREF(I),I=1,11)
 33	FORMAT (2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
      IF(NCHC.EQ.2) RETURN
C
C	Do some checking of the preface for valid information. 
	IL = IPREF(45)
	IZ = IPREF(46)
	IZ3 = IAND(IZ,3)
	IF(IZ.LT.8) DB=20./1.5
	IF(IZ.GE.8) DB=20.
	IT3 = 0
	IF (IAND(IPREF(47),8) .NE.0) IT3 = 1
      IN=IPREF(48) 
      IREP=50*2**((IPREF(49)+1)/2)
      NFREQ=LFREQ(IL+1)
C.....Check for valid L,Z,N
	GOOD = .FALSE.
	IF ((IL.EQ.11).AND.(IZ3.EQ.2.OR.IZ3.EQ.1).AND.(IN.EQ.5))
     +                              GOOD = .TRUE.
	IF ((IL.EQ.15).AND.(IZ3.LT.2).AND.(IN.EQ.5.OR.IN.EQ.6)) 
     +                              GOOD = .TRUE.
      NANTDAT=LANT(IL+1)
      NHITES=LHITES(IL+1) 
      NCHAN=NANTDAT*NFREQ*NHITES 
      NSMPLS=32*(2**(IAND(IN,3)))
      NPULSES=NCHAN 
      IF(NHITES.GT.1) NPULSES=NCHAN/2 
C 
      NDOPP=NSMPLS/(2*(1+IT3))
      IF(NCHAN*NDOPP.NE.0) NCASES=1024/(NCHAN*NDOPP) 
C 
C
	IF(.NOT.GOOD) WRITE(*,101) IL,IZ,IT3,IN
 101	FORMAT (' Something Amiss in the Preface (LZTN = ',4Z1,')')
C
      IF(NHITES.GT.1) WRITE(*,*) ' NOT PROGRAMMED FOR NHITES > 1' 
      IF (NHITES.GT.1)  GOOD = .FALSE.
C 
      DO 200 K=1,NFREQ
	   PREFRQ(K)=FREQ(K) 
	   FREQ(K)=0.
	   PRERNG(K)=RANG(K) 
	   RANG(K)=0.
	   LASTGN(K)=IGAIN(K)
	   IGAIN(K)=0
 200	CONTINUE
C 
      K1=54 
      DO 210 K=1,NFREQ 
      	K1=K1+4 
      	K2=K1+2 
      	CALL ENCOD(1,IPREF,K1,K2,ITEMP) 
      	RANG(K)=ITEMP 
      	K1=K1+3 
      	IGAIN(K)=6*IPREF(K1)
      	K1=K1+1 
      	K2=K1+3 
      	CALL ENCOD(1,IPREF,K1,K2,ITEMP) 
      	FREQ(K)=ITEMP*10
      	FREQ(K)=FREQ(K)+2.5 
      	IF(FREQ(K).GT.40000.) FREQ(K)=FREQ(K)-39995.
  210 CONTINUE
C 
      RETURN
      END 
C
C =========================================================================
C 
      SUBROUTINE ANT(LOCATION,L,Z, NA,GOOD) 
C
C	Determines the antenna pattern/setup for the particular LOCATION.
C	The following locations are currently valid:
C	   	   	   1) Goose Bay, Labrador.
C	   	   	   2) Ramey, Puerto Rico
C	   	   	   3) Thule, Greenland since March 1985
C	   	   	   4) Millstone Hill, Massachusetts
C	   	   	   5) Sondre Stromfjord, Greenland.
C	   	   	   6) Erie, Colorado
C	   	   	   7) Qaanaaq, Greenland
C	   	   	   8) Argentia, Newfoundland
C	               9) Wallops Island, Virginia
C	              10) Standard Antenna Array.

C	L,Z,and N are Digisonde control parameters
C	NA     = Number of antennas used
C 
	INTEGER LOCATION,T,KT,L,Z,Z1,NF,NA,MAXANT,MXANT,MXNF,
     +        J,JS,N1,JJ,J1
      INTEGER AN(5,8),KTASK(16,3)
	LOGICAL GOOD
C
C	VARIABLES FOR THE COMMON BLOCKS
C	For /ANTENNA/
	INTEGER*1 JSEQ(7),NANTNO(7)
	REAL YCOORD(7),XCOORD(7),DELX(6,7),SDXSQ,DELY(6,7),SDYSQ,
     +       SDXDY,ANTSEP,ZMAX
C
C	         COMMON BLOCKINGS
      COMMON/ANTENNA/ JSEQ,NANTNO,YCOORD,XCOORD,DELX,SDXSQ,DELY,SDYSQ,
     +                SDXDY,ANTSEP,ZMAX
 
C=======================================================================
C ANTENNA COORD IN METERS 
C X AXIS=NORTH=AZIMUTH ZERO DEG 
C (-Y) AXIS=EAST=AZIMUTH 90 DEG 
C   YCOORD= Y COORDINATES 
C   XCOORD= X COORDINATES 
C   (YGOOSE= Y COORDINATES AT GOOSE BAY, ETC.)
C
C DGS256: DEFINE 7 COORD.  IF ONLY 4 ANTENNAS EXIST, DEFINE COORD.
C         FOR ANT. 2,3 AND 4 AS 999.; THE 4 ANTENNAS ARE THE 4 OUTER
C         ANTENNAS (1,5,6,7). 
C 
C AN(KT,JS)=ANTENNA NUMBER OR 98 OR 99
C    KT INDICATES THE DRIFT TASK
C    INDEX JS=1,2,... 
C            =SEQUENCE NUMBERS IDENTIFYING THE ORDER OF THE 
C             DATA ON TAPE
C    AN(KT,JS)=98: ANTENNA DATA IS ON TAPE BUT IS NOT USED
C             =99: END OF SEQUENCE
C 
C FOR J=1,NA (NA=NUMBER OF ANTENNAS USED):  
C    JSEQ(J)=JS=THE SEQUENCE NUMBERS OF THE ANTENNA DATA USED 
C               E.G. FOR KT=5: 2 TO 8 
C    NANTNO(J)=THE ANTENNA NUMBERS FOR THE ANTENNA DATA USED
C              E.G. FOR KT=5: 1 TO 7
C 
C DGS256 (KT=2 TO 17
C           =IL+2, IL=0,15):  
C   KT=3,4,11,12 (IL=1,2,9,10): 4 INNER ANTENNAS (1,2,3,4)
C   KT=6,9,14,17 (IL=4,7,12,15): 4 OUTER ANTENNAS (1,5,6,7) 
C   KT=5,7,13,15 (IL=3,5,11,13): 8 ANTENNAS RECORDED; USE ONLY LAST 7 
C=======================================================================
C
C *********THIS IS ONLY CORRECT FOR :
C********** L=B,Z=2 or L=F,Z=0,1:
      DATA KTASK/0,2,2,3,2,3,3,2,0,0,0,3,2,0,0,2, 
     +           0,1,1,3,1,3,3,1,0,0,0,3,1,0,0,1,
     +           0,0,0,3,0,0,0,0,0,0,0,3,0,0,0,0/ 
      DATA(AN(1,JS),JS=1,5)/1,2,3,4,99/ 
      DATA(AN(2,JS),JS=1,5)/1,5,6,7,99/ 
      DATA(AN(3,JS),JS=1,8)/98,1,2,3,4,5,6,7/ 
      DATA(AN(4,JS),JS=1,8)/98,1,98,98,98,5,6,7/
      DATA(AN(5,JS),JS=1,8)/1,2,3,4,5,6,7,99/ 
 
	IF (LOCATION.EQ.1) THEN
C	   Goose Bay, Labrador.  4 antennas only.
	   WRITE(*,*) ' Goose Bay coordinates are COMPASS' 
	   XCOORD(1) =   0.00
	   YCOORD(1) =   0.00
	   XCOORD(2) =   0.00
	   YCOORD(2) =  57.74
	   XCOORD(3) = -50.00
	   YCOORD(3) = -28.87
	   XCOORD(4) =  50.00
	   YCOORD(4) = -28.87
	   XCOORD(5) = 999.00000
	   YCOORD(5) = 999.00000
	   XCOORD(6) = 999.00000
	   YCOORD(6) = 999.00000
	   XCOORD(7) = 999.00000
	   YCOORD(7) = 999.00000

	ELSE IF (LOCATION.EQ.2) THEN
C	      Ramey DISS, Puerto Rico
C	      Magnetic Declination is 10 degrees west of True North.
	   WRITE(*,*) ' Ramey coordinates are GEOGRAPHIC' 
	   XCOORD(1) =   0.00
	   YCOORD(1) =   0.00
	   XCOORD(2) =  11.40
	   YCOORD(2) =  31.33
	   XCOORD(3) = -32.82
	   YCOORD(3) = - 5.79
	   XCOORD(4) =  21.43
	   YCOORD(4) = -25.54
	   XCOORD(5) =  44.23
	   YCOORD(5) =  37.11
	   XCOORD(6) = -54.25
	   YCOORD(6) =  19.75
	   XCOORD(7) =  10.03
	   YCOORD(7) = -56.86
	ELSE IF (LOCATION.EQ.3) THEN
C	      Thule, Greenland since March, 1985
	   WRITE(*,*) ' Thule coordinates are GEOMAGNETIC.' 
	   XCOORD(1) =   0.00
	   YCOORD(1) =   0.00
	   XCOORD(2) = -14.48
	   YCOORD(2) =  51.02
	   XCOORD(3) = -44.54
	   YCOORD(3) = -51.97
	   XCOORD(4) =  52.64
	   YCOORD(4) =  -6.50
	   XCOORD(5) = 999.00000
	   YCOORD(5) = 999.00000
	   XCOORD(6) = 999.00000
	   YCOORD(6) = 999.00000
	   XCOORD(7) = 999.00000
	   YCOORD(7) = 999.00000
	ELSE IF (LOCATION.EQ.4) THEN
C	      Millstone Hill, Mass.  
C	      Magnetic declination is 13.3 deg West of True North.
	   WRITE(*,*) ' Millstone coordinates are GEOGRAPHIC.'
	   XCOORD(1) =   0.00
	   YCOORD(1) =   0.00
	   XCOORD(2) =  22.86
	   YCOORD(2) = -24.26
	   XCOORD(3) = -32.44
	   YCOORD(3) = - 7.67
	   XCOORD(4) =   9.58
	   YCOORD(4) =  31.93
	   XCOORD(5) =  55.30
	   YCOORD(5) = -16.59
	   XCOORD(6) = -42.02
	   YCOORD(6) = -39.60
	   XCOORD(7) = -13.28
	   YCOORD(7) =  56.19
	ELSE IF (LOCATION.EQ.5) THEN
C	      Sondre Stromfjord.  Magnetic Variation is 41.2 deg West of True.
C	               Corrected Geomagnetic Variation is 19 deg West of True.
	   WRITE(*,*)' Sondre Stromfjord coordinates are GEOGRAPHIC.'
	   XCOORD(1) =   0.00
	   YCOORD(1) =   0.00
	   XCOORD(2) =  -6.47
	   YCOORD(2) =  32.70  
	   XCOORD(3) = -25.08 
	   YCOORD(3) = -21.95
	   XCOORD(4) =  31.56 
	   YCOORD(4) = -10.74
	   XCOORD(5) =  18.60
	   YCOORD(5) =  54.66 
	   XCOORD(6) = -56.64 
	   YCOORD(6) = -11.21 
	   XCOORD(7) =  38.03 
	   YCOORD(7) = -43.44 
	ELSE IF (LOCATION.EQ.6) THEN
C	      Erie, Colorado
	   WRITE(*,*) ' Erie coordinates are COMPASS.' 
	   XCOORD(1) =   0.00000
	   YCOORD(1) =   0.00000
	   XCOORD(2) = 999.00000
	   YCOORD(2) = 999.00000
	   XCOORD(3) = 999.00000
	   YCOORD(3) = 999.00000
	   XCOORD(4) = 999.00000
	   YCOORD(4) = 999.00000
	   XCOORD(5) =  50.00000
	   YCOORD(5) = -28.86751
	   XCOORD(6) =   0.00000
	   YCOORD(6) =  57.73504			
	   XCOORD(7) = -50.00000
	   YCOORD(7) = -28.86751
	ELSE IF (LOCATION.EQ.7) THEN
C	      Qaanaaq, Greenland
	   WRITE(*,*) ' Qaanaaq coordinates are GEOMAGNETIC.' 
	   XCOORD(1) =   0.00000
	   YCOORD(1) =   0.00000
	   XCOORD(2) =  -7.49837
	   YCOORD(2) =  32.47900
	   XCOORD(3) = -24.37846
	   YCOORD(3) = -22.73328
	   XCOORD(4) =  31.87683
	   YCOORD(4) =  -9.74572
	   XCOORD(5) =  16.88009
	   YCOORD(5) =  55.21228
	   XCOORD(6) = -56.25528
	   YCOORD(6) = -12.98756
	   XCOORD(7) =  39.37519
	   YCOORD(7) = -42.22473
	ELSE IF (LOCATION.EQ.8) THEN
C	      Argentia, Newfoundland
	   WRITE(*,*) ' Argentia coordinates are COMPASS.' 
	   XCOORD(1) =   0.00000
	   YCOORD(1) =   0.00000
	   XCOORD(2) =  16.66667
	   YCOORD(2) =  28.86751
	   XCOORD(3) = -33.33333
	   YCOORD(3) =   0.00000
	   XCOORD(4) =  16.66667
	   YCOORD(4) = -28.86751
	   XCOORD(5) =  50.00000
	   YCOORD(5) =  28.86751
	   XCOORD(6) = -50.00000
	   YCOORD(6) =  28.86751
	   XCOORD(7) =   0.00000
	   YCOORD(7) = -57.73503
	ELSE IF (LOCATION.EQ.9) THEN
C	      Wallops Island, VA.
	   WRITE(*,*) ' Wallops Island coordinates are COMPASS.' 
	   XCOORD(1) =   0.00000
	   YCOORD(1) =   0.00000
	   XCOORD(2) =  16.66667
	   YCOORD(2) =  28.86751
	   XCOORD(3) = -33.33333
	   YCOORD(3) =   0.00000
	   XCOORD(4) =  16.66667
	   YCOORD(4) = -28.86751
	   XCOORD(5) =  50.00000
	   YCOORD(5) =  28.86751
	   XCOORD(6) = -50.00000
	   YCOORD(6) =  28.86751
	   XCOORD(7) =   0.00000
	   YCOORD(7) = -57.73503
	ELSE IF (LOCATION.EQ.10) THEN
C	      Standard Antenna Array.
C	   WRITE(*,*) ' Standard Antenna coordinates are UNDEFINED.'
	   XCOORD(1) =   0.00000
	   YCOORD(1) =   0.00000
	   XCOORD(2) =  16.66667
	   YCOORD(2) =  28.86751
	   XCOORD(3) = -33.33333
	   YCOORD(3) =   0.00000
	   XCOORD(4) =  16.66667
	   YCOORD(4) = -28.86751
	   XCOORD(5) =  50.00000
	   YCOORD(5) =  28.86751
	   XCOORD(6) = -50.00000
	   YCOORD(6) =  28.86751
	   XCOORD(7) =   0.00000
	   YCOORD(7) = -57.73503
	ELSE
	   WRITE(*,*) 'Error -- Location #',LOCATION,' not defined.'
	ENDIF
C  
	Z1 = IAND(Z,3) 
      KT = KTASK(L+1,Z1+1) 
      IF (((LOCATION.EQ.5).OR.(LOCATION.EQ.6)).AND.KT.EQ.3) KT=4
      IF(KT.EQ.0) THEN
	   WRITE(*,*) ' NOT PROGRAMMED FOR L=',L,',Z=',Z
	   GOOD = .FALSE.
	   RETURN
	ENDIF 
C 
      J=0 
      DO 20 JS=1,8
	   IF (AN(KT,JS).EQ.99) GOTO 30
	   IF (AN(KT,JS).LT.98) THEN
	      J=J+1 
            JSEQ(J)=JS
            NA=J
            NANTNO(J)=AN(KT,JS) 
            IF((YCOORD(NANTNO(J)).EQ.999.)
     +         .AND.(XCOORD(NANTNO(J)).EQ.999.)) THEN 
               WRITE(*,*) ' ERROR IN ANTENNA SPECIFICATION.'
	         GOOD = .FALSE.
	         RETURN
	      ENDIF 
	   ENDIF
   20 CONTINUE
C 
C===== ANTSEP (METERS) IS THE ANTENNA SEPARATION BETWEEN THE 2ND AND
C      3RD ANTENNAS USED (EQUALS SEPARATION BETWEEN 3RD AND 4TH, OR 
C      4TH AND 2ND).  THIS SEPARATION DETERMINES THE SEPARATION BET-
C      WEEN MAJOR LOBES, AND IS USED IN SUBROUTINE SRCLOC TO DETERMINE
C      THE MAXIMUM ZENITH ANGLE ZMAX FOR THE SKYMAP.
C 
 30	ANTSEP=SQRT(((YCOORD(NANTNO(2))-YCOORD(NANTNO(3)))**2)+ 
     +   ((XCOORD(NANTNO(2))-XCOORD(NANTNO(3)))**2)) 
C 
C===== DELX(JJ,J)=[X(J)-X(JJ)],  X(J)=X-COORDINATE OF ANTENNA-
C                                POSITION VECTOR A(J).
C      SDXSQ=DOUBLE SUM OF DELX(JJ,J)**2, OVER JJ=1,(NA-1)
C                                          AND J=(JJ+1),NA
C            (NA=NUMBER OF ANTENNAS). E.G. FOR 7 ANTENNAS: (JJ,J)=
C            (1,2),(1,3),...,(1,7),(2,3),(2,4),...,(2,7),...,(6,7). 
C      SIMILARLY FOR DELY,SDYSQ,SDXDY.
C      THEY ARE USED IN SUBROUTINE SRCLOC TO DETERMINE THE SOURCE 
C      LOCATIONS (SEE FURTHER COMMENTS IN SRCLOC).
C 
      N1 = NA-1 
      SDXSQ = 0.0
	SDXDY = 0.0
	SDYSQ = 0.0
      DO 40 JJ=1,N1 
         J1 = JJ+1 
         DO 40 J = J1,NA 
            DELX(JJ,J)=(XCOORD(NANTNO(J))-XCOORD(NANTNO(JJ))) 
            SDXSQ=SDXSQ+DELX(JJ,J)**2 
            DELY(JJ,J)=(YCOORD(NANTNO(J))-YCOORD(NANTNO(JJ))) 
            SDYSQ=SDYSQ+DELY(JJ,J)**2 
            SDXDY=SDXDY+DELX(JJ,J)*DELY(JJ,J) 
   40 CONTINUE
C 
      RETURN
      END 
C 
C =========================================================================
C 
      SUBROUTINE SRCLOC(IFF,ZEEMAX,GOOD,STATS)
C 
C===== CALCULATES THE SOURCE LOCATIONS
C
	INTEGER IFF,NTWOPI,NTIMES,I,J,JMAX,NDX,TERMS,JJJ,IERR,
     +        IDOPP,IROUND,N,N1,JJ,J1,K,IRAD
	REAL WAVELEN,ABSK,SINZMAX,TWOPI,RAD,RADT5,WSCALE,
     +     SUM,SUM234,SUM567,PHIMAX,SPHIDX,SPHIDY,SPHISQ,SRCKX,SRCKY,
     +     XIX,YIY,ESQ,RMS,PHI12,PHI13,PHI14,PHI25,PHI36,PHI47,
     +     SDPHIDX,SDPHIDY,SDPHISQ,DENOM,AMP,ZEEMAX
      REAL DELPHI(6,7),ERR(6,7)
	LOGICAL GOOD,STATS
C
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C	   FOR /CONSTANTS/
	REAL PI
C	   FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C     For /STATS/
	INTEGER NREJ(4),NQUAL(4),NACPT(4),NTOSS(4),NOUT(4),NSRCS(4),
     +        NBAD,KAMP(0:63),KMAX(7,0:63),KMPA(7,0:63),KPHAS(0:359),
     +        KRMS(0:359),KPDIF(-180:180,6),KERR(21,-100:100)
C	For /MAPDATA/
	INTEGER*1 MAXAMP(7),MPAMP(7),
     +           MAPAMP(256),MAPDOP(256),MAPRMS(256)
	REAL YMAP(256),XMAP(256)
	LOGICAL*2 TOSSLINE(128,2)
	INTEGER NUMSRC
C	For /ANTENNA/
	INTEGER*1 JSEQ(7),NANTNO(7)
	REAL YCOORD(7),XCOORD(7),DELX(6,7),SDXSQ,DELY(6,7),SDYSQ,
     +       SDXDY,ANTSEP,ZMAX
 
C
C
C	   	COMMON BLOCKINGS
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/CONSTANTS/ PI
	COMMON/UNPACKED/ FM,PHI
      COMMON/STATS/ NREJ,NQUAL,NACPT,NTOSS,NOUT,NSRCS,NBAD,KAMP,
     +	   	      KMAX,KMPA,KRMS,KPHAS,KPDIF,KERR
	COMMON/MAPDATA/ NUMSRC,MAXAMP,MPAMP,TOSSLINE,
     +                 YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS
      COMMON/ANTENNA/ JSEQ,NANTNO,YCOORD,XCOORD,DELX,SDXSQ,DELY,SDYSQ,
     +                SDXDY,ANTSEP,ZMAX
 
C
	NUMSRC = 0
	RAD = PI/180.
	RADT5 = 5.0*RAD
	TWOPI = 2.0*PI
C 
	IF (FREQ(IFF).NE.0) THEN
         WAVELEN = 299792.5/FREQ(IFF)
	ELSE
	   WRITE(*,*) 'SRCLOC -- Divide by zero FREQ(',IFF,')'
	   WAVELEN = 1.0
	ENDIF
      ABSK = TWOPI/WAVELEN
      IF(ZEEMAX.EQ.0.0)  THEN
	   IF (ANTSEP.NE.0) THEN 
	      SINZMAX = WAVELEN/ANTSEP
	   ELSE
	      WRITE(*,*) 'SRCLOC -- Divide by zero ANTSEP'
	      SINZMAX = 0.5000
	   ENDIF
	ELSE
	   SINZMAX = SIN(ZEEMAX*RAD)
	ENDIF 
      IF(SINZMAX.GT.1.00.AND.ZEEMAX.EQ.0.) SINZMAX = 1.00
      ZMAX=ASIN(SINZMAX)/RAD
      WSCALE = ABSK*SINZMAX/20.
C
	NUMSRC = 0
	IF (.NOT.GOOD) RETURN
C 
C=======================================================================
C THIS SUBROUTINE CALCULATES THE SOURCE LOCATIONS AS A FUNCTION OF
C THE COORDINATES OF A "SKYMAP". 
C FOR EACH SPECTRAL LINE, THE SOURCE LOCATION WITH AMPLITUDE MSPD 
C IS DEFINED AS MSPD(YIY,XIX), WHERE
C       MAP COORDINATES YIY,XIX=+20,..., 0,...,-20
C ***** NOTE: +YIY=WEST; +XIX=NORTH 
C THE MAXIMUM ZENITH ANGLE ZMAX (THE ZENITH ANGLE AT THE CORNERS
C OF THE SQUARE MAP) IS LIMITED TO
C     SINZMAX=SIN(ZMAX)=WAVELENGTH/ANTSEP 
C (ANTSEP IS DEFINED IN SUBROUTINE ANT) WITH UPPER LIMIT OF 
C 1.00=SIN(90 DEG).  ZMAX CAN BE FURTHER LIMITED BY INPUTTING
C ZEEMAX=NON-ZERO AT THE BEGINNING OF THE RUN.
C ANY SOURCE OUTSIDE OF ZMAX 
C IS OUTSIDE OF THE FIRST GRATING LOBE AND IS ALIASED INTO 
C THE REGION WITHIN ZMAX. 
C WAVELENGTH IN METERS. SEE BELOW ABOUT WSCALE. 
C=======================================================================
C
C
C	Process negative Dopplers first, then positive.
      DO 200 ISIGN=1,2
C 
C 
C===== LOOP 170: PROCESS EACH SPECTRAL LINE ============================
C	   ISIGN = 1 for -Dopp makes the index I run from 127 -> 1 (-> 0)
C	   ISIGN = 2 for +Dopp makes the index I run from 1 -> 127 (0 ->)
C
C	   This processes the Doppler lines from the most negative, through
C	   zero and on to the most positive.
C
   35 IF(ISIGN.EQ.1) THEN
         I = NDOPP + 1
	ELSE
	   I = 0
	ENDIF
C
      DO 170 IDOPP = 1,NDOPP
         IF(ISIGN.EQ.1) THEN 
	      I = I - 1
	   ELSE
            I = I + 1
	   ENDIF
C
C	Processing Doppler line I
C 
C	If the value of TOSSLINE is true for this Doppler line (I)
C	  (sign and number) then do not calculate a source for the line.
C
	IF (TOSSLINE(I,ISIGN)) THEN 
C	  Skip this Doppler line on the basis of SNR
	   NREJ(IFF) = NREJ(IFF) + 1
         GOTO 170
	ENDIF 
	NACPT(IFF) = NACPT(IFF) + 1
C 
C=======================================================================
C CONSIDER THE 4 INNER ANTENNAS: FROM THE SYMMETRY OF THE ANTENNA ARRAY,
C       -K*[A(2)+A(3)+A(4)-3*A(1)]=PHI(2)+PHI(3)+PHI(4)-3*PHI(1)=0, 
C          (NOTE: SAME EQUATION APPLIES FOR ANTS 5,6,7 AND 1) 
C WHERE K*A(J)=PHASE AT ANT J OF SOURCE WITH DOPPLER I; 
C       K=WAVE PROPAGATION VECTOR;
C       *=DOT PRODUCT;
C       PHI(J)=MEASURED PHASE AT ANTENNA J; 
C       A(J)=POSITION VECTOR OF ANTENNA J.
C THE MEASURED PHASES PHI(J) ARE ALL POSITIVE, SO IF -K*A(J) IS 
C NEGATIVE, PHI(J) IS TOO LARGE AND MUST BE DECREMENTED BY 2PI FOR
C THE ABOVE EQUATIONS TO HOLD.
C LET SUM=SUM[PHI(J)-PHI(1)],J=2,3,4: THERE ARE 5 INDEPENDENT 
C     POSSIBILITIES, WITH PHI BEING TOO LARGE FOR:  
C      ("SUM=" MEANS SUM IS APPROXIMATELY EQUAL TO) 
C       NO ANTENNAS                 IF SUM=    0   (NTWOPI= 0); 
C       1 OUTER ANT                 IF SUM=  2PI   (NTWOPI= 1); 
C       1 OUTER ANT AND CENTER ANT  IF SUM= -4PI   (NTWOPI=-2); 
C       2 OUTER ANTS                IF SUM=  4PI   (NTWOPI= 2); 
C       2 OUTER ANTS AND CENTER ANT IF SUM= -2PI   (NTWOPI=-1). 
C CORRECT THE PHASE PHI OF THE CENTER ANT AND/OR THE OUTER ANTENNA WITH 
C THE LARGEST PHASE AND/OR THE 2 OUTER ANTS WITH THE LARGEST PHASES.
C=======================================================================
C 
         SUM = 0.0 
         DO 410 J = 2,4
  410    SUM = SUM + PHI(I,J,ISIGN)-PHI(I,1,ISIGN)
	   NTWOPI = IROUND(SUM/TWOPI) 
         IF(IABS(NTWOPI).GT.2) THEN
	      NQUAL(IFF)=NQUAL(IFF)+1
            GO TO 170
	   ENDIF
C
         IF(NTWOPI.NE.0) THEN
C	      Phases need correcting 
            IF(NTWOPI.LT.0) PHI(I,1,ISIGN)=PHI(I,1,ISIGN) - TWOPI 
             NTIMES=1
            IF(NTWOPI.EQ.-1.OR.NTWOPI.EQ.2) NTIMES=2
            DO 430 N=1,NTIMES 
               PHIMAX=PHI(I,2,ISIGN) 
               JMAX=2
               DO 420 J=3,4
                  IF(PHI(I,J,ISIGN).GE.PHIMAX) THEN
                     PHIMAX=PHI(I,J,ISIGN) 
                     JMAX=J
	            ENDIF
  420          CONTINUE
            PHI(I,JMAX,ISIGN) = PHI(I,JMAX,ISIGN) - TWOPI
  430       CONTINUE				 
	   ENDIF
C 
C===== WITH THE CORRECTED PHASES, DETERMINE SUM[PHI(J)-PHI(1)],J=2,3,4; 
C      ROUND THE SUM TO NEAREST 1 DEG, AND KEEP KOUNT OF NO. OF 
C      OCCURRENCES OF EACH SUM IN KPDIF(x,1).
C      (INCLUDE VALUES ABOVE +/- 180 DEGREES WITH +/- 180 DEGREES.) 
C 
	   SUM234 = 0.0
         DO 431 J=2,4
 431	   SUM234 = SUM234 + PHI(I,J,ISIGN)
         SUM = SUM234 - 3.0*PHI(I,1,ISIGN) 
         IF(ABS(SUM).GE.PI) THEN
            NQUAL(IFF)=NQUAL(IFF)+1 
            GO TO 170
	   ENDIF 
	   IF (STATS) THEN
	      NDX = IRAD(SUM,-180,180)
            KPDIF(NDX,1) = KPDIF(NDX,1) + 1 
	   ENDIF
C 
C=======================================================================
C CORRECT THE MEASURED PHASES OF ANTENNAS 5,6,7 USING THE FACT THAT 
C     K*[A(3)-A(1)] = K*[A(2)-A(5)] 
C     K*[A(4)-A(1)] = K*[A(3)-A(6)] 
C     K*[A(2)-A(1)] = K*[A(4)-A(7)] 
C=======================================================================
C 
         IF(NANT.GT.4) THEN
            PHI12=PHI(I,1,ISIGN)-PHI(I,2,ISIGN) 
            PHI13=PHI(I,1,ISIGN)-PHI(I,3,ISIGN) 
            PHI14=PHI(I,1,ISIGN)-PHI(I,4,ISIGN) 
            PHI25=PHI(I,2,ISIGN)-PHI(I,5,ISIGN) 
            PHI36=PHI(I,3,ISIGN)-PHI(I,6,ISIGN) 
            PHI47=PHI(I,4,ISIGN)-PHI(I,7,ISIGN) 
            SUM = PHI13 + PHI25 
	      NTWOPI = IROUND(SUM/TWOPI)
            PHI(I,5,ISIGN) = PHI(I,5,ISIGN) + NTWOPI*TWOPI
            SUM = PHI14 + PHI36 
	      NTWOPI = IROUND(SUM/TWOPI)
            PHI(I,6,ISIGN) = PHI(I,6,ISIGN) + NTWOPI*TWOPI
            SUM = PHI12 + PHI47 	 
	      NTWOPI = IROUND(SUM/TWOPI)
            PHI(I,7,ISIGN) = PHI(I,7,ISIGN) + NTWOPI*TWOPI
C 	   	   	   	   	 
C===== WITH THE CORRECTED PHASES, DETERMINE SUM[PHI(J)-PHI(1)],J=5,6,7; 
C      SEE ABOVE, IN REFERENCE TO THE SAME SUM WITH J=2,3,4.
C      ALSO COMPARE SUM[PHI(J)] WITH J=2,3,4 VERSUS THE SUM WITH
C      J=5,6,7; ALSO COMPARE PHI(2)-PHI(1) VS PHI(4)-PHI(7);ETC.
C   NOTE: SOME OF THESE COMPARISONS ARE NOT USED REGULARLY; WHEN
C         IT IS SUSPECTED THAT ONE ANTENNA IS BAD, THEY CAN BE USED 
C         TO TRY TO DETERMINE WHICH IS THE BAD ANTENNA. 
C 
            SUM567=0
            DO 432 J=5,7
  432       SUM567 = SUM567 + PHI(I,J,ISIGN)
            SUM = SUM567 - 3*PHI(I,1,ISIGN) 
            IF(ABS(SUM).GE.PI) THEN
	         NQUAL(IFF)=NQUAL(IFF)+1 
	         GOTO 170
	      ENDIF
	      IF (STATS) THEN
	         NDX = IRAD(SUM,-180,180)
               KPDIF(NDX,2) = KPDIF(NDX,2) + 1 
	      ENDIF
C 
	      SUM = SUM234 - SUM567 
	      IF(ABS(SUM).GE.PI) THEN
               NQUAL(IFF) = NQUAL(IFF) + 1 
               GO TO 170 
	      ENDIF
	      IF (STATS) THEN
	         NDX = IRAD(SUM,-180,180)
               KPDIF(NDX,6) = KPDIF(NDX,6) + 1 
	         PHI25=PHI(I,2,ISIGN)-PHI(I,5,ISIGN) 
	         PHI36=PHI(I,3,ISIGN)-PHI(I,6,ISIGN) 
	         PHI47=PHI(I,4,ISIGN)-PHI(I,7,ISIGN) 
	         SUM = PHI12 + PHI47 
	         NDX = IRAD(SUM,-180,180)
	         KPDIF(NDX,3) = KPDIF(NDX,3) + 1 
	         SUM = PHI13 + PHI25 
	         NDX = IRAD(SUM,-180,180)
	         KPDIF(NDX,4) = KPDIF(NDX,4) + 1 
	         SUM = PHI14 + PHI36 
	         NDX = IRAD(SUM,-180,180)
	         KPDIF(NDX,5) = KPDIF(NDX,5) + 1 
	      ENDIF
	   ENDIF
C	   Finished with the antennas > #4 
C 
C=======================================================================
C USE LEAST-SQUARE FITTING TO DETERMINE THE SOURCE LOCATION.
C 
C     NANT-1 NANT                                         2 
C ESQ= SUM   SUM    [ -K*[A(J)-A(JJ)] - [PHI(J)-PHI(JJ)] ] /TERMS 
C      JJ=1  J=JJ+1 
C 
C                                                         2 
C    = SUM [ -KX*DELX(JJ,J)-KY*DELY(JJ,J) - DELPHI(JJ,J) ] /TERMS 
C     JJ,J
C             ESQ=LEAST-SQUARE ERROR
C             NANT=NUMBER OF ANTENNAS 
C             KX,KY=X,Y COMPONENTS OF K (CALLED SRCKX,SRCKY BELOW)
C             DELX,DELY DEFINED IN SUBROUTINE ANT 
C             TERMS=NUMBER OF TERMS IN THE SUM E.G. TERMS=21 FOR 7 ANTS 
C TAKING DERIVATIVES OF ESQ W.R.T. KX AND KY AND SETTING THEM TO
C ZERO YIELDS:  
C    KX*SUM(DELX**2)   + KY*SUM(DELX*DELY) = -SUM(DELPHI*DELX)
C    KX*SUM(DELX*DELY) + KY*SUM(DELY**2)   = -SUM(DELPHI*DELY)
C (AGAIN SUMS ARE DOUBLE SUMS OVER JJ AND J)
C FROM WHICH KX AND KY ARE DETERMINED.
C=======================================================================
C 
	   N1 = NANT-1 
         SDPHIDX = 0.0
	   SDPHIDY = 0.0
       	SDPHISQ = 0.0
         TERMS = 0
C 
         DO 80 JJ=1,N1 
            J1=JJ+1 
            DO 80 J=J1,NANT 
               SDPHISQ = SDPHISQ + (PHI(I,J,ISIGN)-PHI(I,JJ,ISIGN))**2 
               DELPHI(JJ,J) = PHI(I,J,ISIGN) - PHI(I,JJ,ISIGN) 
               SDPHIDX=SDPHIDX+DELPHI(JJ,J)*DELX(JJ,J) 
               SDPHIDY=SDPHIDY+DELPHI(JJ,J)*DELY(JJ,J) 
               TERMS = TERMS + 1 
   80    CONTINUE
C 
         DENOM=SDXSQ*SDYSQ-SDXDY*SDXDY 
	   IF(DENOM.NE.0.0) THEN
            SRCKX=(-SDPHIDX*SDYSQ+SDXDY*SDPHIDY)/DENOM
            SRCKY=(-SDXSQ*SDPHIDY+SDPHIDX*SDXDY)/DENOM
	   ELSE 
	      WRITE(*,*) 'SRCLOC -- Divide by zero DENOM'
	      SRCKX = 1.0
	      SRCKY = 1.0
	   ENDIF
C 
C=======================================================================
C WAVE PROGAGATION VERTOR K IS DEFINED AS ORIGINATING AT THE SOURCE;
C RANGE VECTOR ORIGINATES AT CENTER OF COORD SYSTEM (ON THE GROUND).
C THEREFORE (UNIT VECTOR K)=-(UNIT VECTOR R), AND IN TERMS OF THE MAP 
C COORDINATES,
C  SRCKX= -ABS(K)*SINZMAX*(XIX/20)=-WSCALE*XIX 
C  SRCKY= -ABS(K)*SINZMAX*(YIY/20)=-WSCALE*YIY 
C WHERE WSCALE=UNITS OF K PER MAP DIVISION. 
C USE SRCKX,SRCKY TO DEFINE MAP COORDINATES.
C ALTHOUGH NOT NEEDED IN THIS PROGRAM, THE COMPONENTS OF R IN KM
C FOLLOW FROM THE MAP COORDINATES AS
C  X= ABS(R)*SINZMAX*(XIX/20)=RSCALE*XIX 
C  Y= ABS(R)*SINZMAX*(YIY/20)=RSCALE*YIY 
C WHERE RSCALE=KM PER MAP DIVISION FOR RANGE IN KM. 
C=======================================================================
C 
	   IF (WSCALE.NE.0) THEN
           XIX=-SRCKX/WSCALE 
           YIY=-SRCKY/WSCALE
	   ELSE
	      WRITE(*,*) 'SRCLOC -- Divide by zero WSCALE'
	      XIX = -SRCKX
	      YIY = -SRCKY
	   ENDIF
C
	   IF((ABS(XIX).GE.20.5).OR.(ABS(YIY).GE.20.5)) THEN
C	      Source is not on the map 
            NOUT(IFF)=NOUT(IFF)+1 
            GO TO 170
	   ENDIF 
C 
C===== FOR THE SOURCES ON THE MAP, DETERMINE THE ROOT-MEAN-SQUARE 
C      ERROR RMS=SQRT(ESQ) FOR THE CALCULATED VECTOR K. 
C      ERR(JJ,J)=THE ERROR FOR EACH ANTENNA SEPARATION I.E. 
C      ESQ=SUM[ERR(JJ,J)**2]/TERMS
C 
         ESQ=0 
         N1 = NANT-1 
         DO 299 JJ = 1,N1
            J1 = JJ+1 
            DO 299 J = J1,NANT
               ERR(JJ,J) = ABS(SRCKX*DELX(JJ,J) 
     +                   + SRCKY*DELY(JJ,J)+DELPHI(JJ,J)) 
               ESQ=ESQ+ERR(JJ,J)**2
  299    CONTINUE
	   IF (TERMS.NE.0) THEN
            ESQ=ESQ/TERMS
	   ELSE
	      WRITE(*,*) 'SRCLOC -- Divide by zero TERMS'
	      TERMS = 1
	   ENDIF 
         RMS=SQRT(ESQ) 
C	Keep track of RMS error in 1 degree increments
	   NDX = IRAD(RMS,0,359)
	   KRMS(NDX) = KRMS(NDX) + 1
C 
C===== COMPARE THE ERROR FOR EACH ANTENNA SEPARATION WITH THE RMS 
C      ERROR; KEEP COUNT IN 1-PERCENT INCREMENTS. 
C 
         JJJ=0 
         N1=NANT-1 
         DO 300 JJ=1,N1
            J1=JJ+1 
            DO 300 J=J1,NANT
               JJJ=JJJ+1 
              IF(RMS.EQ.0.) THEN
	           IERR = 0
	        ELSE
                 IERR = 100*(ERR(JJ,J)-RMS)/RMS 
	        ENDIF
              IF(IERR.LT.-100) IERR = -100
              IF(IERR.GT.100) IERR = 100
              KERR(JJJ,IERR) = KERR(JJJ,IERR) + 1 
  300    CONTINUE
C 
C===== FOR THE SOURCE AT (IY,IX), DEFINE THE SOURCE POWER INTENSITY 
C      AS THE DOPPLER AMPLITUDE (IN DB, OR 6 BIT DATA) OF THE
C      SPECTRAL LINE I AS THE AVERAGE (dB) AMPLITUDE OVER ALL ANTENNAS
C	 THIS IS EFFECTIVELY THE GEOMETRIC MEAN OF THE SPETRAL AMPLITUDES. 
C 
         NSRCS(IFF) = NSRCS(IFF) + 1 
C 
	   AMP = 0.0
	   DO 310 K = 1, NANT
	      AMP = AMP + FM(I,K,ISIGN)
 310	   CONTINUE
	   AMP = AMP/NANT
         NUMSRC = NUMSRC + 1 
         YMAP(NUMSRC) = YIY
         XMAP(NUMSRC) = XIX
         MAPAMP(NUMSRC) = AMP 
         MAPDOP(NUMSRC) = I
         IF(ISIGN.EQ.1) MAPDOP(NUMSRC) = -MAPDOP(NUMSRC) 
         MAPRMS(NUMSRC) = IROUND(RMS/RAD) 
C	*** End of loop through all spectral lines ***
 170	CONTINUE
C     *** End of loop through +/- Dopplers.
 200	CONTINUE
      RETURN
      END 
C
C  ====================================================================== 
C
	INTEGER FUNCTION IRAD(PHASER,MIND,MAXD)
C
C	Determines the array index value from the radian phase PHASER
C     bounded by MAXD and MIND (values in degrees).
C
	INTEGER I,MIND,MAXD,IROUND
	REAL PHASER,DEG
	DATA DEG /57.29577951/
C
	I = IROUND(PHASER*DEG)
	IF (I.LT.MIND) THEN
	   IRAD = MIND
	ELSE IF (I.GT.MAXD) THEN
	   IRAD = MAXD
	ELSE
	   IRAD = I
	ENDIF
	RETURN 
	END
C
C   ====================================================================
C 
      SUBROUTINE ENCOD(K,IARRAY,IBEG,IEND,NAME) 
C
C	Encodes the elements IBEG to IEND of IARRAY into NAME.
C	K determines the weighting
C	   = 1 -- Decimal weighting
C	   = 2 -- Hexidecimal weighting
C 
      INTEGER*2 IARRAY(89)
	INTEGER BASE,SHIFT,IBEG,IEND,NAME,N,MULT,IP
C     
C 
      NAME=0
	IF (K.EQ.1) THEN 
	   BASE = 10
	ELSE
	   BASE = 16
	ENDIF
C
      N = IEND-IBEG+1 
     	MULT = BASE**N
     	DO 10 IP=IBEG,IEND
      	MULT=MULT/BASE
 10	NAME=NAME+IARRAY(IP)*MULT 
      RETURN
      END 
C 
C    ==================================================================== 
C
	SUBROUTINE INITSTAT()
C
C	Initializes the statistics arrays, does various housekeeping
C	tasks on the arrays used to characterize the quality of the data.
C	  This routine should be called whenever a new batch of statistics
C	is going to be started.
C
	INTEGER NDX,KKK,IERR,JJJ,I,K
C
C	VARIABLES FOR THE COMMON BLOCKS
C     For /STATS/
	INTEGER NREJ(4),NQUAL(4),NACPT(4),NTOSS(4),NOUT(4),NSRCS(4),
     +        NBAD,KAMP(0:63),KMAX(7,0:63),KMPA(7,0:63),KPHAS(0:359),
     +        KRMS(0:359),KPDIF(-180:180,6),KERR(21,-100:100)
C	For /MAPDATA/
	INTEGER*1 MAXAMP(7),MPAMP(7),
     +           MAPAMP(256),MAPDOP(256),MAPRMS(256)
	REAL YMAP(256),XMAP(256)
	LOGICAL*2 TOSSLINE(128,2)
	INTEGER NUMSRC
C
C	   	COMMON BLOCKINGS
      COMMON/STATS/ NREJ,NQUAL,NACPT,NTOSS,NOUT,NSRCS,NBAD,KAMP,
     +              KMAX,KMPA,KRMS,KPHAS,KPDIF,KERR
	COMMON/MAPDATA/ NUMSRC,MAXAMP,MPAMP,TOSSLINE,
     +                 YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS
 
C	Zero the phase differences
	DO 540 I = 1, 6
      	DO 540 NDX = -180, 180 
	      KPDIF(NDX,I) = 0
 540	CONTINUE 
C	Zero the phase percent RMS error vs antenna array.
      DO 541 JJJ=1,21 
	   DO 541 IERR=-100, 100
	      KERR(JJJ,IERR)=0
 541	CONTINUE
C	Zero the various quality counts
	DO 510 I=1,4
         NREJ(I)=0
	   NQUAL(I)=0
	   NACPT(I)=0
	   NTOSS(I)=0
	   NOUT(I)=0
	   NSRCS(I)=0 
 510	CONTINUE
C	Zero the amplitude, phase and RMS counts 
      DO 520 I=0,63
	   DO 515 K = 1,7
	      KMAX(K,I) = 0
	      KMPA(K,I) = 0
 515	   CONTINUE
	   KAMP(I)=0 
 520	CONTINUE
	DO 521 I = 0,359
	   KRMS(I) = 0
 521	KPHAS(I)=0
C
	RETURN
	END
C
C
C 
C  ========================================================================
C 
      SUBROUTINE UNP256(IFF,KASE) 
C 
C===== UNPACK THE (NANTxNDOPP) NEG- AND POS-DOPPLER AMPLITUDES 
C      AND PHASES FOR THE FREQUENCY NO. IFF.  KEEP ONLY THE 6 MSB 
C      OF THE AMPLITUDES; 6-BIT AMPLITUDES HAVE 1.5 DB RESOLUTION 
C      IF Z (IPREF(46)) IS LESS THAN 8; 1 DB RESOLUTION IF Z.GE.8.
C      CONVERT 8-BIT PHASES TO RADIANS. 
C 
      INTEGER IFF,ISIGN,KBYTE,IDOPP,KASE,JVAL,HITE,NDX,KINDEX,
     +        JANT,KBASE
	REAL RAD8,RAD88
C
C	VARIABLES FOR THE COMMON BLOCKS
C	   FOR /BUFFS/
	INTEGER*2 IBUF(4096),IPREF(89),LPREF(89)
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C	   FOR /CONSTANTS/
	REAL PI
C 	 FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C	For /MAPDATA/
	INTEGER*1 MAXAMP(7),MPAMP(7),
     +           MAPAMP(256),MAPDOP(256),MAPRMS(256)
	REAL YMAP(256),XMAP(256)
	LOGICAL*2 TOSSLINE(128,2)
	INTEGER NUMSRC
C	For /ANTENNA/
	INTEGER*1 JSEQ(7),NANTNO(7)
	REAL YCOORD(7),XCOORD(7),DELX(6,7),SDXSQ,DELY(6,7),SDYSQ,
     +       SDXDY,ANTSEP,ZMAX
C
C	   	COMMON BLOCKINGS
	COMMON/BUFFS/ IBUF,IPREF,LPREF
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/CONSTANTS/ PI
	COMMON/UNPACKED/ FM,PHI
	COMMON/MAPDATA/ NUMSRC,MAXAMP,MPAMP,TOSSLINE,
     +                 YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS
      COMMON/ANTENNA/ JSEQ,NANTNO,YCOORD,XCOORD,DELX,SDXSQ,DELY,SDYSQ,
     +                SDXDY,ANTSEP,ZMAX
C 
	RAD8 = 2.0*PI/256.0
	RAD88 = 8.0*RAD8
      HITE=1 
C
C	Loop through first - and then + Dopplers.
C
	DO 300 ISIGN = 1, 2
      DO 100 JANT=1,NANT 
	   JVAL = JSEQ(JANT)
	   IDOPP = 1
	   KBASE = KINDEX(KASE,ISIGN,IFF,NFREQ,JVAL,NANT,
     +            HITE,NHITES,IDOPP,NDOPP)
	   KBASE = KBASE - 1
	   DO 110 IDOPP = 1, NDOPP
C=====      UNPACK NDOPP AMPLITUDES (and phases) FOR THIS ANTENNA 
C      	   KBYTE now contains the byte number (in IBUF) of the desired
C	      amplitude.  Take the 6 MSB by shifting right 2 bits.
C	      Also, get the phase and convert it into radians.
C
            FM(IDOPP,JANT,ISIGN) = ISHFT(IBUF(KBASE+IDOPP), -2)
            PHI(IDOPP,JANT,ISIGN)=FLOAT(IBUF(KBASE+IDOPP+128))*RAD8 
 110	   CONTINUE 
 100  CONTINUE
 300	CONTINUE
C 
      RETURN
      END 
C 
C  ======================================================================
C 
      INTEGER FUNCTION KINDEX
     +  (ICASE,ISIGN,IFREQ,NFREQ,IANT,NA,IHITE,NHITE,IDOPP,NDOPP) 
C	Determine the location in the raw data buffer corresponding to 
C	the variables ICASE,ISIGN,IFREQ,IANT,IHITE and IDOPP
C	given that the data was recorded with NFREQ,NAntenna, NHITE and NDOPP.
C
C	In the parameter list, the variables starting with I are the 
C	particulars, with the similar variable starting with N representing
C	the maximum.
C 
	INTEGER ICASE,ISIGN,IFREQ,NFREQ,IANT,NA,IHITE,NHITE,
     +        IDOPP,NDOPP,KBYTE,KANT
C 
C===== CALCULATE WHICH BYTE (OF 4096 BYTES) CONTAINS THE DESIRED
C      AMPLITUDE
C      ISIGN=1 FOR NEGATIVE DOPPLERS, 2 FOR POSITIVE. 
C 
	KANT = NA
      IF(NA.EQ.7) KANT=8
C 
      KBYTE = ((((((ICASE-1)*2 + 2-ISIGN)*NFREQ + IFREQ-1)*KANT + 
     +      IANT-1)*NHITE + IHITE-1)*NDOPP + IDOPP) 
C 
C===== AT THIS POINT, KBYTE INDICATES WHICH AMPLITUDE IS WANTED 
C      I.E. WHICH BYTE THE AMPLITUDE WOULD BE IF DATA WERE IN FORMAT
C      2048 AMPLITUDES, 2048 PHASES. NOW CALCULATE AT WHICH OF 4096 
C      BYTES THE AMPLITUDE IS, FOR DATA IN FORMAT 128 AMPL, 128 PHASES, 
C      128 AMPL, ...
C 
      KINDEX = KBYTE + 128*((KBYTE-1)/128) 
      RETURN
      END 
C
C
C   =======================================================================
C
	SUBROUTINE FINDMPA(IANT,NDOPPLERS,  MPA,MAXAMP)
C
C	Searches all doppler lines for the current subcase and antenna IANT
C	and then returns the Most Probable Amplitude MPA and maximum 
C	amplitude MAXAMP.
C
	INTEGER IFF,IANT,MPA,MAXAMP,AMPCOUNT(64),I,J,NDOPPLERS,IDOPP,
     +        MAXCOUNT,ISIGN,IAPAIR
C
C	Variables for the common blocks
C 	 FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C
	COMMON/UNPACKED/ FM,PHI
C
	DO 20 I = 1, 64
 20	AMPCOUNT(I) = 0
	MAXAMP = 0
C
	DO 30 ISIGN = 1, 2
	   DO 30 IDOPP = 1, NDOPPLERS
	      J = FM(IDOPP,IANT,ISIGN)
	      AMPCOUNT(J+1) = AMPCOUNT(J+1) + 1
	      IF (J.GT.MAXAMP) MAXAMP = J
 30	CONTINUE
C
C	Determine MPA.  Start by finding the pair whose combined count is
C	the maximum.  For equal counts, select the highest amplitude pair.
	MAXCOUNT = 0
	DO 40 I = 1, 63
	   IAPAIR = AMPCOUNT(I) + AMPCOUNT(I+1)
	   IF (IAPAIR.GE.MAXCOUNT) THEN
	      MPA = I
	      MAXCOUNT = IAPAIR
	   ENDIF
 40	CONTINUE
C.....Determine the HIGHEST count of this pair.
C.....For equal counts, select the LOWER amplitude.
	IF (AMPCOUNT(MPA).GE.AMPCOUNT(MPA+1)) MPA = MPA - 1
	RETURN
	END
C
C   =======================================================================
C 
      SUBROUTINE PREPDAT(IFF,KASE,THRESH,CLEAN,STATS,GOOD)
C 
C	Unpack the data in the IBUF(4096) buffer
C	Check this data, antenna by antenna, for acceptable data.
C	Acceptance criterion for a subcase (complete spectra) are:
C	 - The Maximum spectral amplitude must be THRESH steps above
C	   the Most Probable Amplitude, antenna by antenna, for *ALL*
C	antennas.
C	Acceptance criterion for a Doppler line (given that the subcase
C	is acceptable) are:
C	 - Each spectral line must have:
C	   -- An amplitude at least CLEAN above MPA (.GE. CLEAN + MPA)
C	   -- Amplitude at least IDBELOW below the subcase maximum amplitude.
C	   -- Minimum amplitude greater than 6 amplitude steps (.GT.6)
C	     on *ALL* antennas.
C
	INTEGER MAX,MIN,MPA,THRESH,CLEAN,IANT,IDOPP,I,IRAD,NDX,IDBELOW,
     +        IDBVAR,IAMP,KASE
	LOGICAL GOOD,OK,STATS
C
C	VARIABLES FOR THE COMMON BLOCKS
C	For /CONTROL/
	INTEGER LOCALE,IPRT,ISTAT,CASECLEAN,LINECLEAN,P2,P3,P4,P5,NR2DO
	LOGICAL FINDSRC,PRT,STAT,TEST,FILE,TOSS1
	REAL ZEEMAX,TTIME
	CHARACTER*30 SKYDATAFILE,TESTFILE,STATFILE,STATION
C	   FOR /PRAMS/
      INTEGER IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,IGAIN(4),LASTGN(4)
	REAL FREQ(4),RANG(4),PREFRQ(4),PRERNG(4)
C	   FOR /UNPACKED/
	INTEGER*1 FM(128,7,2)
	REAL PHI(128,7,2)
C     For /STATS/
	INTEGER NREJ(4),NQUAL(4),NACPT(4),NTOSS(4),NOUT(4),NSRCS(4),
     +        NBAD,KAMP(0:63),KMAX(7,0:63),KMPA(7,0:63),KPHAS(0:359),
     +        KRMS(0:359),KPDIF(-180:180,6),KERR(21,-100:100)
C	For /MAPDATA/
	INTEGER*1 MAXAMP(7),MPAMP(7),
     +         MAPAMP(256),MAPDOP(256),MAPRMS(256)
	REAL YMAP(256),XMAP(256)
	LOGICAL*2 TOSSLINE(128,2)
	INTEGER NUMSRC
C 
C
C	   	COMMON BLOCKINGS
	COMMON/CONTROL/ FINDSRC,PRT,STAT,TEST,FILE,LOCALE,ZEEMAX,TTIME,
     +                SKYDATAFILE,IPRT,ISTAT,CASECLEAN,LINECLEAN,
     +                P2,P3,P4,P5,NR2DO,TESTFILE,STATFILE,STATION,
     +	             TOSS1
 	COMMON/PRAMS/ IL,IZ,IT3,IN,IREP,NFREQ,NANT,NANTDAT,NHITES,NCHAN,
     +	   	NSMPLS,NPULSES,NDOPP,NCASES,FREQ,RANG,IGAIN,
     +	   	PREFRQ,PRERNG,LASTGN
	COMMON/UNPACKED/ FM,PHI
      COMMON/STATS/ NREJ,NQUAL,NACPT,NTOSS,NOUT,NSRCS,NBAD,KAMP,
     +	   	      KMAX,KMPA,KRMS,KPHAS,KPDIF,KERR
	COMMON/MAPDATA/ NUMSRC,MAXAMP,MPAMP,TOSSLINE,
     +                 YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS
C
	IDBELOW = 99
	IDBVAR = 20
C 
C===== SUBROUTINE UNP256 UNPACKS THE NEG- AND POS-DOPPLER AMPLITUDES 
C      AND PHASES FOR FREQ. NO. IFF 
C 
	CALL UNP256(IFF,KASE)
C
C	Now perform the probability distribution for the 6 bit amplitudes
C	and phases in degrees.
C
	IF (STATS) THEN
	DO 60 ISIGN = 1, 2
	   DO 60 IDOPP = 1, NDOPP
	      DO 60 IANT = 1, NANT
	         NDX = IRAD(PHI(IDOPP,IANT,ISIGN),0,359)
	         KPHAS(NDX) = KPHAS(NDX) + 1
	         NDX = FM(IDOPP,IANT,ISIGN)
	         KAMP(NDX) = KAMP(NDX) + 1
 60	CONTINUE
	ENDIF
C
	IF (.NOT.GOOD) THEN
	   NTOSS(IFF) = NTOSS(IFF) + 1
	   RETURN
	ENDIF
C
C	Check all antennas for the acceptability of the data
C
	GOOD = .TRUE.
	NUMSRC = 0
C
	DO 30 IANT = 1, NANT
	   CALL FINDMPA(IANT,NDOPP,  MPA,MAX)
	   IF ((MAX - MPA).LT.THRESH) THEN
C...........Toss the subcase.
	      GOOD = .FALSE.
	   ENDIF
	   MAXAMP(IANT) = MAX
	   MPAMP(IANT) = MPA
C	   Record the MAXAMP and MPAMP in the STATS Probability Distribution
C	   Functions KMAX and KMPA.
	   KMAX(IANT,MAX) = KMAX(IANT,MAX) + 1
	   KMPA(IANT,MPA) = KMPA(IANT,MPA) + 1
 30	CONTINUE
C
C
	IF (.NOT.GOOD) THEN
	   NTOSS(IFF) = NTOSS(IFF) + 1
	   RETURN
	ENDIF
C
C	Now check each spectral line.  If the amplitude on a spectral line
C	is less than the Most Probable Amplitude plus the CLEANing value
C	or not greater than 6 on *any* antenna then that spectral line is
C	tossed out.
C	The spectral line is also tossed out if its amplitude is less than
C	IDBELOW below the maximum for that antenna.
C	If the amplitude of a spectral line fluctuates by more than IDBVAR
C	(20 dB) from antenna to antenna, that spectral line is tossed out.
C
	DO 40 ISIGN = 1, 2
	   DO 40 IDOPP = 1, NDOPP
	      OK = .TRUE.
	      MIN = 99
	      MAX = 0
	      DO 50 IANT = 1, NANT
	         IAMP = FM(IDOPP,IANT,ISIGN)
	         IF (IAMP.LT.(MPAMP(IANT)+CLEAN)) OK =.FALSE.
	         IF (IAMP.LT.(MAXAMP(IANT)-IDBELOW)) OK =.FALSE.
	         IF (IAMP.LE.6) OK = .FALSE.
	         IF (IAMP.LT.MIN) MIN = IAMP
	         IF (IAMP.GT.MAX) MAX = IAMP
 50	      CONTINUE
C
	      IF ((MAX-MIN).GT.IDBVAR) OK = .FALSE.	      
	      IF (OK) THEN
	         TOSSLINE(IDOPP,ISIGN) = .FALSE.
	      ELSE
	         TOSSLINE(IDOPP,ISIGN) = .TRUE.
	      ENDIF
 40	CONTINUE
C
C	Now check the accepted lines for a single accepted spectral line
C	surrounded by rejected lines.  Toss out these "spikes" as noise.
C	Skip this process if TESTing data.
C
	IF (.NOT.TEST) THEN
C........Toss the most positive and most negative lines.
	   TOSSLINE(NDOPP,1) = .TRUE.
	   TOSSLINE(NDOPP,2) = .TRUE.
C........Negative Dopplers, starting with the most negative.
	   DO 70 IDOPP = NDOPP-1,2,-1
	      TOSSLINE(IDOPP,1) =
     +          (TOSSLINE(IDOPP-1,1).AND.TOSSLINE(IDOPP+1,1)).OR.
     +           TOSSLINE(IDOPP,1)
 70	   CONTINUE
C........The -1 Doppler line.
	   TOSSLINE(1,1) = (TOSSLINE(1,2).AND.TOSSLINE(2,1)).OR.
     +                 TOSSLINE(1,1)
C........The +1 Doppler line.
	   TOSSLINE(1,2) = (TOSSLINE(1,1).AND.TOSSLINE(2,2)).OR.
     +                 TOSSLINE(1,2)
C........Positive Dopplers, starting with the second line.
	   DO 80 IDOPP = 2,NDOPP-1
	      TOSSLINE(IDOPP,2)=
     +          (TOSSLINE(IDOPP-1,2).AND.TOSSLINE(IDOPP+1,2)).OR.
     +           TOSSLINE(IDOPP,2)
 80	   CONTINUE
	ENDIF
	RETURN
	END

