$NOTRUNCATE
$DECLARE
      PROGRAM SPLITIT
C
C     This program splits one SKYMAP output file into two or merges
C	two files into one.
C
      INTEGER INFIL1,INFIL2,OUTFIL1,OUTFIL2,I,N1,N2,NRECS
      INTEGER*2 LTT(11)
      REAL*8 PARSETIME,STARTTIME,NOWTIME,ENDTIME
      CHARACTER*20 INFILE1,INFILE2,OUTFILE1,OUTFILE2
	CHARACTER*3 OUTC
      LOGICAL EOF1,EOF2,SPLIT,MERGE,EXTRACT,INRANGE,DONE
C
C         VARIABLES FOR THE COMMON BLOCKS
C
C     For /INDATA/
      INTEGER*2 NMAP,IFF,GAIN,MPAMP,MAXAMP,NUMSRC,IPREF(89),
     +        MAPAMP(256),MAPDOP(256),MAPRMS(256),KTH,LTH
      REAL FREQ,RANGE,YMAP(256),XMAP(256),ZMAX
      COMMON/INDATA/ NMAP,IFF,IPREF,FREQ,RANGE,GAIN,MPAMP,MAXAMP,
     +            ZMAX,NUMSRC,YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS,KTH,LTH
C
      DATA LTT /0,0,0,0,0,0,0,0,0,0,0/
      INFIL1 = 10
      INFIL2 = 11
      OUTFIL1  = 21
      OUTFIL2  = 22
	N1 = 0
	N2 = 0
C
	WRITE(*,*) ' SKYMAP Data File Manipulation Program.'
	WRITE(*,*) ' '
	WRITE(*,*) ' Possible actions:'
	WRITE(*,*) '     1) Completely merge two files into one.'
	WRITE(*,*) '     2) Extract a section of one file.'
	WRITE(*,*) '     3) Split a file into two at a given time.'
	READ(*,*)  I
	MERGE = (I.EQ.1)
	EXTRACT = (I.EQ.2)
	SPLIT = (I.EQ.3)
C
      WRITE(*,*)' Enter the name of the SOURCE file.'
      READ(*,'(A)') INFILE1
      OPEN(UNIT=INFIL1,FILE=INFILE1,FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS='OLD')
	IF (MERGE) THEN
         WRITE(*,*) ' Enter the name of the SECOND source file.'
         READ(*,'(A)') INFILE2
         OPEN(UNIT=INFIL2,FILE=INFILE2,FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS='OLD')
	ENDIF
C
      WRITE(*,*)' Enter the name of the first OUTPUT file.'
      READ(*,'(A)') OUTFILE1
	OPEN(UNIT=OUTFIL1,FILE=OUTFILE1,FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS = 'NEW')
C
	IF (SPLIT) THEN
	   WRITE(*,*)' Enter the name of the second OUTPUT file.'
	   READ(*,'(A)') OUTFILE2
	   OPEN(UNIT=OUTFIL2,FILE=OUTFILE2,FORM='FORMATTED',
     +        ACCESS='SEQUENTIAL',STATUS = 'NEW')
	ENDIF
C
	STARTTIME = 0.0
	ENDTIME = 1.0E+30
	NRECS = 999999
	IF (SPLIT.OR.EXTRACT) THEN
 	   WRITE(*,*) ' For the first extracted file segment:'
 555     WRITE(*,*) '    Enter starting time (ie: 881121900) '
         WRITE(*,*) '    or 0 for begining of file.'
         READ(*,'(11I1)') LTT
         STARTTIME = PARSETIME(LTT)
         WRITE(*,*) '    Enter split/ending time (ie: 881121900) '
         WRITE(*,*) '    or 0 to select the number of records.'
         READ(*,'(11I1)') LTT
         ENDTIME = PARSETIME(LTT)
	   IF (ENDTIME.EQ.0.0) THEN
	      ENDTIME = 1.0E+30
	      WRITE(*,*) ' Enter the number of records to extract'
            WRITE(*,*) '    or 0 for all.'
	      READ(*,*) NRECS
	   ENDIF
	   IF (NRECS.EQ.0) NRECS = 9999999
	   IF (ENDTIME.LT.STARTTIME) GOTO 555
	ENDIF
C
C.....Start the transfer of data.
	EOF1 = .FALSE.
	DONE = .FALSE.
	N1 = 0
 10	CALL READMAPDATA(INFIL1,EOF1)
	NOWTIME = PARSETIME(IPREF)
	DONE = ((NOWTIME.GE.ENDTIME).OR.(N1.EQ.NRECS))
	INRANGE = (NOWTIME.GE.STARTTIME)
	IF (.NOT.(EOF1.OR.DONE)) THEN
	   OUTC = '   '
	   IF (MERGE.OR.INRANGE) THEN
	      OUTC = '1-->'
	      N1 = N1 + 1
	      CALL WRITEMAPDATA(OUTFIL1)
	   ENDIF
	   WRITE(*,33) OUTC,(IPREF(I),I=1,11)
 33	   FORMAT (1X,A3,2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
	   GOTO 10
	ENDIF
	IF (EOF1) WRITE(*,*) ' EOF Encountered on file ',INFILE1
C
	IF (SPLIT) THEN
	   EOF2 = .FALSE.
	   N2 = 0
 20	   WRITE(*,33) '2-->',(IPREF(I),I=1,11)
	   CALL WRITEMAPDATA(OUTFIL2)
	   N2 = N2 + 1
	   CALL READMAPDATA(INFIL1,EOF2)
	   IF (.NOT.EOF2) GOTO 20
	   WRITE(*,*) ' EOF Encountered on file ',INFILE1
	ENDIF
C
	IF (MERGE) THEN
	   EOF2 = .FALSE.
	   N2 = 0
 25	   CALL READMAPDATA(INFIL2,EOF2)
	   IF (.NOT.EOF2) THEN
 	      WRITE(*,33) '2-->',(IPREF(I),I=1,11)
	      CALL WRITEMAPDATA(OUTFIL1)
	      N1 = N1 + 1
	      GOTO 25
	   ELSE
	      WRITE(*,*) ' EOF Encountered on file ',INFILE2
	   ENDIF
	ENDIF
C
 	CLOSE (UNIT=INFIL1)
	CLOSE (UNIT=INFIL2)
	CLOSE (UNIT=OUTFIL1)
	CLOSE (UNIT=OUTFIL2)
	WRITE(*,*) ' Program terminating ...'
	WRITE(*,*) N1,' Records written to file ',OUTFILE1 
	WRITE(*,*) N2,' Records written to file ',OUTFILE2 
	END
C
C   ========================================================================
C
      REAL*8 FUNCTION PARSETIME(TIME)
C            This function takes an integer array of 11 values and
C         calculates the approximate number of seconds since January, 1900.
C         These values are for comparison purposes only.
C	    Performance across year boundires is not optimal, esp. leap years.
C         Will fail past the year 2000.
C
      INTEGER*2 TIME(11)
C         Seconds per year
      PARSETIME = 31662400.*(10*TIME(1)+ TIME(2))
C         Seconds per day
      PARSETIME = PARSETIME + 86400.*(100*TIME(3)+10*TIME(4)+TIME(5))
C         Seconds per hour
      PARSETIME = PARSETIME + 3600.*(10*TIME(6) + TIME(7))
C         Seconds per minute
      PARSETIME = PARSETIME + 60.*(10*TIME(8) + TIME(9))
C         And finally the seconds
      PARSETIME = PARSETIME + 10.*TIME(10) +1.*TIME(11)
      RETURN
      END
C
C  ======================================================================
C
      SUBROUTINE READMAPDATA(INFILE,EOF)
C
C===== READ THE MAP DATA FROM A FILE <infile> FOR LATER USE IN PRINTING
C      SKYMAPS OR CALCULATING DRIFT VELOCITIES.  FREQUENCY READ IS
C          <IFF>  THE FORMAT OF THE PREFACE IS AS FOLLOWS:
C
C=======================================================================
C CODE RELEVANT PREFACE CHARACTERS (DECIMAL UNLESS SPECIFIED OTHERWISE)
C    INTO ARRAY MAPREF:
C  POSITION ! FORMAT  !  INFORMATION
C_______________________________________________________________
C  1        ! A1      !  SPACE                                  !
C  2-4      ! 3Z1     !  STATION ID CODE                        !
C  5-9      ! I5      !  RECORD NO.                             !
C  10       ! A1      !  SPACE                                  !
C  11-15    ! 5Z1     !  DATE                                   !
C  16       ! A1      !  SPACE                                  !
C  17-22    ! 6Z1     !  TIME                                   !
C  23       ! 1X      !  SPACE                                  !
C  24       ! Z1      !  PROGRAM SET                            !
C  25       ! Z1      !  PROGRAM TYPE                           !
C  26-31    ! 6Z1     !  JOURNAL (6 HEX DIGITS)                 !
C  32-38    ! 7Z1     !  P1 TO P7 (7 HEX DIGITS)                !
C  39       ! 1X      !  SPACE                                  !
C  40-46    ! 7Z1     !  XLZTNRW (7 HEX DIGITS)                 !
C  47-53    ! 7Z1     !  K(I*)(G*)HEIG (7 HEX DIGITS)           !
C  54-57    ! I4      !  ZMAX (10THS OF A DEGREE)               !
C  58-59    ! I2      !  NFREQ=FREQUENCY NUMBER                 !
C  60-66    ! I7      !  FREQ(NFREQ), IN 100-HZ UNITS           !
C  67-71    ! I5      !  RANG(NFREQ), IN 100-METER UNITS        !
C  72-74    ! I3      !  IGAIN(NFREQ), IN DB                    !
C  75-77    ! I3      !  MPAMP(NFREQ)                           !
C  78-80    ! I3      !  MAXAMP(NFREQ)                          !
C  81-84    ! I4      !  NO. OF SOURCES FOR NFREQ               !
C  85-87    ! I3      !  KTH, CASE SELECTION THRESHOLD          !
C  88-90    ! I3      !  LTH, SPECTRAL LINE SELECTION THRESHOLD ! 
C================================================================
C
      INTEGER INFILE,I,I1,I2,IRNG,IFRQ,IZMAX
      CHARACTER*2 JUNK
      LOGICAL EOF
C
C         VARIABLES FOR THE COMMON BLOCKS
C
C     For /INDATA/
      INTEGER*2 NMAP,IFF,GAIN,MPAMP,MAXAMP,NUMSRC,IPREF(89),
     +        MAPAMP(256), MAPDOP(256),MAPRMS(256),KTH,LTH
      REAL FREQ,RANGE,YMAP(256),XMAP(256),ZMAX
      COMMON/INDATA/ NMAP,IFF,IPREF,FREQ,RANGE,GAIN,MPAMP,MAXAMP,
     +     ZMAX,NUMSRC,YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS,KTH,LTH
C
      DO 10 I =1, 89
 10   IPREF(I) = 0
      DO 20 I=1,256
         XMAP(I) = 0.0
         YMAP(I) = 0.0
         MAPAMP(I) = 0
         MAPRMS(I) = 0
 20   CONTINUE
      EOF = .FALSE.
C
      READ(INFILE,110,END=99) (IPREF(I),I=41,43),NMAP,
     +  (IPREF(I),I=1,19), (IPREF(I),I=26,32), (IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC,KTH,LTH
C
110   FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +        I4,I2,I7,I5,4I3,I4,2I3)
C
      RANGE = FLOAT(IRNG)/10.
      FREQ =  FLOAT(IFRQ)/10.
      ZMAX =  FLOAT(IZMAX)/10.
C
      DO 140 I1=1,NUMSRC,26
         I2=I1+25
         IF(I2.GT.NUMSRC) I2=NUMSRC
         READ(INFILE,151) JUNK,(YMAP(I),I=I1,I2)
         READ(INFILE,151) JUNK,(XMAP(I),I=I1,I2)
         READ(INFILE,150) JUNK,(MAPAMP(I),I=I1,I2)
         READ(INFILE,150) JUNK,(MAPDOP(I),I=I1,I2)
         READ(INFILE,150) JUNK,(MAPRMS(I),I=I1,I2)
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C
      RETURN
C     End of File condition.
 99   EOF = .TRUE.
      NUMSRC = 0
      RETURN
      END

C
C  ======================================================================
C
      SUBROUTINE WRITEMAPDATA(OUTFILE)
C
C===== WRITE THE MAP DATA TO A FILE <outfile>.
C
      INTEGER OUTFILE,I,I1,I2,IRNG,IFRQ,IZMAX
C
C         VARIABLES FOR THE COMMON BLOCKS
C
C     For /INDATA/
      INTEGER*2 NMAP,IFF,GAIN,MPAMP,MAXAMP,NUMSRC,IPREF(89),
     +        MAPAMP(256), MAPDOP(256),MAPRMS(256),KTH,LTH
      REAL FREQ,RANGE,YMAP(256),XMAP(256),ZMAX
C
C     Common Blockings
      COMMON/INDATA/ NMAP,IFF,IPREF,FREQ,RANGE,GAIN,MPAMP,MAXAMP,
     +     ZMAX,NUMSRC,YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS,KTH,LTH
C
	IRNG = INT(10.0*RANGE)
	IFRQ = INT(10.0*FREQ)
	IZMAX = INT(10.0*ZMAX)
C
      WRITE(OUTFILE,110) (IPREF(I),I=41,43),NMAP,
     +  (IPREF(I),I=1,19), (IPREF(I),I=26,32), (IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC,KTH,LTH
C
110   FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +        I4,I2,I7,I5,4I3,I4,2I3)
C
      DO 140 I1=1,NUMSRC,26
         I2=I1+25
         IF(I2.GT.NUMSRC) I2=NUMSRC
         WRITE(OUTFILE,151) ' Y',(YMAP(I),I=I1,I2)
         WRITE(OUTFILE,151) ' X',(XMAP(I),I=I1,I2)
         WRITE(OUTFILE,150) 'PD',(MAPAMP(I),I=I1,I2)
         WRITE(OUTFILE,150) 'DO',(MAPDOP(I),I=I1,I2)
         WRITE(OUTFILE,150) 'ER',(MAPRMS(I),I=I1,I2)
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C
      RETURN
      END
