$DECLARE
$NOTRUNCATE
$DEBUG
	PROGRAM PHASEFIX
C
C	T. Bullett
C	   01 December 90
C	A Program to test various phase correction processes for 
C	simulated Digisonde Drift Data.
C
C	Variables:
C  PHASE(7)  - Actual (unwrapped) phase at each antenna.
C  PHASEM(7) - Measured (wrapped) phase at each antenna.
C  PHASEC(7) - Corrected(wrapped) phase at each antenna.
C
$INCLUDE:'COMMON\ANT.CMN'
C    
	INTEGER I,ISEQ,LSEQ,ISEED
	REAL FREQ,THETA,PHI,WLEN,K0,KX,KY,KZ,ZMAX,ZMAXCD,
     +     KSX,KSY,KSZ,KSH,THETAS,PHIS,THETAL
	REAL PHASE(MANT),PHASEM(MANT),PHASEC(MANT),PHASE0,PH0
	LOGICAL OK
C
	REAL C,PI,TWOPI,EPSD,DEG,RAD
	PARAMETER (C=3.0E8, PI=3.141579, TWOPI=2*PI, EPSD=1.0E-2)
	PARAMETER (DEG=180./PI, RAD=PI/180.)
C
C
C
	OPEN(UNIT=3,FILE='PHFIX.OUT',FORM='FORMATTED')
C
	WRITE(*,*) ' Antenna Phase Correction'
	WRITE(*,*) ' Standard 100m Antenna Array Configuration.'
	WRITE(*,*) ' Enter the Frequency [MHz]'
	READ(*,*) FREQ
	FREQ = FREQ * 1.0E06
	WLEN = C/FREQ
	ZMAXCD = 180/PI*ASIN(MIN(1.0,C/(FREQ*57.7)))
	WRITE(*,104) ZMAXCD	
	ZMAX = 180/PI*ASIN(MIN(1.0,C/(2*FREQ*33.333)))
	WRITE(*,102) ZMAX	
c
	WRITE(*,*) ' Enter antenna sequence, ie: 1,2,3,4,5,6,7'
	READ(*,*) (ANTSEQ(I),I=1,7)
C
	K0 = TWOPI/WLEN
C
	WRITE(*,*) ' Frequency is:'
	WRITE(3,*) ' Frequency is:'
	WRITE(*,103) FREQ/1.0E6
	WRITE(3,103) FREQ/1.0E6
	WRITE(*,*) ' The antenna sequence is:'
	WRITE(3,*) ' The antenna sequence is:'
	WRITE(*,105) (ANTSEQ(I),I=1,7)
	WRITE(3,105) (ANTSEQ(I),I=1,7)
	WRITE(*,*) ' Arrival angles Theta, Phi,   X,     Y'
	WRITE(3,*) ' Arrival angles Theta, Phi,   X,     Y'
C
	CALL SETR12()
C
	DO 100 PHI = 0, TWOPI, 5.0*RAD
	   CALL GETTIM(I,I,ISEED,I)
	   CALL SEED(ISEED)
	   THETA = 0.0
	   OK = .TRUE.
	   DO WHILE (OK)
	      THETAL = THETA
	      THETA = THETA + RAD
	      KX = K0*SIN(THETA)*COS(PHI)
	      KY = K0*SIN(THETA)*SIN(PHI)
	      KZ = K0*COS(THETA)
	      CALL RANDOM(PHASE0)
	      PHASE0 = TWOPI*PHI
C
C	      Determine the phases on each antenna, and the measured phases.
	      CALL ANTPHASE(PHASE0,KX,KY,KZ, PHASE,PHASEM)
C
t	      WRITE(*,*) ' Actual and measured antenna phases, [DEG].'
t	      WRITE(*,103) (180./PI*PHASE(I),I=1,7)
t	      WRITE(*,103) (180./PI*(PHASE(I)-PHASE0),I=1,7)
t	      WRITE(*,103) (180./PI*PHASEM(I),I=1,7)
C
	      LSEQ = ISEQ
	      CALL SOURCELOC(K0,PHASEM, PH0,PHASEC,KSX,KSY,KSZ,ISEQ)
C	
t	      WRITE(*,*) ' Corrected antenna phases, [DEG].'
t	      WRITE(*,103) (180./PI*PHASEC(I),I=1,7)
t	      WRITE(*,*) ' Phase correction sequence = ',ISEQ
C
C
t	      WRITE(*,*) ' Actual values of K.' 
t	      WRITE(*,101) KX,KY,KZ,K0
t	      WRITE(*,*) ' Source Located K.' 
t	      WRITE(*,101) KSX,KSY,KSZ,K0
C
C	      Determine the arrival angle: Thetas and Phis.
	      KSH = SQRT(KSX*KSX + KSY*KSY)
	      THETAS = ASIN(KSH/K0)
	      PHIS = 0.0
	      IF (THETAS.GT.0.0) PHIS = ATAN2(KSY,KSX)
	      IF (PHIS.LT.0.0) PHIS = PHIS + TWOPI
	      OK = (ABS(THETA - THETAS).LT.EPSD).AND.
     +           (ABS(PHI   - PHIS  ).LT.EPSD).AND.
cx	      OK =
     +           (THETA.LT.PI)
t	      WRITE(*,*) ' Actual and located arrival angles'
t	      WRITE(*,103) DEG*THETA, DEG*PHI, 
t    +                   DEG*THETAS, DEG*PHIS, 1.0*ISEQ
t	      WRITE(3,103) DEG*THETA, DEG*PHI,
t    +                   DEG*THETAS, DEG*PHIS, 1.0*ISEQ
	   ENDDO
C
C	   The last value of Theta (THETAL) is the largest correct one.
	   WRITE(*,103) DEG*THETAL, DEG*PHI,
     +                DEG*THETAL*COS(PHI),DEG*THETAL*SIN(PHI),1.*LSEQ
	   WRITE(3,103) DEG*THETAL, DEG*PHI,
     +                DEG*THETAL*COS(PHI),DEG*THETAL*SIN(PHI),1.*LSEQ
	   
 100	CONTINUE
	CLOSE (UNIT=3)
C
 101	FORMAT(' Kx,Ky,Kz = ',3F7.4,' K0 = ',F7.4)
 102	FORMAT('      My Maximum Zenith angle is:',F5.1)
 103	FORMAT(10F7.1)
 104	FORMAT(' Claudes Maximum Zenith angle is:',F5.1)
 105	FORMAT(10I5)
C
	END
C
C   =====================================================================
C
	SUBROUTINE ANTPHASE(PH0,KX,KY,KZ, PHASEA,PHASEM)
C
C	Determine the actual phases (PHASEA) and measured phases (PHASEM)
C	on the antenna array in /ANT/, given an initial phase PH0 and the
C	K vector (Kx,Ky,Kz).
C
$INCLUDE:'COMMON\ANT.CMN'
C
	INTEGER I
	REAL PH0,KX,KY,KZ,PHASEA(MANT),PHASEM(MANT),TWOPI
	PARAMETER(TWOPI = 2.0*3.14159)
C
	DO 20 I = 1, MANT
	   PHASEA(I) = KX*ANTX(I)+ KY*ANTY(I)+ KZ*ANTZ(I)+ PH0
	   IF (PHASEA(I).LT.0.0) THEN 
	      PHASEM(I) = MOD(PHASEA(I), TWOPI) + TWOPI
	   ELSE
	      PHASEM(I) = MOD(PHASEA(I), TWOPI)
	   ENDIF
 20	CONTINUE
	RETURN
	END
C
C   =====================================================================
C
	SUBROUTINE SETR12 ()
C
C	Set up the R1, R2, RI1, RI2, PHIM1 and PHIM2 arrays for SOURCELOC()
C
$INCLUDE:'COMMON\ANT.CMN'
$INCLUDE:'COMMON\R12.CMN'
C
	R1  = 0
	R2  = 0
	RI1 = 0
	RI2 = 0
C
C	Set up [R] and [Phi] using antennas in positions 1,2,3
	R1(1,1)  = ANTX(ANTSEQ(2)) - ANTX(ANTSEQ(1))
	R1(1,2)  = ANTY(ANTSEQ(2)) - ANTY(ANTSEQ(1))
	R1(2,1)  = ANTX(ANTSEQ(3)) - ANTX(ANTSEQ(1))
	R1(2,2)  = ANTY(ANTSEQ(3)) - ANTY(ANTSEQ(1))
	CALL INVERTR(R1,RI1)
C
C	Set up [R] and [Phi] using antennas in positions 2,3,4
	R2(1,1)  = ANTX(ANTSEQ(3)) - ANTX(ANTSEQ(2))
	R2(1,2)  = ANTY(ANTSEQ(3)) - ANTY(ANTSEQ(2))
	R2(2,1)  = ANTX(ANTSEQ(4)) - ANTX(ANTSEQ(2))
	R2(2,2)  = ANTY(ANTSEQ(4)) - ANTY(ANTSEQ(2))
	CALL INVERTR(R2,RI2)
C
	RETURN
	END
C
C   =====================================================================
C
	SUBROUTINE SOURCELOC(K0,PHASEM,   PH0,PHASEC,KX,KY,KZ,KSEQ)
C
C	Corrects the PHASEM() phases by approximately locating the
C	source using the first 4 antennas in the ANTSEQ() array.
C
C	Variables:
C  K0        - Magnitude of the K vector, 2*pi/Lambda
C  PHASEM(7) - Measured (wrapped) phase for each antenna.
C  PH0       - The initial phase of the located source.
C  PHASEC(7) - Corrected (unwrapped) phase for each antenna.
C  Kx,Ky,Kz  - 3D components of source arrival vector K.
C  PSEQ      - Set of N2PI corrections which turn PHASEM into PHASEC.
C
C  TPSEQ(3,14)- The 6 sequences of n2pi possible for the 'inner' 4 antennas
C  N2PI1(2)  - Number of 2pi corrections for the antennas in [R1]
C  N2PI2(2)  - Number of 2pi corrections for the antennas in [R2]
C
$INCLUDE:'COMMON\ANT.CMN'
$INCLUDE:'COMMON\R12.CMN'
C
	INTEGER I,N2PI1(2),N2PI2(2),TS(4,15),ISEQ,N2PI,KSEQ,KR
	REAL K0,KX,KY,KZ,KX1,KY1,KZ1,KX2,KY2,KZ2,KH1,KH2,
     +     ZMIN,ZENITH,PHTST,TPTST,PH0,PH01
	REAL PHASEM(7),PHASEC(7),PHASET(7)
	LOGICAL KOK,TPOK
C
C
	REAL C,PI,TWOPI,EPS
	PARAMETER (C=3.0E8, PI=3.141579, TWOPI=2*PI, EPS=1.0E-3)
C
C	             ISEQ =  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15
	DATA(TS(1,I),I=1,15)/0, 0, 0, 0, 0, 0, 0,-1,-1,-1,-1,-1,-1,-1,-1/
	DATA(TS(2,I),I=1,15)/0, 0,-1, 0,-1,-1,-1, 0, 0, 0,-1, 0,-1,-1,-1/
	DATA(TS(3,I),I=1,15)/0,-1, 0,-1,-1, 0,-1, 0, 0,-1, 0,-1,-1, 0,-1/
	DATA(TS(4,I),I=1,15)/-1,0, 0,-1, 0,-1,-1, 0,-1, 0, 0,-1, 0,-1,-1/
C
	ZMIN = 90.0
	KX = 0
	KY = 0
	KZ = 0
	KSEQ = 0
C
C	Set up the measured phase differences.
	PHIM1(1) = PHASEM(ANTSEQ(2)) - PHASEM(ANTSEQ(1))
	PHIM1(2) = PHASEM(ANTSEQ(3)) - PHASEM(ANTSEQ(1))
	PHIM2(1) = PHASEM(ANTSEQ(3)) - PHASEM(ANTSEQ(2))
	PHIM2(2) = PHASEM(ANTSEQ(4)) - PHASEM(ANTSEQ(2))
C
C	Try all 15 TS(,) phase corrections.  Take the one
C	closest to the Zenith.
C
	KR = ANTSEQ(1)
	DO 100 ISEQ = 1, 15
	   N2PI1(1) = TS(2,ISEQ) - TS(1,ISEQ)
	   N2PI1(2) = TS(3,ISEQ) - TS(1,ISEQ)
	   CALL FINDK(RI1,PHIM1,N2PI1,  KX1,KY1,KZ1)
	   KH1 = SQRT(KX1*KX1 + KY1*KY1)
	   KZ1 = 0.0
	   IF (KH1.LE.K0) KZ1 = SQRT(K0*K0 - KH1*KH1) 
u	   write(*,*) ph01,kx1,ky1,kz1,iseq
C
	   PH02 = 0.0
	   N2PI2(1) = TS(3,ISEQ) - TS(2,ISEQ)
	   N2PI2(2) = TS(4,ISEQ) - TS(2,ISEQ)
	   CALL FINDK(RI2,PHIM2,N2PI2,  KX2,KY2,KZ2)
	   KH2 = SQRT(KX2*KX2 + KY2*KY2)
	   KZ2 = 0.0
	   IF (KH2.LE.K0) KZ2 = SQRT(K0*K0 - KH2*KH2) 
u	   write(*,*) kx2,ky2,kz2,iseq
C
C	   Determine if this phase correction sequence is valid
	   KOK = (KZ1.GT.0.0).AND.(KZ2.GT.0.0).AND.
     +          (ABS(KX1-KX2).LT.EPS).AND.(ABS(KY1-KY2).LT.EPS)
	   IF (KOK) THEN
C	      Determine if this K is closer to zenith than any others.
	      ZENITH = 180./PI*ASIN(KH1/K0)
	      IF (ZENITH.LT.ZMIN) THEN
	         ZMIN = ZENITH
	         KSEQ = ISEQ
	         KX = KX1
	         KY = KY1
	         KZ = KZ1
	      ENDIF
	   ENDIF
 100	CONTINUE
C
C	Kx, Ky and Kz is the solution for K closest to Zenith that fits
C	all 4 antennas.  Using this, correct the measured phases.
C
	PH0 = PHASEM(ANTSEQ(1))
	CALL ANTPHASE(PH0,KX,KY,KZ,   PHASEC, PHASET)
C
	RETURN
	END
C
C   ==================================================================
C
	SUBROUTINE FINDK(RI,PHIM,N2PI, KX,KY,KZ)
C
C	Solves the matrix equation [R][K] = [Phi]+[N2pi]*2pi,
C	given [RI], the inverse of [R]
C	Currently returns only the Kx and Ky components.
C
	REAL RI(2,2),PHIM(2),KX,KY,KZ,PI,TWOPI
	INTEGER N2PI(2)
	PARAMETER (PI = 3.141579, TWOPI = 2.0*PI)
C
	KX = 0.0
	KY = 0.0
	KZ = 0.0

C	Multiply [RI] by [Phi] to get [K]
	KX = RI(1,1)*(PHIM(1)+TWOPI*N2PI(1)) + 
     +     RI(1,2)*(PHIM(2)+TWOPI*N2PI(2))
	KY = RI(2,1)*(PHIM(1)+TWOPI*N2PI(1)) + 
     +     RI(2,2)*(PHIM(2)+TWOPI*N2PI(2))
C
	RETURN
	END
C
C =========================================================================
C
	SUBROUTINE INVERTR(R,RI)
C
C	Determine the inverse [RI] of the 2x2 matrix [R].
C
	REAL R(2,2),RI(2,2),DET,DETI
C
	DET = R(1,1)*R(2,2) - R(1,2)*R(2,1)
	IF (DET.EQ.0.0) RETURN
C
	DETI = 1.0/DET
	RI(1,1) =  R(2,2)*DETI
	RI(1,2) = -R(1,2)*DETI
	RI(2,1) = -R(2,1)*DETI
	RI(2,2) =  R(1,1)*DETI
C
	RETURN
	END
C
C =========================================================================
C
	BLOCK DATA ANT7

$INCLUDE:'COMMON\ANT.CMN'

	DATA ANTX  /00.00,-28.87, 00.00, 28.87,-28.87,-28.87, 57.73/
	DATA ANTY  /00.00, 16.67,-33.33, 16.67, 50.00,-50.00, 00.00/
	DATA ANTZ  /00.00, 00.00, 00.00, 00.00, 00.00, 00.00, 00.00/
	END
	
	
	
	
