C.......FILE NAME    5SUNHT.FOR
C     CREATED 16-APR-81   LAST MODIFIED 20-aug-85 for VAX / UNIX
c     modified by R. Gamache --- June, 28, 1986
C
C.... PROG TO CALCULATE SUNRISE AND SUNSET TIMES FOR DIFFERENT
C     ALTITUDES
C
C.....INPUT DATA:-
C     IY    YEAR
C     MON   MONTH
C     ID    DAY
C     DLAT  LATITUDE OF STATION	North
C     DLON  LONGITUDE OF STATION West
C     TMER  LONGITUDE OF MERIDIAN AT WHICH TIME IS MEASURED for local time
C
C....OUTPUT
C     SUNRISE AND SUNSET TIMES FOR DIFFERENT HEIGHTS
C
C.... SPECIAL CASES SUNSET=SUNRIS=+99   IF SUN NEVER SETS
C                                 -99   IF SUN NEVER RISES
C
C
      DIMENSION TIMER(10),TIMES(10),HT(10)
      DATA HT / 0.,100.,200.,300.,400.,500.,4*0. /
      DATA NHT / 6 /
C
      WRITE(6,555)
555   FORMAT(///' THIS PROG CALCULATES SUNRISE & SUNSET TIMES',/
     A ' FOR THE FOLLOWING HEIGHTS AT A SPECIFIED',
     A ' LOCATION.....'//)
      WRITE(6,556) (HT(I),I=1,NHT)
556   FORMAT(10F6.1//)
10    CONTINUE
      WRITE(6,100)
100   FORMAT(//2X,'ENTER YEAR,MONTH,DAY ')
      READ(5,*) IY,MON,ID
200   FORMAT(3I2)
      IF(IY.EQ.0.OR.IY.GE.99) STOP 'NORMAL EXIT'
      WRITE(6,101)
101   FORMAT(//2X,'ENTER STATION LAT(N) & LONG(W) (DEGREES) ')
      READ(5,*) DLAT,DLON
201   FORMAT(2F5.0)
      WRITE(6,102)
102   FORMAT(//2X,'ENTER LONGITUDE AT WHICH TIME IS MEASURED: 0 for UT 
     + station longitude for LT .. F5.0')
      READ(5,201) TMER
      WLON=360.-DLON
      WMER=360.-TMER
C
      CALL ZEN2
     A (IY,MON,ID,DLAT,WLON,WMER,NHT,HT,TIMER,TIMES)
C
      WRITE(6,203) IY,MON,ID
203   FORMAT(///2X,'EPOCH ..  ',3I3)
      WRITE(6,204) DLAT,DLON,TMER
204   FORMAT(2X,'STATION COORDS ',2F6.1,5X,'TIME MERIDIAN ',F6.1)
      WRITE(6,205)
205   FORMAT(//2X,'SUNRISE & SUNSET TIMES AT DIFFERENT HEIGHTS',
     A //4X,'HEIGHT',3X,'SUNRISE',4X,'SUNSET')
      DO 40 IHT=1,NHT
      IHR=TIMER(IHT)
      IMIN=(TIMER(IHT)-IHR)*60.
      JHR=TIMES(IHT)
      JMIN=(TIMES(IHT)-JHR)*60.
      WRITE(6,206) HT(IHT),IHR,IMIN,JHR,JMIN
206   FORMAT(F10.1,2(6X,I2,':',I2))
40    CONTINUE
C
      GO TO 10
      END
      SUBROUTINE ZEN2
     A (LLY,LMON,LDAY,DLAT,DLON,TMER,NHT,HT,TIMER,TIMES)
C     MODIFIED VERSION OF NEWBERN SMITH'S COS(SOLAR ZENITH ANGLE) S/R
C---- ARCOSINE IS CALCULATED VIA THE ATAN FUNCTION
C.....LLY = LOCAL YEAR   LAST TWO DIGITS ONLY
C     LMON = LOCAL MONTH
C     LDAY = LOCAL DAY
C     LH = LOCAL HOUR
C     LM = LOCAL MINUTE
C     TMER = LOCAL TO WHICH TIME CORRESPONDS
C     DLAT = NORTHERN LATITUDE IN DEGREES
C     DLON = WEST LONGITUDE IN DEGREES
C     COSKI = COSINE OF ZENITH ANGLE
C     CHI = ZENITH ANGLE IN DEGREES
C     SUNRIS = TIME IN HOURS OF SUNRISE ON THAT DAY
C     SUNSET = TIME IN HOURS OF SUNSET ON THAT DAY
      DIMENSION NDO(12),NDL(12),TIMER(5),TIMES(5),HT(5)
      DATA DTR / 0.01745329 /
C     DAY NUMBERS FOR ORDINARY AND LEAP YEARS
      DATA NDO,NDL / 1,32,60,91,121,152,182,213,244,274,305,335,
     A 1,32,61,92,122,153,183,214,245,275,306,336/
C     AMPLITUDES OF FOURIER EXPANSION COEFFICIENTS   1955 EPOCH
      DATA P1,P2,P3,P4,P6 /
     A 0.017203534,0.034407068,0.051610602,0.068814136,0.103221204 /
      IF(MOD(LY,4).EQ.0) LD=NDL(LMON)+LDAY-1
      IF(MOD(LY,4).NE.0) LD=NDO(LMON)+LDAY-1
      LY=LLY-60
      MER=TMER
C     FIND TIME OF THE EQUINOX FOR THAT YEAR
      IF(LY) 7,7,9
7     IL=INT((3.1-LY)/4.)
      GO TO 11
9     IL=-INT((LY+.1)/4.)
11    DT=-0.7819+0.24225*LY+IL
      TD=LD+(LH+LM/60.+MER/15.)/24.
      TE=TD-DT
C     DECLINATION
      DCL=23.256*SIN(P1*(TE-82.242))+.381*SIN(P2*(TE-44.855))+.167*SIN
     1(P3*(TE-23.355))-.013*SIN(P4*(TE+11.97))+.011*SIN(P6*(TE-10.41))
     2+.339137
      DC=DCL*DTR
      TF=TE-.5
C     THE EQUATION OF TIME
      EQT=-7.38*SIN(P1*(TF-4.))-9.87*SIN(P2*(TF+9.))+.27*SIN(P3*(TF-53.
     A))-.2*COS(P4*(TF-17.))
      ET=EQT*DTR/4.
      FA=DLAT*DTR
      FB=DLON*DTR
      FC=MER*DTR
      PHO=FC-FB+ET
      T=LH+LM/60.
      PHI=.26179939*(T-12.)+PHO
      A=SIN(FA)*SIN(DC)
      B=COS(FA)*COS(DC)
      COSKI=A+B*COS(PHI)
C     THE ZENITH ANGLE
      SECKI=1./COSKI
      TANKI=SQRT(SECKI**2-1.)
      CHI=ATAN(TANKI)
      CHI=CHI/DTR
      IF(COSKI.LT.0.) CHI=180.-CHI
C
C     CALCULATE SUNRISE/SUNSET TIMES FOR DIFFERENT HEIGHTS
C     SEE EXPLANATORY SUPPLEMENT TO THE EPHEMERIS PG 401
C     SUNRISE AT HEIGHT H METRES IS AT
C             CHI(H)=90.83+0.0347*SQRT(H)
C     NOTE THAT THIS INCLUDES CORRECTIONS FOR HORIZONTAL REFRACTION
C     AND SEMI-DIAMETER OF SOLAR DISK
C
      ET=ET/0.26179939
      DO 40 IHT=1,NHT
C     COSKI AT THIS HEIGHT
      CH=COS((90.83+0.0347*SQRT(HT(IHT)*1.E3))*DTR)
      COSPHI=(CH-A)/B
      IF(COSPHI.NE.0.) GO TO 20
      PHI=3.141592654*0.5
      GO TO 25
20    SECPHI=1./COSPHI
C     ALLOW FOR SUN NEVER SETTING    HIGH LATITUDE SUMMER
      SUNSET=99.
      SUNRIS=99.
      IF(SECPHI.GT.-1..AND.SECPHI.LE.0.) GO TO 26
C     ALLOW FOR SUN NEVER RISING    HIGH LATITUDE WINTER
      SUNSET=-99.
      SUNRIS=-99.
      IF(SECPHI.GT.0..AND.SECPHI.LT.1.) GO TO 26
C...   NORMAL CONDITIONS OF SUNRISE & SUNSET
      TANPHI=SQRT(SECPHI**2-1.)
      PHI=ATAN(TANPHI)
      IF(SECPHI.LE.0.) PHI=3.141592654-PHI
25    CONTINUE
      SRLT=12.-PHI/0.26179939
      SUNRIS=SRLT+(DLON-TMER)/15.-ET
      SUNSET=24.-SRLT+(DLON-TMER)/15.-ET
      IF(SUNRIS.LT.0.) SUNRIS=SUNRIS+24.
      IF(SUNRIS.GE.24.) SUNRIS=SUNRIS-24.
      IF(SUNSET.LT.0) SUNSET=SUNSET+24.
      IF(SUNSET.GE.24.) SUNSET=SUNSET-24.
26    CONTINUE
      TIMER(IHT)=SUNRIS
      TIMES(IHT)=SUNSET
40    CONTINUE
C
      RETURN
      END
