C.I....For /CONTROL/
C   /CONTROL/   Refer to the INPUTDATA routine in VELHIO.FOR for a more
C	          complete explination of these variables.
C	CHKADR       -  Check AutoDrift operation
C	FILE         -  Flag to select between file and printer.
C	IGTYPE       -  Select type of graph to be generated, None if = 0
C	IGCONT       -  Determine contents of desired graph.
C	IGOPTN       -  Determine options for selected type of graph.
C	IGCLEAN      -  Determine the level of cleaning for Density Graphs.
C	ILIST        -  Listing operation selector, none if = 0
C	IAUX         -  Auxilary listing operation selector, none if = 0
C	IGROUP       -  Grouping options, in time (see INPUTDATA,TIMEBREAK)
C	IWEIGH       -  Weighting options (see INPUTDATA, WEIGHT)
C	ISORT        -  Sorting options (see INPUTDATA, SORTSOURCE)
C	IFILTER      -  Filtering options (see INPUTDATA, FILTER)
C	ICORRECT     -  Correction options (see INPUTDATA, CORRECT)
C	ICHOOSE      -  Data Choice options (see INPUTDATA, CHOOSE)
C	IU           -  The Input Unit # for reading MAPDATA
C	PU           -  The outPut Unit number, can be file or printer
C	AU           -  Auxilary Unit number for output, must be file.
C	INFILE       -  Input file name
C	LFILE        -  List file name
C	AFILE        -  Auxilary file name
C	GFLAG(NFRAB) -  Logical flag map indicating which FRAB's to GRAPH.
C	LFLAG(NFRAB) -  Logical flag map indicating which FRAB's to LIST.
C	      	      	      	      	      	      	      	 
	INTEGER IGTYPE,IGCONT,IGOPTN,IGCLEAN,ILIST,IAUX,IGROUP,IWEIGH,
     +        ISORT,IFILTER,ICHOOSE,IRECHOOSE,ICORRECT,IU,PU,AU
	LOGICAL CHKADR,FILE,GFLAG(NFRAB),LFLAG(NFRAB),
     +        AFLAG(NFRAB)
	CHARACTER*30 INFILE,LFILE,AFILE
	COMMON /CONTROL/ CHKADR,FILE,IGTYPE,IGCONT,IGOPTN,IGCLEAN,ILIST,
     +                 IAUX,IGROUP,IWEIGH,ISORT,IFILTER,ICHOOSE,
     +                 IRECHOOSE,ICORRECT,IU,PU,AU,INFILE,LFILE,AFILE,
     +                 GFLAG,LFLAG,AFLAG

C.....GRPVEL.CMN
C  /GRPVEL/        -  Statistical data for the Group Velocity in NFRAB
C	                possible Frequency-Range-Angle Bins.
C	                NFRAB and NSTAT are
C	                program parameters.
C	                The second index indicates which value is contained. 
C GVZ(NFRAB,NSTAT) -  Statistics for the Group Velocity Z-component.
C	     , 1)    -  Mean
C	     , 2)    -  Standard Deviation
C	     , 3)    -  Median
C	     , 4)    -  Upper quartile
C	     , 5)    -  Lower quartile
C	     , 6)    -  Most probable
C	     , 7)    -  Least Square fit to ALL data. 
C   8) -,NSTAT)    -  For future use  
C GVH(NFRAB,NSTAT) -  Statistics for the Group Velocity Horizontal magnitude.
C GAZ(NFRAB,NSTAT) -  Statistics for the Group Velocity horizontal AZimuth.
C GVX(NFRAB,NSTAT) -  Statistics for the Group Velocity X component.
C GVY(NFRAB,NSTAT) -  Statistics for the Group Velocity Y component.
C GSQ(NFRAB,NSTAT) -  Statistics for the velocity root mean square error.
C GVL(NFRAB,NSTAT) -  Statistics for the Group Velocity Line-of-Sight.
C GSL(NFRAB,NSTAT) -  Statistics for the LOS velocity root mean square error.
C NGVEL(NFRAB)     -  Number of measurements at each FRAB.
C NGVELOS(NFRAB)   -  Number of measurements at each FRAB.
C
C.....For /GRPVEL/
	REAL GVZ(NFRAB,NSTAT),GVH(NFRAB,NSTAT),GAZ(NFRAB,NSTAT),
     +     GVX(NFRAB,NSTAT),GVY(NFRAB,NSTAT),GSQ(NFRAB,NSTAT),
     +     GVL(NFRAB,NSTAT),GSL(NFRAB,NSTAT)
	INTEGER NGVEL(NFRAB),NGVELOS(NFRAB)
	COMMON /GRPVEL/ GVZ,GVH,GAZ,GVX,GVY,GSQ,GVL,GSL,NGVEL,NGVELOS

C.....For /MAPDATA/
C  /MAPDATA/   Data read in from input file (SKY output)
C	NMAP      	-  Record number from original tape (useless here)
C	IFF         -  Frequency/height number (1-4)
C	IPREF(89)   -  Digisonde Preface characters
C	FREQ        -  Frequency of measurement MHz
C	RANGE       -  Virtual height of the data, Km
C	GAIN        -  Receiver attenuation, dB
C	MPAMP       -  Most Probable AMPlitude, dB
C	MAXAMP      -  Maximum Amplitude, dB
C	ZMAX        -  Maximum Zenith angle, degrees
C	NUMSRC      -  # of sources that follow
C	YMAP(NDLM)   -  Y coordinates of sources
C	XMAP(NDLM)   -  X coordinates of sources
C	MAPAMP(NDLM) -  Amplitudes of sources, dB
C	MAPDOP(NDLM) -  Doppler channel # of sources
C	MAPRMS(NDLM) -  Source location error
C

	INTEGER*2 NMAP,IFF,GAIN,MPAMP,MAXAMP,NUMSRC,IPREF(89),
     +	       MAPAMP(NDLM),MAPDOP(NDLM),MAPRMS(NDLM)
	REAL FREQ,RANGE,YMAP(NDLM),XMAP(NDLM),ZMAX
	COMMON/MAPDATA/ NMAP,IFF,IPREF,FREQ,RANGE,GAIN,MPAMP,MAXAMP,
     +	             ZMAX,NUMSRC,YMAP,XMAP,MAPAMP,MAPDOP,MAPRMS

C.....For /SELECT/
C  /SELECT/  Values which effect the selection of CASES, SOURCES, VELOCITIES
C	MINSRC      -  Minimum # of sources to use for calculation
C	MINDOPP     -  Minimum Doppler # to use
C	MAXDOPP     -  Maximum Doppler # to use
C	MPOSERR     -  Maximum positional error to allow (degrees).
C	MCASESNR    -  Subcase maximum Signal - Noise case selection threshold.
C	MINLOBE     -  Lower threshold for source selection, realtive to
C	               subcase maximum amplitude.
C	MSRCSNR     -  Minimum SNR for each source.
C	VZMAX       -  Maximum vertical velocity to allow (m/s).
C	VHMAX       -  Maximum horizontal velocity to allow (m/s).
C	VERRMAX     -  Maximum % velocity error to allow.
C
	INTEGER MINSRC,MINDOPP,MAXDOPP,MPOSERR,MCASESNR,MINLOBE,MSRCSNR
	REAL VZMAX,VHMAX,VERRMAX,VOLMIN
	COMMON /SELECT/ MINSRC,MINDOPP,MAXDOPP,MPOSERR,MCASESNR,
     +                MINLOBE,MSRCSNR,VZMAX,VHMAX,VERRMAX,VOLMIN

C  For /SINDEX/
C  /SINDEX/  Index arrays for active (selected) /SOURCES/
C	NSELXED       - Number of active entries in SELINDX index.
C	SELINDX(NIND) - Index of those sources selected for INDIVEL2.
C
	INTEGER*2 NSELXED,SELINDX(NSS)
	COMMON/SINDEX/ NSELXED,SELINDX


C.....For /SOURCES/
C  /SOURCES/ Information on each source required for determining the
C	       velocity vector.  NSS is the parameter for the maximum
C            number of saved sources.
C	NSRCRS         - Current number of sources  (INTEGER*4)
C	NSOVER         - Current number of excess sources over NSS (INTEGER*4).
C	THETAS(NSS)    - INTEGER*2 arrival elevation angle*10, from Zenith.
C	PHIS(NSS)      - INTEGER*2 arrival azimuth*10, from magnetic North, 
C                      increasing to the EAST, like Navigational coordiantes.
C                      *** NOTE ***  This is opposite SKYMAP data conventions. 
C	ERMS(NSS)      - INTEGER*1 source RMS positional error.
C	AMPS(NSS)      - INTEGER*1 amplitude of the source,dB.
C	NOIS(NSS)      - INTEGER*1 noise (MPA) of the source,dB.
C	VRS(NSS)       - Radial velocity of the source. (REAL*4)
C	BINS(NSS,NFRAB)- INTEGER*1 The /BOUNDARY/ bins for this source.
C	                 Up to NOLAP are possible
C	ACTIVE(NSS)    - LOGICAL*1 flag indicating selection of this source.
c	devwgt(nss) - A weight based on the source deviation from an assumed velocity
C
	REAL VRS(NSS),devwgt(nss)
	INTEGER*1 ERMS(NSS),AMPS(NSS),NOIS(NSS),BINS(NSS,NOLAP)
	INTEGER*2 THETAS(NSS),PHIS(NSS)
	INTEGER*4 NSRCRS,NSOVER
	LOGICAL*1 ACTIVE(NSS)
	COMMON /SOURCES/ NSRCRS,NSOVER,THETAS,PHIS,ERMS,AMPS,NOIS,VRS,
     +                 BINS,ACTIVE,devwgt
C.....For /STATION/
C  /STATION/  Station dependent values
C	ILOC        -  Location # (1-6)
C	LOCATION    -  Name of station (text)
C	SID         -  3 character station ID code, should match preface.
C	GEOLAT      -  Geographic Latitide, Degrees North
C	GEOLON      -  Geographic Longitude, Degrees East
C	BLAT        -  Magnetic Latitude
C	BLONG       -  Magtetic Longitude.
C	VELHMAX     -  Maximum horizontal velocity magnitude for plots.
C	VELZMAX     -  Maximum absolute vertical velocity for plots.
C	GYROFREQ    -  Gyrofrequency in MHz.
C	DIPANGLE    -  Dip angle of the station, Degrees.
C
	INTEGER ILOC
	CHARACTER*3 SID
	CHARACTER*20 LOCATION
	REAL GEOLAT,GEOLON,BLAT,BLONG,VELHMAX,VELZMAX,GYROFREQ,DIPANGLE
	COMMON /STATION/ ILOC,LOCATION,SID,GEOLAT,GEOLON,BLAT,BLONG,
     +                 VELHMAX,VELZMAX,GYROFREQ,DIPANGLE

C.....For /SUMS/
C 
C  /SUMS/   Necessary components for calculating individual velocities
C	      Values here are intermediate steps in the Individual Velocity
C	      vector Least-square error calculation  (See INDIVEL2).
C	SUMW   - Sum of the weights.
C	SUMWVM - Sum of the product of the weights*velocities.
C	SUMWAV - Sum of weights*LOS directions*velocities (for Vlos).
C	SUMWAA - Sum of weights*LOS directions (for Vlos).
C	R(3,3) - The 9 component sums of the least-square fit. 
C	RVM(3) - The sum of the (R.Vm) term in the least-square fit.
C	NSUMS  - Number of data points involved in the above sums.
C
	REAL SUMW,SUMWVM,SUMWAV,SUMWAA,R(3,3),RVM(3)
	INTEGER NSUMS
	COMMON /SUMS/ SUMW,SUMWVM,SUMWAV,SUMWAA,R,RVM,NSUMS

C.....For /TIME/
C  /TIME/
C	STARTTIME, ENDTIME, NOWTIME, LASTTIME
C	ATIME       - Data Accumulation time = time over which data is
C	              averaged/smoothed. (seconds)
C	ACCSTIME    - The accumulation (averaging) start time. 
C	CSTIME,CETIME,CNTIME,CCSTIME,CLTIME - Times in CHARACTER*17 format
C	                         YYYY DDD HH:MM:SS 
C	NR2DO       - The number of Subcases to process if ENDTIME unspecified.
C
	REAL*8 STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME
	CHARACTER*17 CSTIME,CETIME,CNTIME,CLTIME,CCSTIME
	INTEGER NR2DO
	COMMON /TIME/ STARTTIME,ENDTIME,NOWTIME,LASTTIME,ATIME,ACCSTIME,
     +              CSTIME,CETIME,CNTIME,CLTIME,CCSTIME,NR2DO

C.....For /VELOCITY/
C  /VELOCITY/ The calculated individual velocity components.
C             NIND is a parameter for the maximum number of 
C	        individual velocities allowed.
C	NIVEL3D    -  Number of 3D individual velocities in the arrays.
C	NIV3OVR    -  Number of 3D velocities in excess of NIND.
C	NIVELOS    -  Number of LOS individual velocities in the arrays.
C	NIVLOVR    -  Number of LOS velocities in excess of NIND.
C	INDIVBIN   -  Bin number for these individual velocities.  
C	VX(NIND)   -  Velocity X components (m/s).
C	VY(NIND)   -  Velocity Y components (m/s).
C	VZ(NIND)   -  Velocity Z components (m/s).
C	ESR(NIND)  -  Root Mean Squared Error in the fit of the sources to
C	              the (VX,VY,VZ) uniform velocity.
C	DETR(NIND) -  The determinant of the R array in /SUMS/ for each
C	              individual velocities.  Used as an indication of
C	              the stability of the calculations.
C	VL(NIND)   -  The Line-of-Sight Velocity
C	ESRL(NIND) -  The Root Mean Squared error of the sources to the
C	              Line-of-Sight velocity.
C
	INTEGER NIVEL3D,NIV3OVR,NIVLOVR,NIVELOS,INDIVBIN
	REAL VX(NIND),VY(NIND),VZ(NIND),ESR(NIND),VL(NIND),ESRL(NIND)
	REAL DETR(NIND)
	COMMON /VELOCITY/ NIVEL3D,NIV3OVR,NIVELOS,NIVLOVR,INDIVBIN,
     +                  VX,VY,VZ,ESR,DETR,VL,ESRL

C.....For /VELPDFS/
C  /VELPDFS/ Similar to the information in the /VELOCITY/ block, the
C	       Individual Velocities are represented as Probability
C	       Distribution Functions in Cartesian and Cylindrical coordinates.
C	       See the subroutine MAKEPDF for details.
C	LIMV(1,4)    - Vx for the PDF: Low, High, # bins, #bins/tickmark.
C	    (2,4)    - Vy                   "
C	    (3,4)    - Vz                   "
C	    (4,4)    - Vhorizontal				"
C	    (5,4)    - Vazimuth					"
C	    (6,4)    - Vlos  					"
C	KPDF(1,NPDF) - The PDF for Vx.
C	    (2,NPDF) - The PDF for Vy.
C	    (3,NPDF) - The PDF for Vz.
C	    (4,NPDF) - The PDF for Vhorizontal.
C	    (5,NPDF) - The PDF for Vazimuth.
C	    (6,NPDF) - The PDF for Vlos
C	STEP(6)      - The value step for each of the 6 parameters above
C
	INTEGER LIMV(6,4)
	REAL STEP(6)
	INTEGER*2 KPDF(6,NPDF)
	COMMON /VELPDFS/ LIMV,KPDF,STEP

C.....BOUNDS.CMN
C.....For /BOUNDS/
C  /BOUNDS/      -  Data in this common block define the limits in
C                   Frequency, Range and Arrival Angle for each of the
C	              NFRAB's. 
C  NFRABS        -  Number of FRAB's defined.  Must be <= NFRAB.
C  TRUEHEIGHT    -  Logical flag selecting between true and virtual height
C	              selection of the data.  *** TRUE HEIGHT NOT YET AVAILABLE ***
C  BFRQ(NFRAB,2) -  Bounds upon the FReQuency, upper ,1) and lower ,2)
C  BRNG(NFRAB,2) -  Bounds upon the RaNGe, upper ,1) and lower ,2)
C  BANG(NFRAB,4) -  Bounds on the ANGles of arrival for this bin.
C                   ,1) = Zenith angle of the Line-of-Sight direction (deg).
C                   ,2) = Azimuth of the Line-of-Sight direction (deg).
C                   ,3) = Half 'Beamwidth' in Zenith (deg).
C                   ,4) = Half 'Beamwidth' in Azimuth (deg).
C  NBSRC(NFRAB)  - Number of sources in each FRAB
C 17 July 91
C  BAVFRQ(NFRAB) - Weighted sum/average frequency of sources in each bin
C  BAVHGT(NFRAB) - Weighted sum/average height of sources in each bin
C
	INTEGER NFRABS,NBSRC(NFRAB)
	LOGICAL TRUEHEIGHT
	REAL BFRQ(NFRAB,2),BRNG(NFRAB,2),BANG(NFRAB,4),
     +     BAVFRQ(NFRAB),BAVHGT(NFRAB)
	COMMON /BOUNDS/ NFRABS,TRUEHEIGHT,BFRQ,BRNG,BANG,NBSRC,
     +                BAVFRQ,BAVHGT


C.....PARAMS.CMN
C.....Program Parameters.  NOTE: NPDF must be EVEN.
	INTEGER NIND,NFRAB,NSTAT,NSS,NPDF,NDLM,NOLAP
	REAL VERSION
	PARAMETER (NIND= 2000, NFRAB= 25, NSTAT= 7, NSS= 2000, 
     +           NPDF= 180, NDLM= 128, NOLAP= 3) 
	PARAMETER (VERSION = 3.2)

