$DECLARE
$NOTRUNCATE
	SUBROUTINE MOMENT(DATA,N,AVE,ADEV,SDEV,VAR,SKEW,CURT)
C
C	Given an array of DATA lenght N, this routine returns its mean in
C	AVE, (first moment) the average deviation ADEV, the standard deviation
C     SDEV (second moment), the variance VAR, the skewness SKEW (third
C	moment) and the kutrosis CURT (fourth moment).
C
	INTEGER N,J
	REAL DATA(N),AVE,ADEV,SDEV,VAR,SKEW,CURT,S,P,TINY,huge
	PARAMETER (TINY=1.0E-8, HUGE=1.0E8)
C
	IF(N.LT.1) THEN
	   AVE  = 0.0
	   ADEV = 0.0
	   SDEV = 0.0
	   VAR  = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	   RETURN
	ENDIF
	IF (N.EQ.1) THEN
	   AVE  = DATA(1)
	   ADEV = 0.0
	   SDEV = 0.0
	   VAR  = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	   RETURN
	ENDIF
C
	S = 0.0
	DO 11 J = 1, N
	   S = S + DATA(J)
 11	CONTINUE
	AVE = S/N
	ADEV = 0.0
	VAR = 0.0
	SKEW = 0.0 
	CURT = 0.0
	DO 12 J = 1, N
	   S = DATA(J) - AVE
	   ADEV = ADEV + ABS(S)
C	   Attempt to eliminate overflow
	   P = MIN( S*S, HUGE)
	   VAR = VAR + P
	   P = P * S
	   SKEW = SKEW + P
	   P = MIN( P * S, HUGE)
	   CURT = CURT + P
 12	CONTINUE
	ADEV = ADEV/N
	VAR = VAR /(N-1)
	IF (VAR.GT.TINY) THEN
	   SDEV = SQRT(VAR)
	   SKEW = SKEW/(N*SDEV**3)
	   CURT = CURT/(N*VAR**2) - 3
	ELSE
C	   SKEW and CURT are undefined.
	   SDEV = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	ENDIF
	RETURN
	END
C
C  =======================================================================
C
	SUBROUTINE WMOMENT(DATA,W,N,AVE,ADEV,SDEV,VAR,SKEW,CURT)
C
C	Given an array of DATA lenght N with weights W, this routine returns
C	its weighted mean in AVE, (first moment) the average deviation ADEV,
C	the standard deviation SDEV (second moment), the variance VAR,
C	the skewness SKEW (third moment) and the kutrosis CURT (fourth moment).
C
	INTEGER N,J
	REAL DATA(N),W(N),AVE,ADEV,SDEV,VAR,SKEW,CURT,S,P,WSUM
C
	IF(N.LT.1) THEN
	   AVE  = 0.0
	   ADEV = 0.0
	   SDEV = 0.0
	   VAR  = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	   RETURN
	ENDIF
	IF (N.EQ.1) THEN
	   AVE  = DATA(1)
	   ADEV = 0.0
	   SDEV = 0.0
	   VAR  = 0.0
	   SKEW = 0.0
	   CURT = 0.0
	   RETURN
	ENDIF
C
	S = 0.0
	WSUM = 0.0
	DO 11 J = 1, N
	   S = S + DATA(J)*W(J)
	   WSUM = WSUM + W(J)
 11	CONTINUE
	IF(WSUM.NE.0) AVE = S/WSUM
	ADEV = 0.0
	VAR = 0.0
	SKEW = 0.0 
	CURT = 0.0
	DO 12 J = 1, N
	   S = DATA(J) - AVE
	   ADEV = ADEV + ABS(S)
	   P = S*S
	   VAR = VAR + P
	   P = P * S
	   SKEW = SKEW + P
	   P = P * S
	   CURT = CURT + P
 12	CONTINUE
	ADEV = ADEV/N
	VAR = VAR /(N-1)
	SDEV = 0.0
	IF (VAR.GT.0) SDEV = SQRT(VAR)
	IF (VAR.NE.0) THEN
	   SKEW = SKEW/(N*SDEV**3)
	   CURT = CURT/(N*VAR**2) - 3
	ELSE
C	   SKEW and CURT are undefined.
	   SKEW = 0.0
	   CURT = 0.0
	ENDIF
	RETURN
	END
C
C  ========================================================================
C
	SUBROUTINE MEDIAN1(X,N,XMED)
C
C	Given an array X of N numbers, this returns their median value XMED.
C	The array X is sorted in ascending order.
C
	INTEGER N,N2
	REAL X(N),XMED
	CALL SORT(N,X)
	N2 = N/2
	IF (N.EQ.0) THEN
	   XMED = 0.0
	   RETURN
	ENDIF
C
	IF(2*N2.EQ.N) THEN
	   XMED = 0.5*(X(N2) + X(N2+1))
	ELSE
	   XMED = X(N2+1)
	ENDIF
	RETURN
	END
C
	SUBROUTINE MEDIAN4(X,N,XMED,QU,QL)
C
C	Given an array X of N numbers, this returns their median value XMED
C	as well as the Lower Quartile (QL) and the Upper Quartile (QU).
C	The array X is sorted in ascending order in the process.
C
	INTEGER N,N2
	REAL X(N),XMED,QL,QU,D,P
	CALL SORT(N,X)
	N2 = N/2
	IF (N.EQ.0) THEN
	   XMED = 0.0
	   QU = 0.0
	   QL = 0.0
	   RETURN
	ELSE IF (N.EQ.1) THEN
	   XMED = X(1)
	   QU = XMED
	   QL = XMED
	   RETURN
	ENDIF
C
	IF(2*N2.EQ.N) THEN
	   XMED = 0.5*(X(N2) + X(N2+1))
	ELSE
	   XMED = X(N2+1)
	ENDIF
	D = (N-1)/4.0
	N2 = INT(D) + 1
	N2 = MIN(N-1,MAX(N2,1))
	P = D - INT(D)
	QL = (1.0 - P)*X(N2) + P*X(N2+1)
	D = 3.0*D
	N2 = INT(D) + 1
	N2 = MIN(N-1,MAX(N2,1))
	P = D - INT(D)
	QU = (1.0 - P)*X(N2) + P*X(N2+1)
	RETURN
	END
C
C
	SUBROUTINE MEDIAN10(X,N,XMED,DU,DL)
C
C	Given an array X of N numbers, this returns their median value XMED
C	as well as the upper 90% Decile (DU) and the lower 10% Decile (QL).
C	The array X is sorted in ascending order in the process.
C
	INTEGER N,N2
	REAL X(N),XMED,DL,DU,D,P
	CALL SORT(N,X)
	N2 = N/2
	IF (N.EQ.0) THEN
	   XMED = 0.0
	   DU = 0.0
	   DL = 0.0
	   RETURN
	ELSE IF (N.EQ.1) THEN
	   XMED = X(1)
	   DU = XMED
	   DL = XMED
	   RETURN
	ENDIF
C
	IF(2*N2.EQ.N) THEN
	   XMED = 0.5*(X(N2) + X(N2+1))
	ELSE
	   XMED = X(N2+1)
	ENDIF
	D = N/10.0
	N2 = INT(D) + 1
	N2 = MIN(N-1,MAX(N2,1))
	P = D - INT(D)
	DL = (1.0 - P)*X(N2) + P*X(N2+1)
	D = 9.0*D
	N2 = INT(D) + 1
	N2 = MIN(N-1,MAX(N2,1))
	P = D - INT(D)
	DU = (1.0 - P)*X(N2) + P*X(N2+1)
	RETURN
	END
C
C
	SUBROUTINE SORT(N,RA)
C
C	Sorts the array RA of length N into ascending numerical order using
C	Heapsort algorithm.  RA is replaced on output.  See Chapter 8 of
C	"Numerical Recipies."
C
	INTEGER L,N,IR,I,J
	REAL RA(N),RRA
C
	L = N/2+1
	IR = N
	IF (N.LT.2) RETURN
C
 10	CONTINUE
	   IF (L.GT.1) THEN
	      L = L - 1
	      RRA = RA(L)
	   ELSE
	      RRA = RA(IR)
	      RA(IR) = RA(1)
	      IR = IR - 1
	      IF (IR.EQ.1) THEN
	         RA(1) = RRA
	         RETURN
	      ENDIF
	   ENDIF
	   I = L
	   J = L + L
 20	IF (J.LE.IR) THEN
	      IF (J.LT.IR) THEN
	         IF(RA(J).LT.RA(J+1)) J = J + 1
	      ENDIF
	      IF (RRA.LT.RA(J)) THEN
	         RA(I) = RA(J)
	         I = J
	         J = J + J
	      ELSE
	         J = IR + 1
	      ENDIF
	   GOTO 20
	   ENDIF
	   RA(I) = RRA
	GOTO 10
	END
C
C
	SUBROUTINE INDEXX(N,ARRIN,INDX)
C
C	Indexes the array ARRIN of length N into ascending numerical order 
C	using a Heapsort algorithm.  The elements of INDX are such that
C	ARRIN(INDX(J)) are in ascending order for J=1,2,3,...N.
C	See Chapter 8 of "Numerical Recipies."
C
	INTEGER L,N,IR,I,J,INDXT
	INTEGER INDX(N)
	REAL ARRIN(N),Q
C
      DO 11 J=1,N
        INDX(J)=J
11    CONTINUE
      L=N/2+1
      IR=N
	IF (N.LT.2) RETURN
10    CONTINUE
        IF(L.GT.1)THEN
          L=L-1
          INDXT=INDX(L)
          Q=ARRIN(INDXT)
        ELSE
          INDXT=INDX(IR)
          Q=ARRIN(INDXT)
          INDX(IR)=INDX(1)
          IR=IR-1
          IF(IR.EQ.1)THEN
            INDX(1)=INDXT
            RETURN
          ENDIF
        ENDIF
        I=L
        J=L+L
20      IF(J.LE.IR)THEN
          IF(J.LT.IR)THEN
            IF(ARRIN(INDX(J)).LT.ARRIN(INDX(J+1)))J=J+1
          ENDIF
          IF(Q.LT.ARRIN(INDX(J)))THEN
            INDX(I)=INDX(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 20
        ENDIF
        INDX(I)=INDXT
      GO TO 10
      END
C
C
	SUBROUTINE LUDECOMP(A,N,NP,INDX,D,SING)
C
C	Given an NxN matrix A, with physical dimensions NP, this routine
C	replaces it by the LU decomposition of a rowwise premutation of itself.
C	A and N are input.  See Numeric Methods, p. 35 for more info.
C	SING is a flag indicating a singular matrix.

C
	INTEGER I,J,K,N,IMAX,NMAX,NP,INDX(N)
	PARAMETER (NMAX=100)
	REAL A(NP,NP),D,TINY,VV(NMAX),AAMAX,DUM,SUM
	PARAMETER(TINY = 1.0E-20)
	LOGICAL SING

C
	SING = .FALSE.
	D = 1.0
	DO 12 I = 1, N
	   AAMAX = 0.0
	   DO 11 J = 1, N
	      IF(ABS(A(I,J)).GT.AAMAX) AAMAX = ABS(A(I,J))
 11	   CONTINUE
	   IF (AAMAX.EQ.0) THEN
	      WRITE(*,*) 'LUDCMP -- Singular matrix'
	      SING = .TRUE.
	      RETURN
	   ENDIF
	   VV(I) = 1.0/AAMAX
 12	CONTINUE
C
	DO 19 J = 1, N
	   IF (J.GT.1) THEN
	      DO 14 I = 1, J-1
	         SUM = A(I,J)
	         IF (I.GT.1) THEN
	            DO 13 K = 1, I-1
	               SUM = SUM - A(I,K)*A(K,J)
 13	            CONTINUE
	            A(I,J) = SUM
               ENDIF
 14	      CONTINUE
         ENDIF
         AAMAX = 0.0
	   DO 16 I = J, N
	      SUM = A(I,J)
	      IF (J.GT.1) THEN
	         DO 15 K = 1, J-1
	            SUM = SUM - A(I,K)*A(K,J)
 15	         CONTINUE
	         A(I,J) = SUM
	      ENDIF
	      DUM = VV(I)*ABS(SUM)
	      IF (DUM.GE.AAMAX) THEN
	         IMAX = I
	         AAMAX = DUM
	      ENDIF
 16	   CONTINUE
	   IF (J.NE.IMAX) THEN
            DO 17 K = 1, N
	         DUM = A(IMAX,K)
	         A(IMAX,K) = A(J,K)
	         A(J,K) = DUM
 17	      CONTINUE
	      D = -D
	      VV(IMAX) = VV(J)
	   ENDIF
	   INDX(J) = IMAX
	   IF (J.NE.N) THEN
	      IF (A(J,J).EQ.0.0) A(J,J) = TINY
	      DUM = 1/A(J,J)
	      DO 18 I = J+1 ,N
	         A(I,J) = A(I,J)*DUM
 18	      CONTINUE
	   ENDIF
 19	CONTINUE
	IF(A(N,N).EQ.0.0) A(N,N) = TINY
	RETURN
	END
C
C
	SUBROUTINE LUBAKSUB(A,N,NP,INDX,B)
C
C	Solves the set of N linear equations Ax=B. The matrix to be input here
C	is not the original matrix A but its LU decomposition, determined by
C	LUDCMP.  INDX is input as the permuatation vector returned by LUDCMP.
C	B is input as the right-hand side vector and returns with the solution
C	x.  A, N, NP and INDX are not modified by this routine, which can be
C	called many times with different right-hand sides B without updating
C	A,N,NP,INDX.
C
	INTEGER N,NP,I,J,LL,II,INDX(N)
	REAL A(NP,NP),B(N),SUM
C
	II = 0
	DO 12 I = 1, N
	   LL = INDX(I)
	   SUM = B(LL)
	   B(LL) = B(I)
	   IF (II.NE.0) THEN
	      DO 11 J = II, I-1
	         SUM = SUM  - A(I,J)*B(J)
 11	      CONTINUE
	   ELSE IF (SUM.NE.0) THEN
	      II = I
	   ENDIF
	   B(I) = SUM
 12	CONTINUE
	DO 14 I = N, 1, -1
	   SUM = B(I)
	   IF (I.LT.N) THEN
	      DO 13 J = I+1, N
	         SUM = SUM - A(I,J)*B(J)
 13	      CONTINUE
	   ENDIF
	   B(I) = SUM/A(I,I)
 14	CONTINUE
	RETURN
	END
C
C
C
	INTEGER FUNCTION FACT(N)
C
C	Determines the factorial of N
	INTEGER I,N
	FACT = 1
	DO 1 I = 2, N
	   FACT = FACT*I
 1	CONTINUE
	RETURN
	END
C
C
	INTEGER FUNCTION NCOMB(N,R)
	INTEGER N,R,I
	NCOMB = N
	DO 10 I = 1, R-1
 10	NCOMB = (NCOMB*(N-I))/(I+1)
	RETURN
	END
C	
C
	REAL FUNCTION RAN2(IDUM)
C
C	Returns a uniform random deviate between 0.0 and 1.0.  Set argument
C	IDUM to any negative value to initialize or reinitialize the sequence.
C
	INTEGER M,IA,IC,IY,IDUM,IR(97),IFF,J
	REAL RM
	PARAMETER (M=714025,IA=1366,IC=150889,RM=1.0/M)
	DATA IFF / 0/
C
	IF ((IDUM.LT.0).OR.(IFF.EQ.0)) THEN
	   IFF = 1
	   IDUM = MOD(IC-IDUM,M)
C	   Initialize the shuffle table.
	   DO 11 J = 1, 97
	      IDUM = MOD(IA*IDUM+IC,M)
	      IR(J) = IDUM
 11	   CONTINUE
	   IDUM = MOD(IA*IDUM+IC,M)
	   IY = IDUM
	ENDIF
	J = 1+(97*IY)/M
	IF ((J.GT.97).OR.(J.LT.1)) J = 1
	IY = IR(J)
	RAN2 = IY*RM
	IDUM =MOD(IA*IDUM+IC,M)
	IR(J) = IDUM
	RETURN
	END
C
C
	SUBROUTINE FFT(DATA,NN,ISIGN)
C
C	Replaces DATA by its discrete Fourier Transform, if ISIGN is input
C	as +1, or replaces DATA by its inverse Fourier Transform if 
C	ISIGN = -1.  DATA is a complex array of length NN, or equivalently
C	a real array of length 2*NN.  NN **MUST** be an integer power of 2!
C
	INTEGER NN,ISIGN,N,I,J,M,MMAX,ISTEP
	REAL*8 WR,WI,WPR,WPI,WTEMP,THETA,PI
	REAL DATA(2*NN),TEMPR,TEMPI
C
	PI = 4.0D0*DATAN(1.0D0)
	N = 2*NN
	J = 1
C	This is the bit-reversal section of the routine
	DO 11 I = 1, N , 2
	   IF (J.GT.I) THEN
	      TEMPR = DATA(J)
	      TEMPI = DATA(J+1)
	      DATA(J) = DATA(I)
	      DATA(J+1) = DATA(I+1)
	      DATA(I) = TEMPR
	      DATA(I+1) = TEMPI
	   ENDIF
	   M = N/2
 1	   IF ((M.GE.2).AND.(J.GT.M)) THEN
	      J = J - M
	      M = M/2
	      GOTO 1
	   ENDIF
	   J = J + M
 11	CONTINUE
C
C	Here begins the Danielson-Lanczos section of the routine.
C	The outer loop is executed log2(NN) times.
C
	MMAX = 2
 2	IF (N.GT.MMAX) THEN
	   ISTEP = 2*MMAX
C	   Initialize for the trig. recurrence.
	   THETA = 2.0D0*PI/(ISIGN*MMAX)
	   WPR = -2.0D0*DSIN(0.5D0*THETA)**2
	   WPI = DSIN(THETA)
	   WR = 1.0D0
	   WI = 0.0D0
	   DO 13 M = 1, MMAX, 2
	      DO 12 I = M, N, ISTEP
	         J = I + MMAX
	         TEMPR = WR*DATA(J)   - WI*DATA(J+1)
	         TEMPI = WR*DATA(J+1) + WI*DATA(J)
	         DATA(J) = DATA(I) - TEMPR
	         DATA(J+1) = DATA(I+1) - TEMPI
	         DATA(I) = DATA(I) + TEMPR
	         DATA(I+1) = DATA(I+1) + TEMPI
 12	      CONTINUE
	      WTEMP = WR
	      WR = WR*WPR - WI*WPI + WR
	      WI = WI*WPR + WTEMP*WPI + WI
 13	   CONTINUE
	   MMAX = ISTEP
	   GOTO 2
	ENDIF
	RETURN
	END
C
C

