$DECLARE
$NOTRUNCATE
C 
C	Functions and things for the VELH program.
C
C
C
	LOGICAL FUNCTION REPORT(PROBLEM, WHERE)
C
	LOGICAL PROBLEM
	CHARACTER*70 WHERE
	CHARACTER*1 JUNK
C
	IF (PROBLEM) THEN
	   PROBLEM = .FALSE.
	   WRITE(*,*) ' Error detected from routine: '
	   WRITE(*,*) '           ',WHERE(1:30)
	   WRITE(*,*) ' Press <ENTER> to continue or ^C to stop: '
	   READ(*,'(A)') JUNK
	ENDIF
	REPORT = .FALSE.
	RETURN
	END
C
C ========================================================================
C
	CHARACTER*17 FUNCTION CTIME(ISEL)
C	
C	As a convenience feature, this function returns the CHARACTER*17 time
C	indicated by ISEL.
C
C	1) Current time (CNTIME)
C	2) Start time of current accumulation (CCSTIME)
C	3) Start time of entire run (CSTIME)
C	4) End time of entire run (CETIME)
C	5) CCSTIME, truncated to previous ATIME Min.
C	6) CCSTIME in Decimal Hours.
C
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
C
	INTEGER ISEL,IAT,IROUND,IH,IM,IS
	REAL RH,RM
	CHARACTER*17 CTT
C
	IF (ISEL.EQ.1) THEN
	   CTIME = CNTIME
	ELSE IF (ISEL.EQ.2) THEN
	   CTIME = CCSTIME
	ELSE IF (ISEL.EQ.3) THEN
	   CTIME = CSTIME
	ELSE IF (ISEL.EQ.4) THEN
	   CTIME = CETIME
	ELSE IF (ISEL.EQ.5) THEN
	   IF (ATIME.LE.0.0) RETURN
	   CTT = CCSTIME
C........# of Minutes to round off to.
	   RM = ATIME/60.
	   IAT = MAX(IROUND(RM),1)
	   READ (CTT,'(9X,I2,1X,I2,1X,I2)') IH,IM,IS
	   RM = IM + IS/60.
	   IM = IAT*INT(RM/IAT)
	   IF (IM.GE.60) THEN
	      IH = IH + 1
	      IM = IM - 60
	   ENDIF
	   IS = 0
	   WRITE(CTT,'(A9,I2.2,A1,I2.2,A1,I2.2)') CTT,IH,':',IM,':',IS
	   CTIME = CTT
	ELSE IF (ISEL.EQ.6) THEN
C........Time in YYYY DDD HH.HHHHH
	   CTT = CCSTIME
	   READ (CTT,'(9X,I2,1X,I2,1X,I2)') IH,IM,IS
	   RH = IH + IM/60. + IS/3600.
	   WRITE(CTT,'(A9,F8.5)') CTT(1:9),RH
	   CTIME = CTT
	ELSE
	   CTIME = 'CTIME:Bad option '
	ENDIF
	RETURN
	END

C
C
C
	REAL FUNCTION SIND(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	SIND = SIN(RAD*ANGLE)
	RETURN
	END
C
	REAL FUNCTION COSD(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	COSD = COS(RAD*ANGLE)
	RETURN
	END
C
	REAL FUNCTION TAND(ANGLE)
	REAL ANGLE,RAD
	DATA RAD /0.017453293/
	TAND = TAN(RAD*ANGLE)
	RETURN
	END
C
C.....Inverse Trig functions return angles in degrees from 0-360 
	REAL FUNCTION ACOSD(VALUE)
	REAL VALUE,DEG
	DATA DEG /57.29577951/
	IF (ABS(VALUE).GT.1.0) VALUE = SIGN(1.0,VALUE)
	ACOSD = DEG*ACOS(VALUE)
	IF (ACOSD.LT.0.0) ACOSD = ACOSD + 360.0
	RETURN
	END
C
	REAL FUNCTION ASIND(VALUE)
	REAL VALUE,DEG
	DATA DEG /57.29577951/
	IF (ABS(VALUE).GT.1.0) VALUE = SIGN(1.0,VALUE)
	ASIND = DEG*ASIN(VALUE)
	IF (ASIND.LT.0.0) ASIND = ASIND + 360.0
	RETURN
	END
C
	REAL FUNCTION ATAND2(Y,X)
	REAL Y,X,DEG
	DATA DEG /57.29577951/
	ATAND2 = 0.0
	IF ((Y.EQ.0).AND.(X.EQ.0)) RETURN
	ATAND2 = DEG*ATAN2(Y,X)
	IF (ATAND2.LT.0.0) ATAND2 = ATAND2 + 360.0
	RETURN
	END
C
C
	SUBROUTINE CARTESIAN(R,THETA,PHI,   X,Y,Z)
C
C	Given the spherical coordinate system values of R, THETA and PHI,
C	this routine calculates the corresponding Cartesian values of
C	X,Y,Z.  THETA and PHI are assumed to be in degrees.
C
	REAL X,Y,Z,R,THETA,PHI
	REAL SIND,COSD
C
	X = R*SIND(THETA)*COSD(PHI)
	Y = R*SIND(THETA)*SIND(PHI)
	Z = R*COSD(THETA)
	RETURN
	END
C	
C
C
C========================================================================
C
      REAL*8 FUNCTION PARSETIME(TIME)
C            This function takes an integer array of 11 values and
C         calculates the approximate number of seconds since January, 1900.
C         These values are for comparison purposes only.
C	    Performance across year boundires is not optimal, esp. leap years.
C         Will fail past the year 2000.
C
      INTEGER*2 TIME(11)
C         Seconds per year
      PARSETIME = 31662400.*(10*TIME(1)+ TIME(2))
C         Seconds per day
      PARSETIME = PARSETIME + 86400.*(100*TIME(3)+10*TIME(4)+TIME(5))
C         Seconds per hour
      PARSETIME = PARSETIME + 3600.*(10*TIME(6) + TIME(7))
C         Seconds per minute
      PARSETIME = PARSETIME + 60.*(10*TIME(8) + TIME(9))
C         And finally the seconds
      PARSETIME = PARSETIME + 10.*TIME(10) +1.*TIME(11)
      RETURN
      END
C
C========================================================================
C
	CHARACTER*17 FUNCTION CTIMELTT(LTT)
C.....Converts the 11 INTEGER*2 argument LTT into the 17 character
C.....CTT time format.
	INTEGER*2 I,LTT(11)
	CTIMELTT = ' '
	WRITE(CTIMELTT,102) (LTT(I),I=1,11)
 102	FORMAT ('19',2I1,1X,3I1,1X,2I1,':',2I1,':',2I1)
	RETURN
	END
C
C========================================================================
C
	REAL*8 FUNCTION PARCTIME(CTT)
C
C	Parse a CHARACTER*17 time into a REAL*8 time.
C
	REAL*8 PARSETIME
	CHARACTER*17 CTT
	INTEGER*2 LTT(11),ZERO,I
C
	ZERO = ICHAR('0')
C.....Year.
	LTT(1)  = ICHAR(CTT(3:3))   - ZERO
	LTT(2)  = ICHAR(CTT(4:4))   - ZERO
C.....Day.
	LTT(3)  = ICHAR(CTT(6:6))   - ZERO
	LTT(4)  = ICHAR(CTT(7:7))   - ZERO
	LTT(5)  = ICHAR(CTT(8:8))   - ZERO
C.....Hour.
	LTT(6)  = ICHAR(CTT(10:10)) - ZERO
	LTT(7)  = ICHAR(CTT(11:11)) - ZERO
C.....Minute.
	LTT(8)  = ICHAR(CTT(13:13)) - ZERO
	LTT(9)  = ICHAR(CTT(14:14)) - ZERO
C.....Second
	LTT(10) = ICHAR(CTT(16:16)) - ZERO
	LTT(11) = ICHAR(CTT(17:17)) - ZERO
C
	DO 5 I = 1, 11
	   IF (LTT(I).LT.0) LTT(I) = 0
 5	CONTINUE
C
	PARCTIME = PARSETIME(LTT)
	RETURN
	END
	

C ==========================================================================
C
	SUBROUTINE SETSTATION(LOC)
C
C	Initialize station parameters.
C
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
C
	INTEGER LOC
C
	IF (LOC.EQ.1) THEN
	   LOCATION = ' GOOSE BAY, LABRADOR'
	   SID = '   ' 
	   GEOLAT  =  53.32 
	   GEOLON  = 299.16
	   VELHMAX = 450.0
	ELSE IF (LOC.EQ.2) THEN
	   LOCATION = '  THULE, GREENLAND ' 
	   SID = '   '
	   GEOLAT  =  76.5
	   GEOLON  =  291.2
	   VELHMAX = 1000.0
	   VELZMAX =  100.0 
	ELSE IF (LOC.EQ.3) THEN
	   LOCATION = '   MILLSTONE HILL   '
	   SID = '042'
	   GEOLAT   =  42.6
	   GEOLON   = 288.5
	   GYROFREQ =   1.40
	   DIPANGLE =  72.9
	   VELHMAX  = 200.0
	   VELZMAX  =  20.0
	ELSE IF (LOC.EQ.4) THEN 
	   LOCATION = '  QANAQ, GREENLAND ' 
	   GEOLAT  =   77.5
	   GEOLON  =  290.8
	   VELHMAX = 1400.0
	   VELZMAX =  140.0 
	ELSE IF (LOC.EQ.5) THEN
	   LOCATION = '   ARGENTIA, NFLD   '
	   SID = 'A47'
	   GEOLAT  =  47.3
	   GEOLON  = 306.0
	   VELHMAX = 400.0
	   VELZMAX =  40.0
	ELSE IF (LOC.EQ.6) THEN
	   LOCATION = '   WALLOPS ISLAND   '
	   SID = '   '
	   GEOLAT  =  37.9
	   GEOLON  = 284.5
	   VELHMAX = 200.0
	   VELZMAX =  20.0
	ELSE IF (LOC.EQ.7) THEN
	   LOCATION = ' SONDRE STROMFJORD  '
	   SID = '067'
	   GEOLAT  =   66.99
	   GEOLON  =  309.05
	   VELHMAX = 1400.0
	   VELZMAX =  140.0
	ENDIF
	RETURN
	END
C
C
	INTEGER FUNCTION IROUND(VALUE)
C
	REAL VALUE
	IF (VALUE.GE.0) THEN
	   IROUND = INT(VALUE + 0.50001)
	ELSE
	   IROUND = INT(VALUE - 0.50001)
	ENDIF
	RETURN
	END
C
	INTEGER FUNCTION ISGN(I)
	INTEGER I
	IF (I.EQ.0) THEN
	   ISGN = 0
	ELSE IF (I.LT.0) THEN
	   ISGN = -1
	ELSE
	   ISGN = 1
	ENDIF
	RETURN
	END
C
C===========================================================================
C
	CHARACTER*1 FUNCTION OPTI(I)
C
C	Returns the Optifont character corresponding to the value of I.
C	I can take on values from 0 to 15.
C
	INTEGER I
	CHARACTER*1 CTABLE(0:15)
	INTEGER*1 ITABLE(0:15)
	EQUIVALENCE (ITABLE,CTABLE)
	SAVE CTABLE,ITABLE
C
C	Put the Optifont values (0-9 and A-F characters with the high bits
C	set) into CTABLE by loading integers into the EQUIVALENCEd ITABLE.
	DATA ITABLE/-80,-79,-78,-77,-76,-75,-74,-73,-72,-71,
     +            -63,-62,-61,-60,-59,-58/
C
	OPTI = CTABLE(MIN(MAX(I,0),15))
	RETURN
	END
C
C ========================================================================
C
	INTEGER FUNCTION GETINT(A,B)
C	Returns an integer read from the console in the range (A,B)
C
	INTEGER A,B,I
 10	READ(*,*,ERR=10) I
	IF ((I.LT.A).OR.(I.GT.B)) THEN
	   WRITE(*,*) ' Invalid choice, try again ...'
	   GOTO 10
	ENDIF
	GETINT = I
	WRITE(*,*) ' '
	RETURN
	END
C
C ========================================================================
C
	REAL FUNCTION GETFP(A,B)
C	Returns an integer read from the console in the range (A,B)
C
	REAL A,B,C
 10	READ(*,*,ERR=10) C
	IF ((C.LT.A).OR.(C.GT.B)) THEN
	   WRITE(*,*) ' Invalid choice, try again ...'
	   GOTO 10
	ENDIF
	GETFP = C
	WRITE(*,*) ' '
	RETURN
	END
C
C =========================================================================
C
	CHARACTER*1 FUNCTION OPTICOUNT(N)
C
C	This function returns the Optifont character roughly corresponding
C	to the LOG(N).  A table is used to get nice numbers.
C
	INTEGER KTABLE(0:15),I,N,K
	SAVE KTABLE
	CHARACTER*1 OPTI
C
C  Optifont value:  0     1    2    3    4     5     6     7       
	DATA KTABLE / 0,    2,   5,  10,  20,   30,   50,   75,
     +             100, 150, 200, 300, 500, 1000, 2000, 5000/
C  Optifont value:  8    9    A    B     C    D     E     F
C
C.....Run through the 16 KTABLE values until one of them is >=
C.....than the number points N.  The index at which this happens is
C.....the desired index.
C
	K = 15
	DO 10 I = 0, 15
	  IF (N.GE.KTABLE(I)) K = I
 10	CONTINUE
	OPTICOUNT = OPTI(K)
	RETURN
	END
C
C  ======================================================================
C
	SUBROUTINE INITOPTI(IO,SMALL)
C	Initializes the Okidata 192 printer with OptiFont characters
C	in place of the numbers 0-9 and the letters A-F, as well as the
C	period (.) character.
C	The array CHARSET contains the 12 decimal ASCII numbers needed to
C	define the Optifont characters.
C	If (SMALL) is .TRUE., Line spacing is 13/144", unidirectional.
C	If (SMALL) is .FALSE., Line spacing is 17/144", bidirectional.
C
	CHARACTER*2 STARTDEF,UNIDIR,BIDIR
	CHARACTER*3 DEFINEA
	CHARACTER*4 L13144,L17144
	INTEGER*2 CHARSET(17,12),I,IC
	INTEGER IO
	LOGICAL SMALL
C
	DATA (CHARSET(1,I),I=1,12)/176,0,0,20,0,0,0,0,0,0,0,0/
	DATA (CHARSET(2,I),I=1,12)/177,0,0,62,0,0,0,0,0,0,0,0/
	DATA (CHARSET(3,I),I=1,12)/178,58,0,0,36,0,0,0,0,0,0,0/
	DATA (CHARSET(4,I),I=1,12)/179,42,0,0,54,0,0,0,0,0,0,0/
	DATA (CHARSET(5,I),I=1,12)/180,14,0,8,0,0,60,0,0,0,0,0/
	DATA (CHARSET(6,I),I=1,12)/181,46,0,0,42,0,48,0,0,0,0,0/
	DATA (CHARSET(7,I),I=1,12)/182,62,0,0,40,0,56,0,0,0,0,0/
	DATA (CHARSET(8,I),I=1,12)/183,58,0,0,62,0,6,0,0,0,0,0/
	DATA (CHARSET(9,I),I=1,12)/184,62,0,0,42,0,30,0,0,0,0,0/
	DATA (CHARSET(10,I),I=1,12)/185,46,0,0,58,0,0,62,0,0,0,0/
	DATA (CHARSET(11,I),I=1,12)/193,62,0,0,54,0,0,62,0,0,0,0/
	DATA (CHARSET(12,I),I=1,12)/194,62,0,0,62,0,0,60,0,0,32,0/
	DATA (CHARSET(13,I),I=1,12)/195,62,0,0,62,0,0,58,0,0,36,0/
	DATA (CHARSET(14,I),I=1,12)/196,62,0,0,62,0,0,42,0,0,54,0/
	DATA (CHARSET(15,I),I=1,12)/197,62,0,0,62,0,0,62,0,0,28,0/
	DATA (CHARSET(16,I),I=1,12)/198,62,0,0,62,0,0,62,0,0,58,0/
	DATA (CHARSET(17,I),I=1,12)/174,0,0,0,0,0,8,0,0,0,0,0/
C
	STARTDEF = CHAR(27)//CHAR(36)
	DEFINEA = CHAR(27)//CHAR(37)//CHAR(65)
C	L13144 sets line spacing to 13/144" for Optifont
C	L17144 sets line spacing to 17/144" for Text.
C
	L13144 = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(13)
	L17144 = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(17)
	UNIDIR = CHAR(27)//CHAR(45)
	BIDIR = CHAR(27)//CHAR(61)
C
C	This copies the printer character set to printer's RAM,
C	Then transfers the OptiFont characters to the printer.
C	Unit IO is for the printer
C
	WRITE(IO,99) STARTDEF,
     +            (DEFINEA,(CHAR(CHARSET(IC,I)),I=1,12),IC=1,17)
 99	FORMAT(1X,A2,17(A3,12A1))
C.....Switches the printer to use the downloaded character set
	IF (SMALL) THEN
	   WRITE(IO,'(1X,2A1,A4,A2)') CHAR(27),CHAR(50),L13144,UNIDIR
	ELSE
	   WRITE(IO,'(1X,2A1,A4,A2)') CHAR(27),CHAR(50),L17144,BIDIR
	ENDIF	
	RETURN
	END


