$DECLARE
$NOTRUNCATE
C
C ======================================================================
C
	SUBROUTINE GRAPHEAD(IO,LINES,END)
C
C	Prints the header necesary for the various types of graphs. 
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\CONTROL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\SELECT.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELPDFS.CMN'
C
C
	INTEGER I,I1,I2,KTABLE(0:15),IROUND,ISPT(6),LAST,IO
	REAL SP
	LOGICAL END
	CHARACTER*140 LABL,SCAL
	CHARACTER*30 TYPE(3)
	CHARACTER*17 CTIME
	CHARACTER*1 OPTI,DOT
	CHARACTER*4 L13144,L17144
	SAVE LABL,SCAL,LAST
C
	DATA TYPE /'DENSITY GRAPH',
     +           'STATISTICAL GRAPH',
     +           'DENSITY + STATSITICAL GRAPH'/
C
C  Optifont value:  0    1    2    3    4    5    6   7       
	DATA KTABLE / 0,   2,   5,  10,  20,  30,  50, 75,
     +             100, 150, 200, 300, 500, 1000, 2000, 5000/
C  Optifont value:  8    9    A    B     C    D     E     F
C
	SP = 16.0
C	L13144 sets line spacing to 13/144" for Optifont
C	L17144 sets line spacing to 17/144" for Text.
	L13144 = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(13)
	L17144 = CHAR(27)//CHAR(37)//CHAR(57)//CHAR(17)
	DOT = CHAR(174)

C
	IF (END) THEN
C.....Print scales in reverse order
	   WRITE(IO,108) L13144,(DOT,I=0,LAST)
	   WRITE(IO,107) SCAL
	   WRITE(IO,107) LABL
	   RETURN
	ENDIF
C
	DO 10 I = 1, 6
C........STEP = Scale Steps per Bin, from /VELPDFS/
C........ISPT = Scale Steps per Tick
	   ISPT(I) = IROUND(STEP(I)*LIMV(I,4))
 10	CONTINUE
C
	IF (IGCONT.EQ.1) THEN
	   WRITE(LABL,401) 'Azimuth (',STEP(5),' deg, 90=East)',
     +                    'Vh (',STEP(4),' m/s)',
     +                    'Vz (',STEP(3),' m/s)'
	   WRITE(SCAL,501) (I,I=LIMV(5,1),LIMV(5,2),ISPT(5)),
     +                    (I,I=LIMV(4,1),LIMV(4,2),ISPT(4)),
     +                    (I,I=LIMV(3,1),LIMV(3,2),ISPT(3)) 
	   LAST = LIMV(3,3)+LIMV(4,3)+LIMV(5,3) + 6
C
	ELSE IF (IGCONT.EQ.2) THEN
	   WRITE(LABL,402) 'Azimuth (',STEP(5),' deg, 90=East)'
	   WRITE(SCAL,502) (I,I=LIMV(5,1),LIMV(5,2),ISPT(5))
	   LAST = LIMV(5,3)
C
	ELSE IF (IGCONT.EQ.3) THEN
	   WRITE(LABL,402) 'Vh (',STEP(4),' m/s)'
	   WRITE(SCAL,503) (I,I=LIMV(4,1),LIMV(4,2),ISPT(4))
	   LAST = LIMV(4,3)
C
	ELSE IF (IGCONT.EQ.4) THEN
	   WRITE(LABL,402) 'Vz (',STEP(3),' m/s)'
	   WRITE(SCAL,504) (I,I=LIMV(3,1),LIMV(3,2),ISPT(3))
	   LAST = LIMV(3,3)
C
	ELSE IF (IGCONT.EQ.5) THEN
	   WRITE(LABL,405) 'Azimuth (',STEP(5),' deg, 90=East)',
     +                    'Vh (',STEP(4),' m/s)'
	   WRITE(SCAL,505) (I,I=LIMV(5,1),LIMV(5,2),ISPT(5)),
     +                    (I,I=LIMV(4,1),LIMV(4,2),ISPT(4))
	   LAST = LIMV(4,3)+LIMV(5,3) + 3
C 
	ELSE IF (IGCONT.EQ.6) THEN
 	   WRITE(LABL,406) 'Vx (',STEP(1),' m/s)',
     +                    'Vy (',STEP(2),' m/s)',
     +                    'Vz (',STEP(3),' m/s)'
	   WRITE(SCAL,506) (I,I=LIMV(1,1),LIMV(1,2),ISPT(1)),
     +                    (I,I=LIMV(2,1),LIMV(2,2),ISPT(2)),
     +                    (I,I=LIMV(3,1),LIMV(3,2),ISPT(3)) 
	   LAST = LIMV(1,3)+LIMV(2,3)+LIMV(3,3) + 3
C
	ELSE IF (IGCONT.EQ.7) THEN
	   WRITE(LABL,402) 'Vx (',STEP(1),' m/s)' 
	   WRITE(SCAL,507) (I,I=LIMV(1,1),LIMV(1,2),ISPT(1)) 
	   LAST = LIMV(1,3)
C
	ELSE IF (IGCONT.EQ.8) THEN
 	   WRITE(LABL,402) 'Vy (',STEP(2),' m/s)'
	   WRITE(SCAL,507) (I,I=LIMV(2,1),LIMV(2,2),ISPT(2))
	   LAST = LIMV(2,3)
C
	ELSE IF (IGCONT.EQ.9) THEN
 	   WRITE(LABL,409) 'Vx (',STEP(1),' m/s)',
     +                    'Vy (',STEP(2),' m/s)'
	   WRITE(SCAL,509) (I,I=LIMV(1,1),LIMV(1,2),ISPT(1)),
     +                    (I,I=LIMV(2,1),LIMV(2,2),ISPT(2))
	   LAST = LIMV(1,3)+LIMV(2,3) + 3
C
	ELSE IF (IGCONT.EQ.10) THEN
	   WRITE(LABL,402) 'Vlos (',STEP(6),' m/s)'
	   WRITE(SCAL,504) (I,I=LIMV(6,1),LIMV(6,2),ISPT(6))
	   LAST = LIMV(6,3)
	ENDIF
C
 401	FORMAT(30X,A,F4.1,A,30X,A,F4.1,A,20X,A,F4.1,A)
 402	FORMAT(60X,A,F4.1,A)
 405	FORMAT(35X,A,F4.1,A,45X,A,F4.1,A)
 406	FORMAT(30X,A,F4.1,A,40X,A,F4.1,A,26X,A,F4.1,A)
 409	FORMAT(30X,A,F4.1,A,30X,A,F4.1,A)
C
 501	FORMAT(3X,'UT ',13I5,I3,8I5,I4,I5,I4,I6,I5)
 502	FORMAT(3X,'UT ',25I5)
 503	FORMAT(3X,'UT ',I5,20I6)
 504	FORMAT(3X,'UT ',I5,9I6,I6,9I6,I7)
 505	FORMAT(3X,'UT ',I5,12I6,I3,9I5,I6)
 506	FORMAT(3X,'UT ',11I5,5I5,I4,5I5,I4,3I5,I4)
 507	FORMAT(3X,'UT ',21I6)
 509	FORMAT(3X,'UT ',10I6,I5,I5,10I6)
C
	WRITE(IO,*) L17144
	WRITE(IO,101) TYPE(IGTYPE)
	WRITE(IO,102) CTIME(2)
	WRITE(IO,103) LOCATION
	WRITE(IO,104) (KTABLE(I),I=0,15)
	WRITE(IO,105) (IROUND(100.*I/SP),I=0,16)
	WRITE(IO,106) (OPTI(I),I=0,15)
	WRITE(IO,*) ' '
	WRITE(IO,110) NFRABS
	DO 20 I1 = 1, NFRABS, 25
	   I2 = MIN(I1+24,NFRABS)
	   WRITE(IO,111) (I,I=I1,I2)
	   WRITE(IO,112) 'Low  F ',(BFRQ(I,1),I=I1,I2)
	   WRITE(IO,112) 'High F ',(BFRQ(I,2),I=I1,I2)
	   WRITE(IO,113) 'Low  H ',(INT(BRNG(I,1)),I=I1,I2)
	   WRITE(IO,113) 'High H ',(INT(BRNG(I,2)),I=I1,I2)
	   WRITE(IO,112) 'Zenith ',(BANG(I,1),I=I1,I2)
	   WRITE(IO,112) 'Azimuth',(BANG(I,2),I=I1,I2)
	   WRITE(IO,112) 'BWzen  ',(BANG(I,3),I=I1,I2)
	   WRITE(IO,112) 'BWaz   ',(BANG(I,4),I=I1,I2)
	   WRITE(IO,*) ' '
 20	CONTINUE
	WRITE(IO,109) IGCLEAN
	WRITE(IO,114)'Weight','Sort','MinSrc','MinDop','MaxDop','dVmax',
     +             'MaxVh','MaxVz','CaseSNR','MinLobe','SrcSNR',
     +             'SrcErr'
	WRITE(IO,115) IWEIGH,ISORT,MINSRC,MINDOPP,MAXDOPP,VERRMAX,
     +              VHMAX,VZMAX,MCASESNR,MINLOBE,MSRCSNR,MPOSERR
	WRITE(IO,*) ' '
	WRITE(IO,107) LABL
	WRITE(IO,107) SCAL
	WRITE(IO,108) L13144,(DOT,I=0,LAST)
	LINES = 183

 101	FORMAT (60X,A)
 102  FORMAT (50X,'Start time: ',A)
 103  FORMAT (45X,'Drift Velocity Vectors for: ',A/)
 104	FORMAT (5X,'Numbers between     :',16I6,'+')
 105  FORMAT (5X,'Percentages between :',17I6)
 106	FORMAT (5X,'Are printed as      :  ',16A6)
 107	FORMAT (A138)
 108	FORMAT (1X,A4,9X,138A1)
 109	FORMAT (' Cleaning = ',Z1)
 110	FORMAT (30X,'Frequency-Range Bin Boundries in MHz and Km,',
     +            ' Total of ',I3,' defined')
 111	FORMAT (9X,25I5)
 112	FORMAT (1X,A8,25F5.1)
 113	FORMAT (1X,A8,25I5)
 114	FORMAT (12A8)
 115	FORMAT (5I8,F8.2,2F8.0,4I8)
	RETURN
	END
C
C===========================================================================
C
	SUBROUTINE BLANKLINE(CLINE,IGCON,ALLDOTS)
C
C	Fills the LINE with spaces and the appropriate vertical lines
C	for graph limits and dots for tick marks.  If ALLDOTS is .TRUE., 
C	all spaces are replaced with dots.
C	NOTE: This method is not perfect for odd numbers of bins.  It makes
C	the upper half space one bin larger than the lower half.  It is mostly
C	unnoticable, and is not worth the effort needed to correct.
C
C	The array ISEQ determines which data type (1-6) gets placed in 
C	which column of the graph (First, Second, Third,...)
C	depending upon the graphing option number (1-10).  Something similar
C	is done in the SCALEDGR routine.
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELOCITY.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELPDFS.CMN'
C
	INTEGER I,IGCON,IK,J,NB,NT,POS,M
	INTEGER*1 ISEQ(6,10)
	CHARACTER*1 CLINE(140),VLINE,DOT
	LOGICAL ODD,ALLDOTS
C
C............Option #          1  2  3  4  5  6  7  8  9 10
	DATA (ISEQ(1,J),J=1,10)/ 5, 5, 4, 3, 5, 1, 1, 2, 1, 6/
	DATA (ISEQ(2,J),J=1,10)/ 4, 0, 0, 0, 4, 2, 0, 0, 2, 0/
	DATA (ISEQ(3,J),J=1,10)/ 3, 0, 0, 0, 0, 3, 0, 0, 0, 0/
	DATA (ISEQ(4,J),J=1,10)/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0/
	DATA (ISEQ(5,J),J=1,10)/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0/
	DATA (ISEQ(6,J),J=1,10)/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0/

C
	DOT = CHAR(174)
	VLINE = CHAR(124)
	DO 10 I = 1, 140
	   CLINE(I) = ' '
 10	CONTINUE
C
C.....Room for date/time on each line.
	POS = 10
C.....Fill with dots past the date/time.
	IF (ALLDOTS) THEN
	   DO 11 I = POS, 140
	      CLINE(I) = DOT
 11	   CONTINUE
	ENDIF
C
	DO 20 IK = 1,6 
	   I = ISEQ(IK,IGCON)
	   IF (I.NE.0) THEN
	      NB = LIMV(I,3)
	      NT = LIMV(I,4)
	      IF (NB.GT.0) THEN
C..............Place vertical lines and dots.
	         ODD = 2*INT(NB/2).NE.NB
	         CLINE(POS) = VLINE
	         CLINE(POS+NB) = VLINE
	         IF (ODD) THEN
	            M = NB/2
	            CLINE(POS+M) = VLINE
	            DO 14 J = NT, M-NT, NT
	               CLINE(POS+M-J) = DOT
	               CLINE(POS+M+J) = DOT
 14	            CONTINUE 
	         ELSE
	            DO 15 J = NT, NB-NT, NT
	               CLINE(POS+J) = DOT
 15	            CONTINUE
	         ENDIF
	         POS = POS + NB + 3
	      ENDIF
	   ENDIF
 20	CONTINUE
	RETURN
	END

C
C =======================================================================
C
	SUBROUTINE SCALEDGR(IGT,IGC)
C
C	This routine sets the scales for the /VELPDFS/ block which define
C	how the PDFs are to be calculated.
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELOCITY.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELPDFS.CMN'
C
	INTEGER I,J,IGT,IGC,IROUND
	REAL STEPMIN
	LOGICAL ODD
	PARAMETER(STEPMIN = 0.001)
C
C	IGC    -- Determines the contnents of the Density Graph
C	     1  = Azimuth, Vh and Vz.
C	     2  = Azimuth only.
C	     3  = Horizontal velocity (Vh) only.
C	     4  = Vertical velocity (Vz) only.
C	     5  = Az and Vh.
C	     6  = Vx, Vy and Vz.
C	     7  = Vx only.
C	     8  = Vy only.
C	     9  = Vx and Vy.
C	    10  = Vlos
C
C	The first 8 characters on the line are reserved for times, dates
C	and other various codes.  The remaining characters are divided up
C	as follows:
C	These arrays determine how many bins (NBIN) and how many
C	bins per tick mark (NTIK) on the scales to use for each varible
C	depending upon which type of graph is selected.
C	Variables are : 1=Vx, 2=Vy, 3=Vz, 4=Vh, 5=Az, 6=Vlos. 
C
	INTEGER*1 NBIN(6,10),NTIK(6,10)
C............Option #           1   2   3   4   5   6   7   8   9  10
	DATA (NBIN(1,J),J=1,10)/  0,  0,  0,  0,  0, 51,121,  0, 61,  0/
	DATA (NBIN(2,J),J=1,10)/  0,  0,  0,  0,  0, 51,  0,121, 61,  0/
	DATA (NBIN(3,J),J=1,10)/ 21,  0,  0,121,  0, 21,  0,  0,  0,  0/
	DATA (NBIN(4,J),J=1,10)/ 40,  0,120,  0, 50,  0,  0,  0,  0,  0/
	DATA (NBIN(5,J),J=1,10)/ 60,120,  0,  0, 72,  0,  0,  0,  0,  0/
	DATA (NBIN(6,J),J=1,10)/  0,  0,  0,  0,  0,  0,  0,  0,  0,120/
C
C............Option #          1  2  3  4  5  6  7  8  9 10
	DATA (NTIK(1,J),J=1,10)/ 0, 0, 0, 0, 0, 5, 6, 0, 6, 0/
	DATA (NTIK(2,J),J=1,10)/ 0, 0, 0, 0, 0, 5, 0, 6, 6, 0/
	DATA (NTIK(3,J),J=1,10)/ 5, 0, 0, 6, 0, 5, 0, 0, 0, 0/
	DATA (NTIK(4,J),J=1,10)/ 5, 0, 6, 0, 5, 0, 0, 0, 0, 0/
	DATA (NTIK(5,J),J=1,10)/ 5, 5, 0, 0, 6, 0, 0, 0, 0, 0/
	DATA (NTIK(6,J),J=1,10)/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 6/
C
C
C	Set logical PDF limits.  Will be changed as necessary depending
C	on which DENGRAPH is chosen.
C	Also, set a BINNING of the PDF's to be calculated when 
C	NOT doing a DENGRAPH at this point in this routine. 

C......X component
	 LIMV(1,1) = - IROUND(VELHMAX)
	 LIMV(1,2) =   IROUND(VELHMAX)
C......Y component
	 LIMV(2,1) = - IROUND(VELHMAX)
	 LIMV(2,2) =   IROUND(VELHMAX)
C......Z component
	 LIMV(3,1) = - IROUND(VELZMAX)
	 LIMV(3,2) =   IROUND(VELZMAX)
C......Horizontal component
	 LIMV(4,1) =   0
	 LIMV(4,2) =   IROUND(VELHMAX)
C......Azimuth
	 LIMV(5,1) = 0
 	 LIMV(5,2) = 360
C......LOS component
	 LIMV(6,1) = - IROUND(VELZMAX)
	 LIMV(6,2) =   IROUND(VELZMAX)

C......Default Binning, use ALL bins.  NPDF assumed to be EVEN!!
	 DO 22 I = 1, 6
	   LIMV(I,3) = NPDF
	   STEP(I) = MAX(STEPMIN,REAL(LIMV(I,2)-LIMV(I,1))/NPDF)
 22	 CONTINUE
C
	IF (IGT.EQ.0) RETURN
	IF (IGC.LT.1.OR.IGC.GT.10) IGC = 1
C
C.....Set the # of PDF bins and tick spacing for each variable 
C.....based on the NBIN array.
	DO 30 I = 1, 6
	   LIMV(I,3) = NBIN(I,IGC)
	   LIMV(I,4) = NTIK(I,IGC)
C........Set the STEP value for each element.
	   IF (LIMV(I,3).GT.1) THEN
	      ODD = 2*INT(LIMV(I,3)/2).NE.LIMV(I,3)
	      IF (ODD) THEN
	         STEP(I) = 
     +          MAX(REAL(LIMV(I,2)-LIMV(I,1))/(LIMV(I,3)-1),STEPMIN)
	      ELSE
	         STEP(I) = 
     +          MAX(REAL(LIMV(I,2)-LIMV(I,1))/LIMV(I,3),STEPMIN)
	      ENDIF
	   ELSE
	      STEP(I) = 1000.
	   ENDIF
 30	CONTINUE
	RETURN
	END
C
C==========================================================================
C
	SUBROUTINE DENGRAPH(IGC,CLINE,KLEAN)
C
C	This subroutine produces an Optifont %density graph of the  
C	calculated individual drift velocity vectors.
C	Output is to the character line array CLINE.  All printing, 
C	including CLINE, graph headers and titles, is handled externally.
C
C	The first ITO(=9) characters of the line have been/will be defined,
C	usually with the time or other useful information.
C
C	A probability density function is taken for the Horizontal velocity,
C	the Azimuth and the Vertical velocity.  The  PERCENTAGE of entries in
C	each bin	is scaled and printed in Optifont.
C
C	The calculation of the PDFs is performed in the GROUPVEL routine
C	with the assistance of the PDF routine.  These routines need
C	information on how to calculate the PDFs to be placed in the
C	LIMV() arrays in the /VELPDF/ block.  The SCALEDGR routine sets
C	these limits such that the DENGRAPH routine can just print all of
C	the bins.
C
C	IGC    -- Determines the contnents of the Density Graph
C	     1  = Azimuth, Vh and Vz.
C	     2  = Azimuth only.
C	     3  = Horizontal velocity (Vh) only.
C	     4  = Vertical velocity (Vz) only.
C	     5  = Az and Vh.
C	     6  = Vx, Vy and Vz.
C	     7  = Vx only.
C	     8  = Vy only.
C	     9  = Vx and Vy.
C	    10  = Vlos.
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELOCITY.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELPDFS.CMN'
C
	INTEGER IGC,I,N,ITO,POS,K,IROUND,KLEAN,NIVEL
	CHARACTER*1 CLINE(140),VLN,DOT
	CHARACTER*1 OPTI,OPTICOUNT
	REAL SP
	LOGICAL OK
C
C.....SP is the scale factor to convert percentages to (0-15)
	SP = 16.0
C.....SK is the scale factor for the total number of points.
C.....ITO is the number of characters the time takes at the line start.
C
	ITO = 9			  
	DOT = CHAR(174)
	VLN = CHAR(124)
	POS = ITO
C
	IF (IGC.EQ.10) THEN
	   NIVEL = NIVELOS
	ELSE
	   NIVEL = NIVEL3D
	ENDIF
C
C.....Total number of points.  Check a lookup table for which character
C.....to print for the number of sources.
C
	IF (NIVEL.EQ.0) THEN
C........No data, return the empty line now.
	   RETURN
	ENDIF
C
	CLINE(POS) = OPTICOUNT(NIVEL)
	POS = POS + 1
C
	IF (IGC.EQ.1) THEN
C........Add Azimuth, Horizontal and Vertical velocities.
	   N = LIMV(5,3)
	   DO 15 I = 1, N
	      K = IROUND(SP*KPDF(5,I)/FLOAT(NIVEL))
	      OK = (KPDF(5,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 15	   CONTINUE
	   POS = POS + N + 3
	   N = LIMV(4,3)
	   DO 14 I = 1, N
	      K = IROUND(SP*KPDF(4,I)/FLOAT(NIVEL))
	      OK = (KPDF(4,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 14	   CONTINUE
	   POS = POS + N + 3
	   N = LIMV(3,3)
	   DO 13 I = 1, N
	      K = IROUND(SP*KPDF(3,I)/FLOAT(NIVEL))
	      OK = (KPDF(3,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 13	   CONTINUE
	ELSE IF (IGC.EQ.2) THEN
C........Add only the azimuth.
	   N = LIMV(5,3)
	   DO 25 I = 1, N
	      K = IROUND(SP*KPDF(5,I)/FLOAT(NIVEL))
	      OK = (KPDF(5,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 25	   CONTINUE
	ELSE IF (IGC.EQ.3) THEN
C........Add only the Horizontal velocity.
	   N = LIMV(4,3)
	   DO 34 I = 1, N
	      K = IROUND(SP*KPDF(4,I)/FLOAT(NIVEL))
	      OK = (KPDF(4,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 34	   CONTINUE
	ELSE IF (IGC.EQ.4) THEN
C........Add only the Vertical velocity.
	   N = LIMV(3,3)
	   DO 43 I = 1, N
	      K = IROUND(SP*KPDF(3,I)/FLOAT(NIVEL))
	      OK = (KPDF(3,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 43	   CONTINUE
	ELSE IF (IGC.EQ.5) THEN
C........Add Azimuth and Horizontal Velocity.
	   N = LIMV(5,3)
	   DO 55 I = 1, N
	      K = IROUND(SP*KPDF(5,I)/FLOAT(NIVEL))
	      OK = (KPDF(5,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 55	   CONTINUE
	   POS = POS + N + 3
	   N = LIMV(4,3)
	   DO 54 I = 1, N
	      K = IROUND(SP*KPDF(4,I)/FLOAT(NIVEL))
	      OK = (KPDF(4,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 54	   CONTINUE
	ELSE IF (IGC.EQ.6) THEN
C........Add Vx, Vy and Vz
	   N = LIMV(1,3)
	   DO 61 I = 1, N
	      K = IROUND(SP*KPDF(1,I)/FLOAT(NIVEL))
	      OK = (KPDF(1,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 61	   CONTINUE
	   POS = POS + N + 3
	   N = LIMV(2,3)
	   DO 62 I = 1, N
	      K = IROUND(SP*KPDF(2,I)/FLOAT(NIVEL))
	      OK = (KPDF(1,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 62	   CONTINUE
	   POS = POS + N + 3
	   N = LIMV(3,3)
	   DO 63 I = 1, N
	      K = IROUND(SP*KPDF(3,I)/FLOAT(NIVEL))
	      OK = (KPDF(3,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 63	   CONTINUE		 
	ELSE IF (IGC.EQ.7) THEN
C........Add Vx only.
	   N = LIMV(1,3)
	   DO 71 I = 1, N
	      K = IROUND(SP*KPDF(1,I)/FLOAT(NIVEL))
	      OK = (KPDF(1,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 71	   CONTINUE

	ELSE IF (IGC.EQ.8) THEN
C........Add Vy only.
	   N = LIMV(2,3)
	   DO 82 I = 1, N
	      K = IROUND(SP*KPDF(2,I)/FLOAT(NIVEL))
	      OK = (KPDF(2,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 82	   CONTINUE
	ELSE IF (IGC.EQ.9) THEN
C........Add Vx and Vy.
	   N = LIMV(1,3)
	   DO 91 I = 1, N
	      K = IROUND(SP*KPDF(1,I)/FLOAT(NIVEL))
	      OK = (KPDF(1,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 91	   CONTINUE
	   POS = POS + N + 3
	   N = LIMV(2,3)
	   DO 92 I = 1, N
	      K = IROUND(SP*KPDF(2,I)/FLOAT(NIVEL))
	      OK = (KPDF(2,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 92	   CONTINUE
	ELSE IF (IGC.EQ.10) THEN
C........Add only the Line-of-Sight velocity.
	   N = LIMV(6,3)
	   DO 101 I = 1, N
	      K = IROUND(SP*KPDF(6,I)/FLOAT(NIVEL))
	      OK = (KPDF(6,I).GT.0).AND.(K.GE.KLEAN) 
	      IF (OK) CLINE(I+POS) = OPTI(K)
 101	   CONTINUE
	ELSE
C
	   WRITE(*,*) ' DENGRAPH -- Invalid content option:',IGC
	ENDIF
C
	RETURN
	END
C
