$DECLARE
$NOTRUNCATE	
C
C =========================================================================
C
	SUBROUTINE OUTPUT(IBIN)
C
C	Directs the calling of the various output routines based on the
C	/CONTROL/ variables.  Also manages the printing of headers,
C	FormFeeds, and other loose ends that make a pretty output page.
C
C	   LDAY - The DayNumber the last time this routine was called.
C	   LCT  - The Last CTime for this routine.
C
C	The routines which do the writing/printing should not have to
C	access the /CONTROL/ block, but have their control parameters
C	passed as arguments.
C	Position on the page is monitored in units of 1/144".
C	Each print routine must pass upward the number of 1/144" it used on
C	the last call.
C
C	Arguement switches:
C	   IBIN=-1  - Writes scales on bottom of graph.  Closes I/O files.
C	   IBIN= 0  - Writes a blank line, with time, etc but no data.
C
C	Graph Types: IGTYPE
C	    1) Density Graph.
C	    2) Statistial Graph: (mean,median,quartile, etc).
C	    3) Density and Statistical graphs superimposed.
C
C
C.....Options defined by the bits in the IGOPTN variable:
C	 1: 0=All/1=Best bins printed. 
C	 2: 0=Exclude/1=Include Sunrise/Sunset times for station.
C	 4: 0=Continuous/1=Daily page breaks.
C	 8: 0=Actual/1=Rounded time.
C
C.....Paramteters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\CONTROL.CMN'

	INTEGER IBIN,PAGE144,POS144,NLUSED,JUNK,MS,JBIN,I,IDAY,LDAY
	LOGICAL GRAPH,LIST,AUX,HEADER,BEST,SUN,BREAK,ROUND,DENSG,STATG,
     +        UTIME,FRBIN,END,EMPTYLINE,NEWDAY,BLANK
	CHARACTER*17 LCT,CT,CTIME
	CHARACTER*1 CLINE(140),SUNRIZE
	SAVE PAGE144,POS144,HEADER,LCT,LDAY
C
	DATA PAGE144 /1584/
	DATA POS144 /0/
	DATA HEADER /.TRUE./
	DATA LCT /'XXX'/
	DATA LDAY /0/
C
	PAGE144 = 0
	IF (IBIN.EQ.-1) THEN
C........Write the scales on the bottom of graphs.
	   END = .TRUE.
	   CALL PRTHEAD(PU,IGTYPE,ILIST,NLUSED,END)
C........Terminate by closing files, etc.
	   CLOSE (UNIT=PU)
	   CLOSE (UNIT=AU)
	   RETURN
	ENDIF
C
C
C.....Options defined by the bits in the IGOPTN variable:
C	 1: 0=All/1=Best bins printed. 
C	 2: 0=Exclude/1=Include Sunrise/Sunset times for station.
C	 4: 0=Continuous/1=Daily page breaks.
C	 8: 0=Actual/1=Rounded time.
C	16: 0=All/1=Unique time printing.
C	32: 0=Exclude/1=Include FRB printing.
C	64: 0=Exclude/1=Include Blank Lines
C
	BEST  = IAND(IGOPTN,1).NE.0
	SUN   = IAND(IGOPTN,2).NE.0
	BREAK = IAND(IGOPTN,4).NE.0
	ROUND = IAND(IGOPTN,8).NE.0
	UTIME = IAND(IGOPTN,16).NE.0
	FRBIN = IAND(IGOPTN,32).NE.0
	BLANK = IAND(IGOPTN,64).NE.0
C
	DENSG = IAND(IGTYPE,1).NE.0
	STATG = IAND(IGTYPE,2).NE.0
C
	GRAPH = (IGTYPE.NE.0).AND.GFLAG(IBIN)
	LIST  = (ILIST.NE.0).AND.LFLAG(IBIN)
	AUX   = (IAUX.NE.0).AND.AFLAG(IBIN)
	NLUSED = 0
C
C.....To print a blank line and manage a 'No Source' print.
	EMPTYLINE = (IBIN.EQ.0).AND. BLANK
	IF ((IBIN.EQ.0).AND..NOT.BLANK) RETURN

C........Get the integration start time.
 	IF (ROUND) THEN
	   CT = CTIME(5)
	ELSE
	   CT = CTIME(2)
	ENDIF
	READ(CT,'(5X,I3)') IDAY
	NEWDAY = (IDAY.NE.LDAY).AND.(LDAY.NE.0)
	LDAY = IDAY
C
C.....On the first time through
	IF (HEADER) THEN
	   CALL PRTHEAD(PU,IGTYPE,ILIST,NLUSED,END)
	   HEADER = .FALSE.
	   POS144 = NLUSED
	ENDIF
C.....Manage the daily page breaks.
	IF (NEWDAY.AND.BREAK) THEN
	   END = .TRUE.
	   CALL PRTHEAD(PU,IGTYPE,ILIST,NLUSED,END)
	   END = .FALSE.
	   WRITE(PU,*) CHAR(12)
	   CALL PRTHEAD(PU,IGTYPE,ILIST,NLUSED,END)
	   POS144 = NLUSED
	   LDAY = IDAY
	ENDIF
C
	IF (BEST) THEN
C........Only print the BIN with the most sources.
	   MS = 0
	   DO 30 I = 1, NFRAB
	      IF(NBSRC(I).GT.MS) THEN
	         MS = NBSRC(I)
	         JBIN = I
	      ENDIF
 30	   CONTINUE
	   GRAPH = (IBIN.EQ.JBIN).AND.GRAPH
	   LIST  = (IBIN.EQ.JBIN).AND.LIST
	   AUX   = (IBIN.EQ.JBIN).AND.AUX
	ENDIF

	IF (GRAPH) THEN 
C........Prepare a blank line for this graph  Fill with DOTs if NEWDAY.
	   CALL BLANKLINE(CLINE,IGCONT,NEWDAY)
C........Insert the time.
	   IF (CT.NE.LCT.OR..NOT.UTIME) THEN
	      LCT = CT
	      CLINE(1) = CT(10:10)
	      CLINE(2) = CT(11:11)
	      CLINE(3) = CT(12:12)
	      CLINE(4) = CT(13:13)
	      CLINE(5) = CT(14:14)
	   ENDIF
C........Overwrite the time with the day number if NEWDAY
	   IF (NEWDAY) THEN
	      CLINE(1) = ' '
	      CLINE(2) = ' '
	      CLINE(3) = CT(6:6)
	      CLINE(4) = CT(7:7)
	      CLINE(5) = CT(8:8)
	   ENDIF
C
C........Sunrise/Sunset option
	   IF (SUN) CLINE(6) = SUNRIZE(CT)
C........FRB option
	   IF (FRBIN) THEN
	      IF (IBIN.GT.9) WRITE(CLINE(7),'(I1)') IBIN/10 
	      WRITE(CLINE(8),'(I1)') MOD(IBIN,10)
	   ENDIF 
C
C........Add data to this chart.
	   IF (EMPTYLINE) THEN
	      CLINE(7) = ' '
	      CLINE(8) = ' '
	   ELSE
	      IF (DENSG) CALL DENGRAPH(IGCONT,CLINE,IGCLEAN)
		   IF (STATG) CALL STATGRAPH(IGCONT,CLINE)
	   ENDIF
	   WRITE(PU,101) (CLINE(I),I=1,137)
	   NLUSED = 13
	ENDIF
C
 101	FORMAT (1X,140A1)
C
	IF (LIST) THEN
	   CALL LISTDATA(PU,IBIN,ILIST,NLUSED)
	ENDIF
C
	IF (AUX) THEN
	   CALL AUXDATA(AU,IBIN,IAUX,JUNK)
	ENDIF
C
	POS144 = POS144 + NLUSED
C	IF ((PAGE144-POS144).LT. 50) THEN
C	   WRITE(PU,*) CHAR(12)
C	   HEADER = .TRUE.
C	   POS144 = 0
C	ENDIF
	RETURN
	END
C
C ======================================================================
C
	SUBROUTINE PRTHEAD(IO,GRAPH,LIST,LINES,END)
C
C	Output the Header for a given GRAPH or LIST type to the unit IO.
C	This can be called once per page, or not, as needed.
C	LINES is the number of 1/144" lines used in this call.
C
C	Currently implemented LIST HEADER options:
C	   1)  All information as availible from SUBROUTINE WRITEGROUPDATA
C	   2)  Vx,Vy,Vz, Mean, Median, # only.
C	   3)  Vaz,Vh,Vz, Mean, Median, # only.
C	   4)  Individual Velocities.
C	   5)  Individual Veloctiy Probability Distribution Function.
C
	INTEGER IO,GRAPH,LIST,LINES
	LOGICAL END
C
	IF (LIST.EQ.1) THEN
	   WRITE(IO,*) ' All Velocity Data.'
	   WRITE(IO,101) ' Mean',' Std Dev',' Median',
     +                 ' 75%tile',' 25%tile','Most Prob' 
	   LINES = 34
	ELSE IF (LIST.EQ.2) THEN
	   WRITE(IO,*) ' Vx(North), Vy(East), Vz(Up) Components (m/s).'
	   WRITE(IO,102) 'Time','Mean Vx','Med Vx','MProb Vx',
     +                        'Mean Vy','Med Vy','MProb Vy',
     +                        'Mean Vz','Med Vz','MProb Vz','#'
	   LINES = 34
	ELSE IF (LIST.EQ.3) THEN
	   WRITE(IO,*) ' Vazimuth(deg, 0=N,90=E), Vhorizontal, Vz (m/s)' 
	   WRITE(IO,102) 'Time','Mean Va','Med Va','MProb Va',
     +                        'Mean Vh','Med Vh','MProb Vh',
     +                        'Mean Vz','Med Vz','MProb Vz','#'
	   LINES = 34
	ELSE IF (LIST.EQ.4) THEN
	   WRITE(IO,*) ' Individual Velocities'
	   LINES = 17
	ELSE IF (LIST.EQ.5) THEN
	   WRITE(IO,*) ' Probability Distribution Functions'
	   LINES = 17
	ELSE IF (GRAPH.NE.0) THEN
	   CALL GRAPHEAD(IO,LINES,END)
	ELSE
	   WRITE(IO,*) '  **** UNIMPLEMENTED HEADER ****  ',GRAPH,LIST
	   LINES = 17
	ENDIF
C
 101	FORMAT (4X,12A10)
 102	FORMAT (1X,A17,2X,9A10,A6) 
 103	FORMAT (1X,A3,2X,5A10) 

	RETURN
	END
C
C ===================================================================
C
	SUBROUTINE LISTDATA(IO,BIN,LIST,LINES)
C
C
C	Currently implemented LISTDATA options:
C	   1)  All information as availible from SUBROUTINE WRITEGROUPDATA
C	   2)  Vx,Vy,Vz, Mean, Median, # only.
C	   3)  Vaz,Vh,Vz, Mean, Median, # only.
C	   4)  Individual Velocities.
C	   5)  Individual Veloctiy Probability Distribution Function.
C	   6)  Vlos stats.
C
C.....Paramteters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\GRPVEL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELOCITY.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELPDFS.CMN'
C
	INTEGER IO,BIN,LIST,LINES,I,J
	CHARACTER*17 CTIME
	LOGICAL PROBLEM
C
	CHARACTER*2 CV(6)
	DATA CV /'Vx','Vy','Vz','Vh','Va','Vl'/
C
	PROBLEM = .FALSE.
C
C.....Print nothing if no sources/velocities availible.
	IF (LIST.LT.1) RETURN
C
	IF (LIST.EQ.1) THEN
	   CALL WRITEGROUPDATA(IO,BIN,PROBLEM,LINES)
	ELSE IF (LIST.EQ.2) THEN
C........Vx,Vy,Vz, Mean, Median, Most Prob, #.
	   WRITE(IO,101) CTIME(1),GVX(BIN,1),GVX(BIN,3),GVX(BIN,6),
     +                 GVY(BIN,1),GVY(BIN,3),GVY(BIN,6),
     +                 GVZ(BIN,1),GVZ(BIN,3),GVZ(BIN,6), NGVEL(BIN)
	   LINES = 24
	ELSE IF (LIST.EQ.3) THEN
C........Vaz,Vh,Vz, Mean, Median, Most Prob, #.
	   WRITE(IO,101) CTIME(1),GAZ(BIN,1),GAZ(BIN,3),GAZ(BIN,6),
     +                 GVH(BIN,1),GVH(BIN,3),GVH(BIN,6),
     +                 GVZ(BIN,1),GVZ(BIN,3),GVH(BIN,6), NGVEL(BIN)
	   LINES = 24
	ELSE IF (LIST.EQ.4) THEN
C........Dump of Individual Velocities.
	   WRITE(IO,*) CTIME(1)
	   WRITE(IO,106) '#','Vx','Vy','Vz','Err','Det'
	   DO 40 I = 1, NIVEL3D
	      WRITE(IO,102) I,VX(I),VY(I),VZ(I),ESR(I),DETR(I)
 40	   CONTINUE
	   WRITE(IO,106) '#','Vlos','Err'
	   DO 41 I = 1, NIVELOS
	      WRITE(IO,102) I,VL(I),ESRL(I)
 41	   CONTINUE	
	   LINES = 24*(NIVEL3D+NIVELOS+2)
	ELSE IF (LIST.EQ.5) THEN
C........PDF printout.
	   WRITE(*,107) 'Time','Low','High','# Bins','NIVEL'
	   DO 50 J = 1, 5
	      WRITE(IO,103) CV(J),CTIME(1),(LIMV(J,I),I=1,4),NIVEL3D
	      WRITE(IO,104) (KPDF(J,I),I=1,LIMV(J,3)) 
 50	   CONTINUE
	   LINES = 240
	ELSE IF (LIST.EQ.6) THEN
	   WRITE(*,101) CTIME(1),(GVL(BIN,I),I=1,NSTAT)
C........Line-of-Sight Group velocities.	   
	ENDIF
C
C
 101	FORMAT (1X,A17,2X,9F10.2,I6) 
 102	FORMAT (1X,I3,2X,3F10.2,2F10.5,F10.2,F10.5) 
 103	FORMAT (1X,A2,2X,A17,2X,4I10,I5)
 104	FORMAT (1X,65I2)
 105  FORMAT (1X,A17,A5,5A10)
 106	FORMAT (1X,A3,2X,10A10)
 107	FORMAT (1X,A20,3A10,A5)
	RETURN
	END
C
C ==========================================================================
C
	SUBROUTINE AUXDATA(IO,BIN,AUX,LINES)
C
C	Write data to a file.  This was intended to create output for
C     use by another program, graphics or further anaylsis.
C	No headers are generated.
C
C	Currently implemented AUX options:
C	   1)  All information as availible from SUBROUTINE WRITEGROUPDATA
C	   2)  Dump of all /SOURCES/
C
C.....Paramteters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\GRPVEL.CMN'
C
	INTEGER IO,BIN,AUX,LINES
	LOGICAL PROBLEM
c
	PROBLEM = .FALSE.
C.....Print nothing if no sources/velocities availible.
	IF (AUX.LT.1) RETURN
C
	IF (AUX.EQ.1) THEN
	   CALL WRITEGROUPDATA(IO,BIN,PROBLEM,LINES)
	ELSE IF (AUX.EQ.2) THEN
	   CALL DUMPSOURCE(IO,BIN,PROBLEM,LINES)
	ENDIF
C
C
 101	FORMAT (1X,A17,2X,6F10.2) 
	RETURN
 	END
C
C ==========================================================================
C 
	SUBROUTINE INPUTDATA()
C
C	Use menus to read in pertinent input parameters for the drift
C	velocity vector calculations.
C
C.....Paramteters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\CONTROL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\SELECT.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
C
C	Variable declaration
	INTEGER GETINT,IJUNK,ICFILE
	CHARACTER*17 CTT
	LOGICAL GRAPH,PROBLEM,LIST
	REAL*8 PARCTIME
	CHARACTER*30 CFILE,JFILE
C
C....READ INPUT PARAMETERS, from either the user or a file. 
C
	IU = 50
	PU = 10
	AU = 11
C
	WRITE(*,*) ' Drift Velocity Vector Calculation.'
	WRITE(*,*) ' '
C
	WRITE(*,*) ' Input Options:'
	WRITE(*,*) '      1) Enter options from the keyboard.'
	WRITE(*,*) '      2) Read option file from disk.'
C
	IJUNK = GETINT(1,2)
	IF (IJUNK.EQ.2) THEN
C
C........Input variables are from a file, but allow user
C........to change the names of the input and output files.
 901	   WRITE(*,*) ' Enter the name of the control file:'
	   READ (*,'(A)') CFILE
	   OPEN(UNIT=ICFILE,FILE=CFILE,FORM='FORMATTED',
     +        ACCESS='SEQUENTIAL',STATUS='OLD',ERR=901)
C........Read from the control file.
	   CALL READCTRLFILE(ICFILE,PROBLEM)
	   CLOSE(UNIT=ICFILE)
	   IF (PROBLEM) GOTO 901
C
	   GRAPH = (IGTYPE.NE.0)
C
C........Open the necessary files for velocity calculation.
 908	   WRITE(*,*)' Enter the name of the file with the source data:'
	   WRITE(*,*)'  or * for file:',INFILE  
	   READ(*,'(A)') JFILE
	   IF (JFILE.NE.'*') INFILE = JFILE
	   OPEN(UNIT=IU,FILE=INFILE,FORM='FORMATTED',
     +        ACCESS='SEQUENTIAL',STATUS='OLD',ERR=908)
C
	   IF (FILE) THEN
C...........Open a file for output on unit PU
 910	      WRITE(*,*) ' Name of the file for the data listings.'
	      WRITE(*,*)'  or * for file:',LFILE  
	      READ(*,'(A)') JFILE
	      IF (JFILE.NE.'*') LFILE = JFILE

	      OPEN(UNIT=PU,FILE=LFILE,FORM='FORMATTED',MODE='WRITE',
     +           ACCESS='SEQUENTIAL',ERR=910)
	   ELSE
C...........Open the printer for output on unit PU
	      OPEN(UNIT=PU,FILE='PRN',FORM='FORMATTED',MODE='WRITE',
     +           ACCESS='SEQUENTIAL')
	      CALL INITOPTI(PU,GRAPH)
	   ENDIF
C........Auxilary output file.
	   IF (IAUX.NE.0) THEN
 911	      WRITE(*,*) ' Name of the file for the AUX listings.'
	      WRITE(*,*)'  or * for file:',AFILE  
	      READ(*,'(A)') JFILE
	      IF (JFILE.NE.'*') AFILE = JFILE

	      OPEN(UNIT=AU,FILE=AFILE,FORM='FORMATTED',MODE='WRITE',
     +        ACCESS='SEQUENTIAL',ERR=911)
	   ENDIF
	   RETURN
	ENDIF
C 
C.....Input options from the user.
C
 902	WRITE(*,*) 'Enter the name of the file with the source data:'
	READ(*,'(A)') INFILE
	OPEN(UNIT=IU,FILE=INFILE,FORM='FORMATTED',
     +     ACCESS='SEQUENTIAL',STATUS='OLD',ERR=902)

C
	WRITE(*,*) ' Enter the number of the desired location:'
	WRITE(*,*) '     1) Goose Bay, Labrador.'
	WRITE(*,*) '     2) Thule, Greenland '
	WRITE(*,*) '     3) Millstone Hill, Massachusetts'
	WRITE(*,*) '     4) Qaanaaq, Greenland'
	WRITE(*,*) '     5) Argentia, Newfoundland'
	WRITE(*,*) '     6) Wallops Island, Virgina'
	WRITE(*,*) '     7) Sondre Stromfjord, Greenland'
C
	ILOC = GETINT(1,7)
	CALL SETSTATION(ILOC)
C
	IGTYPE = 0
	ILIST = 0
	IAUX = 0
	WRITE(*,*) ' Do you wish to:'
	WRITE(*,*) '     1) List data.'
	WRITE(*,*) '     2) Graph data.'
	GRAPH = (GETINT(1,2).EQ.2)
	LIST = .FALSE.
	IF (GRAPH) THEN
	   FILE = .FALSE.
	   WRITE(*,*) ' Graph Types:'
	   WRITE(*,*) '      1) Density Graph.'
	   WRITE(*,*) '      2) Statistics: (mean,median,quartile,etc).'
	   WRITE(*,*) '      3) Density and Statistics.'
	   IGTYPE = GETINT(1,3)
C
	   WRITE(*,*) ' Maximum Horizontal Velocity for Graphs.'
	   WRITE(*,*) ' Choose the desired Maximum Horizontal Velocity:'
	   WRITE(*,109)'       0)',INT(VELHMAX), ' m/s  (Default)'
	   WRITE(*,*)   '      1)   200 m/s'
	   WRITE(*,*)   '      2)   400 m/s'
	   WRITE(*,*)   '      3)   600 m/s'
	   WRITE(*,*)   '      4)   800 m/s'
	   WRITE(*,*)   '      5)  1000 m/s'
	   WRITE(*,*)   '      6)  1200 m/s'
	   WRITE(*,*)   '      7)  1400 m/s'
	   WRITE(*,*)   '      8)  1600 m/s'
	   WRITE(*,*)   '      9)  1800 m/s'
	   WRITE(*,*)   '     10)  2000 m/s'
	   WRITE(*,*)   '     11)  2200 m/s'
	   WRITE(*,*)   '     12)  2400 m/s'
 109	   FORMAT (A,I6,A)
	   IJUNK = GETINT(0,12)
	   IF (IJUNK.NE.0) THEN
	      VELHMAX = 200.0*FLOAT(IJUNK)
	      VELZMAX = VELHMAX/10.0
	   ENDIF
C
	   WRITE(*,*) ' Density Graph Contents.'
	   WRITE(*,*) '     1  = Azimuth, Vh and Vz.'
	   WRITE(*,*) '     2  = Azimuth only.'
	   WRITE(*,*) '     3  = Horizontal velocity (Vh) only.'
	   WRITE(*,*) '     4  = Vertical velocity (Vz) only.'
	   WRITE(*,*) '     5  = Az and Vh.'
	   WRITE(*,*) '     6  = Vx, Vy and Vz.'
	   WRITE(*,*) '     7  = Vx only.'
	   WRITE(*,*) '     8  = Vy only.'
	   WRITE(*,*) '     9  = Vx and Vy.'
	   WRITE(*,*) '    10  = Line-of-Sight (Vlos) only.'
	   IGCONT = GETINT(1,10)
C
	   WRITE(*,*) ' Density Graph Cleaning. '
	   WRITE(*,*) '   0 = No cleaning, 15 = Excessive cleaning.'
	   WRITE(*,*) '   Enter desired cleaning level.'
	   IGCLEAN = GETINT(0,15)
C
C	Options defined by the bits in the IGOPTN variable:
C	 1: 0=All/1=Best bins printed. 
C	 2: 0=Exclude/1=Include Sunrise/Sunset times for station.
C	 4: 0=Continuous/1=Daily page breaks.
C	 8: 0=Actual/1=Rounded time.
C	16: 0=All/1=Unique time printing.
C
	   IGOPTN = 0
	   WRITE(*,*)' Additional Graphing options:'
	   WRITE(*,*)' '
	   WRITE(*,*)' Graph which Frequency-Range Bins (FRBs):'
	   WRITE(*,*)'      0) All FRBs with data.'
	   WRITE(*,*)'      1) The 1 FRB with the most data.'
	   IGOPTN = IOR(IGOPTN, GETINT(0,1))
	   WRITE(*,*)' Solar data: Sunrise, Sunset, Noon, Midnight,etc.'
	   WRITE(*,*)'      0) Exclude. '
	   WRITE(*,*)'      1) Include. '
	   IGOPTN = IOR(IGOPTN, 2*GETINT(0,1))
	   WRITE(*,*)' Page Breaking:'
	   WRITE(*,*)'      0) Continuous paging.'
	   WRITE(*,*)'      1) Daily page breaks at 00:00 UT.'
	   IGOPTN = IOR(IGOPTN, 4*GETINT(0,1))
	   WRITE(*,*)' Printed time:'
	   WRITE(*,*)'      0) Actual start time.'
	   WRITE(*,*)'      1) Rounded to nearest 5, 10 or 15 minutes.'
	   IJUNK = GETINT(0,1)
	   IGOPTN = IOR(IGOPTN, 8*IJUNK)
	   IF (IJUNK.NE.0) THEN
	      WRITE(*,*) ' Rounding:'
	      WRITE(*,*) '    1)  5 Minutes.'
	      WRITE(*,*) '    2) 10 Minutes.'
	      WRITE(*,*) '    3) 15 Minutes.'
	      ATIME = 5.*60.*GETINT(1,3)
	   ENDIF
	   WRITE(*,*)' Print the time:'
	   WRITE(*,*)'      0) Always.'
	   WRITE(*,*)'      1) Only when it changes.'
	   IGOPTN = IOR(IGOPTN, 16*GETINT(0,1))
	   WRITE(*,*)' Frequency-Range Bin #:'
	   WRITE(*,*)'      0) Exclude. '
	   WRITE(*,*)'      1) Include. '
	   IGOPTN = IOR(IGOPTN, 32*GETINT(0,1))
	   WRITE(*,*) ' Blank Lines:'
	   WRITE(*,*) '     0) Supress blank lines.'
	   WRITE(*,*) '     1) Allow blank lines.'
	   IGOPTN = IOR(IGOPTN, 64*GETINT(0,1))

	   WRITE(*,*)' '
	ENDIF
C
	LFILE = '    '
	AFILE = LFILE
	IF (.NOT.GRAPH) THEN
	   WRITE(*,*)' Data Listing Options:'
	   WRITE(*,*)'      0) No data listings.'
	   WRITE(*,*)'      1) All Velocity Data.'
	   WRITE(*,*)'      2) List Vx,Vy,Vz Mean,Median,Most Probable.'
	   WRITE(*,*)'      3) List Vaz,Vh,Vz Mean,Median,Most Probable.'
	   WRITE(*,*)'      4) Individual Velocities.'
	   WRITE(*,*)'      5) Individual Veloctiy PDFunction.'
	   ILIST = GETINT(0,5)
	   LIST = (ILIST.NE.0)
	   IF (LIST) THEN
	      WRITE(*,*) ' Data Listing Destination:'
	      WRITE(*,*) '      1) List to the printer.'
	      WRITE(*,*) '      2) List to a file.'
	      FILE = (GETINT(1,2).EQ.2)
	   ENDIF
	ENDIF
	IF (FILE) THEN
 903	   WRITE(*,*) ' Name of the file for the data listings.'
	   READ(*,'(A)') LFILE
	   OPEN(UNIT=PU,FILE=LFILE,FORM='FORMATTED',MODE='WRITE',
     +       ACCESS='SEQUENTIAL',ERR=903)
	 ELSE
	   OPEN(UNIT=PU,FILE='PRN',FORM='FORMATTED',MODE='WRITE',
     +        ACCESS='SEQUENTIAL')
	   CALL INITOPTI(PU,GRAPH)
	ENDIF
C
	WRITE(*,*) ' Auxilary data listing options -- to a FILE only!'
	WRITE(*,*) '      0) No Auxilary data listings.'
	WRITE(*,*) '      1) Full output of Group Velocity data.'
	WRITE(*,*) '      2) Dump of all sources.'
	IAUX = GETINT(0,2)
	IF (IAUX.NE.0) THEN
 904	   WRITE(*,*) ' Name of the file for the data listings.'
	   READ(*,'(A)') AFILE
	   OPEN(UNIT=AU,FILE=AFILE,FORM='FORMATTED',MODE='WRITE',
     +        ACCESS='SEQUENTIAL',ERR=904)
	ENDIF
C
	CALL INITIOFLAGS()
C
	WRITE(*,*) ' Data grouping options:'
	WRITE(*,*) '     1) Subcase Velocities.'
	WRITE(*,*) '     2) Case Velocities.'
	WRITE(*,*) '     3) Group Velocities.'
	WRITE(*,*) '     4) Specify velocity grouping interval.'
	IGROUP = GETINT(1,4)
	IF (IGROUP.EQ.4) THEN
 66	   WRITE(*,*) ' Enter number of minutes between velocity',
     +              ' calculations.'
	   READ(*,*) ATIME
	   ATIME = ATIME*60.0
	   IF (ATIME.LE.0.0) GOTO 66
	ENDIF
C
C.....Starting and ending times.
C
	NR2DO = 0
 21 	WRITE(*,*) ' Enter starting date and time in the format:'
	WRITE(*,*) ' 1987 022 01:05:02   or enter 0 for first record'
	WRITE(*,*) ' of the file.'
	READ (*,29) CTT
 29	FORMAT (A17)
	STARTTIME = PARCTIME(CTT)
	CSTIME = CTT
	WRITE(*,*) ' Enter ending date and time (same format) or'
	WRITE(*,*) ' enter 0 to select a number of cases.'
	READ(*,29) CTT
	ENDTIME = PARCTIME(CTT)
	CETIME = CTT
	IF (ENDTIME.EQ.0.0) THEN
	   ENDTIME = 1.0E27
	   WRITE(*,*) ' Enter number of DRIFT sub-cases to process or'
	   WRITE(*,*) ' enter 0 for all records up to EOF.'
	   READ(*,*) NR2DO
	ENDIF
	IF (STARTTIME.GT.ENDTIME) THEN
	   WRITE(*,*)' Entered start time exceeds entered ending time.'
	   GOTO 21
	ENDIF
	IF (NR2DO.EQ.0) NR2DO = 9999999

C.....Weight to apply to each data point in the velocity calculation.
C 
	WRITE(*,*) ' Individual velocity calculation weight factor:'
	WRITE(*,*) '     0) No Weighting .'
	WRITE(*,*) '     1) Log Density.'
	WRITE(*,*) '     2) Log Density * Doppler Number.'
	WRITE(*,*) '     3) Linear Density.' 
	WRITE(*,*) '     4) Linear Density * Doppler Number.' 
	WRITE(*,*) '     5) Doppler Number.'
C 
	IWEIGH = GETINT(0,5) 
C
C	Source selection criteria.  Used in various locations
C	to toss out 'bad' data points.
C
C	WRITE(*,*) '       Criteria for Source selection:' 
	WRITE(*,*) ' Enter the minimum number of sources per subcase.'
	READ(*,*) MINSRC
	IF (MINSRC.LT.3) MINSRC = 3
	WRITE(*,*)' Enter the Minimum Absolute Doppler Number (0=ALL).'
	READ(*,*) MINDOPP 
	WRITE(*,*)' Enter the Maximum Absolute Doppler Number (0=ALL).'
	WRITE(*,*)'   Negative values are below spectral limit.'
	READ(*,*) MAXDOPP
	IF (MAXDOPP.EQ.0) MAXDOPP = 9999
	WRITE(*,*) ' Enter Maximum Positional Error (Degrees; 0=ALL)'
	READ(*,*) MPOSERR
	IF (MPOSERR.LE.0) MPOSERR = 9999
	WRITE(*,*) ' Enter SNR threshold for Subcase selection,'
	WRITE(*,*) ' (Subcase Maximum Amplitude - Noise, dB; 0=ALL)'
	READ(*,*) MCASESNR 
	WRITE(*,*) ' Process sources how far below the Subcase peak ?',
     +           ' (dB; 0=ALL)' 
	READ(*,*) MINLOBE
	IF (MINLOBE.LE.0) MINLOBE = 100 
	WRITE(*,*) ' Source Minimum SNR (dB; 0=ALL)'
	READ(*,*) MSRCSNR
C
CX	WRITE(*,*) ' Phase Code Doppler Ghost Removal.'
CX	WRITE(*,*) '    0) Leave Doppler Ghosts.'
CX	WRITE(*,*) '    1) Remove Doppler Ghosts.'
CX	ICORRECT = GETINT(0,1)
	ICORRECT = 0
C
	WRITE(*,*) ' Criteria for Velocity Selection.'
	WRITE(*,*) ' Enter the Maximum Vertical Velocity (m/s; 0=ALL)'
	READ(*,*) VZMAX
	IF (VZMAX.LE.0) VZMAX = 99999.9
	WRITE(*,*) ' Enter the Maximum Horizontal Velocity (m/s; 0=ALL)'
	READ(*,*) VHMAX
	IF (VHMAX.LE.0) VHMAX = 99999.9
	WRITE(*,*) ' Enter the maximum velocity change to allow,'
	WRITE(*,*) ' (percent of velocity magnitude; 0=ALL)'
	READ(*,*) VERRMAX
     	VERRMAX = VERRMAX/100.
	IF (VERRMAX.EQ.0) VERRMAX = 999.999
C.....Minimum VOLUME for the first three INDIVEL3D points.
	VOLMIN = 0.0300
C
C.....Sorting Order.
	WRITE(*,*) ' '
	WRITE(*,*) ' Source Sorting Order:'
	WRITE(*,*) '     0) No source sorting.'
	WRITE(*,*) '     1) Decreasing Amplitude.'
	WRITE(*,*) '     2) Increasing Amplitude.'
	WRITE(*,*) '     3) Decreasing absolute Doppler.'
	WRITE(*,*) '     4) Increasing absolute Doppler.'
	WRITE(*,*) '     5) Increasing RMS error.'
	WRITE(*,*) '     6) Decreasing Zenith angle.'
	WRITE(*,*) '     7) Increasing Zenith angle.'
	ISORT = GETINT(0,7)
Cx
Cx.....Re-selection of sources.
Cx	WRITE(*,*) ' Source Re-selection options:'
Cx	WRITE(*,*) '      1) Delete.'
Cx	WRITE(*,*) '      2) Shuffle.'
Cx	IRECHOOSE = GETINT(1,2)
	IRECHOOSE = 1
C
C.....Control variables not yet implemented.
	IFILTER = 0
	ICHOOSE = 0
C
C.....Set the BOUNDS for data grouping.
	CALL SETBOUNDS()
C
	WRITE(*,*) ' Finished reading input parameters.  Enter:'
	WRITE(*,*) '      1) Continue with Drift Velocity calculation.'
	WRITE(*,*) '      2) Write input parameters to a control file,'
	WRITE(*,*) '         then continue with calculation.'
	IJUNK = GETINT(1,2)
	IF (IJUNK.EQ.2) THEN
 905	   WRITE(*,*) ' Enter the name of the control file:'
	   READ (*,'(A)') CFILE
	   OPEN(UNIT=ICFILE,FILE=CFILE,FORM='FORMATTED',MODE='WRITE',
     +     ACCESS='SEQUENTIAL',STATUS='UNKNOWN',ERR=905)
C........Write to the control file & close it.
	   CALL WRITECTRLFILE(ICFILE,PROBLEM)
	   CLOSE(UNIT=ICFILE)
ccx		PROBLEM = REPORT(PROBLEM,'INPUTDATA -- Write to control file')
	ENDIF
C
	RETURN
	END
C
C   ====================================================================
C
	SUBROUTINE DUMPSOURCE(UNIT,IBIN,ERROR,L144)
C
C	Lists all sources in the bin IBIN to UNIT.  If IBIN is < 1 then
C	dump ALL sources, and their mapping into various FRAB's
C
$INCLUDE: '\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SOURCES.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SINDEX.CMN'
C
	INTEGER I,J,K,N,UNIT,IBIN,L144
	LOGICAL ERROR
	CHARACTER*17 CTIME
C
	ERROR = .FALSE.
	L144 = 0
C
	IF (IBIN.LT.1) THEN
	   N = NSRCRS
	ELSE
	   N = NBSRC(IBIN)
	ENDIF
	WRITE(UNIT,101) CTIME(1),IBIN,N,NSRCRS
	IF (N.LT.1) RETURN
	WRITE(UNIT,103) 'Src#','Indx','Theta','Phi','Erms','Amp',
     +                'Noise','Vrad','Active'
	IF (IBIN.LT.1) THEN
C........Dump all /SOURCES/
	   DO 10 I = 1, N
	      WRITE(UNIT,102) I,0,THETAS(I)/10.,PHIS(I)/10.,ERMS(I),
     +                      AMPS(I),NOIS(I),VRS(I),ACTIVE(I)
	      WRITE(UNIT,104) (BINS(I,K),K=1,NFRABS)
 10	   CONTINUE
	ELSE 
C........Print those sources selected and indexed.  Note that there could
C........be a difference between the SELINDX values and NBSRC(IBIN)
	   DO 20 I = 1, NBSRC(IBIN)
	      J = MAX(1,SELINDX(I))
	      WRITE(UNIT,102) I,J,THETAS(J)/10.,PHIS(J)/10.,ERMS(J),
     +                      AMPS(J),NOIS(J),VRS(J),ACTIVE(J)
 20	   CONTINUE
	ENDIF
 101	FORMAT (1X,A17,' Bin #',I4,5X,I5,' Sources selected of ',I5)
 102	FORMAT (2I6,2F6.1,3I6,F10.4,L8)
 103	FORMAT (7A6,A10,2A8)
 104	FORMAT (10X,40I3)
	RETURN
	END
C
C ==========================================================================
C
	SUBROUTINE WRITEGROUPDATA(UNIT,IFRB,ERROR,L144)
C
C	Writes the data from the /GRPVEL/ common block for the bin IFRB
C	as well as some /TIME/ and /BOUNDS/ information to the FORTRAN 
C	unit#	UNIT.  The LOGICAL variable ERROR is set if an error occurs in
C	the write operation.
C	L144 is the number of 1/144" lines used in this call, info needed by
C	OUTPUT routine to calculate page lengths.
C
C	This routine had a bug.  When IFRB = 0 the 2nd line of the record
C	is garbage due to an incorrectly accessed array.  Now, nothing is
C	written if IFRB = 0.
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\GRPVEL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
C
	INTEGER UNIT,IFRB,NVAR,I,L144
	LOGICAL ERROR
	CHARACTER*17 CTIME
C
	ERROR = .FALSE.
	NVAR = 8
C
	IF (IFRB.EQ.0) RETURN
	WRITE(UNIT,101,ERR=900) CTIME(2),IFRB,NSTAT,NVAR,VERSION
	WRITE(UNIT,104,ERR=900) 'BIN',BFRQ(IFRB,1),BFRQ(IFRB,2),
     +                         BRNG(IFRB,1),BRNG(IFRB,2),
     +                         (BANG(IFRB,I),I=1,4),
     +                         NGVEL(IFRB),NGVELOS(IFRB),
     +                         bavfrq(ifrb),bavhgt(ifrb)
	WRITE(UNIT,102,ERR=900) 'VZ ',(GVZ(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'VH ',(GVH(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'AZ ',(GAZ(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'VX ',(GVX(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'VY ',(GVY(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,103,ERR=900) 'SQ ',(GSQ(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,102,ERR=900) 'VL ',(GVL(IFRB,I),I=1,NSTAT)
	WRITE(UNIT,103,ERR=900) 'SL ',(GSL(IFRB,I),I=1,NSTAT)
	L144 = 170	
	RETURN
 101	FORMAT (1X,A17,3I5,F5.2)
 102	FORMAT (1X,A3,12F10.2)
 103	FORMAT (1X,A3,12F10.4)
 104	FORMAT (1X,A3,8F10.2,2I6,f6.2,f6.1)
C
 900	ERROR = .TRUE.
	RETURN
	END
C
C===========================================================================
C
	SUBROUTINE READCTRLFILE(UN,ERROR)
C
C	Read the necessary control information from a file opened on UN
C	into the appropriate COMMON blocks.  ERROR is set if there is one.
C	The version number assists in error checking.
C
C.....Program Parameters.
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\CONTROL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\SELECT.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
C
	INTEGER UN,I,J,KFRB,KSS,KSTAT,KIND,KDLM,KPDF
	REAL VER
	LOGICAL ERROR
	ERROR = .FALSE.
C
C.....Check the version number
	READ(UN,108,ERR=900,END=900) VER,KFRB,KSS,KSTAT,KIND,KDLM,KPDF
	ERROR = ((VER.NE.VERSION).OR.(KFRB.GT.NFRAB).OR.
     +         (KSS.GT.NSS).OR.(KSTAT.GT.NSTAT).OR.
     +         (KIND.GT.NIND).OR.(KDLM.GT.NDLM).OR.(KPDF.GT.NPDF))
	IF (ERROR) THEN
	   WRITE(*,*) ' READCTRLFILE --> Incorrect file version number ',
     +              'or incompatable PARAMETER settings.'
	   WRITE(*,111) 'File    :',VER,KFRB,KSS,KSTAT,KIND,KDLM,KPDF
	   WRITE(*,111) 'Program :',VERSION,NFRAB,NSS,NSTAT,NIND,NDLM,
     +                           NPDF

	   RETURN
	ENDIF
C
C.....Input /CONTROL/
	READ(UN,101,ERR=900,END=900)
     +            CHKADR,FILE,IGTYPE,IGCONT,IGOPTN,IGCLEAN,ILIST,IAUX,
     +            IGROUP,IWEIGH,ISORT,IFILTER,ICHOOSE,IRECHOOSE,
     +            ICORRECT,IU,PU,AU
	READ(UN,109,ERR=900,END=900) INFILE,LFILE,AFILE
	READ(UN,107,ERR=900,END=900) (GFLAG(I),I=1,KFRB)
	READ(UN,107,ERR=900,END=900) (LFLAG(I),I=1,KFRB)
	READ(UN,107,ERR=900,END=900) (AFLAG(I),I=1,KFRB)
C.....Input /SELECT/
	READ(UN,102,ERR=900,END=900) 
     +                      MINSRC,MINDOPP,MAXDOPP,MPOSERR,MINLOBE,
     +                      MSRCSNR,VZMAX,VHMAX,VERRMAX,VOLMIN
C.....Input /STATION/
	READ(UN,103,ERR=900,END=900)
     +                      ILOC,LOCATION,SID,GEOLAT,GEOLON,BLAT,
     +                      BLONG,VELHMAX,VELZMAX,GYROFREQ,DIPANGLE
C.....Input /TIME/
	READ(UN,104,ERR=900,END=900)
     +                      STARTTIME,ENDTIME,ATIME,
     +                      CSTIME,CETIME,NR2DO
C.....Input /BOUNDS/
	READ(UN,105,ERR=900,END=900) NFRABS,TRUEHEIGHT
	READ(UN,106,ERR=900,END=900)
     +   (BFRQ(I,1),BFRQ(I,2),BRNG(I,1),BRNG(I,2),(BANG(I,J),J=1,4),
     +                                          NBSRC(I),I=1,NFRABS)
C
	RETURN
C
 101	FORMAT(1X,2L3,16I4)
 102	FORMAT(1X,6I4,2F10.2,F10.4,F10.7)
 103	FORMAT(1X,I3,A20,A3,8F10.3)
 104	FORMAT(1X,2E25.18,F10.2,2A17,I10)
 105	FORMAT(1X,I5,L3)
 106	FORMAT(1X,8F10.4,I6)
 107	FORMAT(1X,128L1)
 108	FORMAT(1X,F5.2,10I5)
 109	FORMAT(1X,3A30)
 111	FORMAT (1X,A10,' Version=',F5.2,/' NFRB=',I5,' NSS=',I5,
     +        ' NSTAT =',I5,' NIND=',I5,' NDLM=',I5,' NPDF=',I5)

C
 900  ERROR = .TRUE.
C
	RETURN
	END
C 
C===========================================================================
C
	SUBROUTINE WRITECTRLFILE(UN,ERROR)
C
C
C	Write the necessary control information to a file opened on UN
C	from the appropriate COMMON blocks.  ERROR is set if there is one.
C
C.....Parameters.
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\CONTROL.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\SELECT.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\TIME.CMN'
C
C
	INTEGER UN,I,J
	LOGICAL ERROR
	ERROR = .FALSE.
C
C.....Output version number and Parameters.
	WRITE(UN,108,ERR=900) VERSION,NFRAB,NSS,NSTAT,NIND,NDLM,NPDF
C.....Output /CONTROL/
	WRITE(UN,101,ERR=900)
     +            CHKADR,FILE,IGTYPE,IGCONT,IGOPTN,IGCLEAN,ILIST,IAUX,
     +            IGROUP,IWEIGH,ISORT,IFILTER,ICHOOSE,IRECHOOSE,
     +            ICORRECT,IU,PU,AU
	WRITE(UN,109,ERR=900) INFILE,LFILE,AFILE
	WRITE(UN,107,ERR=900) (GFLAG(I),I=1,NFRAB)
	WRITE(UN,107,ERR=900) (LFLAG(I),I=1,NFRAB)
	WRITE(UN,107,ERR=900) (AFLAG(I),I=1,NFRAB)
C.....Output /SELECT/
	WRITE(UN,102,ERR=900) MINSRC,MINDOPP,MAXDOPP,MPOSERR,MINLOBE,
     +                      MSRCSNR,VZMAX,VHMAX,VERRMAX,VOLMIN
C.....Output /STATION/
	WRITE(UN,103,ERR=900) ILOC,LOCATION,SID,GEOLAT,GEOLON,BLAT,
     +                      BLONG,VELHMAX,VELZMAX,GYROFREQ,DIPANGLE
C.....Output /TIME/
	WRITE(UN,104,ERR=900) STARTTIME,ENDTIME,ATIME,
     +                      CSTIME,CETIME,NR2DO
C.....Output /BOUNDS/
	WRITE(UN,105,ERR=900) NFRABS,TRUEHEIGHT
	WRITE(UN,106,ERR=900)
     +   (BFRQ(I,1),BFRQ(I,2),BRNG(I,1),BRNG(I,2),(BANG(I,J),J=1,4),
     +                                            NBSRC(I),I=1,NFRABS)
C
	WRITE(UN,*) ' '
	RETURN
C
 101	FORMAT(1X,2L3,16I4,3A30)
 102	FORMAT(1X,6I4,2F10.2,F10.4,F10.7)
 103	FORMAT(1X,I3,A20,A3,8F10.3)
 104	FORMAT(1X,2E25.18,F10.2,2A17,I10)
 105	FORMAT(1X,I5,L3)
 106	FORMAT(1X,8F10.4,I6)
 107	FORMAT(1X,128L1)
 108	FORMAT(1X,F5.2,10I5)
 109	FORMAT(1X,3A30)
C
 900  ERROR = .TRUE.
	RETURN
	END
C
C  ======================================================================
C 
	SUBROUTINE READMAPDATA(INFILE,EOF) 
C 
C===== READ THE MAP DATA FROM A FILE <infile> FOR LATER USE IN PRINTING 
C	SKYMAPS OR CALCULATING DRIFT VELOCITIES.  FREQUENCY READ IS
C	 <IFF>  THE FORMAT OF THE PREFACE IS AS FOLLOWS:
C
C	NOTE:  Range is converted to meters and Frequency to Hertz.
C 
C
C  POSITION ! FORMAT  !  INFORMATION
C_______________________________________________________________
C  1        ! A1      !  SPACE                                  !
C  2-4      ! 3Z1     !  STATION ID CODE                        !
C  5-9      ! I5      !  RECORD NO.                             !
C  10       ! A1      !  SPACE                                  !
C  11-15    ! 5Z1     !  DATE                                   !
C  16       ! A1      !  SPACE                                  !
C  17-22    ! 6Z1     !  TIME                                   !
C  23       ! 1X      !  SPACE                                  !
C  24       ! Z1      !  PROGRAM SET                            !
C  25       ! Z1      !  PROGRAM TYPE                           !
C  26-31    ! 6Z1     !  JOURNAL (6 HEX DIGITS)                 !
C  32-38    ! 7Z1     !  P1 TO P7 (7 HEX DIGITS)                !
C  39       ! 1X      !  SPACE                                  !
C  40-46    ! 7Z1     !  XLZTNRW (7 HEX DIGITS)                 !
C  47-53    ! 7Z1     !  K(I*)(G*)HEIG (7 HEX DIGITS)           !
C  54-57    ! I4      !  ZMAX (10THS OF A DEGREE)               !
C  58-59    ! I2      !  NFREQ=FREQUENCY NUMBER                 !
C  60-66    ! I7      !  FREQ(NFREQ), IN 100-HZ UNITS           !
C  67-71    ! I5      !  RANG(NFREQ), IN 100-METER UNITS        !
C  72-74    ! I3      !  IGAIN(NFREQ), IN DB                    !
C  75-77    ! I3      !  MPAMP(NFREQ)                           !
C  78-80    ! I3      !  MAXAMP(NFREQ)                          !
C  81-84    ! I4      !  NO. OF SOURCES FOR NFREQ               !
C  85-87    ! I3      !  KTH, CASE SELECTION THRESHOLD          !
C  88-90    ! I3      !  LTH, SPECTRAL LINE SELECTION THRESHOLD ! 
C================================================================
C
	INTEGER INFILE,I,I1,I2,IRNG,IFRQ,IZMAX,KC,LC,IERR
	CHARACTER*2 JUNK
	LOGICAL EOF
C
C	VARIABLES FOR THE COMMON BLOCKS
C
C.....For /MAPDATA/
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\MAPDATA.CMN'
C
C
	DO 10 I =1, 89
 10   IPREF(I) = 0
	DO 20 I=1,NDLM
	   XMAP(I) = 0.0
	   YMAP(I) = 0.0
	   MAPAMP(I) = 0
	   MAPRMS(I) = 0
 20   CONTINUE
	EOF = .FALSE.
C
	READ(INFILE,110,END=99,ERR=901,IOSTAT=IERR)
     +  (IPREF(I),I=41,43),NMAP,(IPREF(I),I=1,19),
     +  (IPREF(I),I=26,32), (IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC,KC,LC
C
 110	FORMAT (1X,3Z1,I5,1X,5Z1,1X,6Z1,1X,15Z1,1X,14Z1
     +        I4,I2,I7,I5,4I3,I4,2I3) 
C
	RANGE = FLOAT(IRNG)*100.
	FREQ =  FLOAT(IFRQ)*100.
	ZMAX =  FLOAT(IZMAX)/10.
	 
	DO 140 I1=1,NUMSRC,26 
	   I2=I1+25
	   IF(I2.GT.NUMSRC) I2=NUMSRC 
	   READ(INFILE,151,ERR=902) JUNK,(YMAP(I),I=I1,I2) 
	   READ(INFILE,151,ERR=902) JUNK,(XMAP(I),I=I1,I2) 
	   READ(INFILE,150,ERR=902) JUNK,(MAPAMP(I),I=I1,I2)
	   READ(INFILE,150,ERR=902) JUNK,(MAPDOP(I),I=I1,I2) 
	   READ(INFILE,150,ERR=902) JUNK,(MAPRMS(I),I=I1,I2) 
  140 CONTINUE
  150 FORMAT(1X,A2,26I5)
  151 FORMAT(1X,A2,26F5.1)
C 
	RETURN
C     End of File condition.
 99   EOF = .TRUE.
 	NUMSRC = 0
	RETURN

 901	WRITE(*,101)' Error #',IERR, ' reading the SKYMAP data header.'
	write(*,110)
     +  (IPREF(I),I=41,43),NMAP,(IPREF(I),I=1,19),
     +  (IPREF(I),I=26,32), (IPREF(I),I=44,57),
     +  IZMAX,IFF,IFRQ,IRNG,GAIN,MPAMP,MAXAMP,NUMSRC,KC,LC

	NUMSRC = 0
	EOF = .FALSE.
	RETURN
 101	FORMAT (A,I5,A)

 902	WRITE(*,*) ' Error reading the SKYMAP source locations.'
	NUMSRC = 0
	EOF = .FALSE.
	RETURN
	END 
