$NOTRUNCATE
$DECLARE
C
C ==========================================================================
C
	SUBROUTINE INITIOFLAGS()
C
C	This routine initializes the GFLAG,LFLAG and AFLAG arrays
C	to indicate which FRB's are to be output.
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\CONTROL.CMN'
C
	INTEGER I
C
C....Currently, all values are set to .TRUE., meaning output everything.
C
	DO 10 I = 1, NFRAB
	   GFLAG(I) = .TRUE.
	   LFLAG(I) = .TRUE.
	   AFLAG(I) = .TRUE.
 10	CONTINUE
	RETURN
	END
C
C ==========================================================================
C
	SUBROUTINE SETBOUNDS()
C
C	Sets the values for the /BOUNDS/ common block
C
C.....Parameters.
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C
C.....For /BOUNDS/
$INCLUDE:'\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
C
C	Simple boundary conditions: 60-600Km ranges for frequencies from
C	0.0 MHz to 12 MHz in steps of 0.5 MHz
C	All angles accepted.
C
C  /BOUNDS/      -  Data in this common block define the limits in
C                   Frequency, Range and Arrival Angle for each of the
C	              NFRAB's. 
C  NFRABS        -  Number of FRAB's defined.  Must be <= NFRAB.
C  TRUEHEIGHT    -  Logical flag selecting between true and virtual height
C	              selection of the data.  *** TRUE HEIGHT NOT YET AVAILABLE ***
C  BFRQ(NFRAB,2) -  Bounds upon the FReQuency, upper ,1) and lower ,2)
C  BRNG(NFRAB,2) -  Bounds upon the RaNGe, upper ,1) and lower ,2)
C  BANG(NFRAB,4) -  Bounds on the ANGles of arrival for this bin.
C                   ,1) = Zenith angle of the Line-of-Sight direction (deg).
C                   ,2) = Azimuth of the Line-of-Sight direction (deg).
C                   ,3) = Half 'Beamwidth' in Zenith (deg).
C                   ,4) = Half 'Beamwidth' in Azimuth (deg).
C  NBSRC(NFRAB)  - Number of sources in each FRAB
C
C
	INTEGER GETINT,IBIN,I,IZN,IAZ,IZW
	REAL FMIN,FMAX,DF,F,GETFP
C
 1	FMIN = 0.0
	FMAX = 12.0
	DF = 0.5
	NFRABS = 0
	TRUEHEIGHT = .FALSE.
	WRITE(*,*) ' Frequency-Range-Angle Bin (FRAB) Boundaries.'
	WRITE(*,*) '      0) Manual entry of bins.'
	WRITE(*,*) '      1) All in one bin.'
	WRITE(*,*) '      2) 0.5 MHz bins, 0.0 to 12.0 MHz, All.'
	WRITE(*,*) '      3) 0.5 MHz bins, 0.0 to 12.0 MHz, Vertical.'
	WRITE(*,*) '      4) All Freq/Range Cone, Nx5 deg bins.'
	
	IBIN = GETINT(0,4)
C
	IF (IBIN.EQ.0) THEN
	   WRITE(*,*) ' Enter total number of FRABs.'
	   NFRABS = GETINT(1,NFRAB)
	   DO 5 I = 1,NFRABS
	      WRITE(*,'(A,I3)') ' Bin #',I
	      WRITE(*,101) ' Lower Frequency (MHz)'
	      BFRQ(I,1) = GETFP(0.5, 30.0)
	      WRITE(*,101) ' Upper Frequency (MHz)'
	      BFRQ(I,2) = GETFP(BFRQ(I,1), 30.0)
	      WRITE(*,101) ' Lower Range (Km)'
	      BRNG(I,1) = GETINT(60,600)
	      WRITE(*,101) ' Upper Range (Km)'
	      BRNG(I,2) = GETINT(INT(BRNG(I,1)), 600)
	      WRITE(*,101) ' Line-of-Sight Zenith (deg)'
	      BANG(I,1) = GETFP(0.0, 90.0)
	      WRITE(*,101) ' Line-of-Sight Azimuth (deg)'
	      BANG(I,2) = GETFP(-180.0, 360.0)
	      WRITE(*,101) ' Zenith Half-Beamwidth (deg)'
	      BANG(I,3) = GETFP(0.0, 90.0)
	      WRITE(*,101) ' Azimuth Half-Beamwidth (deg)'
	      BANG(I,4) = GETFP(0.0, 180.0)
 5	   CONTINUE
	ELSE IF (IBIN.EQ.1) THEN
	   NFRABS = 1
	   BFRQ(1,1) = 0.5
	   BFRQ(1,2) = 30.0
	   BRNG(1,1) = 60.0
	   BRNG(1,2) = 600.0
	   BANG(1,1) = 0.0
	   BANG(1,2) = 0.0
	   BANG(1,3) = 90.0
	   BANG(1,4) = 360.0
	ELSE IF (IBIN.EQ.2) THEN
	   DO 20 F = FMIN, FMAX, DF
	      NFRABS = NFRABS + 1
	      IF(NFRABS.GT.NFRAB) THEN
	         WRITE(*,*) ' SETBOUNDS -- Insufficient FRABs'
	         NFRABS = NFRAB
	      ENDIF
	      NBSRC(NFRABS) = 0.0
	      BFRQ(NFRABS,1) = F
	      BFRQ(NFRABS,2) = F+DF
	      BRNG(NFRABS,1) = 60.0
	      BRNG(NFRABS,2) = 600.0
	      BANG(NFRABS,1) = 0.0
	      BANG(NFRABS,2) = 0.0
	      BANG(NFRABS,3) = 90.0
	      BANG(NFRABS,4) = 360.0
 20	   CONTINUE
	ELSE IF (IBIN.EQ.3) THEN
	   DO 30 F = FMIN, FMAX, DF
	      NFRABS = NFRABS + 1
	      IF(NFRABS.GT.NFRAB) THEN
	         WRITE(*,*) ' SETBOUNDS -- Insufficient FRABs'
	         NFRABS = NFRAB
	      ENDIF
	      NBSRC(NFRABS) = 0.0
	      BFRQ(NFRABS,1) = F
	      BFRQ(NFRABS,2) = F+DF
	      BRNG(NFRABS,1) = 60.0
	      BRNG(NFRABS,2) = 600.0
	      BANG(NFRABS,1) = 0.0
	      BANG(NFRABS,2) = 0.0
	      BANG(NFRABS,3) = 5.0
	      BANG(NFRABS,4) = 360.0
 30	   CONTINUE
	ELSE IF (IBIN.EQ.4) THEN
C	   5 Degree beams in Azimuth, so there are 360/5=72 of them.
	   WRITE(*,*) ' Enter the angle of the cone (1-90 deg).'
	   IZN = GETINT(1,90)
	   WRITE(*,*) ' Enter elevation width of beam (1-90 deg).'
	   IZW = GETINT(1,90)
	   NFRABS = 0
	   DO 40 IAZ = 0, 355, 5
	      NFRABS = NFRABS + 1
	      IF(NFRABS.GT.NFRAB) THEN
	         WRITE(*,*) ' SETBOUNDS -- Insufficient FRABs'
	         NFRABS = NFRAB
	      ENDIF
	      BFRQ(NFRABS,1) = 0.50
	      BFRQ(NFRABS,2) = 16.0
	      BRNG(NFRABS,1) = 60.0
	      BRNG(NFRABS,2) = 600.0
	      BANG(NFRABS,1) = IZN 
	      BANG(NFRABS,2) = IAZ
	      BANG(NFRABS,3) = IZW/2.0
	      BANG(NFRABS,4) = 2.50
 40	   CONTINUE
	ENDIF
	DO 50 I = 1, NFRABS
	   NBSRC(I) = 0
 50	CONTINUE
 101	FORMAT(1X,A,\)

	RETURN
	END
C
C   ====================================================================
C 
	SUBROUTINE INDIVELOS(RESTART) 
C 
C
C	LINE-OF-SIGHT INDIVIDUAL VELOCITIES -- LEAST-SQUARE-ERROR CALCULATION: 
C
C	Very similar to the INDIVEL3D routine, but in one dimension.
C                                            
C    ESQ= SUM{ W(i)*[(Vlos*Alos.Am(i))-(Vm(i))]**2}
C          i
C         ------------------------------------------
C                   SUM W(i)
C                    i
C
C  ESQ     = Least Square Error 
C  W(I)    = Weighting Factor
C  Vlos    = Line-of-Sight velocity.
C  Alos    = Line-of-Sight direction unit vector
C  Am      = Measured source position unit vector
C  .       = Dot Product operator.
C  Vm      = The radial component of the measured velocity, in the
C            direction of Am(i).  This is the Doppler value in the
C	       /SOURCES/ block.  Refered to as Vm in the code.
C
C	The deriviative of ESQ (with respect to Vlos) is set to zero, 
C	yeilding an equation which can then be solved for Vlos.
C	The Least-Square error ESQ can also be calculated.
C
C	08 August 89 -- Updated version of INDIVEL calculates the
C	   Line-of-Sight velocity using the following equations:
C
C	         SUM{ W(i)*[Alos.R(i)*Vm] }
C	          i                                     SUMWAV
C	Vlos =   ----------------------------     =  -------------	
C	          SUM { W(i)*[Alos.R(i)]**2 }           SUMWAA
C	           i
C	Where:
C
C
C	The calling of this routine is done after all desired sources have
C	been read into the array /SOURCES/.  Only those sources with the
C	ACTIVE flag set to .TRUE. are used in this calculation.  These are
C     sources in the /VELOCITY/INDIVBIN Frequency-Range-Angle bin whose
C	limits are defined by /BOUNDS/.
C
C	INDLOSOK checks to see if a given velocity has exceeded
C	the limits specified for Individual Velocities in /SELECT/.
C	If a velocity exceeds the /SELECT/ limits, it is deleted.
C
C	Sources are assumed to have been selected and sorted in the order
C	in which it is desired to insert them into the least-square error
C	calculation.
C
C..........Parammeters 
$INCLUDE: '\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE: '\DRIFT\VELOCITY\COMMON\CONTROL.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SELECT.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SINDEX.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SOURCES.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SUMS.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\VELOCITY.CMN'
C
C
C	Program Variables.
	INTEGER IS,ISRC
	REAL W,X,Y,Z,VM,THETA,PHI,VLOS,VLRMS
	REAL WEIGHT,VELLOS,VLOSRMS
	LOGICAL RESTART,OK,INDLOSOK
C
C
	RESTART = .FALSE.
	IF (NSELXED.LT.1) THEN 
	   NIVELOS = 0
	   NIVLOVR = 0
	   WRITE(*,*) ' INDIVELOS -- Not enough sources.'
	   RETURN
	ENDIF
C 
C.....Only 1 source is needed for this routine, so generate 1 Vlos
C.....per source selected.
	NIVELOS = 0
	NIVLOVR = 0
	DO 30 IS = 1, NSELXED
	   ISRC = SELINDX(IS)
C........Calculate the Weight W for the current source ISRC.
	   W = WEIGHT(ISRC,IWEIGH)
C........Determine the (X Y Z) components of the unit position vector
C........of ISRC from its arrival angles THETA and PHI
	   THETA = THETAS(ISRC)/10.0
	   PHI   = PHIS(ISRC)/10.0
	   VM    = VRS(ISRC)
	   CALL CARTESIAN(1.00,THETA,PHI,   X,Y,Z)
	   CALL ADDTOSUMS(VM,W,X,Y,Z)
C........Calculate a LOS velocity.
	   VLOS = VELLOS()
	   VLRMS = VLOSRMS(VLOS)
C
	   OK = INDLOSOK(VLOS,VLRMS,RESTART,IS)
	   IF (RESTART) THEN
	      NSELXED = 0
	      RETURN
	   ENDIF
C
	   IF (OK) THEN
C...........Save this velocity in the /VELOCITY/ block
	      NIVELOS = NIVELOS + 1
	      IF (NIVELOS.GT.NIND) THEN
	         NIVELOS = NIND
	         NIVLOVR = NIVLOVR + 1
	      ENDIF
	      VL(NIVELOS) = VLOS
	      ESRL(NIVELOS) = VLRMS
	   ELSE
C...........This source produced results which were not OK, so skip it.
C...........Remove the last source from the /SUMS/.  Do not save velocity.
	      CALL ADDTOSUMS(VM,-W,X,Y,Z)
	   ENDIF
 30	CONTINUE
C
C.....Finished with all velocities. All selected sources are used. 
	IF (NIVLOVR.GT.0) WRITE(*,101) NIVLOVR,NIND
 101	FORMAT(' INDIVELOS --',I4,' Excess velocities. Limit =',I6)
	RETURN
	END 
C
C
C  =======================================================================
C
	LOGICAL FUNCTION INDLOSOK(VLOS,RMSERR,RESTART,IS)
C
C	Checks the progress of the INDIVELOS calculation to assure
C	that all values and errors are within the limits specified in the
C	/SELECT/ block.  No condition yet known will force a RESTART, but
C	the possibility exists.
C
C	IS is the source index number of the current source, refering
C	to the /SINDEX/ arrays.  NOTE:  IS = NIVELOS + MINSRC 
C
C..........Parammeters 
$INCLUDE: '\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE: '\DRIFT\VELOCITY\COMMON\CONTROL.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SELECT.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SINDEX.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SOURCES.CMN'
C
C
	INTEGER IS
	REAL EV,VMAX,VLOS,RMSERR,TINY
	LOGICAL RESTART
	DATA TINY /1.0E-3/
C
	RESTART  = .FALSE.
	INDLOSOK = .TRUE.
	IS = IS
	VMAX = SQRT(VHMAX*VHMAX + VZMAX*VZMAX)
	IF (ABS(VLOS).GT.TINY) THEN
	   EV = RMSERR/VLOS
	ELSE
	   EV = 100000.
	ENDIF
C
C.....If this is not OK then INDIVELOS will skip this source.
	INDLOSOK = (VLOS.LE.VMAX).AND.(EV.LE.VERRMAX)
C
	RETURN
	END
C
C ====================================================================
C
	REAL FUNCTION VELLOS()
C
C	Calculates from data in the /SUMS/ block the current value for
C	the Line-of-Sight velocity.
C
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\SUMS.CMN'
C
	REAL HUGE
	PARAMETER (HUGE = 1.0E30)
C
	IF (SUMWAA.NE.0.0) THEN
	   VELLOS = SUMWAV/SUMWAA
	ELSE
	   VELLOS = HUGE
	ENDIF
	RETURN
	END
C
C ====================================================================
C
	REAL FUNCTION VLOSRMS(VLOS)
C
C	Calculates from the /SUMS/ block the Root mean square error 
C	associated with those sums and their fit to the Line-of-Sight
C	velocity Vlos.
C
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\SUMS.CMN'
C
	REAL VLOS,HUGE
	PARAMETER (HUGE = 1.0E30)
C
C
	VLOSRMS = VLOS*VLOS*SUMWAA  -  VLOS*SUMWAV  +  SUMWVM 
C
	IF (SUMW.NE.0.0) THEN
	   VLOSRMS = VLOSRMS/SUMW
	ELSE
	   VLOSRMS = HUGE
	ENDIF
	IF (VLOSRMS.LE.0.0)  THEN
	   VLOSRMS = 0.0
	ENDIF
	VLOSRMS = SQRT(VLOSRMS)
	RETURN
	END
C
C ======================================================================
C
	REAL FUNCTION SIGHTLINE(X,Y,Z)
C
C	Determines the dot product of the Line of Sight direction and the
C	unit source position vector (X,Y,Z).  The F-R-A Bin number is taken
C	from /VELOCITY/.  /BOUNDS/ is referenced for the LOS direction.
C	(X,Y,Z) is (North, East, Up).
C
$INCLUDE: '\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\BOUNDS.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\SUMS.CMN'
$INCLUDE: '\DRIFT\VELOCITY\COMMON\VELOCITY.CMN'
C
	REAL THETA,PHI,X,Y,Z,XLOS,YLOS,ZLOS
C
C.....The LOS direction.
	THETA = BANG(INDIVBIN,1)
	PHI   = BANG(INDIVBIN,2)
	CALL CARTESIAN(1.0,THETA,PHI,   XLOS,YLOS,ZLOS)
	SIGHTLINE = X*XLOS + Y*YLOS + Z*ZLOS
	RETURN
	END
C
C
C==========================================================================
C
	SUBROUTINE STATGRAPH(IGC,CLINE)
C
C	This routine places into the CLINE the statisitcal variables in
C	the /GRPVEL/ block.
C
C	IGC    -- Determines the contnents of the Density Graph
C	     1  = Azimuth, Vh and Vz.
C	     2  = Azimuth only.
C	     3  = Horizontal velocity (Vh) only.
C	     4  = Vertical velocity (Vz) only.
C	     5  = Az and Vh.
C	     6  = Vx, Vy and Vz.
C	     7  = Vx only.
C	     8  = Vy only.
C	     9  = Vx and Vy.
C
C.....Parameters
$INCLUDE:'\DRIFT\VELOCITY\COMMON\PARAMS.CMN'
C.....Common Blocks
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELOCITY.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\VELPDFS.CMN'
$INCLUDE:'\DRIFT\VELOCITY\COMMON\GRPVEL.CMN'
C
	INTEGER IGC
	CHARACTER*1 CLINE(140)
C
C	************** UNIMPLEMENTED ******************
	IGC = IGC
	CLINE(1) = CLINE(1)
C
	RETURN
	END
C
C =========================================================================
C
	CHARACTER*1 FUNCTION SUNRIZE(CTIME)
C
C	Determines the sunrise/sunset/midnight/noontime chraracters to
C	print on graphs, given the CTIME and the /STATION/ locations.
C
C       *****  UNIMPLIMENTED *****
C
$INCLUDE:'\DRIFT\VELOCITY\COMMON\STATION.CMN'
C
	CHARACTER*17 CTIME
C
	SUNRIZE = CTIME(10:10)
	SUNRIZE = ' '
	RETURN
	END

