'This Script will
'Check to see file size
	'if file size is greater than correct_size, then make a backup of the file and log it
	'if file size is less than correct_size, then restore from backup and log it

	'also if logfile is greater than logfile_size
	'then create a new logfile

'----------BEGIN VARIABLES------------


	'Requires all variables to be declared before they can be used
	'(helps for mispellings)
Option Explicit

Dim oArgs
Dim result

	'Arguments
Dim file
Dim correct_size
Dim backup_file
Dim logfile
Dim logfile_size

	'In case of syntax errors at command line
Dim err_file
err_file = "FileProtect.err"


'----------END VARIABLES----------


'----------BEGIN COMMAND LINE ARGUMENTS----------


	'Command Line Arguments
	'Quit if any arguments are not present
Set oArgs = WScript.Arguments
If oArgs.Count <> 5 Then
	'try to make the error file
	'saying the syntax is incorrect
	Dim oFSO2, oTS2
	Set oFSO2 = WScript.CreateObject("Scripting.FileSystemObject")
	set oTS2 = oFSO2.CreateTextFile(err_file)
	oTS2.WriteLine 	Date & " " & Time
	oTS2.WriteLine 	"FileProtect WAS NOT RUN!" & vbCrLF & _
			"Incorrect Syntax for Script" & vbCrLF & _
			"Script [file] [file_size] [backup] [Logfile] [Logfile size]" & vbCrLF & vbCrLF & _
			"[file] is the file you wish to protect" & vbCrLF & _
			"if [file_size] is less than the [file] size then a restore will be attempted" & vbCrLF & _
			"[backup] is the file you will be restoring from, or backing up to" & vbCrLF & _
			"if [logfile] size is greater than [logfile_size] a new logfile will be generated" 
	oTS2.Close
	WScript.Quit (1)
End If

file = oArgs(0)
correct_size = oArgs(1)
backup_file = oArgs(2)
logfile = oArgs(3)
logfile_size = oArgs(4)

	'Arguments passed at the command prompt are strings
	'These two have to be numbers, so change them to integers
	'If this is not done, then the conditional statements wont work properly
correct_size = CInt(correct_size)
logfile_size = CInt(logfile_size)


'----------END COMMAND LINE ARGUMENTS----------


'----------BEGIN LOG FILE SETUP----------


	'For the log file
Dim oFSO, oTS
Set oFSO = WScript.CreateObject("Scripting.FileSystemObject")
	'Check the log file's size (in bytes) and make sure it is not too big
	'If it is, then create a new file
result = ShowFileSize(logfile)
If result > logfile_size Then
	set oTS = oFSO.CreateTextFile(logfile)
Else
	Const ForAppending = 8
		'This will create a new logfile, if it doesn't exist
	set oTs = oFSO.OpenTextFile(logfile, ForAppending, True)
End If
oTS.WriteLine   "Artist4 Log Entry" 
oTS.WriteLine 	Date & " " & Time


'----------END LOG FILE SETUP----------


'----------BEGIN BODY----------


	'Get the file's size
	'If file size is 0
	'  Then Restore from backup
	'Else file is not damaged (?) hopefully
	'  Then Make a backup
result = ShowFileSize(file)
If result < correct_size Then
	oTS.WriteLine 	file & " is < " & correct_size & " bytes or does not exist," & " use " & backup_file
	result = RestoreFromBackup(file, backup_file)
Else 
	oTS.WriteLine file & " size is > " & correct_size & " bytes, make a backup"
	result = RestoreFromBackup(backup_file, file)
End If	


'----------END BODY----------


'----------BEGIN FUNCTIONS----------


	'Returns the size, in bytes, of a file
	'If the file doesn't exist, size returned is 0
Function ShowFileSize(filespec)
   Dim fso, file, size
   Set fso = CreateObject("Scripting.FileSystemObject")
   	
   On Error Resume Next	
   Set file = fso.GetFile(filespec)
   If Err <> 0 Then
	oTS.WriteLine 	"Error determining file size," & " cannot access " & filespec
   End If
   	'If there is an error accessing the file (above)
	'Then file.size will be equal to 0
   size = file.size
   ShowFileSize = size
End Function

	'Will restore from backup file
	'If backup file cannot be accessed, function will exit
Function RestoreFromBackup(filespec, backup)
   Dim fso, file	
   Set fso = CreateObject("Scripting.FileSystemObject")
   
   On Error Resume Next
   Set file = fso.GetFile(backup)
   If Err <> 0 Then
		oTS.WriteLine "Error accessing backup file " & backup & " restore not performed"
 	Else
		oTS.WriteLine backup & " was copied to " & filespec
	End If 

   file.Copy filespec

	'This will return a 0 if successful
   RestoreFromBackup = Err
End Function

'----------END FUNCTIONS----------

	'End the log
oTS.Close
