C
C====+==================================================================+==
C
      SUBROUTINE PREF_MMM(IBUF,  IPREF)
C
C     Extract the preface for MMM and ART format data.
C     T. Bullett, AFRL
C
C
      INTEGER IP,IE,IRT,IPEND
      INTEGER*1 IBUF(4096),IPREF(57),ML
      INTEGER IRTYPE
      PARAMETER(ML=15)


      IRT=IRTYPE(IBUF)
C
cdb      write(*,'(60I3)') (i,i=-2,37)
cdb      write(*,'(60(1x,Z2))') (IBUF(I),I=1,40)

      IF ((IRT.EQ.9).OR.(IRT.EQ.8)) THEN
C        MMM format data
C        This should be 57
         IPEND=IBUF(2) - 3
         IPEND=MAX(IPEND,57)
         DO IP = 1,IPEND
            IPREF(IP) = 0
            IE = IP+3
            IPREF(IP)=IAND(IBUF(IE),ML)
         ENDDO
      ELSE IF (IRT.EQ.15) THEN
C        ART format block
C        
         IPEND=57
         DO IP = 1,IPEND
            IPREF(IP) = 0
            IE = IP+8
            IPREF(IP)=IAND(IBUF(IE),ML)
         ENDDO
      ELSE
C        Unknown data type.  Zero the preface array
         IPEND=57
         DO IP = 1,IPEND
            IPREF(IP) = 0
         ENDDO
         WRITE(0,*) 'pref_mmm --> Bad record type ',IRT
      ENDIF
C
cdb      write(*,*) IRT
cdb      write(*,'(60I3)') (i,i=1,40)
cdb      write(*,'(60(1x,Z2))') (IPREF(I),I=1,40)

      RETURN
      END
C
C====+==================================================================+==
C
