C
      PROGRAM REBLOCK4K
C
C     Digisonde data un-corruptor
C
C     Reads in a given number of bytes and writes out the first 4096 of them.
C
C====+==================================================================+==
C
C      Variables
      IMPLICIT NONE
      CHARACTER*120 CLP,INFILE,OUTFILE
      INTEGER*1 IBUF(4096),IBUF1(10000)
      INTEGER I,K,NA,IBS,IUI,IUO,IER,IB
      REAL VERSION
      LOGICAL EOF,ERROR,GOTIN,GOTOUT,INFOK,NEWION


C     Functions
      LOGICAL WRITE4KB
C
      PARAMETER (VERSION=0.17)
C
C
      IUI = 1
      IUO = 2
      GOTIN=.FALSE.
      GOTOUT=.FALSE.
      IBS=4096
      NEWION=.FALSE.
C
C      Parse command line options
C
C
C     Open input file
C     NOTE: This is operating system and compiler dependent.
C           You will likely have to edit this.
C     Pre-opened unit numbers under g77:  stdin=5, stdout=6, stderr=0
C
C====+==================================================================+==
C     Read the command line for arguments
      K = IARGC() 
C     Parse the command line.
      DO NA = 1, K
        CALL GETARG(NA,CLP)
        IF (CLP.EQ.'-h') THEN
          WRITE(*,*)' useage: reblock  infile outfile -i {inblocksize}'
          WRITE(*,*)' '
          WRITE(*,*)' Re-blocks data into 4K blocks.  Input and output'
          WRITE(*,*)' filenames must be provided on the command line.'
          WRITE(*,*)' Command line options:'
          WRITE(*,*)'  -i {inblocksize} input block size'
          WRITE(*,*)'  0:  No Problems'
          WRITE(*,*)' -1:  Problems'
          RETURN 
        ELSE IF (CLP.EQ.'-i') THEN
           CALL GETARG(NA+1,CLP)
           READ(CLP,*) IBS
         ELSE IF (.NOT.GOTIN) THEN
           CALL GETARG(NA,INFILE)
           GOTIN=.TRUE.
        ELSE IF (.NOT.GOTOUT) THEN
           CALL GETARG(NA,OUTFILE)
           GOTOUT=.TRUE.
        ENDIF
      ENDDO
C
C     Filename and output directory must exist on the command line
      IF (.NOT.GOTIN) THEN
         WRITE(0,*) "reblock4k-> ERROR: Input file must be specified"
         CALL EXIT(-1)
         RETURN
      ELSE IF (.NOT.GOTOUT) THEN
         WRITE(0,*) "reblock4k-> ERROR: Output file must be specified"
         CALL EXIT(-1)
         RETURN
      ENDIF
C
      write(*,*) INFILE, OUTFILE

C     Check if input file exists
      INQUIRE(FILE=INFILE,EXIST=INFOK)
      IF (.NOT.INFOK) THEN
         CALL EXIT(-1)
      ENDIF

C
C     Open input file.  This is for g77.  You mileage will vary.
      OPEN(UNIT=IUI,FILE=INFILE, ACCESS='DIRECT', FORM='UNFORMATTED', 
     +     STATUS='OLD', RECL=IBS )
C     Open output file.  This is for g77.  You mileage will vary.
           OPEN(UNIT=IUO,FILE=OUTFILE, ACCESS='DIRECT', 
     +          FORM='UNFORMATTED', RECL=4096 )         
C
      EOF=.FALSE.
      IB=0
      DO WHILE (.NOT.EOF)
         IB = IB + 1
         READ(IUI,IOSTAT=IER,REC=IB) (IBUF1(I),I=1,IBS)
         EOF=(IER.NE.0)
         IF(EOF) CYCLE
         DO I=1,4096
            IBUF(I)=IBUF1(I)
         ENDDO
         ERROR=WRITE4KB(IUO, NEWION, IBUF)
      ENDDO
         
      END
C
C====+==================================================================+==
