C
      PROGRAM SPLIT4K
C
C     Digisonde data fragmenter
C
C     This program fragments Digisonde raw data that are in 4K byte block
C     formats.  This includes:
C     MMM, GRM, BEM, SBF, RSF, 16C and DFT format files.
C     ART format files are ignored.
C
C     Terence Bullett
C     Air Force Research Laboratory
C     03 Feb 2006
C     linux g77
C
C     License:
C     This is in the public domain.  Use it as you see fit.
C     Just don't take credit for my work.
C
C     This software was paid for by the Taxpayers of the
C     United States of America.
C     Thank one the next time you meet.
C
C     References:
C        GL-TR-09-0190 "ARTIST Tape Output Formats"  July 1990  J. Tang, et al
C
C     Useage:
C        split4k infilename outdirname {options}
C
C        The input file must exist and contain 4k block format D256 data.
C        The output directory name must exist
C        The URSICode is optional and overrides file name creation if given
C
C     Revisions
C        30Mar06  TWB  version 0.16
C           Added ability to read thje 4097 byte blocks present on some 9-track 
C           tape image files.
C
C     Limitations
C        I can't reliably read binary files from stdin, at least not in any way
C        that is remotely portable.  Thus this program cannot be a pipe.
C        Sorry.
C
C     To Do
C        Implement SBF and RSF formats.
C           Mods needed in IRTYPE(), NEWIONOGRAM(), FILETYPE()
C        Handle .ART files.  Needs a TIME_ART() subroutine  
C
C====+==================================================================+==
C
C      Variables
      IMPLICIT NONE
      CHARACTER*120 CLP,INFILE,OUTDIR,OUTFILE
      CHARACTER*17 TIME
      CHARACTER*13 DTS
      CHARACTER*5 URSICODE,URSIOR
      CHARACTER*3 EXT 
      INTEGER*1 IBUF(4096),IBUF1(4097),IPREF(57)
      INTEGER I,K,NA,IRT,IUI,IUO,ISID
      REAL VERSION
      LOGICAL EOF,VERBOSE,SOR,NEWION,INFOK,ERROR,GOTIN,GOTOUT,TAPE4097


C     Functions
      LOGICAL READ4KB, NEWIONOGRAM, WRITE4KB, READ4KB1
      INTEGER IRTYPE, IARGC, ID_MMM, ID_GPP 
      CHARACTER*3 FILETYPE
      CHARACTER*5 URSI_UML
      CHARACTER*17 TIME_MMM, TIME_GPP 

C
      PARAMETER (VERSION=0.17)
C
C
      IUI = 1
      IUO = 2
      VERBOSE=.FALSE.
      SOR=.FALSE.
      ERROR=.FALSE.
      GOTIN=.FALSE.
      GOTOUT=.FALSE.
      TAPE4097=.FALSE.
C
C      Parse command line options
C
C
C     Open input file
C     NOTE: This is operating system and compiler dependent.
C           You will likely have to edit this.
C     Pre-opened unit numbers under g77:  stdin=5, stdout=6, stderr=0
C        
C
C====+==================================================================+==
C     Read the command line for arguments
      K = IARGC() 
C     Parse the command line.
      DO NA = 1, K
        CALL GETARG(NA,CLP)
        IF (CLP.EQ.'-h') THEN
          WRITE(*,*)' useage: split4k infile outdir {-v} {-u URSICODE }'
          WRITE(*,*)' '
          WRITE(*,*)' Split merged 4k block files to individual files'
          WRITE(*,*)' Filename must be provided on the command line.'
          WRITE(*,*)' Outdir must be provided on the command line.'
          WRITE(*,*)' Command line options:'
          WRITE(*,*)'  -v  Verbose. '
          WRITE(*,*)'  -u  URSICODE Forces URSICODE as file prefix'
          WRITE(*,*)'  -t  4097 byte tape blocks'
          WRITE(*,*)' Returns exit status as follows:'
          WRITE(*,*)'  0:  No Problems'
          WRITE(*,*)' -1:  Problems'
          RETURN 
        ELSE IF (CLP.EQ.'-v') THEN
           VERBOSE = .TRUE.
        ELSE IF (CLP.EQ.'-t') THEN
           TAPE4097 = .TRUE.
        ELSE IF (CLP.EQ.'-u') THEN
           SOR = .TRUE.
           CALL GETARG(NA+1,URSIOR)
        ELSE IF (.NOT.GOTIN) THEN
           CALL GETARG(NA,INFILE)
           GOTIN=.TRUE.
        ELSE IF (.NOT.GOTOUT) THEN
           CALL GETARG(NA,OUTDIR)
           GOTOUT=.TRUE.
        ENDIF
      ENDDO
C
C     Filename and output directory must exist on the command line
      IF (.NOT.GOTIN) THEN
         WRITE(0,*) "split4k-> ERROR: Input file must be specified"
         CALL EXIT(-1)
         RETURN
      ELSE IF (.NOT.GOTOUT) THEN
         WRITE(0,*) "split4k-> ERROR: Output directory is required"
         CALL EXIT(-1)
         RETURN
      ENDIF
C
C     Check if input file exists
      INQUIRE(FILE=INFILE,EXIST=INFOK)
      IF (.NOT.INFOK) THEN
         CALL EXIT(-1)
      ENDIF
C
C     Open input file.  This is for g77.  You mileage will vary.
      IF (TAPE4097) THEN
         OPEN(UNIT=IUI,FILE=INFILE, ACCESS='DIRECT', FORM='UNFORMATTED', 
     +     STATUS='OLD', RECL=4097 )
      ELSE         
         OPEN(UNIT=IUI,FILE=INFILE, ACCESS='DIRECT', FORM='UNFORMATTED', 
     +     STATUS='OLD', RECL=4096 )
      ENDIF
         
C
      EOF=.FALSE.
      DO WHILE (.NOT.EOF)
         IF (TAPE4097) THEN
            EOF=READ4KB1(IUI,IBUF1)
            DO I=1,4096
               IBUF(I)=IBUF1(I)
            ENDDO
         ELSE
            EOF=READ4KB(IUI,IBUF)
         ENDIF
         IF (EOF) CYCLE
         IRT=IRTYPE(IBUF)
         EXT=FILETYPE(IRT)
         NEWION=NEWIONOGRAM(IRT, IBUF)
cdb         write(*,*) 'IRT=',IRT,' EXT=',EXT,' NEWION=',NEWION
         IF (NEWION) THEN
            IF ((IRT.EQ.9).OR.(IRT.EQ.8)) THEN
              CALL PREF_MMM(IBUF,  IPREF)
              TIME=TIME_MMM(IPREF)
              ISID=ID_MMM(IPREF)
	    ELSE IF ((IRT.EQ.10).OR.(IRT.EQ.12).OR.
     +           (IRT.EQ.13)) THEN
              CALL PREF_16C(IBUF,  IPREF)
              TIME=TIME_MMM(IPREF)
              ISID=ID_MMM(IPREF)
            ELSE IF ((IRT.EQ.7).OR.(IRT.EQ.6)) THEN
               CALL PREF_GPP(IBUF,  IPREF)
               TIME=TIME_GPP(IPREF)
               ISID=ID_GPP(IPREF)
            ELSE IF ((IRT.EQ.3).OR.(IRT.EQ.2)) THEN
               CALL PREF_GPP(IBUF,  IPREF)
               TIME=TIME_GPP(IPREF)
               ISID=ID_GPP(IPREF)
            ELSE IF (IRT.EQ.15) THEN
              CALL PREF_MMM(IBUF,  IPREF)
              TIME=TIME_MMM(IPREF)
              ISID=ID_MMM(IPREF)
            ELSE
              TIME=TIME_GPP(IPREF)
              ISID=ID_MMM(IPREF)
            ENDIF
         ENDIF
C
         IF (NEWION) THEN
            IF (SOR)THEN
               URSICODE=URSIOR
            ELSE
              URSICODE=URSI_UML(ISID)
            ENDIF
C
            DTS=TIME(1:4)//TIME(6:8)//TIME(10:11)//
     +                              TIME(13:14)//TIME(16:17)
            CLOSE(IUO)
            OUTFILE=OUTDIR(1:LEN_TRIM(OUTDIR))
     +                                  //URSICODE//'_'//DTS//'.'//EXT
            IF(VERBOSE) WRITE(*,*) OUTFILE
C     Open output file.  This is for g77.  You mileage will vary.
           OPEN(UNIT=IUO,FILE=OUTFILE, ACCESS='DIRECT', 
     +          FORM='UNFORMATTED', RECL=4096 )
         ENDIF
         ERROR=WRITE4KB(IUO, NEWION, IBUF)
      ENDDO
         
      END
C
C====+==================================================================+==
