### DOzmgv.plot - plots Bell gravity meter drift vs time.
## Written sep88 smsmith sio/gdc
#
# directory path to files of gravity tie data (<date>.gravtie.data)
set DIRGTD = "/UWDSYS/files/GRAVTIE.DATA"
if($#argv < 1) then
   echo "\
    usage:   DOzmgv.plot year \
    example: DOzmgv.plot   88 \
      Produces plot on screen of Bell Gravity meter drift vs. Year/Julian day.\
      When viewing complete, press <return> to remove plot files and exit.\
       (A plotxy.<year>.cmd file for the year must be present.)\
    "
   exit
endif
#
echo "\
 Gravity meter drift plot being generated (ignore prompts for input) ...\
 "
set YR = $1
grep "^ZMGV" $DIRGTD/{$YR}*gravtie.data |awk '{print $4,$2}' - >&! zmgv.{$YR}xy
plotxy <plotxy.$YR.cmd 
go  myplot
set IN = $<
/bin/rm myplot zmgv.{$YR}xy
